package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to change the state of an Amazon CloudWatch alarm.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Metric metric = Metric.Builder.create()
 *         .namespace("MyNamespace")
 *         .metricName("MyMetric")
 *         .dimensions(Map.of("MyDimension", "MyDimensionValue"))
 *         .build();
 * Alarm alarm = Alarm.Builder.create(this, "MyAlarm")
 *         .metric(metric)
 *         .threshold(100)
 *         .evaluationPeriods(3)
 *         .datapointsToAlarm(2)
 *         .build();
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id FROM 'device/+/data'"))
 *         .actions(List.of(
 *             CloudWatchSetAlarmStateAction.Builder.create(alarm)
 *                     .reason("AWS Iot Rule action is triggered")
 *                     .alarmStateToSet(AlarmState.ALARM)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.560Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.CloudWatchSetAlarmStateAction")
public class CloudWatchSetAlarmStateAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected CloudWatchSetAlarmStateAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudWatchSetAlarmStateAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param alarm This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CloudWatchSetAlarmStateAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm alarm, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(alarm, "alarm is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param topicRule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule topicRule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(topicRule, "topicRule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param alarm This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.cloudwatch.IAlarm alarm) {
            return new Builder(alarm);
        }

        private final software.amazon.awscdk.services.cloudwatch.IAlarm alarm;
        private final software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateActionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.cloudwatch.IAlarm alarm) {
            this.alarm = alarm;
            this.props = new software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateActionProps.Builder();
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The value of the alarm state to set.
         * <p>
         * @return {@code this}
         * @param alarmStateToSet The value of the alarm state to set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alarmStateToSet(final software.amazon.awscdk.services.cloudwatch.AlarmState alarmStateToSet) {
            this.props.alarmStateToSet(alarmStateToSet);
            return this;
        }

        /**
         * (experimental) The reason for the alarm change.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param reason The reason for the alarm change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reason(final java.lang.String reason) {
            this.props.reason(reason);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateAction build() {
            return new software.amazon.awscdk.services.iot.actions.CloudWatchSetAlarmStateAction(
                this.alarm,
                this.props.build()
            );
        }
    }
}
