package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to put the record from an MQTT message to republish another MQTT topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, timestamp() as timestamp, temperature FROM 'device/+/data'"))
 *         .actions(List.of(
 *             IotRepublishMqttAction.Builder.create("${topic()}/republish")
 *                     .qualityOfService(MqttQualityOfService.AT_LEAST_ONCE)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.567Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.IotRepublishMqttAction")
public class IotRepublishMqttAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected IotRepublishMqttAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IotRepublishMqttAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param topic The MQTT topic to which to republish the message. This parameter is required.
     * @param props Optional properties to not use default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IotRepublishMqttAction(final @org.jetbrains.annotations.NotNull java.lang.String topic, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.IotRepublishMqttActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required"), props });
    }

    /**
     * @param topic The MQTT topic to which to republish the message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public IotRepublishMqttAction(final @org.jetbrains.annotations.NotNull java.lang.String topic) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.IotRepublishMqttAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.IotRepublishMqttAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param topic The MQTT topic to which to republish the message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String topic) {
            return new Builder(topic);
        }

        private final java.lang.String topic;
        private software.amazon.awscdk.services.iot.actions.IotRepublishMqttActionProps.Builder props;

        private Builder(final java.lang.String topic) {
            this.topic = topic;
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) The Quality of Service (QoS) level to use when republishing messages.
         * <p>
         * Default: MqttQualityOfService.ZERO_OR_MORE_TIMES
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html#mqtt-qos">https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html#mqtt-qos</a>
         * @param qualityOfService The Quality of Service (QoS) level to use when republishing messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder qualityOfService(final software.amazon.awscdk.services.iot.actions.MqttQualityOfService qualityOfService) {
            this.props().qualityOfService(qualityOfService);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.IotRepublishMqttAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.IotRepublishMqttAction build() {
            return new software.amazon.awscdk.services.iot.actions.IotRepublishMqttAction(
                this.topic,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.actions.IotRepublishMqttActionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.actions.IotRepublishMqttActionProps.Builder();
            }
            return this.props;
        }
    }
}
