package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) MQTT Quality of Service (QoS) indicates the level of assurance for delivery of an MQTT Message.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, timestamp() as timestamp, temperature FROM 'device/+/data'"))
 *         .actions(List.of(
 *             IotRepublishMqttAction.Builder.create("${topic()}/republish")
 *                     .qualityOfService(MqttQualityOfService.AT_LEAST_ONCE)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html#mqtt-qos">https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html#mqtt-qos</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.573Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.MqttQualityOfService")
public enum MqttQualityOfService {
    /**
     * (experimental) QoS level 0.
     * <p>
     * Sent zero or more times.
     * This level should be used for messages that are sent over reliable communication links or that can be missed without a problem.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ZERO_OR_MORE_TIMES,
    /**
     * (experimental) QoS level 1.
     * <p>
     * Sent at least one time, and then repeatedly until a PUBACK response is received.
     * The message is not considered complete until the sender receives a PUBACK response to indicate successful delivery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AT_LEAST_ONCE,
}
