package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to write the data from an MQTT message to an Amazon S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket = new Bucket(this, "MyBucket");
 * TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, year, month, day FROM 'device/+/data'"))
 *         .actions(List.of(
 *             S3PutObjectAction.Builder.create(bucket)
 *                     .key("${year}/${month}/${day}/${topic(2)}")
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.574Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.S3PutObjectAction")
public class S3PutObjectAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected S3PutObjectAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3PutObjectAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bucket The Amazon S3 bucket to which to write data. This parameter is required.
     * @param props Optional properties to not use default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3PutObjectAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.S3PutObjectActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), props });
    }

    /**
     * @param bucket The Amazon S3 bucket to which to write data. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3PutObjectAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.S3PutObjectAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.S3PutObjectAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param bucket The Amazon S3 bucket to which to write data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.s3.IBucket bucket) {
            return new Builder(bucket);
        }

        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private software.amazon.awscdk.services.iot.actions.S3PutObjectActionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) The Amazon S3 canned ACL that controls access to the object identified by the object key.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl</a>
         * @param accessControl The Amazon S3 canned ACL that controls access to the object identified by the object key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessControl(final software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        /**
         * (experimental) The path to the file where the data is written.
         * <p>
         * Supports substitution templates.
         * <p>
         * Default: '${topic()}/${timestamp()}'
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html</a>
         * @param key The path to the file where the data is written. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder key(final java.lang.String key) {
            this.props().key(key);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.S3PutObjectAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.S3PutObjectAction build() {
            return new software.amazon.awscdk.services.iot.actions.S3PutObjectAction(
                this.bucket,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.actions.S3PutObjectActionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.actions.S3PutObjectActionProps.Builder();
            }
            return this.props;
        }
    }
}
