package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) Configuration options for the SNS topic action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Topic topic = new Topic(this, "MyTopic");
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, year, month, day FROM 'device/+/data'"))
 *         .actions(List.of(
 *             SnsTopicAction.Builder.create(topic)
 *                     .messageFormat(SnsActionMessageFormat.JSON)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.578Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.SnsTopicActionProps")
@software.amazon.jsii.Jsii.Proxy(SnsTopicActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SnsTopicActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iot.actions.CommonActionProps {

    /**
     * (experimental) The message format of the message to publish.
     * <p>
     * SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted.
     * <p>
     * Default: SnsActionMessageFormat.RAW
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-and-json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/sns-message-and-json-formats.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.SnsActionMessageFormat getMessageFormat() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SnsTopicActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SnsTopicActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SnsTopicActionProps> {
        software.amazon.awscdk.services.iot.actions.SnsActionMessageFormat messageFormat;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link SnsTopicActionProps#getMessageFormat}
         * @param messageFormat The message format of the message to publish.
         *                      SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageFormat(software.amazon.awscdk.services.iot.actions.SnsActionMessageFormat messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        /**
         * Sets the value of {@link SnsTopicActionProps#getRole}
         * @param role The IAM role that allows access to AWS service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SnsTopicActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SnsTopicActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SnsTopicActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsTopicActionProps {
        private final software.amazon.awscdk.services.iot.actions.SnsActionMessageFormat messageFormat;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.messageFormat = software.amazon.jsii.Kernel.get(this, "messageFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.actions.SnsActionMessageFormat.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.messageFormat = builder.messageFormat;
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.iot.actions.SnsActionMessageFormat getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMessageFormat() != null) {
                data.set("messageFormat", om.valueToTree(this.getMessageFormat()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot_actions.SnsTopicActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SnsTopicActionProps.Jsii$Proxy that = (SnsTopicActionProps.Jsii$Proxy) o;

            if (this.messageFormat != null ? !this.messageFormat.equals(that.messageFormat) : that.messageFormat != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.messageFormat != null ? this.messageFormat.hashCode() : 0;
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
