package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to write the data from an MQTT message to an Amazon SQS queue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Queue queue = new Queue(this, "MyQueue");
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, year, month, day FROM 'device/+/data'"))
 *         .actions(List.of(
 *             SqsQueueAction.Builder.create(queue)
 *                     .useBase64(true)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.580Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.SqsQueueAction")
public class SqsQueueAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected SqsQueueAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsQueueAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue The Amazon SQS queue to which to write data. This parameter is required.
     * @param props Optional properties to not use default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsQueueAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.SqsQueueActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), props });
    }

    /**
     * @param queue The Amazon SQS queue to which to write data. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsQueueAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.SqsQueueAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.SqsQueueAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param queue The Amazon SQS queue to which to write data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.services.iot.actions.SqsQueueActionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) Specifies whether to use Base64 encoding.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param useBase64 Specifies whether to use Base64 encoding. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder useBase64(final java.lang.Boolean useBase64) {
            this.props().useBase64(useBase64);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.SqsQueueAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.SqsQueueAction build() {
            return new software.amazon.awscdk.services.iot.actions.SqsQueueAction(
                this.queue,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.actions.SqsQueueActionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.actions.SqsQueueActionProps.Builder();
            }
            return this.props;
        }
    }
}
