package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Properties for defining an AWS IoT Events detector model.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IFunction func;
 * Input input = Input.Builder.create(this, "MyInput")
 *         .inputName("my_input") // optional
 *         .attributeJsonPaths(List.of("payload.deviceId", "payload.temperature"))
 *         .build();
 * State warmState = State.Builder.create()
 *         .stateName("warm")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-enter-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(new LambdaInvokeAction(func)))
 *                 .build()))
 *         .onInput(List.of(Event.builder() // optional
 *                 .eventName("test-input-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .onExit(List.of(Event.builder() // optional
 *                 .eventName("test-exit-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .build();
 * State coldState = State.Builder.create()
 *         .stateName("cold")
 *         .build();
 * // transit to coldState when temperature is less than 15
 * warmState.transitionTo(coldState, TransitionOptions.builder()
 *         .eventName("to_coldState") // optional property, default by combining the names of the States
 *         .when(Expression.lt(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .executing(List.of(new LambdaInvokeAction(func)))
 *         .build());
 * // transit to warmState when temperature is greater than or equal to 15
 * coldState.transitionTo(warmState, TransitionOptions.builder()
 *         .when(Expression.gte(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .build());
 * DetectorModel.Builder.create(this, "MyDetectorModel")
 *         .detectorModelName("test-detector-model") // optional
 *         .description("test-detector-model-description") // optional property, default is none
 *         .evaluationMethod(EventEvaluation.SERIAL) // optional property, default is iotevents.EventEvaluation.BATCH
 *         .detectorKey("payload.deviceId") // optional property, default is none and single detector instance will be created and all inputs will be routed to it
 *         .initialState(warmState)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.871Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.DetectorModelProps")
@software.amazon.jsii.Jsii.Proxy(DetectorModelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DetectorModelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The state that is entered at the creation of each detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.State getInitialState();

    /**
     * (experimental) A brief description of the detector model.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) The value used to identify a detector instance.
     * <p>
     * When a device or system sends input, a new
     * detector instance with a unique key value is created. AWS IoT Events can continue to route
     * input to its corresponding detector instance based on this identifying information.
     * <p>
     * This parameter uses a JSON-path expression to select the attribute-value pair in the message
     * payload that is used for identification. To route the message to the correct detector instance,
     * the device must send a message payload that contains the same attribute-value.
     * <p>
     * Default: - none (single detector instance will be created and all inputs will be routed to it)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDetectorKey() {
        return null;
    }

    /**
     * (experimental) The name of the detector model.
     * <p>
     * Default: - CloudFormation will generate a unique name of the detector model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDetectorModelName() {
        return null;
    }

    /**
     * (experimental) Information about the order in which events are evaluated and how actions are executed.
     * <p>
     * When setting to SERIAL, variables are updated and event conditions are evaluated in the order
     * that the events are defined.
     * When setting to BATCH, variables within a state are updated and events within a state are
     * performed only after all event conditions are evaluated.
     * <p>
     * Default: EventEvaluation.BATCH
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotevents.EventEvaluation getEvaluationMethod() {
        return null;
    }

    /**
     * (experimental) The role that grants permission to AWS IoT Events to perform its operations.
     * <p>
     * Default: - a role will be created with default permissions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DetectorModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DetectorModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DetectorModelProps> {
        software.amazon.awscdk.services.iotevents.State initialState;
        java.lang.String description;
        java.lang.String detectorKey;
        java.lang.String detectorModelName;
        software.amazon.awscdk.services.iotevents.EventEvaluation evaluationMethod;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link DetectorModelProps#getInitialState}
         * @param initialState The state that is entered at the creation of each detector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder initialState(software.amazon.awscdk.services.iotevents.State initialState) {
            this.initialState = initialState;
            return this;
        }

        /**
         * Sets the value of {@link DetectorModelProps#getDescription}
         * @param description A brief description of the detector model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link DetectorModelProps#getDetectorKey}
         * @param detectorKey The value used to identify a detector instance.
         *                    When a device or system sends input, a new
         *                    detector instance with a unique key value is created. AWS IoT Events can continue to route
         *                    input to its corresponding detector instance based on this identifying information.
         *                    <p>
         *                    This parameter uses a JSON-path expression to select the attribute-value pair in the message
         *                    payload that is used for identification. To route the message to the correct detector instance,
         *                    the device must send a message payload that contains the same attribute-value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder detectorKey(java.lang.String detectorKey) {
            this.detectorKey = detectorKey;
            return this;
        }

        /**
         * Sets the value of {@link DetectorModelProps#getDetectorModelName}
         * @param detectorModelName The name of the detector model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder detectorModelName(java.lang.String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        /**
         * Sets the value of {@link DetectorModelProps#getEvaluationMethod}
         * @param evaluationMethod Information about the order in which events are evaluated and how actions are executed.
         *                         When setting to SERIAL, variables are updated and event conditions are evaluated in the order
         *                         that the events are defined.
         *                         When setting to BATCH, variables within a state are updated and events within a state are
         *                         performed only after all event conditions are evaluated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder evaluationMethod(software.amazon.awscdk.services.iotevents.EventEvaluation evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
            return this;
        }

        /**
         * Sets the value of {@link DetectorModelProps#getRole}
         * @param role The role that grants permission to AWS IoT Events to perform its operations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DetectorModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DetectorModelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DetectorModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DetectorModelProps {
        private final software.amazon.awscdk.services.iotevents.State initialState;
        private final java.lang.String description;
        private final java.lang.String detectorKey;
        private final java.lang.String detectorModelName;
        private final software.amazon.awscdk.services.iotevents.EventEvaluation evaluationMethod;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.initialState = software.amazon.jsii.Kernel.get(this, "initialState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.State.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detectorKey = software.amazon.jsii.Kernel.get(this, "detectorKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detectorModelName = software.amazon.jsii.Kernel.get(this, "detectorModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationMethod = software.amazon.jsii.Kernel.get(this, "evaluationMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.EventEvaluation.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.initialState = java.util.Objects.requireNonNull(builder.initialState, "initialState is required");
            this.description = builder.description;
            this.detectorKey = builder.detectorKey;
            this.detectorModelName = builder.detectorModelName;
            this.evaluationMethod = builder.evaluationMethod;
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.iotevents.State getInitialState() {
            return this.initialState;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDetectorKey() {
            return this.detectorKey;
        }

        @Override
        public final java.lang.String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        public final software.amazon.awscdk.services.iotevents.EventEvaluation getEvaluationMethod() {
            return this.evaluationMethod;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("initialState", om.valueToTree(this.getInitialState()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDetectorKey() != null) {
                data.set("detectorKey", om.valueToTree(this.getDetectorKey()));
            }
            if (this.getDetectorModelName() != null) {
                data.set("detectorModelName", om.valueToTree(this.getDetectorModelName()));
            }
            if (this.getEvaluationMethod() != null) {
                data.set("evaluationMethod", om.valueToTree(this.getEvaluationMethod()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iotevents.DetectorModelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DetectorModelProps.Jsii$Proxy that = (DetectorModelProps.Jsii$Proxy) o;

            if (!initialState.equals(that.initialState)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.detectorKey != null ? !this.detectorKey.equals(that.detectorKey) : that.detectorKey != null) return false;
            if (this.detectorModelName != null ? !this.detectorModelName.equals(that.detectorModelName) : that.detectorModelName != null) return false;
            if (this.evaluationMethod != null ? !this.evaluationMethod.equals(that.evaluationMethod) : that.evaluationMethod != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.initialState.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.detectorKey != null ? this.detectorKey.hashCode() : 0);
            result = 31 * result + (this.detectorModelName != null ? this.detectorModelName.hashCode() : 0);
            result = 31 * result + (this.evaluationMethod != null ? this.evaluationMethod.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
