package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Specifies the actions to be performed when the condition evaluates to `true`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotevents.*;
 * IAction action;
 * Expression expression;
 * Event event = Event.builder()
 *         .eventName("eventName")
 *         // the properties below are optional
 *         .actions(List.of(action))
 *         .condition(expression)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.872Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.Event")
@software.amazon.jsii.Jsii.Proxy(Event.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Event extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name of the event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getEventName();

    /**
     * (experimental) The actions to be performed.
     * <p>
     * Default: - no actions will be performed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iotevents.IAction> getActions() {
        return null;
    }

    /**
     * (experimental) The Boolean expression that, when `true`, causes the actions to be performed.
     * <p>
     * Default: - none (the actions are always executed)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iotevents.Expression getCondition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Event}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Event}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<Event> {
        java.lang.String eventName;
        java.util.List<software.amazon.awscdk.services.iotevents.IAction> actions;
        software.amazon.awscdk.services.iotevents.Expression condition;

        /**
         * Sets the value of {@link Event#getEventName}
         * @param eventName The name of the event. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eventName(java.lang.String eventName) {
            this.eventName = eventName;
            return this;
        }

        /**
         * Sets the value of {@link Event#getActions}
         * @param actions The actions to be performed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder actions(java.util.List<? extends software.amazon.awscdk.services.iotevents.IAction> actions) {
            this.actions = (java.util.List<software.amazon.awscdk.services.iotevents.IAction>)actions;
            return this;
        }

        /**
         * Sets the value of {@link Event#getCondition}
         * @param condition The Boolean expression that, when `true`, causes the actions to be performed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder condition(software.amazon.awscdk.services.iotevents.Expression condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Event}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public Event build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Event}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Event {
        private final java.lang.String eventName;
        private final java.util.List<software.amazon.awscdk.services.iotevents.IAction> actions;
        private final software.amazon.awscdk.services.iotevents.Expression condition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventName = software.amazon.jsii.Kernel.get(this, "eventName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.IAction.class)));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventName = java.util.Objects.requireNonNull(builder.eventName, "eventName is required");
            this.actions = (java.util.List<software.amazon.awscdk.services.iotevents.IAction>)builder.actions;
            this.condition = builder.condition;
        }

        @Override
        public final java.lang.String getEventName() {
            return this.eventName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iotevents.IAction> getActions() {
            return this.actions;
        }

        @Override
        public final software.amazon.awscdk.services.iotevents.Expression getCondition() {
            return this.condition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventName", om.valueToTree(this.getEventName()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iotevents.Event"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Event.Jsii$Proxy that = (Event.Jsii$Proxy) o;

            if (!eventName.equals(that.eventName)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            return this.condition != null ? this.condition.equals(that.condition) : that.condition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventName.hashCode();
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            return result;
        }
    }
}
