package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Properties for defining an AWS IoT Events input.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IFunction func;
 * Input input = Input.Builder.create(this, "MyInput")
 *         .inputName("my_input") // optional
 *         .attributeJsonPaths(List.of("payload.deviceId", "payload.temperature"))
 *         .build();
 * State warmState = State.Builder.create()
 *         .stateName("warm")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-enter-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(new LambdaInvokeAction(func)))
 *                 .build()))
 *         .onInput(List.of(Event.builder() // optional
 *                 .eventName("test-input-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .onExit(List.of(Event.builder() // optional
 *                 .eventName("test-exit-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .build();
 * State coldState = State.Builder.create()
 *         .stateName("cold")
 *         .build();
 * // transit to coldState when temperature is less than 15
 * warmState.transitionTo(coldState, TransitionOptions.builder()
 *         .eventName("to_coldState") // optional property, default by combining the names of the States
 *         .when(Expression.lt(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .executing(List.of(new LambdaInvokeAction(func)))
 *         .build());
 * // transit to warmState when temperature is greater than or equal to 15
 * coldState.transitionTo(warmState, TransitionOptions.builder()
 *         .when(Expression.gte(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .build());
 * DetectorModel.Builder.create(this, "MyDetectorModel")
 *         .detectorModelName("test-detector-model") // optional
 *         .description("test-detector-model-description") // optional property, default is none
 *         .evaluationMethod(EventEvaluation.SERIAL) // optional property, default is iotevents.EventEvaluation.BATCH
 *         .detectorKey("payload.deviceId") // optional property, default is none and single detector instance will be created and all inputs will be routed to it
 *         .initialState(warmState)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.InputProps")
@software.amazon.jsii.Jsii.Proxy(InputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface InputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) An expression that specifies an attribute-value pair in a JSON structure.
     * <p>
     * Use this to specify an attribute from the JSON payload that is made available
     * by the input. Inputs are derived from messages sent to AWS IoT Events (BatchPutMessage).
     * Each such message contains a JSON payload. The attribute (and its paired value)
     * specified here are available for use in the condition expressions used by detectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttributeJsonPaths();

    /**
     * (experimental) The name of the input.
     * <p>
     * Default: - CloudFormation will generate a unique name of the input
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<InputProps> {
        java.util.List<java.lang.String> attributeJsonPaths;
        java.lang.String inputName;

        /**
         * Sets the value of {@link InputProps#getAttributeJsonPaths}
         * @param attributeJsonPaths An expression that specifies an attribute-value pair in a JSON structure. This parameter is required.
         *                           Use this to specify an attribute from the JSON payload that is made available
         *                           by the input. Inputs are derived from messages sent to AWS IoT Events (BatchPutMessage).
         *                           Each such message contains a JSON payload. The attribute (and its paired value)
         *                           specified here are available for use in the condition expressions used by detectors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeJsonPaths(java.util.List<java.lang.String> attributeJsonPaths) {
            this.attributeJsonPaths = attributeJsonPaths;
            return this;
        }

        /**
         * Sets the value of {@link InputProps#getInputName}
         * @param inputName The name of the input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputName(java.lang.String inputName) {
            this.inputName = inputName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public InputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProps {
        private final java.util.List<java.lang.String> attributeJsonPaths;
        private final java.lang.String inputName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attributeJsonPaths = software.amazon.jsii.Kernel.get(this, "attributeJsonPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.inputName = software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attributeJsonPaths = java.util.Objects.requireNonNull(builder.attributeJsonPaths, "attributeJsonPaths is required");
            this.inputName = builder.inputName;
        }

        @Override
        public final java.util.List<java.lang.String> getAttributeJsonPaths() {
            return this.attributeJsonPaths;
        }

        @Override
        public final java.lang.String getInputName() {
            return this.inputName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("attributeJsonPaths", om.valueToTree(this.getAttributeJsonPaths()));
            if (this.getInputName() != null) {
                data.set("inputName", om.valueToTree(this.getInputName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iotevents.InputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InputProps.Jsii$Proxy that = (InputProps.Jsii$Proxy) o;

            if (!attributeJsonPaths.equals(that.attributeJsonPaths)) return false;
            return this.inputName != null ? this.inputName.equals(that.inputName) : that.inputName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.attributeJsonPaths.hashCode();
            result = 31 * result + (this.inputName != null ? this.inputName.hashCode() : 0);
            return result;
        }
    }
}
