/**
 * <h1>Actions for AWS::IoTEvents Detector Model</h1>
 * <p>
 * This library contains integration classes to specify actions of state events of Detector Model in <code>&#64;aws-cdk/aws-iotevents</code>.
 * Instances of these classes should be passed to <code>State</code> defined in <code>&#64;aws-cdk/aws-iotevents</code>
 * You can define built-in actions to use a timer or set a variable, or send data to other AWS resources.
 * <p>
 * This library contains integration classes to use a timer or set a variable, or send data to other AWS resources.
 * AWS IoT Events can trigger actions when it detects a specified event or transition event.
 * <p>
 * Currently supported are:
 * <p>
 * <ul>
 * <li>Set variable to detector instanse</li>
 * <li>Invoke a Lambda function</li>
 * </ul>
 * <p>
 * <h2>Set variable to detector instanse</h2>
 * <p>
 * The code snippet below creates an Action that set variable to detector instanse
 * when it is triggered.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * 
 * IInput input;
 * 
 * 
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(actions, List.of(
 *                     new SetVariableAction("MyVariable", Expression.inputAttribute(input, "payload.temperature")))))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Invoke a Lambda function</h2>
 * <p>
 * The code snippet below creates an Action that invoke a Lambda function
 * when it is triggered.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * 
 * IInput input;
 * IFunction func;
 * 
 * 
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(new LambdaInvokeAction(func)))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.iotevents.actions;
