package software.amazon.awscdk.services.iotfleetwise;

/**
 * A CloudFormation `AWS::IoTFleetWise::Campaign`.
 * <p>
 * Creates an orchestration of data collection rules. The AWS IoT FleetWise Edge Agent software running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns in the cloud. After you or your team approve campaigns, AWS IoT FleetWise automatically deploys them to vehicles.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html">Collect and transfer data with campaigns</a> in the <em>AWS IoT FleetWise Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnCampaign cfnCampaign = CfnCampaign.Builder.create(this, "MyCfnCampaign")
 *         .action("action")
 *         .collectionScheme(CollectionSchemeProperty.builder()
 *                 .conditionBasedCollectionScheme(ConditionBasedCollectionSchemeProperty.builder()
 *                         .expression("expression")
 *                         // the properties below are optional
 *                         .conditionLanguageVersion(123)
 *                         .minimumTriggerIntervalMs(123)
 *                         .triggerMode("triggerMode")
 *                         .build())
 *                 .timeBasedCollectionScheme(TimeBasedCollectionSchemeProperty.builder()
 *                         .periodMs(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .signalCatalogArn("signalCatalogArn")
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .compression("compression")
 *         .dataExtraDimensions(List.of("dataExtraDimensions"))
 *         .description("description")
 *         .diagnosticsMode("diagnosticsMode")
 *         .expiryTime("expiryTime")
 *         .postTriggerCollectionDuration(123)
 *         .priority(123)
 *         .signalsToCollect(List.of(SignalInformationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .maxSampleCount(123)
 *                 .minimumSamplingIntervalMs(123)
 *                 .build()))
 *         .spoolingMode("spoolingMode")
 *         .startTime("startTime")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.898Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnCampaign")
public class CfnCampaign extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCampaign(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTFleetWise::Campaign`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCampaign(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnCampaignProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.Action`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAction() {
        return software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.Action`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "action", java.util.Objects.requireNonNull(value, "action is required"));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.CollectionScheme`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCollectionScheme() {
        return software.amazon.jsii.Kernel.get(this, "collectionScheme", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.CollectionScheme`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollectionScheme(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnCampaign.CollectionSchemeProperty value) {
        software.amazon.jsii.Kernel.set(this, "collectionScheme", java.util.Objects.requireNonNull(value, "collectionScheme is required"));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.CollectionScheme`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollectionScheme(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "collectionScheme", java.util.Objects.requireNonNull(value, "collectionScheme is required"));
    }

    /**
     * The name of a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The ARN of the signal catalog associated with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSignalCatalogArn() {
        return software.amazon.jsii.Kernel.get(this, "signalCatalogArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the signal catalog associated with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalCatalogArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "signalCatalogArn", java.util.Objects.requireNonNull(value, "signalCatalogArn is required"));
    }

    /**
     * The ARN of a vehicle or fleet to which the campaign is deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetArn() {
        return software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of a vehicle or fleet to which the campaign is deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetArn", java.util.Objects.requireNonNull(value, "targetArn is required"));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.Compression`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
        return software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.Compression`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "compression", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.DataExtraDimensions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataExtraDimensions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dataExtraDimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.DataExtraDimensions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataExtraDimensions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dataExtraDimensions", value);
    }

    /**
     * The description of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.DiagnosticsMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDiagnosticsMode() {
        return software.amazon.jsii.Kernel.get(this, "diagnosticsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.DiagnosticsMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDiagnosticsMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "diagnosticsMode", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.ExpiryTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExpiryTime() {
        return software.amazon.jsii.Kernel.get(this, "expiryTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.ExpiryTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExpiryTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "expiryTime", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.PostTriggerCollectionDuration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPostTriggerCollectionDuration() {
        return software.amazon.jsii.Kernel.get(this, "postTriggerCollectionDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.PostTriggerCollectionDuration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostTriggerCollectionDuration(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "postTriggerCollectionDuration", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.Priority`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.Priority`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPriority(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "priority", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.SignalsToCollect`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSignalsToCollect() {
        return software.amazon.jsii.Kernel.get(this, "signalsToCollect", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.SignalsToCollect`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalsToCollect(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "signalsToCollect", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.SignalsToCollect`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalsToCollect(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnCampaign.SignalInformationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.iotfleetwise.CfnCampaign.SignalInformationProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "signalsToCollect", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.SpoolingMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSpoolingMode() {
        return software.amazon.jsii.Kernel.get(this, "spoolingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.SpoolingMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpoolingMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "spoolingMode", value);
    }

    /**
     * `AWS::IoTFleetWise::Campaign.StartTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
        return software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::IoTFleetWise::Campaign.StartTime`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startTime", value);
    }
    /**
     * Specifies what data to collect and how often or when to collect it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CollectionSchemeProperty collectionSchemeProperty = CollectionSchemeProperty.builder()
     *         .conditionBasedCollectionScheme(ConditionBasedCollectionSchemeProperty.builder()
     *                 .expression("expression")
     *                 // the properties below are optional
     *                 .conditionLanguageVersion(123)
     *                 .minimumTriggerIntervalMs(123)
     *                 .triggerMode("triggerMode")
     *                 .build())
     *         .timeBasedCollectionScheme(TimeBasedCollectionSchemeProperty.builder()
     *                 .periodMs(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnCampaign.CollectionSchemeProperty")
    @software.amazon.jsii.Jsii.Proxy(CollectionSchemeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CollectionSchemeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditionBasedCollectionScheme() {
            return null;
        }

        /**
         * Information about a collection scheme that uses a time period to decide how often to collect data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeBasedCollectionScheme() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CollectionSchemeProperty> {
            java.lang.Object conditionBasedCollectionScheme;
            java.lang.Object timeBasedCollectionScheme;

            /**
             * Sets the value of {@link CollectionSchemeProperty#getConditionBasedCollectionScheme}
             * @param conditionBasedCollectionScheme Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionBasedCollectionScheme(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.ConditionBasedCollectionSchemeProperty conditionBasedCollectionScheme) {
                this.conditionBasedCollectionScheme = conditionBasedCollectionScheme;
                return this;
            }

            /**
             * Sets the value of {@link CollectionSchemeProperty#getConditionBasedCollectionScheme}
             * @param conditionBasedCollectionScheme Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionBasedCollectionScheme(software.amazon.awscdk.core.IResolvable conditionBasedCollectionScheme) {
                this.conditionBasedCollectionScheme = conditionBasedCollectionScheme;
                return this;
            }

            /**
             * Sets the value of {@link CollectionSchemeProperty#getTimeBasedCollectionScheme}
             * @param timeBasedCollectionScheme Information about a collection scheme that uses a time period to decide how often to collect data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedCollectionScheme(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.TimeBasedCollectionSchemeProperty timeBasedCollectionScheme) {
                this.timeBasedCollectionScheme = timeBasedCollectionScheme;
                return this;
            }

            /**
             * Sets the value of {@link CollectionSchemeProperty#getTimeBasedCollectionScheme}
             * @param timeBasedCollectionScheme Information about a collection scheme that uses a time period to decide how often to collect data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeBasedCollectionScheme(software.amazon.awscdk.core.IResolvable timeBasedCollectionScheme) {
                this.timeBasedCollectionScheme = timeBasedCollectionScheme;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CollectionSchemeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CollectionSchemeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CollectionSchemeProperty {
            private final java.lang.Object conditionBasedCollectionScheme;
            private final java.lang.Object timeBasedCollectionScheme;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditionBasedCollectionScheme = software.amazon.jsii.Kernel.get(this, "conditionBasedCollectionScheme", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeBasedCollectionScheme = software.amazon.jsii.Kernel.get(this, "timeBasedCollectionScheme", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditionBasedCollectionScheme = builder.conditionBasedCollectionScheme;
                this.timeBasedCollectionScheme = builder.timeBasedCollectionScheme;
            }

            @Override
            public final java.lang.Object getConditionBasedCollectionScheme() {
                return this.conditionBasedCollectionScheme;
            }

            @Override
            public final java.lang.Object getTimeBasedCollectionScheme() {
                return this.timeBasedCollectionScheme;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditionBasedCollectionScheme() != null) {
                    data.set("conditionBasedCollectionScheme", om.valueToTree(this.getConditionBasedCollectionScheme()));
                }
                if (this.getTimeBasedCollectionScheme() != null) {
                    data.set("timeBasedCollectionScheme", om.valueToTree(this.getTimeBasedCollectionScheme()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnCampaign.CollectionSchemeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CollectionSchemeProperty.Jsii$Proxy that = (CollectionSchemeProperty.Jsii$Proxy) o;

                if (this.conditionBasedCollectionScheme != null ? !this.conditionBasedCollectionScheme.equals(that.conditionBasedCollectionScheme) : that.conditionBasedCollectionScheme != null) return false;
                return this.timeBasedCollectionScheme != null ? this.timeBasedCollectionScheme.equals(that.timeBasedCollectionScheme) : that.timeBasedCollectionScheme == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditionBasedCollectionScheme != null ? this.conditionBasedCollectionScheme.hashCode() : 0;
                result = 31 * result + (this.timeBasedCollectionScheme != null ? this.timeBasedCollectionScheme.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ConditionBasedCollectionSchemeProperty conditionBasedCollectionSchemeProperty = ConditionBasedCollectionSchemeProperty.builder()
     *         .expression("expression")
     *         // the properties below are optional
     *         .conditionLanguageVersion(123)
     *         .minimumTriggerIntervalMs(123)
     *         .triggerMode("triggerMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnCampaign.ConditionBasedCollectionSchemeProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionBasedCollectionSchemeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionBasedCollectionSchemeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The logical expression used to recognize what data to collect.
         * <p>
         * For example, <code>$variable.Vehicle.OutsideAirTemperature &gt;= 105.0</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * Specifies the version of the conditional expression language.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConditionLanguageVersion() {
            return null;
        }

        /**
         * The minimum duration of time between two triggering events to collect data, in milliseconds.
         * <p>
         * <blockquote>
         * <p>
         * If a signal changes often, you might want to collect data at a slower rate.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumTriggerIntervalMs() {
            return null;
        }

        /**
         * Whether to collect data for all triggering events ( `ALWAYS` ).
         * <p>
         * Specify ( <code>RISING_EDGE</code> ), or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already exploded; they only care about the change from not deployed =&gt; deployed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTriggerMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionBasedCollectionSchemeProperty> {
            java.lang.String expression;
            java.lang.Number conditionLanguageVersion;
            java.lang.Number minimumTriggerIntervalMs;
            java.lang.String triggerMode;

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getExpression}
             * @param expression The logical expression used to recognize what data to collect. This parameter is required.
             *                   For example, <code>$variable.Vehicle.OutsideAirTemperature &gt;= 105.0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getConditionLanguageVersion}
             * @param conditionLanguageVersion Specifies the version of the conditional expression language.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionLanguageVersion(java.lang.Number conditionLanguageVersion) {
                this.conditionLanguageVersion = conditionLanguageVersion;
                return this;
            }

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getMinimumTriggerIntervalMs}
             * @param minimumTriggerIntervalMs The minimum duration of time between two triggering events to collect data, in milliseconds.
             *                                 <blockquote>
             *                                 <p>
             *                                 If a signal changes often, you might want to collect data at a slower rate.
             *                                 <p>
             *                                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumTriggerIntervalMs(java.lang.Number minimumTriggerIntervalMs) {
                this.minimumTriggerIntervalMs = minimumTriggerIntervalMs;
                return this;
            }

            /**
             * Sets the value of {@link ConditionBasedCollectionSchemeProperty#getTriggerMode}
             * @param triggerMode Whether to collect data for all triggering events ( `ALWAYS` ).
             *                    Specify ( <code>RISING_EDGE</code> ), or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already exploded; they only care about the change from not deployed =&gt; deployed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerMode(java.lang.String triggerMode) {
                this.triggerMode = triggerMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionBasedCollectionSchemeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionBasedCollectionSchemeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionBasedCollectionSchemeProperty {
            private final java.lang.String expression;
            private final java.lang.Number conditionLanguageVersion;
            private final java.lang.Number minimumTriggerIntervalMs;
            private final java.lang.String triggerMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.conditionLanguageVersion = software.amazon.jsii.Kernel.get(this, "conditionLanguageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumTriggerIntervalMs = software.amazon.jsii.Kernel.get(this, "minimumTriggerIntervalMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.triggerMode = software.amazon.jsii.Kernel.get(this, "triggerMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.conditionLanguageVersion = builder.conditionLanguageVersion;
                this.minimumTriggerIntervalMs = builder.minimumTriggerIntervalMs;
                this.triggerMode = builder.triggerMode;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Number getConditionLanguageVersion() {
                return this.conditionLanguageVersion;
            }

            @Override
            public final java.lang.Number getMinimumTriggerIntervalMs() {
                return this.minimumTriggerIntervalMs;
            }

            @Override
            public final java.lang.String getTriggerMode() {
                return this.triggerMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                if (this.getConditionLanguageVersion() != null) {
                    data.set("conditionLanguageVersion", om.valueToTree(this.getConditionLanguageVersion()));
                }
                if (this.getMinimumTriggerIntervalMs() != null) {
                    data.set("minimumTriggerIntervalMs", om.valueToTree(this.getMinimumTriggerIntervalMs()));
                }
                if (this.getTriggerMode() != null) {
                    data.set("triggerMode", om.valueToTree(this.getTriggerMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnCampaign.ConditionBasedCollectionSchemeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionBasedCollectionSchemeProperty.Jsii$Proxy that = (ConditionBasedCollectionSchemeProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                if (this.conditionLanguageVersion != null ? !this.conditionLanguageVersion.equals(that.conditionLanguageVersion) : that.conditionLanguageVersion != null) return false;
                if (this.minimumTriggerIntervalMs != null ? !this.minimumTriggerIntervalMs.equals(that.minimumTriggerIntervalMs) : that.minimumTriggerIntervalMs != null) return false;
                return this.triggerMode != null ? this.triggerMode.equals(that.triggerMode) : that.triggerMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.conditionLanguageVersion != null ? this.conditionLanguageVersion.hashCode() : 0);
                result = 31 * result + (this.minimumTriggerIntervalMs != null ? this.minimumTriggerIntervalMs.hashCode() : 0);
                result = 31 * result + (this.triggerMode != null ? this.triggerMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a signal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * SignalInformationProperty signalInformationProperty = SignalInformationProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .maxSampleCount(123)
     *         .minimumSamplingIntervalMs(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnCampaign.SignalInformationProperty")
    @software.amazon.jsii.Jsii.Proxy(SignalInformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SignalInformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the signal.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The maximum number of samples to collect.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSampleCount() {
            return null;
        }

        /**
         * The minimum duration of time (in milliseconds) between two triggering events to collect data.
         * <p>
         * <blockquote>
         * <p>
         * If a signal changes often, you might want to collect data at a slower rate.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumSamplingIntervalMs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SignalInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SignalInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SignalInformationProperty> {
            java.lang.String name;
            java.lang.Number maxSampleCount;
            java.lang.Number minimumSamplingIntervalMs;

            /**
             * Sets the value of {@link SignalInformationProperty#getName}
             * @param name The name of the signal. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SignalInformationProperty#getMaxSampleCount}
             * @param maxSampleCount The maximum number of samples to collect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSampleCount(java.lang.Number maxSampleCount) {
                this.maxSampleCount = maxSampleCount;
                return this;
            }

            /**
             * Sets the value of {@link SignalInformationProperty#getMinimumSamplingIntervalMs}
             * @param minimumSamplingIntervalMs The minimum duration of time (in milliseconds) between two triggering events to collect data.
             *                                  <blockquote>
             *                                  <p>
             *                                  If a signal changes often, you might want to collect data at a slower rate.
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumSamplingIntervalMs(java.lang.Number minimumSamplingIntervalMs) {
                this.minimumSamplingIntervalMs = minimumSamplingIntervalMs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SignalInformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SignalInformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SignalInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignalInformationProperty {
            private final java.lang.String name;
            private final java.lang.Number maxSampleCount;
            private final java.lang.Number minimumSamplingIntervalMs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxSampleCount = software.amazon.jsii.Kernel.get(this, "maxSampleCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumSamplingIntervalMs = software.amazon.jsii.Kernel.get(this, "minimumSamplingIntervalMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.maxSampleCount = builder.maxSampleCount;
                this.minimumSamplingIntervalMs = builder.minimumSamplingIntervalMs;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getMaxSampleCount() {
                return this.maxSampleCount;
            }

            @Override
            public final java.lang.Number getMinimumSamplingIntervalMs() {
                return this.minimumSamplingIntervalMs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getMaxSampleCount() != null) {
                    data.set("maxSampleCount", om.valueToTree(this.getMaxSampleCount()));
                }
                if (this.getMinimumSamplingIntervalMs() != null) {
                    data.set("minimumSamplingIntervalMs", om.valueToTree(this.getMinimumSamplingIntervalMs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnCampaign.SignalInformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SignalInformationProperty.Jsii$Proxy that = (SignalInformationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.maxSampleCount != null ? !this.maxSampleCount.equals(that.maxSampleCount) : that.maxSampleCount != null) return false;
                return this.minimumSamplingIntervalMs != null ? this.minimumSamplingIntervalMs.equals(that.minimumSamplingIntervalMs) : that.minimumSamplingIntervalMs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.maxSampleCount != null ? this.maxSampleCount.hashCode() : 0);
                result = 31 * result + (this.minimumSamplingIntervalMs != null ? this.minimumSamplingIntervalMs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a collection scheme that uses a time period to decide how often to collect data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * TimeBasedCollectionSchemeProperty timeBasedCollectionSchemeProperty = TimeBasedCollectionSchemeProperty.builder()
     *         .periodMs(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnCampaign.TimeBasedCollectionSchemeProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeBasedCollectionSchemeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeBasedCollectionSchemeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time period (in milliseconds) to decide how often to collect data.
         * <p>
         * For example, if the time period is <code>60000</code> , the Edge Agent software collects data once every minute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriodMs();

        /**
         * @return a {@link Builder} of {@link TimeBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeBasedCollectionSchemeProperty> {
            java.lang.Number periodMs;

            /**
             * Sets the value of {@link TimeBasedCollectionSchemeProperty#getPeriodMs}
             * @param periodMs The time period (in milliseconds) to decide how often to collect data. This parameter is required.
             *                 For example, if the time period is <code>60000</code> , the Edge Agent software collects data once every minute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodMs(java.lang.Number periodMs) {
                this.periodMs = periodMs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeBasedCollectionSchemeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeBasedCollectionSchemeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeBasedCollectionSchemeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeBasedCollectionSchemeProperty {
            private final java.lang.Number periodMs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.periodMs = software.amazon.jsii.Kernel.get(this, "periodMs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.periodMs = java.util.Objects.requireNonNull(builder.periodMs, "periodMs is required");
            }

            @Override
            public final java.lang.Number getPeriodMs() {
                return this.periodMs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("periodMs", om.valueToTree(this.getPeriodMs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnCampaign.TimeBasedCollectionSchemeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeBasedCollectionSchemeProperty.Jsii$Proxy that = (TimeBasedCollectionSchemeProperty.Jsii$Proxy) o;

                return this.periodMs.equals(that.periodMs);
            }

            @Override
            public final int hashCode() {
                int result = this.periodMs.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotfleetwise.CfnCampaign}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotfleetwise.CfnCampaign> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotfleetwise.CfnCampaignProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotfleetwise.CfnCampaignProps.Builder();
        }

        /**
         * `AWS::IoTFleetWise::Campaign.Action`.
         * <p>
         * @return {@code this}
         * @param action `AWS::IoTFleetWise::Campaign.Action`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.CollectionScheme`.
         * <p>
         * @return {@code this}
         * @param collectionScheme `AWS::IoTFleetWise::Campaign.CollectionScheme`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionScheme(final software.amazon.awscdk.services.iotfleetwise.CfnCampaign.CollectionSchemeProperty collectionScheme) {
            this.props.collectionScheme(collectionScheme);
            return this;
        }
        /**
         * `AWS::IoTFleetWise::Campaign.CollectionScheme`.
         * <p>
         * @return {@code this}
         * @param collectionScheme `AWS::IoTFleetWise::Campaign.CollectionScheme`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionScheme(final software.amazon.awscdk.core.IResolvable collectionScheme) {
            this.props.collectionScheme(collectionScheme);
            return this;
        }

        /**
         * The name of a campaign.
         * <p>
         * @return {@code this}
         * @param name The name of a campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The ARN of the signal catalog associated with the campaign.
         * <p>
         * @return {@code this}
         * @param signalCatalogArn The ARN of the signal catalog associated with the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalCatalogArn(final java.lang.String signalCatalogArn) {
            this.props.signalCatalogArn(signalCatalogArn);
            return this;
        }

        /**
         * The ARN of a vehicle or fleet to which the campaign is deployed.
         * <p>
         * @return {@code this}
         * @param targetArn The ARN of a vehicle or fleet to which the campaign is deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(final java.lang.String targetArn) {
            this.props.targetArn(targetArn);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.Compression`.
         * <p>
         * @return {@code this}
         * @param compression `AWS::IoTFleetWise::Campaign.Compression`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(final java.lang.String compression) {
            this.props.compression(compression);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.DataExtraDimensions`.
         * <p>
         * @return {@code this}
         * @param dataExtraDimensions `AWS::IoTFleetWise::Campaign.DataExtraDimensions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataExtraDimensions(final java.util.List<java.lang.String> dataExtraDimensions) {
            this.props.dataExtraDimensions(dataExtraDimensions);
            return this;
        }

        /**
         * The description of the campaign.
         * <p>
         * @return {@code this}
         * @param description The description of the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.DiagnosticsMode`.
         * <p>
         * @return {@code this}
         * @param diagnosticsMode `AWS::IoTFleetWise::Campaign.DiagnosticsMode`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diagnosticsMode(final java.lang.String diagnosticsMode) {
            this.props.diagnosticsMode(diagnosticsMode);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.ExpiryTime`.
         * <p>
         * @return {@code this}
         * @param expiryTime `AWS::IoTFleetWise::Campaign.ExpiryTime`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expiryTime(final java.lang.String expiryTime) {
            this.props.expiryTime(expiryTime);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.PostTriggerCollectionDuration`.
         * <p>
         * @return {@code this}
         * @param postTriggerCollectionDuration `AWS::IoTFleetWise::Campaign.PostTriggerCollectionDuration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postTriggerCollectionDuration(final java.lang.Number postTriggerCollectionDuration) {
            this.props.postTriggerCollectionDuration(postTriggerCollectionDuration);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.Priority`.
         * <p>
         * @return {@code this}
         * @param priority `AWS::IoTFleetWise::Campaign.Priority`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.SignalsToCollect`.
         * <p>
         * @return {@code this}
         * @param signalsToCollect `AWS::IoTFleetWise::Campaign.SignalsToCollect`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToCollect(final software.amazon.awscdk.core.IResolvable signalsToCollect) {
            this.props.signalsToCollect(signalsToCollect);
            return this;
        }
        /**
         * `AWS::IoTFleetWise::Campaign.SignalsToCollect`.
         * <p>
         * @return {@code this}
         * @param signalsToCollect `AWS::IoTFleetWise::Campaign.SignalsToCollect`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToCollect(final java.util.List<? extends java.lang.Object> signalsToCollect) {
            this.props.signalsToCollect(signalsToCollect);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.SpoolingMode`.
         * <p>
         * @return {@code this}
         * @param spoolingMode `AWS::IoTFleetWise::Campaign.SpoolingMode`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spoolingMode(final java.lang.String spoolingMode) {
            this.props.spoolingMode(spoolingMode);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.StartTime`.
         * <p>
         * @return {@code this}
         * @param startTime `AWS::IoTFleetWise::Campaign.StartTime`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(final java.lang.String startTime) {
            this.props.startTime(startTime);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::Campaign.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::IoTFleetWise::Campaign.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotfleetwise.CfnCampaign}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotfleetwise.CfnCampaign build() {
            return new software.amazon.awscdk.services.iotfleetwise.CfnCampaign(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
