package software.amazon.awscdk.services.iotfleetwise;

/**
 * A CloudFormation `AWS::IoTFleetWise::DecoderManifest`.
 * <p>
 * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must be true:
 * <p>
 * <ul>
 * <li>Every signal decoder has a unique name.</li>
 * <li>Each signal decoder is associated with a network interface.</li>
 * <li>Each network interface has a unique ID.</li>
 * <li>The signal decoders are specified in the model manifest.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnDecoderManifest cfnDecoderManifest = CfnDecoderManifest.Builder.create(this, "MyCfnDecoderManifest")
 *         .modelManifestArn("modelManifestArn")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .networkInterfaces(List.of(NetworkInterfacesItemsProperty.builder()
 *                 .interfaceId("interfaceId")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .canInterface(CanInterfaceProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .protocolName("protocolName")
 *                         .protocolVersion("protocolVersion")
 *                         .build())
 *                 .obdInterface(ObdInterfaceProperty.builder()
 *                         .name("name")
 *                         .requestMessageId("requestMessageId")
 *                         // the properties below are optional
 *                         .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
 *                         .hasTransmissionEcu("hasTransmissionEcu")
 *                         .obdStandard("obdStandard")
 *                         .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
 *                         .useExtendedIds("useExtendedIds")
 *                         .build())
 *                 .build()))
 *         .signalDecoders(List.of(SignalDecodersItemsProperty.builder()
 *                 .fullyQualifiedName("fullyQualifiedName")
 *                 .interfaceId("interfaceId")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .canSignal(CanSignalProperty.builder()
 *                         .factor("factor")
 *                         .isBigEndian("isBigEndian")
 *                         .isSigned("isSigned")
 *                         .length("length")
 *                         .messageId("messageId")
 *                         .offset("offset")
 *                         .startBit("startBit")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .build())
 *                 .obdSignal(ObdSignalProperty.builder()
 *                         .byteLength("byteLength")
 *                         .offset("offset")
 *                         .pid("pid")
 *                         .pidResponseLength("pidResponseLength")
 *                         .scaling("scaling")
 *                         .serviceMode("serviceMode")
 *                         .startByte("startByte")
 *                         // the properties below are optional
 *                         .bitMaskLength("bitMaskLength")
 *                         .bitRightShift("bitRightShift")
 *                         .build())
 *                 .build()))
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:03.907Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnDecoderManifest")
public class CfnDecoderManifest extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDecoderManifest(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDecoderManifest(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTFleetWise::DecoderManifest`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDecoderManifest(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModificationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModificationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ARN of a vehicle model (model manifest) associated with the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelManifestArn() {
        return software.amazon.jsii.Kernel.get(this, "modelManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of a vehicle model (model manifest) associated with the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelManifestArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelManifestArn", java.util.Objects.requireNonNull(value, "modelManifestArn is required"));
    }

    /**
     * The name of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A brief description of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A brief description of the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
        return software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkInterfaces(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "networkInterfaces", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSignalDecoders() {
        return software.amazon.jsii.Kernel.get(this, "signalDecoders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalDecoders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "signalDecoders", value);
    }

    /**
     * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSignalDecoders(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "signalDecoders", value);
    }

    /**
     * The state of the decoder manifest.
     * <p>
     * If the status is <code>ACTIVE</code> , the decoder manifest can't be edited. If the status is marked <code>DRAFT</code> , you can edit the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the decoder manifest.
     * <p>
     * If the status is <code>ACTIVE</code> , the decoder manifest can't be edited. If the status is marked <code>DRAFT</code> , you can edit the decoder manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }
    /**
     * A single controller area network (CAN) device interface.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanInterfaceProperty canInterfaceProperty = CanInterfaceProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .protocolName("protocolName")
     *         .protocolVersion("protocolVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnDecoderManifest.CanInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(CanInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique name of the interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the communication protocol for the interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocolName() {
            return null;
        }

        /**
         * The version of the communication protocol for the interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocolVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanInterfaceProperty> {
            java.lang.String name;
            java.lang.String protocolName;
            java.lang.String protocolVersion;

            /**
             * Sets the value of {@link CanInterfaceProperty#getName}
             * @param name The unique name of the interface. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CanInterfaceProperty#getProtocolName}
             * @param protocolName The name of the communication protocol for the interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolName(java.lang.String protocolName) {
                this.protocolName = protocolName;
                return this;
            }

            /**
             * Sets the value of {@link CanInterfaceProperty#getProtocolVersion}
             * @param protocolVersion The version of the communication protocol for the interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolVersion(java.lang.String protocolVersion) {
                this.protocolVersion = protocolVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanInterfaceProperty {
            private final java.lang.String name;
            private final java.lang.String protocolName;
            private final java.lang.String protocolVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolName = software.amazon.jsii.Kernel.get(this, "protocolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolVersion = software.amazon.jsii.Kernel.get(this, "protocolVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.protocolName = builder.protocolName;
                this.protocolVersion = builder.protocolVersion;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getProtocolName() {
                return this.protocolName;
            }

            @Override
            public final java.lang.String getProtocolVersion() {
                return this.protocolVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getProtocolName() != null) {
                    data.set("protocolName", om.valueToTree(this.getProtocolName()));
                }
                if (this.getProtocolVersion() != null) {
                    data.set("protocolVersion", om.valueToTree(this.getProtocolVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnDecoderManifest.CanInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanInterfaceProperty.Jsii$Proxy that = (CanInterfaceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.protocolName != null ? !this.protocolName.equals(that.protocolName) : that.protocolName != null) return false;
                return this.protocolVersion != null ? this.protocolVersion.equals(that.protocolVersion) : that.protocolVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.protocolName != null ? this.protocolName.hashCode() : 0);
                result = 31 * result + (this.protocolVersion != null ? this.protocolVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a single controller area network (CAN) signal and the messages it receives and transmits.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * CanSignalProperty canSignalProperty = CanSignalProperty.builder()
     *         .factor("factor")
     *         .isBigEndian("isBigEndian")
     *         .isSigned("isSigned")
     *         .length("length")
     *         .messageId("messageId")
     *         .offset("offset")
     *         .startBit("startBit")
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnDecoderManifest.CanSignalProperty")
    @software.amazon.jsii.Jsii.Proxy(CanSignalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanSignalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A multiplier used to decode the CAN message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFactor();

        /**
         * Whether the byte ordering of a CAN message is big-endian.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIsBigEndian();

        /**
         * Whether the message data is specified as a signed value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIsSigned();

        /**
         * How many bytes of data are in the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLength();

        /**
         * The ID of the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessageId();

        /**
         * Indicates where data appears in the CAN message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOffset();

        /**
         * Indicates the beginning of the CAN message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartBit();

        /**
         * The name of the signal.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanSignalProperty> {
            java.lang.String factor;
            java.lang.String isBigEndian;
            java.lang.String isSigned;
            java.lang.String length;
            java.lang.String messageId;
            java.lang.String offset;
            java.lang.String startBit;
            java.lang.String name;

            /**
             * Sets the value of {@link CanSignalProperty#getFactor}
             * @param factor A multiplier used to decode the CAN message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder factor(java.lang.String factor) {
                this.factor = factor;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getIsBigEndian}
             * @param isBigEndian Whether the byte ordering of a CAN message is big-endian. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isBigEndian(java.lang.String isBigEndian) {
                this.isBigEndian = isBigEndian;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getIsSigned}
             * @param isSigned Whether the message data is specified as a signed value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSigned(java.lang.String isSigned) {
                this.isSigned = isSigned;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getLength}
             * @param length How many bytes of data are in the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder length(java.lang.String length) {
                this.length = length;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getMessageId}
             * @param messageId The ID of the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageId(java.lang.String messageId) {
                this.messageId = messageId;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getOffset}
             * @param offset Indicates where data appears in the CAN message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.String offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getStartBit}
             * @param startBit Indicates the beginning of the CAN message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startBit(java.lang.String startBit) {
                this.startBit = startBit;
                return this;
            }

            /**
             * Sets the value of {@link CanSignalProperty#getName}
             * @param name The name of the signal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanSignalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanSignalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanSignalProperty {
            private final java.lang.String factor;
            private final java.lang.String isBigEndian;
            private final java.lang.String isSigned;
            private final java.lang.String length;
            private final java.lang.String messageId;
            private final java.lang.String offset;
            private final java.lang.String startBit;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.factor = software.amazon.jsii.Kernel.get(this, "factor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isBigEndian = software.amazon.jsii.Kernel.get(this, "isBigEndian", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isSigned = software.amazon.jsii.Kernel.get(this, "isSigned", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.length = software.amazon.jsii.Kernel.get(this, "length", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageId = software.amazon.jsii.Kernel.get(this, "messageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startBit = software.amazon.jsii.Kernel.get(this, "startBit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.factor = java.util.Objects.requireNonNull(builder.factor, "factor is required");
                this.isBigEndian = java.util.Objects.requireNonNull(builder.isBigEndian, "isBigEndian is required");
                this.isSigned = java.util.Objects.requireNonNull(builder.isSigned, "isSigned is required");
                this.length = java.util.Objects.requireNonNull(builder.length, "length is required");
                this.messageId = java.util.Objects.requireNonNull(builder.messageId, "messageId is required");
                this.offset = java.util.Objects.requireNonNull(builder.offset, "offset is required");
                this.startBit = java.util.Objects.requireNonNull(builder.startBit, "startBit is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getFactor() {
                return this.factor;
            }

            @Override
            public final java.lang.String getIsBigEndian() {
                return this.isBigEndian;
            }

            @Override
            public final java.lang.String getIsSigned() {
                return this.isSigned;
            }

            @Override
            public final java.lang.String getLength() {
                return this.length;
            }

            @Override
            public final java.lang.String getMessageId() {
                return this.messageId;
            }

            @Override
            public final java.lang.String getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.String getStartBit() {
                return this.startBit;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("factor", om.valueToTree(this.getFactor()));
                data.set("isBigEndian", om.valueToTree(this.getIsBigEndian()));
                data.set("isSigned", om.valueToTree(this.getIsSigned()));
                data.set("length", om.valueToTree(this.getLength()));
                data.set("messageId", om.valueToTree(this.getMessageId()));
                data.set("offset", om.valueToTree(this.getOffset()));
                data.set("startBit", om.valueToTree(this.getStartBit()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnDecoderManifest.CanSignalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanSignalProperty.Jsii$Proxy that = (CanSignalProperty.Jsii$Proxy) o;

                if (!factor.equals(that.factor)) return false;
                if (!isBigEndian.equals(that.isBigEndian)) return false;
                if (!isSigned.equals(that.isSigned)) return false;
                if (!length.equals(that.length)) return false;
                if (!messageId.equals(that.messageId)) return false;
                if (!offset.equals(that.offset)) return false;
                if (!startBit.equals(that.startBit)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.factor.hashCode();
                result = 31 * result + (this.isBigEndian.hashCode());
                result = 31 * result + (this.isSigned.hashCode());
                result = 31 * result + (this.length.hashCode());
                result = 31 * result + (this.messageId.hashCode());
                result = 31 * result + (this.offset.hashCode());
                result = 31 * result + (this.startBit.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * NetworkInterfacesItemsProperty networkInterfacesItemsProperty = NetworkInterfacesItemsProperty.builder()
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         // the properties below are optional
     *         .canInterface(CanInterfaceProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .protocolName("protocolName")
     *                 .protocolVersion("protocolVersion")
     *                 .build())
     *         .obdInterface(ObdInterfaceProperty.builder()
     *                 .name("name")
     *                 .requestMessageId("requestMessageId")
     *                 // the properties below are optional
     *                 .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
     *                 .hasTransmissionEcu("hasTransmissionEcu")
     *                 .obdStandard("obdStandard")
     *                 .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
     *                 .useExtendedIds("useExtendedIds")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfacesItemsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfacesItemsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.NetworkInterfacesItemsProperty.InterfaceId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * `CfnDecoderManifest.NetworkInterfacesItemsProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnDecoderManifest.NetworkInterfacesItemsProperty.CanInterface`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCanInterface() {
            return null;
        }

        /**
         * `CfnDecoderManifest.NetworkInterfacesItemsProperty.ObdInterface`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getObdInterface() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfacesItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfacesItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfacesItemsProperty> {
            java.lang.String interfaceId;
            java.lang.String type;
            java.lang.Object canInterface;
            java.lang.Object obdInterface;

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getInterfaceId}
             * @param interfaceId `CfnDecoderManifest.NetworkInterfacesItemsProperty.InterfaceId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getType}
             * @param type `CfnDecoderManifest.NetworkInterfacesItemsProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getCanInterface}
             * @param canInterface `CfnDecoderManifest.NetworkInterfacesItemsProperty.CanInterface`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanInterfaceProperty canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getCanInterface}
             * @param canInterface `CfnDecoderManifest.NetworkInterfacesItemsProperty.CanInterface`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canInterface(software.amazon.awscdk.core.IResolvable canInterface) {
                this.canInterface = canInterface;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getObdInterface}
             * @param obdInterface `CfnDecoderManifest.NetworkInterfacesItemsProperty.ObdInterface`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfacesItemsProperty#getObdInterface}
             * @param obdInterface `CfnDecoderManifest.NetworkInterfacesItemsProperty.ObdInterface`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdInterface(software.amazon.awscdk.core.IResolvable obdInterface) {
                this.obdInterface = obdInterface;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfacesItemsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfacesItemsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfacesItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfacesItemsProperty {
            private final java.lang.String interfaceId;
            private final java.lang.String type;
            private final java.lang.Object canInterface;
            private final java.lang.Object obdInterface;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.canInterface = software.amazon.jsii.Kernel.get(this, "canInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.obdInterface = software.amazon.jsii.Kernel.get(this, "obdInterface", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.canInterface = builder.canInterface;
                this.obdInterface = builder.obdInterface;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getCanInterface() {
                return this.canInterface;
            }

            @Override
            public final java.lang.Object getObdInterface() {
                return this.obdInterface;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getCanInterface() != null) {
                    data.set("canInterface", om.valueToTree(this.getCanInterface()));
                }
                if (this.getObdInterface() != null) {
                    data.set("obdInterface", om.valueToTree(this.getObdInterface()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnDecoderManifest.NetworkInterfacesItemsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfacesItemsProperty.Jsii$Proxy that = (NetworkInterfacesItemsProperty.Jsii$Proxy) o;

                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!type.equals(that.type)) return false;
                if (this.canInterface != null ? !this.canInterface.equals(that.canInterface) : that.canInterface != null) return false;
                return this.obdInterface != null ? this.obdInterface.equals(that.obdInterface) : that.obdInterface == null;
            }

            @Override
            public final int hashCode() {
                int result = this.interfaceId.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.canInterface != null ? this.canInterface.hashCode() : 0);
                result = 31 * result + (this.obdInterface != null ? this.obdInterface.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A network interface that specifies the On-board diagnostic (OBD) II network protocol.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ObdInterfaceProperty obdInterfaceProperty = ObdInterfaceProperty.builder()
     *         .name("name")
     *         .requestMessageId("requestMessageId")
     *         // the properties below are optional
     *         .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
     *         .hasTransmissionEcu("hasTransmissionEcu")
     *         .obdStandard("obdStandard")
     *         .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
     *         .useExtendedIds("useExtendedIds")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the interface.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The ID of the message requesting vehicle data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRequestMessageId();

        /**
         * The maximum number message requests per diagnostic trouble code per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDtcRequestIntervalSeconds() {
            return null;
        }

        /**
         * Whether the vehicle has a transmission control module (TCM).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHasTransmissionEcu() {
            return null;
        }

        /**
         * The standard OBD II PID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObdStandard() {
            return null;
        }

        /**
         * The maximum number message requests per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPidRequestIntervalSeconds() {
            return null;
        }

        /**
         * Whether to use extended IDs in the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUseExtendedIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdInterfaceProperty> {
            java.lang.String name;
            java.lang.String requestMessageId;
            java.lang.String dtcRequestIntervalSeconds;
            java.lang.String hasTransmissionEcu;
            java.lang.String obdStandard;
            java.lang.String pidRequestIntervalSeconds;
            java.lang.String useExtendedIds;

            /**
             * Sets the value of {@link ObdInterfaceProperty#getName}
             * @param name The name of the interface. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getRequestMessageId}
             * @param requestMessageId The ID of the message requesting vehicle data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestMessageId(java.lang.String requestMessageId) {
                this.requestMessageId = requestMessageId;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getDtcRequestIntervalSeconds}
             * @param dtcRequestIntervalSeconds The maximum number message requests per diagnostic trouble code per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dtcRequestIntervalSeconds(java.lang.String dtcRequestIntervalSeconds) {
                this.dtcRequestIntervalSeconds = dtcRequestIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getHasTransmissionEcu}
             * @param hasTransmissionEcu Whether the vehicle has a transmission control module (TCM).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hasTransmissionEcu(java.lang.String hasTransmissionEcu) {
                this.hasTransmissionEcu = hasTransmissionEcu;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getObdStandard}
             * @param obdStandard The standard OBD II PID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdStandard(java.lang.String obdStandard) {
                this.obdStandard = obdStandard;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getPidRequestIntervalSeconds}
             * @param pidRequestIntervalSeconds The maximum number message requests per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidRequestIntervalSeconds(java.lang.String pidRequestIntervalSeconds) {
                this.pidRequestIntervalSeconds = pidRequestIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ObdInterfaceProperty#getUseExtendedIds}
             * @param useExtendedIds Whether to use extended IDs in the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useExtendedIds(java.lang.String useExtendedIds) {
                this.useExtendedIds = useExtendedIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdInterfaceProperty {
            private final java.lang.String name;
            private final java.lang.String requestMessageId;
            private final java.lang.String dtcRequestIntervalSeconds;
            private final java.lang.String hasTransmissionEcu;
            private final java.lang.String obdStandard;
            private final java.lang.String pidRequestIntervalSeconds;
            private final java.lang.String useExtendedIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requestMessageId = software.amazon.jsii.Kernel.get(this, "requestMessageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dtcRequestIntervalSeconds = software.amazon.jsii.Kernel.get(this, "dtcRequestIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hasTransmissionEcu = software.amazon.jsii.Kernel.get(this, "hasTransmissionEcu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.obdStandard = software.amazon.jsii.Kernel.get(this, "obdStandard", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pidRequestIntervalSeconds = software.amazon.jsii.Kernel.get(this, "pidRequestIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useExtendedIds = software.amazon.jsii.Kernel.get(this, "useExtendedIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.requestMessageId = java.util.Objects.requireNonNull(builder.requestMessageId, "requestMessageId is required");
                this.dtcRequestIntervalSeconds = builder.dtcRequestIntervalSeconds;
                this.hasTransmissionEcu = builder.hasTransmissionEcu;
                this.obdStandard = builder.obdStandard;
                this.pidRequestIntervalSeconds = builder.pidRequestIntervalSeconds;
                this.useExtendedIds = builder.useExtendedIds;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRequestMessageId() {
                return this.requestMessageId;
            }

            @Override
            public final java.lang.String getDtcRequestIntervalSeconds() {
                return this.dtcRequestIntervalSeconds;
            }

            @Override
            public final java.lang.String getHasTransmissionEcu() {
                return this.hasTransmissionEcu;
            }

            @Override
            public final java.lang.String getObdStandard() {
                return this.obdStandard;
            }

            @Override
            public final java.lang.String getPidRequestIntervalSeconds() {
                return this.pidRequestIntervalSeconds;
            }

            @Override
            public final java.lang.String getUseExtendedIds() {
                return this.useExtendedIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("requestMessageId", om.valueToTree(this.getRequestMessageId()));
                if (this.getDtcRequestIntervalSeconds() != null) {
                    data.set("dtcRequestIntervalSeconds", om.valueToTree(this.getDtcRequestIntervalSeconds()));
                }
                if (this.getHasTransmissionEcu() != null) {
                    data.set("hasTransmissionEcu", om.valueToTree(this.getHasTransmissionEcu()));
                }
                if (this.getObdStandard() != null) {
                    data.set("obdStandard", om.valueToTree(this.getObdStandard()));
                }
                if (this.getPidRequestIntervalSeconds() != null) {
                    data.set("pidRequestIntervalSeconds", om.valueToTree(this.getPidRequestIntervalSeconds()));
                }
                if (this.getUseExtendedIds() != null) {
                    data.set("useExtendedIds", om.valueToTree(this.getUseExtendedIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnDecoderManifest.ObdInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdInterfaceProperty.Jsii$Proxy that = (ObdInterfaceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!requestMessageId.equals(that.requestMessageId)) return false;
                if (this.dtcRequestIntervalSeconds != null ? !this.dtcRequestIntervalSeconds.equals(that.dtcRequestIntervalSeconds) : that.dtcRequestIntervalSeconds != null) return false;
                if (this.hasTransmissionEcu != null ? !this.hasTransmissionEcu.equals(that.hasTransmissionEcu) : that.hasTransmissionEcu != null) return false;
                if (this.obdStandard != null ? !this.obdStandard.equals(that.obdStandard) : that.obdStandard != null) return false;
                if (this.pidRequestIntervalSeconds != null ? !this.pidRequestIntervalSeconds.equals(that.pidRequestIntervalSeconds) : that.pidRequestIntervalSeconds != null) return false;
                return this.useExtendedIds != null ? this.useExtendedIds.equals(that.useExtendedIds) : that.useExtendedIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.requestMessageId.hashCode());
                result = 31 * result + (this.dtcRequestIntervalSeconds != null ? this.dtcRequestIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.hasTransmissionEcu != null ? this.hasTransmissionEcu.hashCode() : 0);
                result = 31 * result + (this.obdStandard != null ? this.obdStandard.hashCode() : 0);
                result = 31 * result + (this.pidRequestIntervalSeconds != null ? this.pidRequestIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.useExtendedIds != null ? this.useExtendedIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about signal messages using the on-board diagnostics (OBD) II protocol in a vehicle.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * ObdSignalProperty obdSignalProperty = ObdSignalProperty.builder()
     *         .byteLength("byteLength")
     *         .offset("offset")
     *         .pid("pid")
     *         .pidResponseLength("pidResponseLength")
     *         .scaling("scaling")
     *         .serviceMode("serviceMode")
     *         .startByte("startByte")
     *         // the properties below are optional
     *         .bitMaskLength("bitMaskLength")
     *         .bitRightShift("bitRightShift")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnDecoderManifest.ObdSignalProperty")
    @software.amazon.jsii.Jsii.Proxy(ObdSignalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObdSignalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of a message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getByteLength();

        /**
         * Indicates where data appears in the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOffset();

        /**
         * The diagnostic code used to request data from a vehicle for this signal.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPid();

        /**
         * The length of the requested data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPidResponseLength();

        /**
         * A multiplier used to decode the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScaling();

        /**
         * The mode of operation (diagnostic service) in a message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceMode();

        /**
         * Indicates the beginning of the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartByte();

        /**
         * The number of bits to mask in a message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitMaskLength() {
            return null;
        }

        /**
         * The number of positions to shift bits in the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitRightShift() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObdSignalProperty> {
            java.lang.String byteLength;
            java.lang.String offset;
            java.lang.String pid;
            java.lang.String pidResponseLength;
            java.lang.String scaling;
            java.lang.String serviceMode;
            java.lang.String startByte;
            java.lang.String bitMaskLength;
            java.lang.String bitRightShift;

            /**
             * Sets the value of {@link ObdSignalProperty#getByteLength}
             * @param byteLength The length of a message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder byteLength(java.lang.String byteLength) {
                this.byteLength = byteLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getOffset}
             * @param offset Indicates where data appears in the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.String offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getPid}
             * @param pid The diagnostic code used to request data from a vehicle for this signal. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pid(java.lang.String pid) {
                this.pid = pid;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getPidResponseLength}
             * @param pidResponseLength The length of the requested data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pidResponseLength(java.lang.String pidResponseLength) {
                this.pidResponseLength = pidResponseLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getScaling}
             * @param scaling A multiplier used to decode the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaling(java.lang.String scaling) {
                this.scaling = scaling;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getServiceMode}
             * @param serviceMode The mode of operation (diagnostic service) in a message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceMode(java.lang.String serviceMode) {
                this.serviceMode = serviceMode;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getStartByte}
             * @param startByte Indicates the beginning of the message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startByte(java.lang.String startByte) {
                this.startByte = startByte;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getBitMaskLength}
             * @param bitMaskLength The number of bits to mask in a message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitMaskLength(java.lang.String bitMaskLength) {
                this.bitMaskLength = bitMaskLength;
                return this;
            }

            /**
             * Sets the value of {@link ObdSignalProperty#getBitRightShift}
             * @param bitRightShift The number of positions to shift bits in the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitRightShift(java.lang.String bitRightShift) {
                this.bitRightShift = bitRightShift;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObdSignalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObdSignalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObdSignalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObdSignalProperty {
            private final java.lang.String byteLength;
            private final java.lang.String offset;
            private final java.lang.String pid;
            private final java.lang.String pidResponseLength;
            private final java.lang.String scaling;
            private final java.lang.String serviceMode;
            private final java.lang.String startByte;
            private final java.lang.String bitMaskLength;
            private final java.lang.String bitRightShift;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.byteLength = software.amazon.jsii.Kernel.get(this, "byteLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pid = software.amazon.jsii.Kernel.get(this, "pid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pidResponseLength = software.amazon.jsii.Kernel.get(this, "pidResponseLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scaling = software.amazon.jsii.Kernel.get(this, "scaling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceMode = software.amazon.jsii.Kernel.get(this, "serviceMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startByte = software.amazon.jsii.Kernel.get(this, "startByte", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitMaskLength = software.amazon.jsii.Kernel.get(this, "bitMaskLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitRightShift = software.amazon.jsii.Kernel.get(this, "bitRightShift", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.byteLength = java.util.Objects.requireNonNull(builder.byteLength, "byteLength is required");
                this.offset = java.util.Objects.requireNonNull(builder.offset, "offset is required");
                this.pid = java.util.Objects.requireNonNull(builder.pid, "pid is required");
                this.pidResponseLength = java.util.Objects.requireNonNull(builder.pidResponseLength, "pidResponseLength is required");
                this.scaling = java.util.Objects.requireNonNull(builder.scaling, "scaling is required");
                this.serviceMode = java.util.Objects.requireNonNull(builder.serviceMode, "serviceMode is required");
                this.startByte = java.util.Objects.requireNonNull(builder.startByte, "startByte is required");
                this.bitMaskLength = builder.bitMaskLength;
                this.bitRightShift = builder.bitRightShift;
            }

            @Override
            public final java.lang.String getByteLength() {
                return this.byteLength;
            }

            @Override
            public final java.lang.String getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.String getPid() {
                return this.pid;
            }

            @Override
            public final java.lang.String getPidResponseLength() {
                return this.pidResponseLength;
            }

            @Override
            public final java.lang.String getScaling() {
                return this.scaling;
            }

            @Override
            public final java.lang.String getServiceMode() {
                return this.serviceMode;
            }

            @Override
            public final java.lang.String getStartByte() {
                return this.startByte;
            }

            @Override
            public final java.lang.String getBitMaskLength() {
                return this.bitMaskLength;
            }

            @Override
            public final java.lang.String getBitRightShift() {
                return this.bitRightShift;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("byteLength", om.valueToTree(this.getByteLength()));
                data.set("offset", om.valueToTree(this.getOffset()));
                data.set("pid", om.valueToTree(this.getPid()));
                data.set("pidResponseLength", om.valueToTree(this.getPidResponseLength()));
                data.set("scaling", om.valueToTree(this.getScaling()));
                data.set("serviceMode", om.valueToTree(this.getServiceMode()));
                data.set("startByte", om.valueToTree(this.getStartByte()));
                if (this.getBitMaskLength() != null) {
                    data.set("bitMaskLength", om.valueToTree(this.getBitMaskLength()));
                }
                if (this.getBitRightShift() != null) {
                    data.set("bitRightShift", om.valueToTree(this.getBitRightShift()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnDecoderManifest.ObdSignalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObdSignalProperty.Jsii$Proxy that = (ObdSignalProperty.Jsii$Proxy) o;

                if (!byteLength.equals(that.byteLength)) return false;
                if (!offset.equals(that.offset)) return false;
                if (!pid.equals(that.pid)) return false;
                if (!pidResponseLength.equals(that.pidResponseLength)) return false;
                if (!scaling.equals(that.scaling)) return false;
                if (!serviceMode.equals(that.serviceMode)) return false;
                if (!startByte.equals(that.startByte)) return false;
                if (this.bitMaskLength != null ? !this.bitMaskLength.equals(that.bitMaskLength) : that.bitMaskLength != null) return false;
                return this.bitRightShift != null ? this.bitRightShift.equals(that.bitRightShift) : that.bitRightShift == null;
            }

            @Override
            public final int hashCode() {
                int result = this.byteLength.hashCode();
                result = 31 * result + (this.offset.hashCode());
                result = 31 * result + (this.pid.hashCode());
                result = 31 * result + (this.pidResponseLength.hashCode());
                result = 31 * result + (this.scaling.hashCode());
                result = 31 * result + (this.serviceMode.hashCode());
                result = 31 * result + (this.startByte.hashCode());
                result = 31 * result + (this.bitMaskLength != null ? this.bitMaskLength.hashCode() : 0);
                result = 31 * result + (this.bitRightShift != null ? this.bitRightShift.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotfleetwise.*;
     * SignalDecodersItemsProperty signalDecodersItemsProperty = SignalDecodersItemsProperty.builder()
     *         .fullyQualifiedName("fullyQualifiedName")
     *         .interfaceId("interfaceId")
     *         .type("type")
     *         // the properties below are optional
     *         .canSignal(CanSignalProperty.builder()
     *                 .factor("factor")
     *                 .isBigEndian("isBigEndian")
     *                 .isSigned("isSigned")
     *                 .length("length")
     *                 .messageId("messageId")
     *                 .offset("offset")
     *                 .startBit("startBit")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .build())
     *         .obdSignal(ObdSignalProperty.builder()
     *                 .byteLength("byteLength")
     *                 .offset("offset")
     *                 .pid("pid")
     *                 .pidResponseLength("pidResponseLength")
     *                 .scaling("scaling")
     *                 .serviceMode("serviceMode")
     *                 .startByte("startByte")
     *                 // the properties below are optional
     *                 .bitMaskLength("bitMaskLength")
     *                 .bitRightShift("bitRightShift")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty")
    @software.amazon.jsii.Jsii.Proxy(SignalDecodersItemsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SignalDecodersItemsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDecoderManifest.SignalDecodersItemsProperty.FullyQualifiedName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFullyQualifiedName();

        /**
         * `CfnDecoderManifest.SignalDecodersItemsProperty.InterfaceId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInterfaceId();

        /**
         * `CfnDecoderManifest.SignalDecodersItemsProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnDecoderManifest.SignalDecodersItemsProperty.CanSignal`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCanSignal() {
            return null;
        }

        /**
         * `CfnDecoderManifest.SignalDecodersItemsProperty.ObdSignal`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getObdSignal() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SignalDecodersItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SignalDecodersItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SignalDecodersItemsProperty> {
            java.lang.String fullyQualifiedName;
            java.lang.String interfaceId;
            java.lang.String type;
            java.lang.Object canSignal;
            java.lang.Object obdSignal;

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getFullyQualifiedName}
             * @param fullyQualifiedName `CfnDecoderManifest.SignalDecodersItemsProperty.FullyQualifiedName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullyQualifiedName(java.lang.String fullyQualifiedName) {
                this.fullyQualifiedName = fullyQualifiedName;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getInterfaceId}
             * @param interfaceId `CfnDecoderManifest.SignalDecodersItemsProperty.InterfaceId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder interfaceId(java.lang.String interfaceId) {
                this.interfaceId = interfaceId;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getType}
             * @param type `CfnDecoderManifest.SignalDecodersItemsProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getCanSignal}
             * @param canSignal `CfnDecoderManifest.SignalDecodersItemsProperty.CanSignal`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.CanSignalProperty canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getCanSignal}
             * @param canSignal `CfnDecoderManifest.SignalDecodersItemsProperty.CanSignal`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder canSignal(software.amazon.awscdk.core.IResolvable canSignal) {
                this.canSignal = canSignal;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getObdSignal}
             * @param obdSignal `CfnDecoderManifest.SignalDecodersItemsProperty.ObdSignal`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest.ObdSignalProperty obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Sets the value of {@link SignalDecodersItemsProperty#getObdSignal}
             * @param obdSignal `CfnDecoderManifest.SignalDecodersItemsProperty.ObdSignal`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obdSignal(software.amazon.awscdk.core.IResolvable obdSignal) {
                this.obdSignal = obdSignal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SignalDecodersItemsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SignalDecodersItemsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SignalDecodersItemsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SignalDecodersItemsProperty {
            private final java.lang.String fullyQualifiedName;
            private final java.lang.String interfaceId;
            private final java.lang.String type;
            private final java.lang.Object canSignal;
            private final java.lang.Object obdSignal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fullyQualifiedName = software.amazon.jsii.Kernel.get(this, "fullyQualifiedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.interfaceId = software.amazon.jsii.Kernel.get(this, "interfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.canSignal = software.amazon.jsii.Kernel.get(this, "canSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.obdSignal = software.amazon.jsii.Kernel.get(this, "obdSignal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fullyQualifiedName = java.util.Objects.requireNonNull(builder.fullyQualifiedName, "fullyQualifiedName is required");
                this.interfaceId = java.util.Objects.requireNonNull(builder.interfaceId, "interfaceId is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.canSignal = builder.canSignal;
                this.obdSignal = builder.obdSignal;
            }

            @Override
            public final java.lang.String getFullyQualifiedName() {
                return this.fullyQualifiedName;
            }

            @Override
            public final java.lang.String getInterfaceId() {
                return this.interfaceId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getCanSignal() {
                return this.canSignal;
            }

            @Override
            public final java.lang.Object getObdSignal() {
                return this.obdSignal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fullyQualifiedName", om.valueToTree(this.getFullyQualifiedName()));
                data.set("interfaceId", om.valueToTree(this.getInterfaceId()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getCanSignal() != null) {
                    data.set("canSignal", om.valueToTree(this.getCanSignal()));
                }
                if (this.getObdSignal() != null) {
                    data.set("obdSignal", om.valueToTree(this.getObdSignal()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotfleetwise.CfnDecoderManifest.SignalDecodersItemsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SignalDecodersItemsProperty.Jsii$Proxy that = (SignalDecodersItemsProperty.Jsii$Proxy) o;

                if (!fullyQualifiedName.equals(that.fullyQualifiedName)) return false;
                if (!interfaceId.equals(that.interfaceId)) return false;
                if (!type.equals(that.type)) return false;
                if (this.canSignal != null ? !this.canSignal.equals(that.canSignal) : that.canSignal != null) return false;
                return this.obdSignal != null ? this.obdSignal.equals(that.obdSignal) : that.obdSignal == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fullyQualifiedName.hashCode();
                result = 31 * result + (this.interfaceId.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.canSignal != null ? this.canSignal.hashCode() : 0);
                result = 31 * result + (this.obdSignal != null ? this.obdSignal.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifestProps.Builder();
        }

        /**
         * The ARN of a vehicle model (model manifest) associated with the decoder manifest.
         * <p>
         * @return {@code this}
         * @param modelManifestArn The ARN of a vehicle model (model manifest) associated with the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestArn(final java.lang.String modelManifestArn) {
            this.props.modelManifestArn(modelManifestArn);
            return this;
        }

        /**
         * The name of the decoder manifest.
         * <p>
         * @return {@code this}
         * @param name The name of the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A brief description of the decoder manifest.
         * <p>
         * @return {@code this}
         * @param description A brief description of the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
         * <p>
         * @return {@code this}
         * @param networkInterfaces `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final software.amazon.awscdk.core.IResolvable networkInterfaces) {
            this.props.networkInterfaces(networkInterfaces);
            return this;
        }
        /**
         * `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`.
         * <p>
         * @return {@code this}
         * @param networkInterfaces `AWS::IoTFleetWise::DecoderManifest.NetworkInterfaces`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(final java.util.List<? extends java.lang.Object> networkInterfaces) {
            this.props.networkInterfaces(networkInterfaces);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
         * <p>
         * @return {@code this}
         * @param signalDecoders `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(final software.amazon.awscdk.core.IResolvable signalDecoders) {
            this.props.signalDecoders(signalDecoders);
            return this;
        }
        /**
         * `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`.
         * <p>
         * @return {@code this}
         * @param signalDecoders `AWS::IoTFleetWise::DecoderManifest.SignalDecoders`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(final java.util.List<? extends java.lang.Object> signalDecoders) {
            this.props.signalDecoders(signalDecoders);
            return this;
        }

        /**
         * The state of the decoder manifest.
         * <p>
         * If the status is <code>ACTIVE</code> , the decoder manifest can't be edited. If the status is marked <code>DRAFT</code> , you can edit the decoder manifest.
         * <p>
         * @return {@code this}
         * @param status The state of the decoder manifest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * `AWS::IoTFleetWise::DecoderManifest.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::IoTFleetWise::DecoderManifest.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest build() {
            return new software.amazon.awscdk.services.iotfleetwise.CfnDecoderManifest(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
