/**
 * <h1>AWS::IVS Construct Library</h1>
 * <p>
 * Amazon Interactive Video Service (Amazon IVS) is a managed live streaming
 * solution that is quick and easy to set up, and ideal for creating interactive
 * video experiences. Send your live streams to Amazon IVS using streaming software
 * and the service does everything you need to make low-latency live video
 * available to any viewer around the world, letting you focus on building
 * interactive experiences alongside the live video. You can easily customize and
 * enhance the audience experience through the Amazon IVS player SDK and timed
 * metadata APIs, allowing you to build a more valuable relationship with your
 * viewers on your own websites and applications.
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Channels</h2>
 * <p>
 * An Amazon IVS channel stores configuration information related to your live
 * stream. You first create a channel and then contribute video to it using the
 * channel’s stream key to start your live stream.
 * <p>
 * You can create a channel
 * <p>
 * <blockquote><pre>
 * Channel myChannel = new Channel(this, "Channel");
 * </pre></blockquote>
 * <p>
 * <h3>Importing an existing channel</h3>
 * <p>
 * You can reference an existing channel, for example, if you need to create a
 * stream key for an existing channel
 * <p>
 * <blockquote><pre>
 * IChannel myChannel = Channel.fromChannelArn(this, "Channel", myChannelArn);
 * </pre></blockquote>
 * <p>
 * <h2>Stream Keys</h2>
 * <p>
 * A Stream Key is used by a broadcast encoder to initiate a stream and identify
 * to Amazon IVS which customer and channel the stream is for. If you are
 * storing this value, it should be treated as if it were a password.
 * <p>
 * You can create a stream key for a given channel
 * <p>
 * <blockquote><pre>
 * StreamKey myStreamKey = myChannel.addStreamKey("StreamKey");
 * </pre></blockquote>
 * <p>
 * <h2>Private Channels</h2>
 * <p>
 * Amazon IVS offers the ability to create private channels, allowing
 * you to restrict your streams by channel or viewer. You control access
 * to video playback by enabling playback authorization on channels and
 * generating signed JSON Web Tokens (JWTs) for authorized playback requests.
 * <p>
 * A playback token is a JWT that you sign (with a playback authorization key)
 * and include with every playback request for a channel that has playback
 * authorization enabled.
 * <p>
 * In order for Amazon IVS to validate the token, you need to upload
 * the public key that corresponds to the private key you use to sign the token.
 * <p>
 * <blockquote><pre>
 * PlaybackKeyPair keyPair = PlaybackKeyPair.Builder.create(this, "PlaybackKeyPair")
 *         .publicKeyMaterial(myPublicKeyPemString)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Then, when creating a channel, specify the authorized property
 * <p>
 * <blockquote><pre>
 * Channel myChannel = Channel.Builder.create(this, "Channel")
 *         .authorized(true)
 *         .build();
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.ivs;
