package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) The L2 construct for Flink Kinesis Data Applications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * App app = new App();
 * Stack stack = new Stack(app, "FlinkAppTest");
 * Application flinkApp = Application.Builder.create(stack, "App")
 *         .code(ApplicationCode.fromAsset(join(__dirname, "code-asset")))
 *         .runtime(Runtime.FLINK_1_11)
 *         .build();
 * Alarm.Builder.create(stack, "Alarm")
 *         .metric(flinkApp.metricFullRestarts())
 *         .evaluationPeriods(1)
 *         .threshold(3)
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.565Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.Application")
public class Application extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.kinesis.analytics.flink.IApplication {

    protected Application(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Application(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Application(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing application defined outside of CDK code by applicationArn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param applicationArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.IApplication fromApplicationArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String applicationArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.analytics.flink.Application.class, "fromApplicationArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.IApplication.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(applicationArn, "applicationArn is required") });
    }

    /**
     * (experimental) Import an existing Flink application defined outside of CDK code by applicationName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param applicationName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.IApplication fromApplicationName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String applicationName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.analytics.flink.Application.class, "fromApplicationName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.IApplication.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(applicationName, "applicationName is required") });
    }

    /**
     * (experimental) Implement the convenience {@link IApplication.addToPrincipalPolicy} method.
     * <p>
     * @param policyStatement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement policyStatement) {
        return software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(policyStatement, "policyStatement is required") });
    }

    /**
     * (experimental) Return a CloudWatch metric associated with this Flink application.
     * <p>
     * @param metricName The name of the metric. This parameter is required.
     * @param props Customization properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * (experimental) Return a CloudWatch metric associated with this Flink application.
     * <p>
     * @param metricName The name of the metric. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (experimental) The time (in milliseconds) this task or operator is back pressured per second.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBackPressuredTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricBackPressuredTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The time (in milliseconds) this task or operator is back pressured per second.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBackPressuredTimeMsPerSecond() {
        return software.amazon.jsii.Kernel.call(this, "metricBackPressuredTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The time (in milliseconds) this task or operator is busy (neither idle nor back pressured) per second.
     * <p>
     * Can be NaN, if the value could not be
     * calculated.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBusyTimePerMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricBusyTimePerMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The time (in milliseconds) this task or operator is busy (neither idle nor back pressured) per second.
     * <p>
     * Can be NaN, if the value could not be
     * calculated.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBusyTimePerMsPerSecond() {
        return software.amazon.jsii.Kernel.call(this, "metricBusyTimePerMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The overall percentage of CPU utilization across task managers.
     * <p>
     * For
     * example, if there are five task managers, Kinesis Data Analytics publishes
     * five samples of this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The overall percentage of CPU utilization across task managers.
     * <p>
     * For
     * example, if there are five task managers, Kinesis Data Analytics publishes
     * five samples of this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentInputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCurrentInputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentInputWatermark() {
        return software.amazon.jsii.Kernel.call(this, "metricCurrentInputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentOutputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCurrentOutputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentOutputWatermark() {
        return software.amazon.jsii.Kernel.call(this, "metricCurrentOutputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The time elapsed during an outage for failing/recovering jobs.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDowntime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricDowntime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The time elapsed during an outage for failing/recovering jobs.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDowntime() {
        return software.amazon.jsii.Kernel.call(this, "metricDowntime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total number of times this job has fully restarted since it was submitted.
     * <p>
     * This metric does not measure fine-grained restarts.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFullRestarts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricFullRestarts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total number of times this job has fully restarted since it was submitted.
     * <p>
     * This metric does not measure fine-grained restarts.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFullRestarts() {
        return software.amazon.jsii.Kernel.call(this, "metricFullRestarts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Overall heap memory utilization across task managers.
     * <p>
     * For example, if there
     * are five task managers, Kinesis Data Analytics publishes five samples of
     * this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeapMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricHeapMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Overall heap memory utilization across task managers.
     * <p>
     * For example, if there
     * are five task managers, Kinesis Data Analytics publishes five samples of
     * this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeapMemoryUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricHeapMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The time (in milliseconds) this task or operator is idle (has no data to process) per second.
     * <p>
     * Idle time excludes back pressured time, so if the task
     * is back pressured it is not idle.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIdleTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIdleTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The time (in milliseconds) this task or operator is idle (has no data to process) per second.
     * <p>
     * Idle time excludes back pressured time, so if the task
     * is back pressured it is not idle.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIdleTimeMsPerSecond() {
        return software.amazon.jsii.Kernel.call(this, "metricIdleTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The number of Kinesis Processing Units that are used to run your stream processing application.
     * <p>
     * The average number of KPUs used each hour
     * determines the billing for your application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKpus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricKpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The number of Kinesis Processing Units that are used to run your stream processing application.
     * <p>
     * The average number of KPUs used each hour
     * determines the billing for your application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKpus() {
        return software.amazon.jsii.Kernel.call(this, "metricKpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The time it took to complete the last checkpoint.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The time it took to complete the last checkpoint.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointDuration() {
        return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total size of the last checkpoint.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total size of the last checkpoint.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointSize() {
        return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total amount of managed memory.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryTotal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryTotal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total amount of managed memory.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryTotal() {
        return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryTotal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The amount of managed memory currently used.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The amount of managed memory currently used.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUsed() {
        return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Derived from managedMemoryUsed/managedMemoryTotal.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Derived from managedMemoryUsed/managedMemoryTotal.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The number of times checkpointing has failed.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfFailedCheckpoints(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNumberOfFailedCheckpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The number of times checkpointing has failed.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfFailedCheckpoints() {
        return software.amazon.jsii.Kernel.call(this, "metricNumberOfFailedCheckpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The number of records this operator or task has dropped due to arriving late.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumLateRecordsDropped(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNumLateRecordsDropped", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The number of records this operator or task has dropped due to arriving late.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumLateRecordsDropped() {
        return software.amazon.jsii.Kernel.call(this, "metricNumLateRecordsDropped", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total number of records this application, operator, or task has received.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsIn(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsIn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total number of records this application, operator, or task has received.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsIn() {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsIn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total number of records this application, operator or task has received per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsInPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsInPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total number of records this application, operator or task has received per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsInPerSecond() {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsInPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total number of records this application, operator or task has emitted.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOut(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total number of records this application, operator or task has emitted.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOut() {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total number of records this application, operator or task has emitted per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOutPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOutPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total number of records this application, operator or task has emitted per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOutPerSecond() {
        return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOutPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total number of old garbage collection operations that have occurred across all task managers.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total number of old garbage collection operations that have occurred across all task managers.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCCount() {
        return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total time spent performing old garbage collection operations.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total time spent performing old garbage collection operations.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCTime() {
        return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The total number of live threads used by the application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThreadsCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricThreadsCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The total number of live threads used by the application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThreadsCount() {
        return software.amazon.jsii.Kernel.call(this, "metricThreadsCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The time that the job has been running without interruption.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUptime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) The time that the job has been running without interruption.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUptime() {
        return software.amazon.jsii.Kernel.call(this, "metricUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The application ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the Flink application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) The application IAM role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.kinesis.analytics.flink.Application}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesis.analytics.flink.Application> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationProps.Builder();
        }

        /**
         * (experimental) The Flink code asset to run.
         * <p>
         * @return {@code this}
         * @param code The Flink code asset to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder code(final software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode code) {
            this.props.code(code);
            return this;
        }

        /**
         * (experimental) The Flink version to use for this application.
         * <p>
         * @return {@code this}
         * @param runtime The Flink version to use for this application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(final software.amazon.awscdk.services.kinesis.analytics.flink.Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * (experimental) A name for your Application that is unique to an AWS account.
         * <p>
         * Default: - CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param applicationName A name for your Application that is unique to an AWS account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * (experimental) Whether the Kinesis Data Analytics service can increase the parallelism of the application in response to resource usage.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param autoScalingEnabled Whether the Kinesis Data Analytics service can increase the parallelism of the application in response to resource usage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingEnabled(final java.lang.Boolean autoScalingEnabled) {
            this.props.autoScalingEnabled(autoScalingEnabled);
            return this;
        }

        /**
         * (experimental) Whether checkpointing is enabled while your application runs.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param checkpointingEnabled Whether checkpointing is enabled while your application runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder checkpointingEnabled(final java.lang.Boolean checkpointingEnabled) {
            this.props.checkpointingEnabled(checkpointingEnabled);
            return this;
        }

        /**
         * (experimental) The interval between checkpoints.
         * <p>
         * Default: 1 minute
         * <p>
         * @return {@code this}
         * @param checkpointInterval The interval between checkpoints. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder checkpointInterval(final software.amazon.awscdk.core.Duration checkpointInterval) {
            this.props.checkpointInterval(checkpointInterval);
            return this;
        }

        /**
         * (experimental) The log group to send log entries to.
         * <p>
         * Default: CDK's default LogGroup
         * <p>
         * @return {@code this}
         * @param logGroup The log group to send log entries to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * (experimental) The level of log verbosity from the Flink application.
         * <p>
         * Default: FlinkLogLevel.INFO
         * <p>
         * @return {@code this}
         * @param logLevel The level of log verbosity from the Flink application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logLevel(final software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel logLevel) {
            this.props.logLevel(logLevel);
            return this;
        }

        /**
         * (experimental) Describes the granularity of the CloudWatch metrics for an application.
         * <p>
         * Use caution with Parallelism level metrics. Parallelism granularity logs
         * metrics for each parallel thread and can quickly become expensive when
         * parallelism is high (e.g. &gt; 64).
         * <p>
         * Default: MetricsLevel.APPLICATION
         * <p>
         * @return {@code this}
         * @param metricsLevel Describes the granularity of the CloudWatch metrics for an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricsLevel(final software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel metricsLevel) {
            this.props.metricsLevel(metricsLevel);
            return this;
        }

        /**
         * (experimental) The minimum amount of time in to wait after a checkpoint finishes to start a new checkpoint.
         * <p>
         * Default: 5 seconds
         * <p>
         * @return {@code this}
         * @param minPauseBetweenCheckpoints The minimum amount of time in to wait after a checkpoint finishes to start a new checkpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minPauseBetweenCheckpoints(final software.amazon.awscdk.core.Duration minPauseBetweenCheckpoints) {
            this.props.minPauseBetweenCheckpoints(minPauseBetweenCheckpoints);
            return this;
        }

        /**
         * (experimental) The initial parallelism for the application.
         * <p>
         * Kinesis Data Analytics can
         * stop the app, increase the parallelism, and start the app again if
         * autoScalingEnabled is true (the default value).
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param parallelism The initial parallelism for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parallelism(final java.lang.Number parallelism) {
            this.props.parallelism(parallelism);
            return this;
        }

        /**
         * (experimental) The Flink parallelism allowed per Kinesis Processing Unit (KPU).
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param parallelismPerKpu The Flink parallelism allowed per Kinesis Processing Unit (KPU). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parallelismPerKpu(final java.lang.Number parallelismPerKpu) {
            this.props.parallelismPerKpu(parallelismPerKpu);
            return this;
        }

        /**
         * (experimental) Configuration PropertyGroups.
         * <p>
         * You can use these property groups to pass
         * arbitrary runtime configuration values to your Flink app.
         * <p>
         * Default: No property group configuration provided to the Flink app
         * <p>
         * @return {@code this}
         * @param propertyGroups Configuration PropertyGroups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder propertyGroups(final software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups propertyGroups) {
            this.props.propertyGroups(propertyGroups);
            return this;
        }

        /**
         * (experimental) Provide a RemovalPolicy to override the default.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Provide a RemovalPolicy to override the default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) A role to use to grant permissions to your application.
         * <p>
         * Prefer omitting
         * this property and using the default role.
         * <p>
         * Default: - a new Role will be created
         * <p>
         * @return {@code this}
         * @param role A role to use to grant permissions to your application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) Determines if Flink snapshots are enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param snapshotsEnabled Determines if Flink snapshots are enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder snapshotsEnabled(final java.lang.Boolean snapshotsEnabled) {
            this.props.snapshotsEnabled(snapshotsEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesis.analytics.flink.Application}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.kinesis.analytics.flink.Application build() {
            return new software.amazon.awscdk.services.kinesis.analytics.flink.Application(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
