package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) Code configuration providing the location to a Flink application JAR file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * App app = new App();
 * Stack stack = new Stack(app, "FlinkAppTest");
 * Application flinkApp = Application.Builder.create(stack, "App")
 *         .code(ApplicationCode.fromAsset(join(__dirname, "code-asset")))
 *         .runtime(Runtime.FLINK_1_11)
 *         .build();
 * Alarm.Builder.create(stack, "Alarm")
 *         .metric(flinkApp.metricFullRestarts())
 *         .evaluationPeriods(1)
 *         .threshold(3)
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.588Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.ApplicationCode")
public abstract class ApplicationCode extends software.amazon.jsii.JsiiObject {

    protected ApplicationCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected ApplicationCode() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Reference code from a local directory containing a Flink JAR file.
     * <p>
     * @param path - a local directory path. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * (experimental) Reference code from a local directory containing a Flink JAR file.
     * <p>
     * @param path - a local directory path. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Reference code from an S3 bucket.
     * <p>
     * @param bucket - an s3 bucket. This parameter is required.
     * @param fileKey - a key pointing to a Flink JAR file. This parameter is required.
     * @param objectVersion - an optional version string for the provided fileKey.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String fileKey, final @org.jetbrains.annotations.Nullable java.lang.String objectVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(fileKey, "fileKey is required"), objectVersion });
    }

    /**
     * (experimental) Reference code from an S3 bucket.
     * <p>
     * @param bucket - an s3 bucket. This parameter is required.
     * @param fileKey - a key pointing to a Flink JAR file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String fileKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(fileKey, "fileKey is required") });
    }

    /**
     * (experimental) A method to lazily bind asset resources to the parent FlinkApplication.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCodeConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) A method to lazily bind asset resources to the parent FlinkApplication.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCodeConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
