package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) Available Flink runtimes for Kinesis Analytics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.cloudwatch.*;
 * App app = new App();
 * Stack stack = new Stack(app, "FlinkAppTest");
 * Application flinkApp = Application.Builder.create(stack, "App")
 *         .code(ApplicationCode.fromAsset(join(__dirname, "code-asset")))
 *         .runtime(Runtime.FLINK_1_11)
 *         .build();
 * Alarm.Builder.create(stack, "Alarm")
 *         .metric(flinkApp.metricFullRestarts())
 *         .evaluationPeriods(1)
 *         .threshold(3)
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.605Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.Runtime")
public class Runtime extends software.amazon.jsii.JsiiObject {

    protected Runtime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Runtime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        FLINK_1_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class, "FLINK_1_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class));
        FLINK_1_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class, "FLINK_1_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class));
        FLINK_1_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class, "FLINK_1_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class));
        FLINK_1_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class, "FLINK_1_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class));
    }

    /**
     * (experimental) Create a new Runtime with with an arbitrary Flink version string.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.analytics.flink.Runtime of(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.analytics.flink.Runtime.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Flink Version 1.11.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesis.analytics.flink.Runtime FLINK_1_11;

    /**
     * (experimental) Flink Version 1.13.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesis.analytics.flink.Runtime FLINK_1_13;

    /**
     * (experimental) Flink Version 1.6.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesis.analytics.flink.Runtime FLINK_1_6;

    /**
     * (experimental) Flink Version 1.8.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesis.analytics.flink.Runtime FLINK_1_8;

    /**
     * (experimental) The Cfn string that represents a version of Flink.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
