package software.amazon.awscdk.services.kinesisfirehose;

/**
 * (experimental) Use an AWS Lambda function to transform records.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.nodejs.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-cdk-firehose-delivery-stream-s3-all-properties");
 * Bucket bucket = Bucket.Builder.create(stack, "Bucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * Bucket backupBucket = Bucket.Builder.create(stack, "BackupBucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * LogGroup logGroup = LogGroup.Builder.create(stack, "LogGroup")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * NodejsFunction dataProcessorFunction = NodejsFunction.Builder.create(stack, "DataProcessorFunction")
 *         .entry(join(__dirname, "lambda-data-processor.js"))
 *         .timeout(Duration.minutes(1))
 *         .build();
 * LambdaFunctionProcessor processor = LambdaFunctionProcessor.Builder.create(dataProcessorFunction)
 *         .bufferInterval(Duration.seconds(60))
 *         .bufferSize(Size.mebibytes(1))
 *         .retries(1)
 *         .build();
 * Key key = Key.Builder.create(stack, "Key")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * Key backupKey = Key.Builder.create(stack, "BackupKey")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * DeliveryStream.Builder.create(stack, "Delivery Stream")
 *         .destinations(List.of(S3Bucket.Builder.create(bucket)
 *                 .logging(true)
 *                 .logGroup(logGroup)
 *                 .processor(processor)
 *                 .compression(Compression.GZIP)
 *                 .dataOutputPrefix("regularPrefix")
 *                 .errorOutputPrefix("errorPrefix")
 *                 .bufferingInterval(Duration.seconds(60))
 *                 .bufferingSize(Size.mebibytes(1))
 *                 .encryptionKey(key)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .bucket(backupBucket)
 *                         .compression(Compression.ZIP)
 *                         .dataOutputPrefix("backupPrefix")
 *                         .errorOutputPrefix("backupErrorPrefix")
 *                         .bufferingInterval(Duration.seconds(60))
 *                         .bufferingSize(Size.mebibytes(1))
 *                         .encryptionKey(backupKey)
 *                         .build())
 *                 .build()))
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.862Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisfirehose.LambdaFunctionProcessor")
public class LambdaFunctionProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.IDataProcessor {

    protected LambdaFunctionProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaFunctionProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param lambdaFunction This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LambdaFunctionProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), props });
    }

    /**
     * @param lambdaFunction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LambdaFunctionProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required") });
    }

    /**
     * (experimental) Binds this processor to a destination of a delivery stream.
     * <p>
     * Implementers should use this method to grant processor invocation permissions to the provided stream and return the
     * necessary configuration to register as a processor.
     * <p>
     * @param _scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) The constructor props of the LambdaFunctionProcessor.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         * @param lambdaFunction This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            return new Builder(lambdaFunction);
        }

        private final software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        private software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.Builder props;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
        }

        /**
         * (experimental) The length of time Kinesis Data Firehose will buffer incoming data before calling the processor.
         * <p>
         * s
         * <p>
         * Default: Duration.minutes(1)
         * <p>
         * @return {@code this}
         * @param bufferInterval The length of time Kinesis Data Firehose will buffer incoming data before calling the processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bufferInterval(final software.amazon.awscdk.core.Duration bufferInterval) {
            this.props().bufferInterval(bufferInterval);
            return this;
        }

        /**
         * (experimental) The amount of incoming data Kinesis Data Firehose will buffer before calling the processor.
         * <p>
         * Default: Size.mebibytes(3)
         * <p>
         * @return {@code this}
         * @param bufferSize The amount of incoming data Kinesis Data Firehose will buffer before calling the processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bufferSize(final software.amazon.awscdk.core.Size bufferSize) {
            this.props().bufferSize(bufferSize);
            return this;
        }

        /**
         * (experimental) The number of times Kinesis Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param retries The number of times Kinesis Data Firehose will retry the processor invocation after a failure due to network timeout or invocation limits. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retries(final java.lang.Number retries) {
            this.props().retries(retries);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor build() {
            return new software.amazon.awscdk.services.kinesisfirehose.LambdaFunctionProcessor(
                this.lambdaFunction,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps.Builder();
            }
            return this.props;
        }
    }
}
