package software.amazon.awscdk.services.kinesisfirehose;

/**
 * (experimental) Options for server-side encryption of a delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IDestination destination;
 * // SSE with an customer-managed CMK that is explicitly specified
 * Key key;
 * // SSE with an AWS-owned CMK
 * // SSE with an AWS-owned CMK
 * DeliveryStream.Builder.create(this, "Delivery Stream AWS Owned")
 *         .encryption(StreamEncryption.AWS_OWNED)
 *         .destinations(List.of(destination))
 *         .build();
 * // SSE with an customer-managed CMK that is created automatically by the CDK
 * // SSE with an customer-managed CMK that is created automatically by the CDK
 * DeliveryStream.Builder.create(this, "Delivery Stream Implicit Customer Managed")
 *         .encryption(StreamEncryption.CUSTOMER_MANAGED)
 *         .destinations(List.of(destination))
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream Explicit Customer Managed")
 *         .encryptionKey(key)
 *         .destinations(List.of(destination))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.864Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisfirehose.StreamEncryption")
public enum StreamEncryption {
    /**
     * (experimental) Data in the stream is stored unencrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    UNENCRYPTED,
    /**
     * (experimental) Data in the stream is stored encrypted by a KMS key managed by the customer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CUSTOMER_MANAGED,
    /**
     * (experimental) Data in the stream is stored encrypted by a KMS key owned by AWS and managed for use in multiple AWS accounts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AWS_OWNED,
}
