package software.amazon.awscdk.services.kinesisfirehose.destinations;

/**
 * (experimental) Generic properties for defining a delivery stream destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.services.kinesisfirehose.destinations.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * Compression compression;
 * IDataProcessor dataProcessor;
 * Duration duration;
 * Key key;
 * LogGroup logGroup;
 * Role role;
 * Size size;
 * CommonDestinationProps commonDestinationProps = CommonDestinationProps.builder()
 *         .logging(false)
 *         .logGroup(logGroup)
 *         .processor(dataProcessor)
 *         .role(role)
 *         .s3Backup(DestinationS3BackupProps.builder()
 *                 .bucket(bucket)
 *                 .bufferingInterval(duration)
 *                 .bufferingSize(size)
 *                 .compression(compression)
 *                 .dataOutputPrefix("dataOutputPrefix")
 *                 .encryptionKey(key)
 *                 .errorOutputPrefix("errorOutputPrefix")
 *                 .logging(false)
 *                 .logGroup(logGroup)
 *                 .mode(BackupMode.ALL)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.867Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisfirehose_destinations.CommonDestinationProps")
@software.amazon.jsii.Jsii.Proxy(CommonDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CommonDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) If true, log errors when data transformation or data delivery fails.
     * <p>
     * If <code>logGroup</code> is provided, this will be implicitly set to <code>true</code>.
     * <p>
     * Default: true - errors are logged.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLogging() {
        return null;
    }

    /**
     * (experimental) The CloudWatch log group where log streams will be created to hold error logs.
     * <p>
     * Default: - if `logging` is set to `true`, a log group will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * (experimental) The data transformation that should be performed on the data before writing to the destination.
     * <p>
     * Default: - no data transformation will occur.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.IDataProcessor getProcessor() {
        return null;
    }

    /**
     * (experimental) The IAM role associated with this destination.
     * <p>
     * Assumed by Kinesis Data Firehose to invoke processors and write to destinations
     * <p>
     * Default: - a role will be created with default permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) The configuration for backing up source records to S3.
     * <p>
     * Default: - source records will not be backed up to S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.destinations.DestinationS3BackupProps getS3Backup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CommonDestinationProps> {
        java.lang.Boolean logging;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.kinesisfirehose.destinations.DestinationS3BackupProps s3Backup;

        /**
         * Sets the value of {@link CommonDestinationProps#getLogging}
         * @param logging If true, log errors when data transformation or data delivery fails.
         *                If <code>logGroup</code> is provided, this will be implicitly set to <code>true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(java.lang.Boolean logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationProps#getLogGroup}
         * @param logGroup The CloudWatch log group where log streams will be created to hold error logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationProps#getProcessor}
         * @param processor The data transformation that should be performed on the data before writing to the destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder processor(software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor) {
            this.processor = processor;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationProps#getRole}
         * @param role The IAM role associated with this destination.
         *             Assumed by Kinesis Data Firehose to invoke processors and write to destinations
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationProps#getS3Backup}
         * @param s3Backup The configuration for backing up source records to S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Backup(software.amazon.awscdk.services.kinesisfirehose.destinations.DestinationS3BackupProps s3Backup) {
            this.s3Backup = s3Backup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CommonDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonDestinationProps {
        private final java.lang.Boolean logging;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.kinesisfirehose.destinations.DestinationS3BackupProps s3Backup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.processor = software.amazon.jsii.Kernel.get(this, "processor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.IDataProcessor.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.s3Backup = software.amazon.jsii.Kernel.get(this, "s3Backup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.destinations.DestinationS3BackupProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logging = builder.logging;
            this.logGroup = builder.logGroup;
            this.processor = builder.processor;
            this.role = builder.role;
            this.s3Backup = builder.s3Backup;
        }

        @Override
        public final java.lang.Boolean getLogging() {
            return this.logging;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.IDataProcessor getProcessor() {
            return this.processor;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.destinations.DestinationS3BackupProps getS3Backup() {
            return this.s3Backup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getProcessor() != null) {
                data.set("processor", om.valueToTree(this.getProcessor()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getS3Backup() != null) {
                data.set("s3Backup", om.valueToTree(this.getS3Backup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_kinesisfirehose_destinations.CommonDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonDestinationProps.Jsii$Proxy that = (CommonDestinationProps.Jsii$Proxy) o;

            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.processor != null ? !this.processor.equals(that.processor) : that.processor != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.s3Backup != null ? this.s3Backup.equals(that.s3Backup) : that.s3Backup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logging != null ? this.logging.hashCode() : 0;
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.processor != null ? this.processor.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.s3Backup != null ? this.s3Backup.hashCode() : 0);
            return result;
        }
    }
}
