package software.amazon.awscdk.services.kinesisfirehose.destinations;

/**
 * (experimental) Possible compression options Kinesis Data Firehose can use to compress data on delivery.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.nodejs.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-cdk-firehose-delivery-stream-s3-all-properties");
 * Bucket bucket = Bucket.Builder.create(stack, "Bucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * Bucket backupBucket = Bucket.Builder.create(stack, "BackupBucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * LogGroup logGroup = LogGroup.Builder.create(stack, "LogGroup")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * NodejsFunction dataProcessorFunction = NodejsFunction.Builder.create(stack, "DataProcessorFunction")
 *         .entry(join(__dirname, "lambda-data-processor.js"))
 *         .timeout(Duration.minutes(1))
 *         .build();
 * LambdaFunctionProcessor processor = LambdaFunctionProcessor.Builder.create(dataProcessorFunction)
 *         .bufferInterval(Duration.seconds(60))
 *         .bufferSize(Size.mebibytes(1))
 *         .retries(1)
 *         .build();
 * Key key = Key.Builder.create(stack, "Key")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * Key backupKey = Key.Builder.create(stack, "BackupKey")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * DeliveryStream.Builder.create(stack, "Delivery Stream")
 *         .destinations(List.of(S3Bucket.Builder.create(bucket)
 *                 .logging(true)
 *                 .logGroup(logGroup)
 *                 .processor(processor)
 *                 .compression(Compression.GZIP)
 *                 .dataOutputPrefix("regularPrefix")
 *                 .errorOutputPrefix("errorPrefix")
 *                 .bufferingInterval(Duration.seconds(60))
 *                 .bufferingSize(Size.mebibytes(1))
 *                 .encryptionKey(key)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .bucket(backupBucket)
 *                         .compression(Compression.ZIP)
 *                         .dataOutputPrefix("backupPrefix")
 *                         .errorOutputPrefix("backupErrorPrefix")
 *                         .bufferingInterval(Duration.seconds(60))
 *                         .bufferingSize(Size.mebibytes(1))
 *                         .encryptionKey(backupKey)
 *                         .build())
 *                 .build()))
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.869Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisfirehose_destinations.Compression")
public class Compression extends software.amazon.jsii.JsiiObject {

    protected Compression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Compression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        GZIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class, "GZIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class));
        HADOOP_SNAPPY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class, "HADOOP_SNAPPY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class));
        SNAPPY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class, "SNAPPY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class));
        ZIP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class, "ZIP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class));
    }

    /**
     * (experimental) Creates a new Compression instance with a custom value.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.destinations.Compression of(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.destinations.Compression.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) gzip.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesisfirehose.destinations.Compression GZIP;

    /**
     * (experimental) Hadoop-compatible Snappy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesisfirehose.destinations.Compression HADOOP_SNAPPY;

    /**
     * (experimental) Snappy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesisfirehose.destinations.Compression SNAPPY;

    /**
     * (experimental) ZIP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.kinesisfirehose.destinations.Compression ZIP;

    /**
     * (experimental) the string value of the Compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
