package software.amazon.awscdk.services.lakeformation;

/**
 * Properties for defining a `CfnDataLakeSettings`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * CfnDataLakeSettingsProps cfnDataLakeSettingsProps = CfnDataLakeSettingsProps.builder()
 *         .admins(List.of(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
 *                 .build()))
 *         .trustedResourceOwners(List.of("trustedResourceOwners"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:04.955Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lakeformation.CfnDataLakeSettingsProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataLakeSettingsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataLakeSettingsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of AWS Lake Formation principals.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdmins() {
        return null;
    }

    /**
     * An array of UTF-8 strings.
     * <p>
     * A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log. You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedResourceOwners() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataLakeSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataLakeSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataLakeSettingsProps> {
        java.lang.Object admins;
        java.util.List<java.lang.String> trustedResourceOwners;

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAdmins}
         * @param admins A list of AWS Lake Formation principals.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder admins(software.amazon.awscdk.core.IResolvable admins) {
            this.admins = admins;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getAdmins}
         * @param admins A list of AWS Lake Formation principals.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder admins(java.util.List<? extends java.lang.Object> admins) {
            this.admins = admins;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataLakeSettingsProps#getTrustedResourceOwners}
         * @param trustedResourceOwners An array of UTF-8 strings.
         *                              A list of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs). The user ARNs can be logged in the resource owner's CloudTrail log. You may want to specify this property when you are in a high-trust boundary, such as the same team or company.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustedResourceOwners(java.util.List<java.lang.String> trustedResourceOwners) {
            this.trustedResourceOwners = trustedResourceOwners;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataLakeSettingsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataLakeSettingsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataLakeSettingsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataLakeSettingsProps {
        private final java.lang.Object admins;
        private final java.util.List<java.lang.String> trustedResourceOwners;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.admins = software.amazon.jsii.Kernel.get(this, "admins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.trustedResourceOwners = software.amazon.jsii.Kernel.get(this, "trustedResourceOwners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.admins = builder.admins;
            this.trustedResourceOwners = builder.trustedResourceOwners;
        }

        @Override
        public final java.lang.Object getAdmins() {
            return this.admins;
        }

        @Override
        public final java.util.List<java.lang.String> getTrustedResourceOwners() {
            return this.trustedResourceOwners;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdmins() != null) {
                data.set("admins", om.valueToTree(this.getAdmins()));
            }
            if (this.getTrustedResourceOwners() != null) {
                data.set("trustedResourceOwners", om.valueToTree(this.getTrustedResourceOwners()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_lakeformation.CfnDataLakeSettingsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataLakeSettingsProps.Jsii$Proxy that = (CfnDataLakeSettingsProps.Jsii$Proxy) o;

            if (this.admins != null ? !this.admins.equals(that.admins) : that.admins != null) return false;
            return this.trustedResourceOwners != null ? this.trustedResourceOwners.equals(that.trustedResourceOwners) : that.trustedResourceOwners == null;
        }

        @Override
        public final int hashCode() {
            int result = this.admins != null ? this.admins.hashCode() : 0;
            result = 31 * result + (this.trustedResourceOwners != null ? this.trustedResourceOwners.hashCode() : 0);
            return result;
        }
    }
}
