package software.amazon.awscdk.services.lambda;

/**
 * (experimental) The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.secretsmanager.Secret;
 * import software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSource;
 * // The secret that allows access to your self hosted Kafka cluster
 * Secret secret;
 * Function myFunction;
 * // The list of Kafka brokers
 * String[] bootstrapServers = List.of("kafka-broker:9092");
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * myFunction.addEventSource(SelfManagedKafkaEventSource.Builder.create()
 *         .bootstrapServers(bootstrapServers)
 *         .topic(topic)
 *         .secret(secret)
 *         .batchSize(100) // default
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:05.279Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda.StartingPosition")
public enum StartingPosition {
    /**
     * (experimental) Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TRIM_HORIZON,
    /**
     * (experimental) Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LATEST,
}
