package software.amazon.awscdk.services.lambda.destinations;

/**
 * (experimental) Use a SQS queue as a Lambda destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // An sqs queue for unsuccessful invocations of a lambda function
 * import software.amazon.awscdk.core.*;
 * Queue deadLetterQueue = new Queue(this, "DeadLetterQueue");
 * Function myFn = Function.Builder.create(this, "Fn")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("// your code"))
 *         // sqs queue for unsuccessful invocations
 *         .onFailure(new SqsDestination(deadLetterQueue))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:05.313Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda_destinations.SqsDestination")
public class SqsDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IDestination {

    protected SqsDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * (experimental) Returns a destination configuration.
     * <p>
     * @param _scope This parameter is required.
     * @param fn This parameter is required.
     * @param _options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.DestinationOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(fn, "fn is required"), _options });
    }

    /**
     * (experimental) Returns a destination configuration.
     * <p>
     * @param _scope This parameter is required.
     * @param fn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(fn, "fn is required") });
    }
}
