package software.amazon.awscdk.services.lambda.eventsources;

/**
 * (experimental) Use an Amazon Kinesis stream as an event source for AWS Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource;
 * Function myFunction;
 * Stream stream = new Stream(this, "MyStream");
 * myFunction.addEventSource(KinesisEventSource.Builder.create(stream)
 *         .batchSize(100) // default
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:05.332Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda_event_sources.KinesisEventSource")
public class KinesisEventSource extends software.amazon.awscdk.services.lambda.eventsources.StreamEventSource {

    protected KinesisEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public KinesisEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called by `lambda.addEventSource` to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (experimental) The identifier for this EventSourceMapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingId() {
        return software.amazon.jsii.Kernel.get(this, "eventSourceMappingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream getStream() {
        return software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.kinesis.IStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private final software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
            this.props = new software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps.Builder();
        }

        /**
         * (experimental) Where to begin consuming the stream.
         * <p>
         * @return {@code this}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * (experimental) The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of:
         * <p>
         * <ul>
         * <li>1000 for {&#64;link DynamoEventSource}</li>
         * <li>10000 for {&#64;link KinesisEventSource}, {&#64;link ManagedKafkaEventSource} and {&#64;link SelfManagedKafkaEventSource}</li>
         * </ul></li>
         * </ul>
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * (experimental) If the stream event source mapping should be enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled If the stream event source mapping should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * (experimental) The maximum amount of time to gather records before invoking the function.
         * <p>
         * Maximum of Duration.minutes(5)
         * <p>
         * Default: Duration.seconds(0)
         * <p>
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxBatchingWindow(final software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * (experimental) If the function returns an error, split the batch in two and retry.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bisectBatchOnError(final java.lang.Boolean bisectBatchOnError) {
            this.props.bisectBatchOnError(bisectBatchOnError);
            return this;
        }

        /**
         * (experimental) The maximum age of a record that Lambda sends to a function for processing.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 60 seconds</li>
         * <li>Maximum value of 7 days</li>
         * </ul>
         * <p>
         * Default: - the retention period configured on the stream
         * <p>
         * @return {@code this}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxRecordAge(final software.amazon.awscdk.core.Duration maxRecordAge) {
            this.props.maxRecordAge(maxRecordAge);
            return this;
        }

        /**
         * (experimental) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * <p>
         * Default: - discarded records are ignored
         * <p>
         * @return {@code this}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * (experimental) The number of batches to process from each shard concurrently.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of 10</li>
         * </ul>
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param parallelizationFactor The number of batches to process from each shard concurrently. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parallelizationFactor(final java.lang.Number parallelizationFactor) {
            this.props.parallelizationFactor(parallelizationFactor);
            return this;
        }

        /**
         * (experimental) Allow functions to return partially successful responses for a batch of records.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting">https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting</a>
         * @param reportBatchItemFailures Allow functions to return partially successful responses for a batch of records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reportBatchItemFailures(final java.lang.Boolean reportBatchItemFailures) {
            this.props.reportBatchItemFailures(reportBatchItemFailures);
            return this;
        }

        /**
         * (experimental) Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
         * <p>
         * Default: - retry until the record expires
         * <p>
         * @return {@code this}
         * @param retryAttempts Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (experimental) The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param tumblingWindow The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tumblingWindow(final software.amazon.awscdk.core.Duration tumblingWindow) {
            this.props.tumblingWindow(tumblingWindow);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource(
                this.stream,
                this.props.build()
            );
        }
    }
}
