package software.amazon.awscdk.services.lambda.eventsources;

/**
 * (experimental) An SQS dead letter queue destination configuration for a Lambda event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.services.lambda.eventsources.DynamoEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.SqsDlq;
 * Table table;
 * Function fn;
 * Queue deadLetterQueue = new Queue(this, "deadLetterQueue");
 * fn.addEventSource(DynamoEventSource.Builder.create(table)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .batchSize(5)
 *         .bisectBatchOnError(true)
 *         .onFailure(new SqsDlq(deadLetterQueue))
 *         .retryAttempts(10)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:05.347Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda_event_sources.SqsDlq")
public class SqsDlq extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSourceDlq {

    protected SqsDlq(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsDlq(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SqsDlq(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * (experimental) Returns a destination configuration for the DLQ.
     * <p>
     * @param _target This parameter is required.
     * @param targetHandler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DlqDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSourceMapping _target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction targetHandler) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DlqDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_target, "_target is required"), java.util.Objects.requireNonNull(targetHandler, "targetHandler is required") });
    }
}
