package software.amazon.awscdk.services.logs;

/**
 * (experimental) How long, in days, the log contents will be retained.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Role myLogsPublishingRole;
 * Vpc vpc;
 * // Exporting logs from a cluster
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.aurora(AuroraClusterEngineProps.builder()
 *                 .version(AuroraEngineVersion.VER_1_17_9)
 *                 .build()))
 *         .instanceProps(InstanceProps.builder()
 *                 .vpc(vpc)
 *                 .build())
 *         .cloudwatchLogsExports(List.of("error", "general", "slowquery", "audit")) // Export all available MySQL-based logs
 *         .cloudwatchLogsRetention(RetentionDays.THREE_MONTHS) // Optional - default is to never expire logs
 *         .cloudwatchLogsRetentionRole(myLogsPublishingRole)
 *         .build();
 * // Exporting logs from an instance
 * DatabaseInstance instance = DatabaseInstance.Builder.create(this, "Instance")
 *         .engine(DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder()
 *                 .version(PostgresEngineVersion.VER_12_3)
 *                 .build()))
 *         .vpc(vpc)
 *         .cloudwatchLogsExports(List.of("postgresql"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:05.915Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_logs.RetentionDays")
public enum RetentionDays {
    /**
     * (experimental) 1 day.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ONE_DAY,
    /**
     * (experimental) 3 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    THREE_DAYS,
    /**
     * (experimental) 5 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FIVE_DAYS,
    /**
     * (experimental) 1 week.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ONE_WEEK,
    /**
     * (experimental) 2 weeks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TWO_WEEKS,
    /**
     * (experimental) 1 month.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ONE_MONTH,
    /**
     * (experimental) 2 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TWO_MONTHS,
    /**
     * (experimental) 3 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    THREE_MONTHS,
    /**
     * (experimental) 4 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FOUR_MONTHS,
    /**
     * (experimental) 5 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FIVE_MONTHS,
    /**
     * (experimental) 6 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SIX_MONTHS,
    /**
     * (experimental) 1 year.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ONE_YEAR,
    /**
     * (experimental) 13 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    THIRTEEN_MONTHS,
    /**
     * (experimental) 18 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EIGHTEEN_MONTHS,
    /**
     * (experimental) 2 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TWO_YEARS,
    /**
     * (experimental) 5 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FIVE_YEARS,
    /**
     * (experimental) 6 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SIX_YEARS,
    /**
     * (experimental) 7 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SEVEN_YEARS,
    /**
     * (experimental) 8 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    EIGHT_YEARS,
    /**
     * (experimental) 9 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NINE_YEARS,
    /**
     * (experimental) 10 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TEN_YEARS,
    /**
     * (experimental) Retain logs forever.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INFINITE,
}
