package software.amazon.awscdk.services.msk;

/**
 * (experimental) Create a MSK Cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.sasl(SaslAuthProps.builder()
 *                 .scram(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:06.695Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.Cluster")
public class Cluster extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.msk.ICluster {

    protected Cluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Cluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.ClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Reference an existing cluster, defined outside of the CDK code, by name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param clusterArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.ICluster fromClusterArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String clusterArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.msk.Cluster.class, "fromClusterArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.ICluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(clusterArn, "clusterArn is required") });
    }

    /**
     * (experimental) A list of usersnames to register with the cluster.
     * <p>
     * The password will automatically be generated using Secrets
     * Manager and the { username, password } JSON object stored in Secrets Manager as <code>AmazonMSK_username</code>.
     * <p>
     * Must be using the SASL/SCRAM authentication mechanism.
     * <p>
     * @param usernames - username(s) to register with the cluster. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addUser(final @org.jetbrains.annotations.NotNull java.lang.String... usernames) {
        software.amazon.jsii.Kernel.call(this, "addUser", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(usernames).toArray(Object[]::new));
    }

    /**
     * (experimental) Get the list of brokers that a client application can use to bootstrap.
     * <p>
     * Uses a Custom Resource to make an API call to <code>getBootstrapBrokers</code> using the Javascript SDK
     * <p>
     * @return - A string containing one or more hostname:port pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getBootstrapBrokers() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapBrokers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Get the list of brokers that a SASL/SCRAM authenticated client application can use to bootstrap.
     * <p>
     * Uses a Custom Resource to make an API call to <code>getBootstrapBrokers</code> using the Javascript SDK
     * <p>
     * @return - A string containing one or more dns name (or IP) and SASL SCRAM port pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getBootstrapBrokersSaslScram() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapBrokersSaslScram", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Get the list of brokers that a TLS authenticated client application can use to bootstrap.
     * <p>
     * Uses a Custom Resource to make an API call to <code>getBootstrapBrokers</code> using the Javascript SDK
     * <p>
     * @return - A string containing one or more DNS names (or IP) and TLS port pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getBootstrapBrokersTls() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapBrokersTls", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN of cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The physical name of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Manages connections for the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) Get the ZooKeeper Connection string.
     * <p>
     * Uses a Custom Resource to make an API call to <code>describeCluster</code> using the Javascript SDK
     * <p>
     * @return - The connection string to use to connect to the Apache ZooKeeper cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getZookeeperConnectionString() {
        return software.amazon.jsii.Kernel.get(this, "zookeeperConnectionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Get the ZooKeeper Connection string for a TLS enabled cluster.
     * <p>
     * Uses a Custom Resource to make an API call to <code>describeCluster</code> using the Javascript SDK
     * <p>
     * @return - The connection string to use to connect to zookeeper cluster on TLS port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getZookeeperConnectionStringTls() {
        return software.amazon.jsii.Kernel.get(this, "zookeeperConnectionStringTls", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Key used to encrypt SASL/SCRAM users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getSaslScramAuthenticationKey() {
        return software.amazon.jsii.Kernel.get(this, "saslScramAuthenticationKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.msk.Cluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.msk.Cluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.msk.ClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.msk.ClusterProps.Builder();
        }

        /**
         * (experimental) The physical name of the cluster.
         * <p>
         * @return {@code this}
         * @param clusterName The physical name of the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * (experimental) The version of Apache Kafka.
         * <p>
         * @return {@code this}
         * @param kafkaVersion The version of Apache Kafka. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kafkaVersion(final software.amazon.awscdk.services.msk.KafkaVersion kafkaVersion) {
            this.props.kafkaVersion(kafkaVersion);
            return this;
        }

        /**
         * (experimental) Defines the virtual networking environment for this cluster.
         * <p>
         * Must have at least 2 subnets in two different AZs.
         * <p>
         * @return {@code this}
         * @param vpc Defines the virtual networking environment for this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) Configuration properties for client authentication.
         * <p>
         * MSK supports using private TLS certificates or SASL/SCRAM to authenticate the identity of clients.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param clientAuthentication Configuration properties for client authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientAuthentication(final software.amazon.awscdk.services.msk.ClientAuthentication clientAuthentication) {
            this.props.clientAuthentication(clientAuthentication);
            return this;
        }

        /**
         * (experimental) The Amazon MSK configuration to use for the cluster.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param configurationInfo The Amazon MSK configuration to use for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurationInfo(final software.amazon.awscdk.services.msk.ClusterConfigurationInfo configurationInfo) {
            this.props.configurationInfo(configurationInfo);
            return this;
        }

        /**
         * (experimental) Information about storage volumes attached to MSK broker nodes.
         * <p>
         * Default: - 1000 GiB EBS volume
         * <p>
         * @return {@code this}
         * @param ebsStorageInfo Information about storage volumes attached to MSK broker nodes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ebsStorageInfo(final software.amazon.awscdk.services.msk.EbsStorageInfo ebsStorageInfo) {
            this.props.ebsStorageInfo(ebsStorageInfo);
            return this;
        }

        /**
         * (experimental) Config details for encryption in transit.
         * <p>
         * Default: - enabled
         * <p>
         * @return {@code this}
         * @param encryptionInTransit Config details for encryption in transit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionInTransit(final software.amazon.awscdk.services.msk.EncryptionInTransitConfig encryptionInTransit) {
            this.props.encryptionInTransit(encryptionInTransit);
            return this;
        }

        /**
         * (experimental) The EC2 instance type that you want Amazon MSK to use when it creates your brokers.
         * <p>
         * Default: kafka.m5.large
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html#broker-instance-types">https://docs.aws.amazon.com/msk/latest/developerguide/msk-create-cluster.html#broker-instance-types</a>
         * @param instanceType The EC2 instance type that you want Amazon MSK to use when it creates your brokers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * (experimental) Configure your MSK cluster to send broker logs to different destination types.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param logging Configure your MSK cluster to send broker logs to different destination types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(final software.amazon.awscdk.services.msk.BrokerLogging logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * (experimental) Cluster monitoring configuration.
         * <p>
         * Default: - DEFAULT monitoring level
         * <p>
         * @return {@code this}
         * @param monitoring Cluster monitoring configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder monitoring(final software.amazon.awscdk.services.msk.MonitoringConfiguration monitoring) {
            this.props.monitoring(monitoring);
            return this;
        }

        /**
         * (experimental) Number of Apache Kafka brokers deployed in each Availability Zone.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param numberOfBrokerNodes Number of Apache Kafka brokers deployed in each Availability Zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder numberOfBrokerNodes(final java.lang.Number numberOfBrokerNodes) {
            this.props.numberOfBrokerNodes(numberOfBrokerNodes);
            return this;
        }

        /**
         * (experimental) What to do when this resource is deleted from a stack.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy What to do when this resource is deleted from a stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster.
         * <p>
         * Default: - create new security group
         * <p>
         * @return {@code this}
         * @param securityGroups The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * (experimental) Where to place the nodes within the VPC.
         * <p>
         * Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
         * The subnets that you specify must be in distinct Availability Zones.
         * Client subnets can't be in Availability Zone us-east-1e.
         * <p>
         * Default: - the Vpc default strategy if not specified.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the nodes within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.msk.Cluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.msk.Cluster build() {
            return new software.amazon.awscdk.services.msk.Cluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
