package software.amazon.awscdk.services.msk;

/**
 * (experimental) Monitoring Configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * MonitoringConfiguration monitoringConfiguration = MonitoringConfiguration.builder()
 *         .clusterMonitoringLevel(ClusterMonitoringLevel.DEFAULT)
 *         .enablePrometheusJmxExporter(false)
 *         .enablePrometheusNodeExporter(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:06.703Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.MonitoringConfiguration")
@software.amazon.jsii.Jsii.Proxy(MonitoringConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface MonitoringConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Specifies the level of monitoring for the MSK cluster.
     * <p>
     * Default: DEFAULT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.ClusterMonitoringLevel getClusterMonitoringLevel() {
        return null;
    }

    /**
     * (experimental) Indicates whether you want to enable or disable the JMX Exporter.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnablePrometheusJmxExporter() {
        return null;
    }

    /**
     * (experimental) Indicates whether you want to enable or disable the Prometheus Node Exporter.
     * <p>
     * You can use the Prometheus Node Exporter to get CPU and disk metrics for the broker nodes.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnablePrometheusNodeExporter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MonitoringConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MonitoringConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<MonitoringConfiguration> {
        software.amazon.awscdk.services.msk.ClusterMonitoringLevel clusterMonitoringLevel;
        java.lang.Boolean enablePrometheusJmxExporter;
        java.lang.Boolean enablePrometheusNodeExporter;

        /**
         * Sets the value of {@link MonitoringConfiguration#getClusterMonitoringLevel}
         * @param clusterMonitoringLevel Specifies the level of monitoring for the MSK cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterMonitoringLevel(software.amazon.awscdk.services.msk.ClusterMonitoringLevel clusterMonitoringLevel) {
            this.clusterMonitoringLevel = clusterMonitoringLevel;
            return this;
        }

        /**
         * Sets the value of {@link MonitoringConfiguration#getEnablePrometheusJmxExporter}
         * @param enablePrometheusJmxExporter Indicates whether you want to enable or disable the JMX Exporter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enablePrometheusJmxExporter(java.lang.Boolean enablePrometheusJmxExporter) {
            this.enablePrometheusJmxExporter = enablePrometheusJmxExporter;
            return this;
        }

        /**
         * Sets the value of {@link MonitoringConfiguration#getEnablePrometheusNodeExporter}
         * @param enablePrometheusNodeExporter Indicates whether you want to enable or disable the Prometheus Node Exporter.
         *                                     You can use the Prometheus Node Exporter to get CPU and disk metrics for the broker nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enablePrometheusNodeExporter(java.lang.Boolean enablePrometheusNodeExporter) {
            this.enablePrometheusNodeExporter = enablePrometheusNodeExporter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MonitoringConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public MonitoringConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MonitoringConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringConfiguration {
        private final software.amazon.awscdk.services.msk.ClusterMonitoringLevel clusterMonitoringLevel;
        private final java.lang.Boolean enablePrometheusJmxExporter;
        private final java.lang.Boolean enablePrometheusNodeExporter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterMonitoringLevel = software.amazon.jsii.Kernel.get(this, "clusterMonitoringLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.msk.ClusterMonitoringLevel.class));
            this.enablePrometheusJmxExporter = software.amazon.jsii.Kernel.get(this, "enablePrometheusJmxExporter", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enablePrometheusNodeExporter = software.amazon.jsii.Kernel.get(this, "enablePrometheusNodeExporter", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterMonitoringLevel = builder.clusterMonitoringLevel;
            this.enablePrometheusJmxExporter = builder.enablePrometheusJmxExporter;
            this.enablePrometheusNodeExporter = builder.enablePrometheusNodeExporter;
        }

        @Override
        public final software.amazon.awscdk.services.msk.ClusterMonitoringLevel getClusterMonitoringLevel() {
            return this.clusterMonitoringLevel;
        }

        @Override
        public final java.lang.Boolean getEnablePrometheusJmxExporter() {
            return this.enablePrometheusJmxExporter;
        }

        @Override
        public final java.lang.Boolean getEnablePrometheusNodeExporter() {
            return this.enablePrometheusNodeExporter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClusterMonitoringLevel() != null) {
                data.set("clusterMonitoringLevel", om.valueToTree(this.getClusterMonitoringLevel()));
            }
            if (this.getEnablePrometheusJmxExporter() != null) {
                data.set("enablePrometheusJmxExporter", om.valueToTree(this.getEnablePrometheusJmxExporter()));
            }
            if (this.getEnablePrometheusNodeExporter() != null) {
                data.set("enablePrometheusNodeExporter", om.valueToTree(this.getEnablePrometheusNodeExporter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_msk.MonitoringConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MonitoringConfiguration.Jsii$Proxy that = (MonitoringConfiguration.Jsii$Proxy) o;

            if (this.clusterMonitoringLevel != null ? !this.clusterMonitoringLevel.equals(that.clusterMonitoringLevel) : that.clusterMonitoringLevel != null) return false;
            if (this.enablePrometheusJmxExporter != null ? !this.enablePrometheusJmxExporter.equals(that.enablePrometheusJmxExporter) : that.enablePrometheusJmxExporter != null) return false;
            return this.enablePrometheusNodeExporter != null ? this.enablePrometheusNodeExporter.equals(that.enablePrometheusNodeExporter) : that.enablePrometheusNodeExporter == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterMonitoringLevel != null ? this.clusterMonitoringLevel.hashCode() : 0;
            result = 31 * result + (this.enablePrometheusJmxExporter != null ? this.enablePrometheusJmxExporter.hashCode() : 0);
            result = 31 * result + (this.enablePrometheusNodeExporter != null ? this.enablePrometheusNodeExporter.hashCode() : 0);
            return result;
        }
    }
}
