package software.amazon.awscdk.services.msk;

/**
 * (experimental) TLS authentication properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .clusterName("myCluster")
 *         .kafkaVersion(KafkaVersion.V2_8_1)
 *         .vpc(vpc)
 *         .encryptionInTransit(EncryptionInTransitConfig.builder()
 *                 .clientBroker(ClientBrokerEncryption.TLS)
 *                 .build())
 *         .clientAuthentication(ClientAuthentication.tls(TlsAuthProps.builder()
 *                 .certificateAuthorities(List.of(CertificateAuthority.fromCertificateAuthorityArn(this, "CertificateAuthority", "arn:aws:acm-pca:us-west-2:1234567890:certificate-authority/11111111-1111-1111-1111-111111111111")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:06.706Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_msk.TlsAuthProps")
@software.amazon.jsii.Jsii.Proxy(TlsAuthProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TlsAuthProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) List of ACM Certificate Authorities to enable TLS authentication.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.acmpca.ICertificateAuthority> getCertificateAuthorities() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TlsAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TlsAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TlsAuthProps> {
        java.util.List<software.amazon.awscdk.services.acmpca.ICertificateAuthority> certificateAuthorities;

        /**
         * Sets the value of {@link TlsAuthProps#getCertificateAuthorities}
         * @param certificateAuthorities List of ACM Certificate Authorities to enable TLS authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder certificateAuthorities(java.util.List<? extends software.amazon.awscdk.services.acmpca.ICertificateAuthority> certificateAuthorities) {
            this.certificateAuthorities = (java.util.List<software.amazon.awscdk.services.acmpca.ICertificateAuthority>)certificateAuthorities;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TlsAuthProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TlsAuthProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TlsAuthProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsAuthProps {
        private final java.util.List<software.amazon.awscdk.services.acmpca.ICertificateAuthority> certificateAuthorities;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificateAuthorities = software.amazon.jsii.Kernel.get(this, "certificateAuthorities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.acmpca.ICertificateAuthority.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateAuthorities = (java.util.List<software.amazon.awscdk.services.acmpca.ICertificateAuthority>)builder.certificateAuthorities;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.acmpca.ICertificateAuthority> getCertificateAuthorities() {
            return this.certificateAuthorities;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCertificateAuthorities() != null) {
                data.set("certificateAuthorities", om.valueToTree(this.getCertificateAuthorities()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_msk.TlsAuthProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TlsAuthProps.Jsii$Proxy that = (TlsAuthProps.Jsii$Proxy) o;

            return this.certificateAuthorities != null ? this.certificateAuthorities.equals(that.certificateAuthorities) : that.certificateAuthorities == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificateAuthorities != null ? this.certificateAuthorities.hashCode() : 0;
            return result;
        }
    }
}
