package software.amazon.awscdk.services.neptune;

/**
 * (experimental) Create a clustered database with a given number of instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.R5_LARGE)
 *         .instances(2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:06.764Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_neptune.DatabaseCluster")
public class DatabaseCluster extends software.amazon.awscdk.services.neptune.DatabaseClusterBase implements software.amazon.awscdk.services.neptune.IDatabaseCluster {

    protected DatabaseCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_NUM_INSTANCES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.neptune.DatabaseCluster.class, "DEFAULT_NUM_INSTANCES", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DatabaseCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.DatabaseClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The default number of instances in the Neptune cluster if none are specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.Number DEFAULT_NUM_INSTANCES;

    /**
     * (experimental) The endpoint to use for read/write operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.Endpoint getClusterEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.Endpoint.class));
    }

    /**
     * (experimental) Identifier of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Endpoint to use for load-balanced read-only operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.Endpoint getClusterReadEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterReadEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.Endpoint.class));
    }

    /**
     * (experimental) The resource id for the cluster;
     * <p>
     * for example: cluster-ABCD1234EFGH5678IJKL90MNOP. The cluster ID uniquely
     * identifies the cluster and is used in things like IAM authentication policies.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The connections object to implement IConnectable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) Endpoints which address each individual instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.neptune.Endpoint> getInstanceEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.Endpoint.class))));
    }

    /**
     * (experimental) Identifiers of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIdentifiers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) Subnet group used by the DB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.ISubnetGroup getSubnetGroup() {
        return software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.ISubnetGroup.class));
    }

    /**
     * (experimental) The VPC where the DB subnet group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * (experimental) The subnets used by the DB subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableIamAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "enableIamAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setEnableIamAuthentication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableIamAuthentication", value);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.neptune.DatabaseCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.neptune.DatabaseCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.neptune.DatabaseClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.neptune.DatabaseClusterProps.Builder();
        }

        /**
         * (experimental) What type of instance to start for the replicas.
         * <p>
         * @return {@code this}
         * @param instanceType What type of instance to start for the replicas. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(final software.amazon.awscdk.services.neptune.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * (experimental) What subnets to run the Neptune instances in.
         * <p>
         * Must be at least 2 subnets in two different AZs.
         * <p>
         * @return {@code this}
         * @param vpc What subnets to run the Neptune instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services.
         * <p>
         * Default: - No role is attached to the cluster.
         * <p>
         * @return {@code this}
         * @param associatedRoles A list of AWS Identity and Access Management (IAM) role that can be used by the cluster to access other AWS services. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder associatedRoles(final java.util.List<? extends software.amazon.awscdk.services.iam.IRole> associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }

        /**
         * (experimental) If set to true, Neptune will automatically update the engine of the entire cluster to the latest minor version after a stabilization window of 2 to 3 weeks.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade If set to true, Neptune will automatically update the engine of the entire cluster to the latest minor version after a stabilization window of 2 to 3 weeks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * (experimental) How many days to retain the backup.
         * <p>
         * Default: - cdk.Duration.days(1)
         * <p>
         * @return {@code this}
         * @param backupRetention How many days to retain the backup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupRetention(final software.amazon.awscdk.core.Duration backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        /**
         * (experimental) Additional parameters to pass to the database engine.
         * <p>
         * Default: - No parameter group.
         * <p>
         * @return {@code this}
         * @param clusterParameterGroup Additional parameters to pass to the database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterParameterGroup(final software.amazon.awscdk.services.neptune.IClusterParameterGroup clusterParameterGroup) {
            this.props.clusterParameterGroup(clusterParameterGroup);
            return this;
        }

        /**
         * (experimental) An optional identifier for the cluster.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param dbClusterName An optional identifier for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dbClusterName(final java.lang.String dbClusterName) {
            this.props.dbClusterName(dbClusterName);
            return this;
        }

        /**
         * (experimental) Indicates whether the DB cluster should have deletion protection enabled.
         * <p>
         * Default: - true if ``removalPolicy`` is RETAIN, false otherwise
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether the DB cluster should have deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * (experimental) What version of the database to start.
         * <p>
         * Default: - The default engine version.
         * <p>
         * @return {@code this}
         * @param engineVersion What version of the database to start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder engineVersion(final software.amazon.awscdk.services.neptune.EngineVersion engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * (experimental) Map AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * Default: - `false`
         * <p>
         * @return {@code this}
         * @param iamAuthentication Map AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iamAuthentication(final java.lang.Boolean iamAuthentication) {
            this.props.iamAuthentication(iamAuthentication);
            return this;
        }

        /**
         * (experimental) Base identifier for instances.
         * <p>
         * Every replica is named by appending the replica number to this string, 1-based.
         * <p>
         * Default: - `dbClusterName` is used with the word "Instance" appended. If `dbClusterName` is not provided, the
         * identifier is automatically generated.
         * <p>
         * @return {@code this}
         * @param instanceIdentifierBase Base identifier for instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceIdentifierBase(final java.lang.String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        /**
         * (experimental) Number of Neptune compute instances.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param instances Number of Neptune compute instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instances(final java.lang.Number instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * (experimental) The KMS key for storage encryption.
         * <p>
         * Default: - default master key.
         * <p>
         * @return {@code this}
         * @param kmsKey The KMS key for storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * (experimental) The DB parameter group to associate with the instance.
         * <p>
         * Default: no parameter group
         * <p>
         * @return {@code this}
         * @param parameterGroup The DB parameter group to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroup(final software.amazon.awscdk.services.neptune.IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        /**
         * (experimental) The port the Neptune cluster will listen on.
         * <p>
         * Default: - The default engine port
         * <p>
         * @return {@code this}
         * @param port The port the Neptune cluster will listen on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * (experimental) A daily time range in 24-hours UTC format in which backups preferably execute.
         * <p>
         * Must be at least 30 minutes long.
         * <p>
         * Example: '01:00-02:00'
         * <p>
         * Default: - a 30-minute window selected at random from an 8-hour block of
         * time for each AWS Region. To see the time blocks available, see
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow A daily time range in 24-hours UTC format in which backups preferably execute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * (experimental) A weekly time range in which maintenance should preferably execute.
         * <p>
         * Must be at least 30 minutes long.
         * <p>
         * Example: 'tue:04:17-tue:04:47'
         * <p>
         * Default: - 30-minute window selected at random from an 8-hour block of time for
         * each AWS Region, occurring on a random day of the week.
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow A weekly time range in which maintenance should preferably execute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * (experimental) The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted.
         * <p>
         * This
         * removal policy also applies to the implicit security group created for the
         * cluster if one is not supplied as a parameter.
         * <p>
         * Default: - Retain cluster.
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) Security group.
         * <p>
         * Default: a new security group is created.
         * <p>
         * @return {@code this}
         * @param securityGroups Security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * (experimental) Whether to enable storage encryption.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param storageEncrypted Whether to enable storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * (experimental) Existing subnet group for the cluster.
         * <p>
         * Default: - a new subnet group will be created.
         * <p>
         * @return {@code this}
         * @param subnetGroup Existing subnet group for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetGroup(final software.amazon.awscdk.services.neptune.ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        /**
         * (experimental) Where to place the instances within the VPC.
         * <p>
         * Default: private subnets
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the instances within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.neptune.DatabaseCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.neptune.DatabaseCluster build() {
            return new software.amazon.awscdk.services.neptune.DatabaseCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
