package software.amazon.awscdk.services.neptune;

/**
 * (experimental) DB parameter group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ClusterParameterGroup clusterParams = ClusterParameterGroup.Builder.create(this, "ClusterParams")
 *         .description("Cluster parameter group")
 *         .parameters(Map.of(
 *                 "neptune_enable_audit_log", "1"))
 *         .build();
 * ParameterGroup dbParams = ParameterGroup.Builder.create(this, "DbParams")
 *         .description("Db parameter group")
 *         .parameters(Map.of(
 *                 "neptune_query_timeout", "120000"))
 *         .build();
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.R5_LARGE)
 *         .clusterParameterGroup(clusterParams)
 *         .parameterGroup(dbParams)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:06.778Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_neptune.ParameterGroup")
public class ParameterGroup extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.neptune.IParameterGroup {

    protected ParameterGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ParameterGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ParameterGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.ParameterGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Imports a parameter group.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param parameterGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.neptune.IParameterGroup fromParameterGroupName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String parameterGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.neptune.ParameterGroup.class, "fromParameterGroupName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.neptune.IParameterGroup.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(parameterGroupName, "parameterGroupName is required") });
    }

    /**
     * (experimental) The name of the parameter group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "parameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.neptune.ParameterGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.neptune.ParameterGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.neptune.ParameterGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.neptune.ParameterGroupProps.Builder();
        }

        /**
         * (experimental) The parameters in this parameter group.
         * <p>
         * @return {@code this}
         * @param parameters The parameters in this parameter group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * (experimental) Description for this parameter group.
         * <p>
         * Default: a CDK generated description
         * <p>
         * @return {@code this}
         * @param description Description for this parameter group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) The name of the parameter group.
         * <p>
         * Default: A CDK generated name for the parameter group
         * <p>
         * @return {@code this}
         * @param parameterGroupName The name of the parameter group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroupName(final java.lang.String parameterGroupName) {
            this.props.parameterGroupName(parameterGroupName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.neptune.ParameterGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.neptune.ParameterGroup build() {
            return new software.amazon.awscdk.services.neptune.ParameterGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
