package software.amazon.awscdk.services.networkmanager;

/**
 * A CloudFormation `AWS::NetworkManager::ConnectPeer`.
 * <p>
 * Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnConnectPeer cfnConnectPeer = CfnConnectPeer.Builder.create(this, "MyCfnConnectPeer")
 *         .bgpOptions(BgpOptionsProperty.builder()
 *                 .peerAsn(123)
 *                 .build())
 *         .connectAttachmentId("connectAttachmentId")
 *         .coreNetworkAddress("coreNetworkAddress")
 *         .insideCidrBlocks(List.of("insideCidrBlocks"))
 *         .peerAddress("peerAddress")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:06.870Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_networkmanager.CfnConnectPeer")
public class CfnConnectPeer extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnConnectPeer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnectPeer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.networkmanager.CfnConnectPeer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::NetworkManager::ConnectPeer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnectPeer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::NetworkManager::ConnectPeer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnectPeer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getAttrConfigurationBgpConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationBgpConfigurations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationCoreNetworkAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationCoreNetworkAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrConfigurationInsideCidrBlocks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrConfigurationInsideCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationPeerAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationPeerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationProtocol() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectPeerId() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectPeerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The core network ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCoreNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "attrCoreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the Connect peer was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Region where the edge is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEdgeLocation() {
        return software.amazon.jsii.Kernel.get(this, "attrEdgeLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the Connect peer.
     * <p>
     * This will be: <code>REJECTED</code> | <code>PENDING_ATTACHMENT_ACCEPTANCE</code> | <code>CREATING</code> | <code>FAILED</code> | <code>AVAILABLE</code> | <code>UPDATING</code> | <code>PENDING_NETWORK_UPDATE</code> | <code>PENDING_TAG_ACCEPTANCE</code> | <code>DELETING</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The list of key-value tags associated with the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * `AWS::NetworkManager::ConnectPeer.BgpOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBgpOptions() {
        return software.amazon.jsii.Kernel.get(this, "bgpOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::NetworkManager::ConnectPeer.BgpOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBgpOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkmanager.CfnConnectPeer.BgpOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "bgpOptions", value);
    }

    /**
     * `AWS::NetworkManager::ConnectPeer.BgpOptions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBgpOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bgpOptions", value);
    }

    /**
     * The ID of the attachment to connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectAttachmentId() {
        return software.amazon.jsii.Kernel.get(this, "connectAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the attachment to connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectAttachmentId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectAttachmentId", value);
    }

    /**
     * The IP address of a core network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkAddress() {
        return software.amazon.jsii.Kernel.get(this, "coreNetworkAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address of a core network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCoreNetworkAddress(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "coreNetworkAddress", value);
    }

    /**
     * The inside IP addresses used for a Connect peer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsideCidrBlocks() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "insideCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The inside IP addresses used for a Connect peer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsideCidrBlocks(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "insideCidrBlocks", value);
    }

    /**
     * The IP address of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPeerAddress() {
        return software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPeerAddress(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "peerAddress", value);
    }
    /**
     * Describes the BGP options.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkmanager.*;
     * BgpOptionsProperty bgpOptionsProperty = BgpOptionsProperty.builder()
     *         .peerAsn(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_networkmanager.CfnConnectPeer.BgpOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BgpOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BgpOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Peer ASN of the BGP.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPeerAsn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BgpOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BgpOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BgpOptionsProperty> {
            java.lang.Number peerAsn;

            /**
             * Sets the value of {@link BgpOptionsProperty#getPeerAsn}
             * @param peerAsn The Peer ASN of the BGP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAsn(java.lang.Number peerAsn) {
                this.peerAsn = peerAsn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BgpOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BgpOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BgpOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BgpOptionsProperty {
            private final java.lang.Number peerAsn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.peerAsn = software.amazon.jsii.Kernel.get(this, "peerAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.peerAsn = builder.peerAsn;
            }

            @Override
            public final java.lang.Number getPeerAsn() {
                return this.peerAsn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPeerAsn() != null) {
                    data.set("peerAsn", om.valueToTree(this.getPeerAsn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_networkmanager.CfnConnectPeer.BgpOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BgpOptionsProperty.Jsii$Proxy that = (BgpOptionsProperty.Jsii$Proxy) o;

                return this.peerAsn != null ? this.peerAsn.equals(that.peerAsn) : that.peerAsn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.peerAsn != null ? this.peerAsn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes a core network BGP configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkmanager.*;
     * ConnectPeerBgpConfigurationProperty connectPeerBgpConfigurationProperty = ConnectPeerBgpConfigurationProperty.builder()
     *         .coreNetworkAddress("coreNetworkAddress")
     *         .coreNetworkAsn(123)
     *         .peerAddress("peerAddress")
     *         .peerAsn(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_networkmanager.CfnConnectPeer.ConnectPeerBgpConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectPeerBgpConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectPeerBgpConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The address of a core network.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkAddress() {
            return null;
        }

        /**
         * The ASN of the Coret Network.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoreNetworkAsn() {
            return null;
        }

        /**
         * The address of a core network Connect peer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPeerAddress() {
            return null;
        }

        /**
         * The ASN of the Connect peer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPeerAsn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectPeerBgpConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectPeerBgpConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectPeerBgpConfigurationProperty> {
            java.lang.String coreNetworkAddress;
            java.lang.Number coreNetworkAsn;
            java.lang.String peerAddress;
            java.lang.Number peerAsn;

            /**
             * Sets the value of {@link ConnectPeerBgpConfigurationProperty#getCoreNetworkAddress}
             * @param coreNetworkAddress The address of a core network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreNetworkAddress(java.lang.String coreNetworkAddress) {
                this.coreNetworkAddress = coreNetworkAddress;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerBgpConfigurationProperty#getCoreNetworkAsn}
             * @param coreNetworkAsn The ASN of the Coret Network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreNetworkAsn(java.lang.Number coreNetworkAsn) {
                this.coreNetworkAsn = coreNetworkAsn;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerBgpConfigurationProperty#getPeerAddress}
             * @param peerAddress The address of a core network Connect peer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAddress(java.lang.String peerAddress) {
                this.peerAddress = peerAddress;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerBgpConfigurationProperty#getPeerAsn}
             * @param peerAsn The ASN of the Connect peer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAsn(java.lang.Number peerAsn) {
                this.peerAsn = peerAsn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectPeerBgpConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectPeerBgpConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectPeerBgpConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectPeerBgpConfigurationProperty {
            private final java.lang.String coreNetworkAddress;
            private final java.lang.Number coreNetworkAsn;
            private final java.lang.String peerAddress;
            private final java.lang.Number peerAsn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coreNetworkAddress = software.amazon.jsii.Kernel.get(this, "coreNetworkAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.coreNetworkAsn = software.amazon.jsii.Kernel.get(this, "coreNetworkAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.peerAddress = software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.peerAsn = software.amazon.jsii.Kernel.get(this, "peerAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coreNetworkAddress = builder.coreNetworkAddress;
                this.coreNetworkAsn = builder.coreNetworkAsn;
                this.peerAddress = builder.peerAddress;
                this.peerAsn = builder.peerAsn;
            }

            @Override
            public final java.lang.String getCoreNetworkAddress() {
                return this.coreNetworkAddress;
            }

            @Override
            public final java.lang.Number getCoreNetworkAsn() {
                return this.coreNetworkAsn;
            }

            @Override
            public final java.lang.String getPeerAddress() {
                return this.peerAddress;
            }

            @Override
            public final java.lang.Number getPeerAsn() {
                return this.peerAsn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCoreNetworkAddress() != null) {
                    data.set("coreNetworkAddress", om.valueToTree(this.getCoreNetworkAddress()));
                }
                if (this.getCoreNetworkAsn() != null) {
                    data.set("coreNetworkAsn", om.valueToTree(this.getCoreNetworkAsn()));
                }
                if (this.getPeerAddress() != null) {
                    data.set("peerAddress", om.valueToTree(this.getPeerAddress()));
                }
                if (this.getPeerAsn() != null) {
                    data.set("peerAsn", om.valueToTree(this.getPeerAsn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_networkmanager.CfnConnectPeer.ConnectPeerBgpConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectPeerBgpConfigurationProperty.Jsii$Proxy that = (ConnectPeerBgpConfigurationProperty.Jsii$Proxy) o;

                if (this.coreNetworkAddress != null ? !this.coreNetworkAddress.equals(that.coreNetworkAddress) : that.coreNetworkAddress != null) return false;
                if (this.coreNetworkAsn != null ? !this.coreNetworkAsn.equals(that.coreNetworkAsn) : that.coreNetworkAsn != null) return false;
                if (this.peerAddress != null ? !this.peerAddress.equals(that.peerAddress) : that.peerAddress != null) return false;
                return this.peerAsn != null ? this.peerAsn.equals(that.peerAsn) : that.peerAsn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coreNetworkAddress != null ? this.coreNetworkAddress.hashCode() : 0;
                result = 31 * result + (this.coreNetworkAsn != null ? this.coreNetworkAsn.hashCode() : 0);
                result = 31 * result + (this.peerAddress != null ? this.peerAddress.hashCode() : 0);
                result = 31 * result + (this.peerAsn != null ? this.peerAsn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a core network Connect peer configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkmanager.*;
     * ConnectPeerConfigurationProperty connectPeerConfigurationProperty = ConnectPeerConfigurationProperty.builder()
     *         .bgpConfigurations(List.of(ConnectPeerBgpConfigurationProperty.builder()
     *                 .coreNetworkAddress("coreNetworkAddress")
     *                 .coreNetworkAsn(123)
     *                 .peerAddress("peerAddress")
     *                 .peerAsn(123)
     *                 .build()))
     *         .coreNetworkAddress("coreNetworkAddress")
     *         .insideCidrBlocks(List.of("insideCidrBlocks"))
     *         .peerAddress("peerAddress")
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_networkmanager.CfnConnectPeer.ConnectPeerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectPeerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectPeerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Connect peer BGP configurations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBgpConfigurations() {
            return null;
        }

        /**
         * The IP address of a core network.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkAddress() {
            return null;
        }

        /**
         * The inside IP addresses used for a Connect peer configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsideCidrBlocks() {
            return null;
        }

        /**
         * The IP address of the Connect peer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPeerAddress() {
            return null;
        }

        /**
         * The protocol used for a Connect peer configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectPeerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectPeerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectPeerConfigurationProperty> {
            java.lang.Object bgpConfigurations;
            java.lang.String coreNetworkAddress;
            java.util.List<java.lang.String> insideCidrBlocks;
            java.lang.String peerAddress;
            java.lang.String protocol;

            /**
             * Sets the value of {@link ConnectPeerConfigurationProperty#getBgpConfigurations}
             * @param bgpConfigurations The Connect peer BGP configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bgpConfigurations(software.amazon.awscdk.core.IResolvable bgpConfigurations) {
                this.bgpConfigurations = bgpConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerConfigurationProperty#getBgpConfigurations}
             * @param bgpConfigurations The Connect peer BGP configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bgpConfigurations(java.util.List<? extends java.lang.Object> bgpConfigurations) {
                this.bgpConfigurations = bgpConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerConfigurationProperty#getCoreNetworkAddress}
             * @param coreNetworkAddress The IP address of a core network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreNetworkAddress(java.lang.String coreNetworkAddress) {
                this.coreNetworkAddress = coreNetworkAddress;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerConfigurationProperty#getInsideCidrBlocks}
             * @param insideCidrBlocks The inside IP addresses used for a Connect peer configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insideCidrBlocks(java.util.List<java.lang.String> insideCidrBlocks) {
                this.insideCidrBlocks = insideCidrBlocks;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerConfigurationProperty#getPeerAddress}
             * @param peerAddress The IP address of the Connect peer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAddress(java.lang.String peerAddress) {
                this.peerAddress = peerAddress;
                return this;
            }

            /**
             * Sets the value of {@link ConnectPeerConfigurationProperty#getProtocol}
             * @param protocol The protocol used for a Connect peer configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectPeerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectPeerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectPeerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectPeerConfigurationProperty {
            private final java.lang.Object bgpConfigurations;
            private final java.lang.String coreNetworkAddress;
            private final java.util.List<java.lang.String> insideCidrBlocks;
            private final java.lang.String peerAddress;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bgpConfigurations = software.amazon.jsii.Kernel.get(this, "bgpConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.coreNetworkAddress = software.amazon.jsii.Kernel.get(this, "coreNetworkAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.insideCidrBlocks = software.amazon.jsii.Kernel.get(this, "insideCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.peerAddress = software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bgpConfigurations = builder.bgpConfigurations;
                this.coreNetworkAddress = builder.coreNetworkAddress;
                this.insideCidrBlocks = builder.insideCidrBlocks;
                this.peerAddress = builder.peerAddress;
                this.protocol = builder.protocol;
            }

            @Override
            public final java.lang.Object getBgpConfigurations() {
                return this.bgpConfigurations;
            }

            @Override
            public final java.lang.String getCoreNetworkAddress() {
                return this.coreNetworkAddress;
            }

            @Override
            public final java.util.List<java.lang.String> getInsideCidrBlocks() {
                return this.insideCidrBlocks;
            }

            @Override
            public final java.lang.String getPeerAddress() {
                return this.peerAddress;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBgpConfigurations() != null) {
                    data.set("bgpConfigurations", om.valueToTree(this.getBgpConfigurations()));
                }
                if (this.getCoreNetworkAddress() != null) {
                    data.set("coreNetworkAddress", om.valueToTree(this.getCoreNetworkAddress()));
                }
                if (this.getInsideCidrBlocks() != null) {
                    data.set("insideCidrBlocks", om.valueToTree(this.getInsideCidrBlocks()));
                }
                if (this.getPeerAddress() != null) {
                    data.set("peerAddress", om.valueToTree(this.getPeerAddress()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_networkmanager.CfnConnectPeer.ConnectPeerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectPeerConfigurationProperty.Jsii$Proxy that = (ConnectPeerConfigurationProperty.Jsii$Proxy) o;

                if (this.bgpConfigurations != null ? !this.bgpConfigurations.equals(that.bgpConfigurations) : that.bgpConfigurations != null) return false;
                if (this.coreNetworkAddress != null ? !this.coreNetworkAddress.equals(that.coreNetworkAddress) : that.coreNetworkAddress != null) return false;
                if (this.insideCidrBlocks != null ? !this.insideCidrBlocks.equals(that.insideCidrBlocks) : that.insideCidrBlocks != null) return false;
                if (this.peerAddress != null ? !this.peerAddress.equals(that.peerAddress) : that.peerAddress != null) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bgpConfigurations != null ? this.bgpConfigurations.hashCode() : 0;
                result = 31 * result + (this.coreNetworkAddress != null ? this.coreNetworkAddress.hashCode() : 0);
                result = 31 * result + (this.insideCidrBlocks != null ? this.insideCidrBlocks.hashCode() : 0);
                result = 31 * result + (this.peerAddress != null ? this.peerAddress.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.networkmanager.CfnConnectPeer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.networkmanager.CfnConnectPeer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::NetworkManager::ConnectPeer.BgpOptions`.
         * <p>
         * @return {@code this}
         * @param bgpOptions `AWS::NetworkManager::ConnectPeer.BgpOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(final software.amazon.awscdk.services.networkmanager.CfnConnectPeer.BgpOptionsProperty bgpOptions) {
            this.props().bgpOptions(bgpOptions);
            return this;
        }
        /**
         * `AWS::NetworkManager::ConnectPeer.BgpOptions`.
         * <p>
         * @return {@code this}
         * @param bgpOptions `AWS::NetworkManager::ConnectPeer.BgpOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(final software.amazon.awscdk.core.IResolvable bgpOptions) {
            this.props().bgpOptions(bgpOptions);
            return this;
        }

        /**
         * The ID of the attachment to connect.
         * <p>
         * @return {@code this}
         * @param connectAttachmentId The ID of the attachment to connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectAttachmentId(final java.lang.String connectAttachmentId) {
            this.props().connectAttachmentId(connectAttachmentId);
            return this;
        }

        /**
         * The IP address of a core network.
         * <p>
         * @return {@code this}
         * @param coreNetworkAddress The IP address of a core network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkAddress(final java.lang.String coreNetworkAddress) {
            this.props().coreNetworkAddress(coreNetworkAddress);
            return this;
        }

        /**
         * The inside IP addresses used for a Connect peer configuration.
         * <p>
         * @return {@code this}
         * @param insideCidrBlocks The inside IP addresses used for a Connect peer configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insideCidrBlocks(final java.util.List<java.lang.String> insideCidrBlocks) {
            this.props().insideCidrBlocks(insideCidrBlocks);
            return this;
        }

        /**
         * The IP address of the Connect peer.
         * <p>
         * @return {@code this}
         * @param peerAddress The IP address of the Connect peer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerAddress(final java.lang.String peerAddress) {
            this.props().peerAddress(peerAddress);
            return this;
        }

        /**
         * The list of key-value tags associated with the Connect peer.
         * <p>
         * @return {@code this}
         * @param tags The list of key-value tags associated with the Connect peer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.networkmanager.CfnConnectPeer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.networkmanager.CfnConnectPeer build() {
            return new software.amazon.awscdk.services.networkmanager.CfnConnectPeer(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.networkmanager.CfnConnectPeerProps.Builder();
            }
            return this.props;
        }
    }
}
