package software.amazon.awscdk.services.opsworkscm;

/**
 * A CloudFormation `AWS::OpsWorksCM::Server`.
 * <p>
 * The <code>AWS::OpsWorksCM::Server</code> resource creates an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise configuration management server. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-create-server-cfn.html">Create a Chef Automate Server in AWS CloudFormation</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/opspup-create-server-cfn.html">Create a Puppet Enterprise Master in AWS CloudFormation</a> in the <em>AWS OpsWorks User Guide</em> , and <a href="https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateServer.html">CreateServer</a> in the <em>AWS OpsWorks CM API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworkscm.*;
 * CfnServer cfnServer = CfnServer.Builder.create(this, "MyCfnServer")
 *         .instanceProfileArn("instanceProfileArn")
 *         .instanceType("instanceType")
 *         .serviceRoleArn("serviceRoleArn")
 *         // the properties below are optional
 *         .associatePublicIpAddress(false)
 *         .backupId("backupId")
 *         .backupRetentionCount(123)
 *         .customCertificate("customCertificate")
 *         .customDomain("customDomain")
 *         .customPrivateKey("customPrivateKey")
 *         .disableAutomatedBackup(false)
 *         .engine("engine")
 *         .engineAttributes(List.of(EngineAttributeProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .engineModel("engineModel")
 *         .engineVersion("engineVersion")
 *         .keyPair("keyPair")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .serverName("serverName")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:07.158Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_opsworkscm.CfnServer")
public class CfnServer extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnServer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opsworkscm.CfnServer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::OpsWorksCM::Server`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnServer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opsworkscm.CfnServerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the server, such as `arn:aws:OpsWorksCM:us-east-1:123456789012:server/server-a1bzhi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A DNS name that can be used to access the engine.
     * <p>
     * Example: <code>myserver-asdfghjkl.us-east-1.opsworks.io</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.
     * <p>
     * <ul>
     * <li>The key cannot be empty.</li>
     * <li>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : / &#64;</code></li>
     * <li>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : / &#64;</code></li>
     * <li>Leading and trailing spaces are trimmed from both the key and value.</li>
     * <li>A maximum of 50 user-applied tags is allowed for any AWS OpsWorks CM server.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ARN of the instance profile that your Amazon EC2 instances use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the instance profile that your Amazon EC2 instances use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceProfileArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceProfileArn", java.util.Objects.requireNonNull(value, "instanceProfileArn is required"));
    }

    /**
     * The Amazon EC2 instance type to use.
     * <p>
     * For example, <code>m5.large</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon EC2 instance type to use.
     * <p>
     * For example, <code>m5.large</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
    }

    /**
     * The service role that the AWS OpsWorks CM service backend uses to work with your account.
     * <p>
     * Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service role that the AWS OpsWorks CM service backend uses to work with your account.
     * <p>
     * Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRoleArn", java.util.Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    /**
     * Associate a public IP address with a server that you are launching.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
        return software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Associate a public IP address with a server that you are launching.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatePublicIpAddress(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "associatePublicIpAddress", value);
    }

    /**
     * Associate a public IP address with a server that you are launching.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatePublicIpAddress(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associatePublicIpAddress", value);
    }

    /**
     * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupId", value);
    }

    /**
     * The number of automated backups that you want to keep.
     * <p>
     * Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is <code>1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionCount() {
        return software.amazon.jsii.Kernel.get(this, "backupRetentionCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of automated backups that you want to keep.
     * <p>
     * Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is <code>1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetentionCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backupRetentionCount", value);
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:.
     * <p>
     * <ul>
     * <li>You can provide either a self-signed, custom certificate, or the full certificate chain.</li>
     * <li>The certificate must be a valid X509 certificate, or a certificate chain in PEM format.</li>
     * <li>The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's <code>NotAfter</code> date).</li>
     * <li>The certificate’s common name or subject alternative names (SANs), if present, must match the value of <code>CustomDomain</code> .</li>
     * <li>The certificate must match the value of <code>CustomPrivateKey</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomCertificate() {
        return software.amazon.jsii.Kernel.get(this, "customCertificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:.
     * <p>
     * <ul>
     * <li>You can provide either a self-signed, custom certificate, or the full certificate chain.</li>
     * <li>The certificate must be a valid X509 certificate, or a certificate chain in PEM format.</li>
     * <li>The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's <code>NotAfter</code> date).</li>
     * <li>The certificate’s common name or subject alternative names (SANs), if present, must match the value of <code>CustomDomain</code> .</li>
     * <li>The certificate must match the value of <code>CustomPrivateKey</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomCertificate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customCertificate", value);
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomDomain() {
        return software.amazon.jsii.Kernel.get(this, "customDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customDomain", value);
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomPrivateKey() {
        return software.amazon.jsii.Kernel.get(this, "customPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomPrivateKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customPrivateKey", value);
    }

    /**
     * Enable or disable scheduled backups.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableAutomatedBackup() {
        return software.amazon.jsii.Kernel.get(this, "disableAutomatedBackup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enable or disable scheduled backups.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableAutomatedBackup(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "disableAutomatedBackup", value);
    }

    /**
     * Enable or disable scheduled backups.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableAutomatedBackup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableAutomatedBackup", value);
    }

    /**
     * The configuration management engine to use.
     * <p>
     * Valid values include <code>ChefAutomate</code> and <code>Puppet</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The configuration management engine to use.
     * <p>
     * Valid values include <code>ChefAutomate</code> and <code>Puppet</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * Optional engine attributes on a specified server.
     * <p>
     * <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
     * <p>
     * <ul>
     * <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
     * </ul>
     * <p>
     * <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
     * <p>
     * <ul>
     * <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
     * <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEngineAttributes() {
        return software.amazon.jsii.Kernel.get(this, "engineAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional engine attributes on a specified server.
     * <p>
     * <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
     * <p>
     * <ul>
     * <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
     * </ul>
     * <p>
     * <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
     * <p>
     * <ul>
     * <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
     * <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "engineAttributes", value);
    }

    /**
     * Optional engine attributes on a specified server.
     * <p>
     * <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
     * <p>
     * <ul>
     * <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
     * </ul>
     * <p>
     * <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
     * <p>
     * <ul>
     * <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
     * <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineAttributes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.opsworkscm.CfnServer.EngineAttributeProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.opsworkscm.CfnServer.EngineAttributeProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "engineAttributes", value);
    }

    /**
     * The engine model of the server.
     * <p>
     * Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineModel() {
        return software.amazon.jsii.Kernel.get(this, "engineModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The engine model of the server.
     * <p>
     * Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineModel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineModel", value);
    }

    /**
     * The major release version of the engine that you want to use.
     * <p>
     * For a Chef server, the valid value for EngineVersion is currently <code>2</code> . For a Puppet server, valid values are <code>2019</code> or <code>2017</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major release version of the engine that you want to use.
     * <p>
     * For a Chef server, the valid value for EngineVersion is currently <code>2</code> . For a Puppet server, valid values are <code>2019</code> or <code>2017</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * The Amazon EC2 key pair to set for the instance.
     * <p>
     * This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyPair() {
        return software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon EC2 key pair to set for the instance.
     * <p>
     * This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyPair(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyPair", value);
    }

    /**
     * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled.
     * <p>
     * Valid values must be specified in one of the following formats:
     * <p>
     * <ul>
     * <li><code>HH:MM</code> for daily backups</li>
     * <li><code>DDD:HH:MM</code> for weekly backups</li>
     * </ul>
     * <p>
     * <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
     * <p>
     * <em>Example:</em> <code>08:00</code> , which represents a daily start time of 08:00 UTC.
     * <p>
     * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled.
     * <p>
     * Valid values must be specified in one of the following formats:
     * <p>
     * <ul>
     * <li><code>HH:MM</code> for daily backups</li>
     * <li><code>DDD:HH:MM</code> for weekly backups</li>
     * </ul>
     * <p>
     * <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
     * <p>
     * <em>Example:</em> <code>08:00</code> , which represents a daily start time of 08:00 UTC.
     * <p>
     * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance.
     * <p>
     * Valid values must be specified in the following format: <code>DDD:HH:MM</code> . <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information.
     * <p>
     * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance.
     * <p>
     * Valid values must be specified in the following format: <code>DDD:HH:MM</code> . <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information.
     * <p>
     * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * A list of security group IDs to attach to the Amazon EC2 instance.
     * <p>
     * If you add this parameter, the specified security groups must be within the VPC that is specified by <code>SubnetIds</code> .
     * <p>
     * If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of security group IDs to attach to the Amazon EC2 instance.
     * <p>
     * If you add this parameter, the specified security groups must be within the VPC that is specified by <code>SubnetIds</code> .
     * <p>
     * If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * The name of the server.
     * <p>
     * The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
        return software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the server.
     * <p>
     * The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverName", value);
    }

    /**
     * The IDs of subnets in which to launch the server EC2 instance.
     * <p>
     * Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
     * <p>
     * EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
     * <p>
     * For more information about supported Amazon EC2 platforms, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The IDs of subnets in which to launch the server EC2 instance.
     * <p>
     * Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
     * <p>
     * EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
     * <p>
     * For more information about supported Amazon EC2 platforms, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", value);
    }
    /**
     * The `EngineAttribute` property type specifies administrator credentials for an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.
     * <p>
     * <code>EngineAttribute</code> is a property of the <code>AWS::OpsWorksCM::Server</code> resource type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworkscm.*;
     * EngineAttributeProperty engineAttributeProperty = EngineAttributeProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_opsworkscm.CfnServer.EngineAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(EngineAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EngineAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the engine attribute.
         * <p>
         * <em>Attribute name for Chef Automate servers:</em>
         * <p>
         * <ul>
         * <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code></li>
         * </ul>
         * <p>
         * <em>Attribute names for Puppet Enterprise servers:</em>
         * <p>
         * <ul>
         * <li><code>PUPPET_ADMIN_PASSWORD</code></li>
         * <li><code>PUPPET_R10K_REMOTE</code></li>
         * <li><code>PUPPET_R10K_PRIVATE_KEY</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the engine attribute.
         * <p>
         * <em>Attribute value for Chef Automate servers:</em>
         * <p>
         * <ul>
         * <li><code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. You can generate this key by running the following <a href="https://docs.aws.amazon.com/https://www.openssl.org/">OpenSSL</a> command on Linux-based computers.</li>
         * </ul>
         * <p>
         * <code>openssl genrsa -out *pivotal_key_file_name* .pem 2048</code>
         * <p>
         * On Windows-based computers, you can use the PuTTYgen utility to generate a base64-encoded RSA private key. For more information, see <a href="https://docs.aws.amazon.com/https://www.ssh.com/ssh/putty/windows/puttygen">PuTTYgen - Key Generator for PuTTY on Windows</a> on SSH.com.
         * <p>
         * <em>Attribute values for Puppet Enterprise servers:</em>
         * <p>
         * <ul>
         * <li><code>PUPPET_ADMIN_PASSWORD</code> : An administrator password that you can use to sign in to the Puppet Enterprise console webpage after the server is online. The password must use between 8 and 32 ASCII characters.</li>
         * <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
         * <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add <code>PUPPET_R10K_PRIVATE_KEY</code> to specify a PEM-encoded private SSH key.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EngineAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EngineAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EngineAttributeProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EngineAttributeProperty#getName}
             * @param name The name of the engine attribute.
             *             <em>Attribute name for Chef Automate servers:</em>
             *             <p>
             *             <ul>
             *             <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code></li>
             *             </ul>
             *             <p>
             *             <em>Attribute names for Puppet Enterprise servers:</em>
             *             <p>
             *             <ul>
             *             <li><code>PUPPET_ADMIN_PASSWORD</code></li>
             *             <li><code>PUPPET_R10K_REMOTE</code></li>
             *             <li><code>PUPPET_R10K_PRIVATE_KEY</code></li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EngineAttributeProperty#getValue}
             * @param value The value of the engine attribute.
             *              <em>Attribute value for Chef Automate servers:</em>
             *              <p>
             *              <ul>
             *              <li><code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. You can generate this key by running the following <a href="https://docs.aws.amazon.com/https://www.openssl.org/">OpenSSL</a> command on Linux-based computers.</li>
             *              </ul>
             *              <p>
             *              <code>openssl genrsa -out *pivotal_key_file_name* .pem 2048</code>
             *              <p>
             *              On Windows-based computers, you can use the PuTTYgen utility to generate a base64-encoded RSA private key. For more information, see <a href="https://docs.aws.amazon.com/https://www.ssh.com/ssh/putty/windows/puttygen">PuTTYgen - Key Generator for PuTTY on Windows</a> on SSH.com.
             *              <p>
             *              <em>Attribute values for Puppet Enterprise servers:</em>
             *              <p>
             *              <ul>
             *              <li><code>PUPPET_ADMIN_PASSWORD</code> : An administrator password that you can use to sign in to the Puppet Enterprise console webpage after the server is online. The password must use between 8 and 32 ASCII characters.</li>
             *              <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
             *              <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add <code>PUPPET_R10K_PRIVATE_KEY</code> to specify a PEM-encoded private SSH key.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EngineAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EngineAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EngineAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EngineAttributeProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_opsworkscm.CfnServer.EngineAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EngineAttributeProperty.Jsii$Proxy that = (EngineAttributeProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.opsworkscm.CfnServer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.opsworkscm.CfnServer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.opsworkscm.CfnServerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.opsworkscm.CfnServerProps.Builder();
        }

        /**
         * The ARN of the instance profile that your Amazon EC2 instances use.
         * <p>
         * @return {@code this}
         * @param instanceProfileArn The ARN of the instance profile that your Amazon EC2 instances use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileArn(final java.lang.String instanceProfileArn) {
            this.props.instanceProfileArn(instanceProfileArn);
            return this;
        }

        /**
         * The Amazon EC2 instance type to use.
         * <p>
         * For example, <code>m5.large</code> .
         * <p>
         * @return {@code this}
         * @param instanceType The Amazon EC2 instance type to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * The service role that the AWS OpsWorks CM service backend uses to work with your account.
         * <p>
         * Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
         * <p>
         * @return {@code this}
         * @param serviceRoleArn The service role that the AWS OpsWorks CM service backend uses to work with your account. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(final java.lang.String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        /**
         * Associate a public IP address with a server that you are launching.
         * <p>
         * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * <p>
         * @return {@code this}
         * @param associatePublicIpAddress Associate a public IP address with a server that you are launching. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final java.lang.Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }
        /**
         * Associate a public IP address with a server that you are launching.
         * <p>
         * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * <p>
         * @return {@code this}
         * @param associatePublicIpAddress Associate a public IP address with a server that you are launching. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        /**
         * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
         * <p>
         * @return {@code this}
         * @param backupId If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(final java.lang.String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        /**
         * The number of automated backups that you want to keep.
         * <p>
         * Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is <code>1</code> .
         * <p>
         * @return {@code this}
         * @param backupRetentionCount The number of automated backups that you want to keep. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionCount(final java.lang.Number backupRetentionCount) {
            this.props.backupRetentionCount(backupRetentionCount);
            return this;
        }

        /**
         * Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:.
         * <p>
         * <ul>
         * <li>You can provide either a self-signed, custom certificate, or the full certificate chain.</li>
         * <li>The certificate must be a valid X509 certificate, or a certificate chain in PEM format.</li>
         * <li>The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's <code>NotAfter</code> date).</li>
         * <li>The certificate’s common name or subject alternative names (SANs), if present, must match the value of <code>CustomDomain</code> .</li>
         * <li>The certificate must match the value of <code>CustomPrivateKey</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param customCertificate Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for `CustomDomain` and `CustomPrivateKey` . The following are requirements for the `CustomCertificate` value:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCertificate(final java.lang.String customCertificate) {
            this.props.customCertificate(customCertificate);
            return this;
        }

        /**
         * Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` .
         * <p>
         * @return {@code this}
         * @param customDomain Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as `https://aws.my-company.com` . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated `Endpoint` value if the server is using a custom domain. If you specify a custom domain, you must also specify values for `CustomCertificate` and `CustomPrivateKey` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomain(final java.lang.String customDomain) {
            this.props.customDomain(customDomain);
            return this;
        }

        /**
         * Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` .
         * <p>
         * @return {@code this}
         * @param customPrivateKey Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for `CustomDomain` and `CustomCertificate` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPrivateKey(final java.lang.String customPrivateKey) {
            this.props.customPrivateKey(customPrivateKey);
            return this;
        }

        /**
         * Enable or disable scheduled backups.
         * <p>
         * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * <p>
         * @return {@code this}
         * @param disableAutomatedBackup Enable or disable scheduled backups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableAutomatedBackup(final java.lang.Boolean disableAutomatedBackup) {
            this.props.disableAutomatedBackup(disableAutomatedBackup);
            return this;
        }
        /**
         * Enable or disable scheduled backups.
         * <p>
         * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * <p>
         * @return {@code this}
         * @param disableAutomatedBackup Enable or disable scheduled backups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableAutomatedBackup(final software.amazon.awscdk.core.IResolvable disableAutomatedBackup) {
            this.props.disableAutomatedBackup(disableAutomatedBackup);
            return this;
        }

        /**
         * The configuration management engine to use.
         * <p>
         * Valid values include <code>ChefAutomate</code> and <code>Puppet</code> .
         * <p>
         * @return {@code this}
         * @param engine The configuration management engine to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * Optional engine attributes on a specified server.
         * <p>
         * <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
         * <p>
         * <ul>
         * <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
         * </ul>
         * <p>
         * <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
         * <p>
         * <ul>
         * <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
         * <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param engineAttributes Optional engine attributes on a specified server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineAttributes(final software.amazon.awscdk.core.IResolvable engineAttributes) {
            this.props.engineAttributes(engineAttributes);
            return this;
        }
        /**
         * Optional engine attributes on a specified server.
         * <p>
         * <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
         * <p>
         * <ul>
         * <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
         * </ul>
         * <p>
         * <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
         * <p>
         * <ul>
         * <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
         * <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param engineAttributes Optional engine attributes on a specified server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineAttributes(final java.util.List<? extends java.lang.Object> engineAttributes) {
            this.props.engineAttributes(engineAttributes);
            return this;
        }

        /**
         * The engine model of the server.
         * <p>
         * Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
         * <p>
         * @return {@code this}
         * @param engineModel The engine model of the server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineModel(final java.lang.String engineModel) {
            this.props.engineModel(engineModel);
            return this;
        }

        /**
         * The major release version of the engine that you want to use.
         * <p>
         * For a Chef server, the valid value for EngineVersion is currently <code>2</code> . For a Puppet server, valid values are <code>2019</code> or <code>2017</code> .
         * <p>
         * @return {@code this}
         * @param engineVersion The major release version of the engine that you want to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * The Amazon EC2 key pair to set for the instance.
         * <p>
         * This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
         * <p>
         * @return {@code this}
         * @param keyPair The Amazon EC2 key pair to set for the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(final java.lang.String keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        /**
         * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled.
         * <p>
         * Valid values must be specified in one of the following formats:
         * <p>
         * <ul>
         * <li><code>HH:MM</code> for daily backups</li>
         * <li><code>DDD:HH:MM</code> for weekly backups</li>
         * </ul>
         * <p>
         * <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
         * <p>
         * <em>Example:</em> <code>08:00</code> , which represents a daily start time of 08:00 UTC.
         * <p>
         * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance.
         * <p>
         * Valid values must be specified in the following format: <code>DDD:HH:MM</code> . <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information.
         * <p>
         * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * A list of security group IDs to attach to the Amazon EC2 instance.
         * <p>
         * If you add this parameter, the specified security groups must be within the VPC that is specified by <code>SubnetIds</code> .
         * <p>
         * If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
         * <p>
         * @return {@code this}
         * @param securityGroupIds A list of security group IDs to attach to the Amazon EC2 instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * The name of the server.
         * <p>
         * The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
         * <p>
         * @return {@code this}
         * @param serverName The name of the server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverName(final java.lang.String serverName) {
            this.props.serverName(serverName);
            return this;
        }

        /**
         * The IDs of subnets in which to launch the server EC2 instance.
         * <p>
         * Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
         * <p>
         * EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
         * <p>
         * For more information about supported Amazon EC2 platforms, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
         * <p>
         * @return {@code this}
         * @param subnetIds The IDs of subnets in which to launch the server EC2 instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.
         * <p>
         * <ul>
         * <li>The key cannot be empty.</li>
         * <li>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : / &#64;</code></li>
         * <li>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : / &#64;</code></li>
         * <li>Leading and trailing spaces are trimmed from both the key and value.</li>
         * <li>A maximum of 50 user-applied tags is allowed for any AWS OpsWorks CM server.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param tags A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.opsworkscm.CfnServer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.opsworkscm.CfnServer build() {
            return new software.amazon.awscdk.services.opsworkscm.CfnServer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
