package software.amazon.awscdk.services.panorama;

/**
 * Properties for defining a `CfnPackageVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.panorama.*;
 * CfnPackageVersionProps cfnPackageVersionProps = CfnPackageVersionProps.builder()
 *         .packageId("packageId")
 *         .packageVersion("packageVersion")
 *         .patchVersion("patchVersion")
 *         // the properties below are optional
 *         .markLatest(false)
 *         .ownerAccount("ownerAccount")
 *         .updatedLatestPatchVersion("updatedLatestPatchVersion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:07.191Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_panorama.CfnPackageVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnPackageVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPackageVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A package ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackageId();

    /**
     * A package version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPackageVersion();

    /**
     * A patch version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPatchVersion();

    /**
     * Whether to mark the new version as the latest version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMarkLatest() {
        return null;
    }

    /**
     * An owner account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerAccount() {
        return null;
    }

    /**
     * If the version was marked latest, the new version to maker as latest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpdatedLatestPatchVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPackageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPackageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPackageVersionProps> {
        java.lang.String packageId;
        java.lang.String packageVersion;
        java.lang.String patchVersion;
        java.lang.Object markLatest;
        java.lang.String ownerAccount;
        java.lang.String updatedLatestPatchVersion;

        /**
         * Sets the value of {@link CfnPackageVersionProps#getPackageId}
         * @param packageId A package ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageId(java.lang.String packageId) {
            this.packageId = packageId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageVersionProps#getPackageVersion}
         * @param packageVersion A package version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageVersion(java.lang.String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageVersionProps#getPatchVersion}
         * @param patchVersion A patch version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder patchVersion(java.lang.String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageVersionProps#getMarkLatest}
         * @param markLatest Whether to mark the new version as the latest version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder markLatest(java.lang.Boolean markLatest) {
            this.markLatest = markLatest;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageVersionProps#getMarkLatest}
         * @param markLatest Whether to mark the new version as the latest version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder markLatest(software.amazon.awscdk.core.IResolvable markLatest) {
            this.markLatest = markLatest;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageVersionProps#getOwnerAccount}
         * @param ownerAccount An owner account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerAccount(java.lang.String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageVersionProps#getUpdatedLatestPatchVersion}
         * @param updatedLatestPatchVersion If the version was marked latest, the new version to maker as latest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatedLatestPatchVersion(java.lang.String updatedLatestPatchVersion) {
            this.updatedLatestPatchVersion = updatedLatestPatchVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPackageVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPackageVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPackageVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPackageVersionProps {
        private final java.lang.String packageId;
        private final java.lang.String packageVersion;
        private final java.lang.String patchVersion;
        private final java.lang.Object markLatest;
        private final java.lang.String ownerAccount;
        private final java.lang.String updatedLatestPatchVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.packageId = software.amazon.jsii.Kernel.get(this, "packageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.packageVersion = software.amazon.jsii.Kernel.get(this, "packageVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.patchVersion = software.amazon.jsii.Kernel.get(this, "patchVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.markLatest = software.amazon.jsii.Kernel.get(this, "markLatest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ownerAccount = software.amazon.jsii.Kernel.get(this, "ownerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.updatedLatestPatchVersion = software.amazon.jsii.Kernel.get(this, "updatedLatestPatchVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.packageId = java.util.Objects.requireNonNull(builder.packageId, "packageId is required");
            this.packageVersion = java.util.Objects.requireNonNull(builder.packageVersion, "packageVersion is required");
            this.patchVersion = java.util.Objects.requireNonNull(builder.patchVersion, "patchVersion is required");
            this.markLatest = builder.markLatest;
            this.ownerAccount = builder.ownerAccount;
            this.updatedLatestPatchVersion = builder.updatedLatestPatchVersion;
        }

        @Override
        public final java.lang.String getPackageId() {
            return this.packageId;
        }

        @Override
        public final java.lang.String getPackageVersion() {
            return this.packageVersion;
        }

        @Override
        public final java.lang.String getPatchVersion() {
            return this.patchVersion;
        }

        @Override
        public final java.lang.Object getMarkLatest() {
            return this.markLatest;
        }

        @Override
        public final java.lang.String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final java.lang.String getUpdatedLatestPatchVersion() {
            return this.updatedLatestPatchVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("packageId", om.valueToTree(this.getPackageId()));
            data.set("packageVersion", om.valueToTree(this.getPackageVersion()));
            data.set("patchVersion", om.valueToTree(this.getPatchVersion()));
            if (this.getMarkLatest() != null) {
                data.set("markLatest", om.valueToTree(this.getMarkLatest()));
            }
            if (this.getOwnerAccount() != null) {
                data.set("ownerAccount", om.valueToTree(this.getOwnerAccount()));
            }
            if (this.getUpdatedLatestPatchVersion() != null) {
                data.set("updatedLatestPatchVersion", om.valueToTree(this.getUpdatedLatestPatchVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_panorama.CfnPackageVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPackageVersionProps.Jsii$Proxy that = (CfnPackageVersionProps.Jsii$Proxy) o;

            if (!packageId.equals(that.packageId)) return false;
            if (!packageVersion.equals(that.packageVersion)) return false;
            if (!patchVersion.equals(that.patchVersion)) return false;
            if (this.markLatest != null ? !this.markLatest.equals(that.markLatest) : that.markLatest != null) return false;
            if (this.ownerAccount != null ? !this.ownerAccount.equals(that.ownerAccount) : that.ownerAccount != null) return false;
            return this.updatedLatestPatchVersion != null ? this.updatedLatestPatchVersion.equals(that.updatedLatestPatchVersion) : that.updatedLatestPatchVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.packageId.hashCode();
            result = 31 * result + (this.packageVersion.hashCode());
            result = 31 * result + (this.patchVersion.hashCode());
            result = 31 * result + (this.markLatest != null ? this.markLatest.hashCode() : 0);
            result = 31 * result + (this.ownerAccount != null ? this.ownerAccount.hashCode() : 0);
            result = 31 * result + (this.updatedLatestPatchVersion != null ? this.updatedLatestPatchVersion.hashCode() : 0);
            return result;
        }
    }
}
