package software.amazon.awscdk.services.pipes;

/**
 * A CloudFormation `AWS::Pipes::Pipe`.
 * <p>
 * Create a pipe. Amazon EventBridge Pipes connect event sources to targets and reduces the need for specialized knowledge and integration code.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pipes.*;
 * CfnPipe cfnPipe = CfnPipe.Builder.create(this, "MyCfnPipe")
 *         .roleArn("roleArn")
 *         .source("source")
 *         .target("target")
 *         // the properties below are optional
 *         .description("description")
 *         .desiredState("desiredState")
 *         .enrichment("enrichment")
 *         .enrichmentParameters(PipeEnrichmentParametersProperty.builder()
 *                 .httpParameters(PipeEnrichmentHttpParametersProperty.builder()
 *                         .headerParameters(Map.of(
 *                                 "headerParametersKey", "headerParameters"))
 *                         .pathParameterValues(List.of("pathParameterValues"))
 *                         .queryStringParameters(Map.of(
 *                                 "queryStringParametersKey", "queryStringParameters"))
 *                         .build())
 *                 .inputTemplate("inputTemplate")
 *                 .build())
 *         .name("name")
 *         .sourceParameters(PipeSourceParametersProperty.builder()
 *                 .activeMqBrokerParameters(PipeSourceActiveMQBrokerParametersProperty.builder()
 *                         .credentials(MQBrokerAccessCredentialsProperty.builder()
 *                                 .basicAuth("basicAuth")
 *                                 .build())
 *                         .queueName("queueName")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .build())
 *                 .dynamoDbStreamParameters(PipeSourceDynamoDBStreamParametersProperty.builder()
 *                         .startingPosition("startingPosition")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                                 .arn("arn")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .maximumRecordAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .onPartialBatchItemFailure("onPartialBatchItemFailure")
 *                         .parallelizationFactor(123)
 *                         .build())
 *                 .filterCriteria(FilterCriteriaProperty.builder()
 *                         .filters(List.of(FilterProperty.builder()
 *                                 .pattern("pattern")
 *                                 .build()))
 *                         .build())
 *                 .kinesisStreamParameters(PipeSourceKinesisStreamParametersProperty.builder()
 *                         .startingPosition("startingPosition")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                                 .arn("arn")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .maximumRecordAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .onPartialBatchItemFailure("onPartialBatchItemFailure")
 *                         .parallelizationFactor(123)
 *                         .startingPositionTimestamp("startingPositionTimestamp")
 *                         .build())
 *                 .managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParametersProperty.builder()
 *                         .topicName("topicName")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .consumerGroupId("consumerGroupId")
 *                         .credentials(MSKAccessCredentialsProperty.builder()
 *                                 .clientCertificateTlsAuth("clientCertificateTlsAuth")
 *                                 .saslScram512Auth("saslScram512Auth")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .startingPosition("startingPosition")
 *                         .build())
 *                 .rabbitMqBrokerParameters(PipeSourceRabbitMQBrokerParametersProperty.builder()
 *                         .credentials(MQBrokerAccessCredentialsProperty.builder()
 *                                 .basicAuth("basicAuth")
 *                                 .build())
 *                         .queueName("queueName")
 *                         // the properties below are optional
 *                         .batchSize(123)
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .virtualHost("virtualHost")
 *                         .build())
 *                 .selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParametersProperty.builder()
 *                         .topicName("topicName")
 *                         // the properties below are optional
 *                         .additionalBootstrapServers(List.of("additionalBootstrapServers"))
 *                         .batchSize(123)
 *                         .consumerGroupId("consumerGroupId")
 *                         .credentials(SelfManagedKafkaAccessConfigurationCredentialsProperty.builder()
 *                                 .basicAuth("basicAuth")
 *                                 .clientCertificateTlsAuth("clientCertificateTlsAuth")
 *                                 .saslScram256Auth("saslScram256Auth")
 *                                 .saslScram512Auth("saslScram512Auth")
 *                                 .build())
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .serverRootCaCertificate("serverRootCaCertificate")
 *                         .startingPosition("startingPosition")
 *                         .vpc(SelfManagedKafkaAccessConfigurationVpcProperty.builder()
 *                                 .securityGroup(List.of("securityGroup"))
 *                                 .subnets(List.of("subnets"))
 *                                 .build())
 *                         .build())
 *                 .sqsQueueParameters(PipeSourceSqsQueueParametersProperty.builder()
 *                         .batchSize(123)
 *                         .maximumBatchingWindowInSeconds(123)
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .targetParameters(PipeTargetParametersProperty.builder()
 *                 .batchJobParameters(PipeTargetBatchJobParametersProperty.builder()
 *                         .jobDefinition("jobDefinition")
 *                         .jobName("jobName")
 *                         // the properties below are optional
 *                         .arrayProperties(BatchArrayPropertiesProperty.builder()
 *                                 .size(123)
 *                                 .build())
 *                         .containerOverrides(BatchContainerOverridesProperty.builder()
 *                                 .command(List.of("command"))
 *                                 .environment(List.of(BatchEnvironmentVariableProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .instanceType("instanceType")
 *                                 .resourceRequirements(List.of(BatchResourceRequirementProperty.builder()
 *                                         .type("type")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .dependsOn(List.of(BatchJobDependencyProperty.builder()
 *                                 .jobId("jobId")
 *                                 .type("type")
 *                                 .build()))
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .retryStrategy(BatchRetryStrategyProperty.builder()
 *                                 .attempts(123)
 *                                 .build())
 *                         .build())
 *                 .cloudWatchLogsParameters(PipeTargetCloudWatchLogsParametersProperty.builder()
 *                         .logStreamName("logStreamName")
 *                         .timestamp("timestamp")
 *                         .build())
 *                 .ecsTaskParameters(PipeTargetEcsTaskParametersProperty.builder()
 *                         .taskDefinitionArn("taskDefinitionArn")
 *                         // the properties below are optional
 *                         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                                 .capacityProvider("capacityProvider")
 *                                 // the properties below are optional
 *                                 .base(123)
 *                                 .weight(123)
 *                                 .build()))
 *                         .enableEcsManagedTags(false)
 *                         .enableExecuteCommand(false)
 *                         .group("group")
 *                         .launchType("launchType")
 *                         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                         .subnets(List.of("subnets"))
 *                                         // the properties below are optional
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .securityGroups(List.of("securityGroups"))
 *                                         .build())
 *                                 .build())
 *                         .overrides(EcsTaskOverrideProperty.builder()
 *                                 .containerOverrides(List.of(EcsContainerOverrideProperty.builder()
 *                                         .command(List.of("command"))
 *                                         .cpu(123)
 *                                         .environment(List.of(EcsEnvironmentVariableProperty.builder()
 *                                                 .name("name")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .environmentFiles(List.of(EcsEnvironmentFileProperty.builder()
 *                                                 .type("type")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .memory(123)
 *                                         .memoryReservation(123)
 *                                         .name("name")
 *                                         .resourceRequirements(List.of(EcsResourceRequirementProperty.builder()
 *                                                 .type("type")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build()))
 *                                 .cpu("cpu")
 *                                 .ephemeralStorage(EcsEphemeralStorageProperty.builder()
 *                                         .sizeInGiB(123)
 *                                         .build())
 *                                 .executionRoleArn("executionRoleArn")
 *                                 .inferenceAcceleratorOverrides(List.of(EcsInferenceAcceleratorOverrideProperty.builder()
 *                                         .deviceName("deviceName")
 *                                         .deviceType("deviceType")
 *                                         .build()))
 *                                 .memory("memory")
 *                                 .taskRoleArn("taskRoleArn")
 *                                 .build())
 *                         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                                 .expression("expression")
 *                                 .type("type")
 *                                 .build()))
 *                         .placementStrategy(List.of(PlacementStrategyProperty.builder()
 *                                 .field("field")
 *                                 .type("type")
 *                                 .build()))
 *                         .platformVersion("platformVersion")
 *                         .propagateTags("propagateTags")
 *                         .referenceId("referenceId")
 *                         .tags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .taskCount(123)
 *                         .build())
 *                 .eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParametersProperty.builder()
 *                         .detailType("detailType")
 *                         .endpointId("endpointId")
 *                         .resources(List.of("resources"))
 *                         .source("source")
 *                         .time("time")
 *                         .build())
 *                 .httpParameters(PipeTargetHttpParametersProperty.builder()
 *                         .headerParameters(Map.of(
 *                                 "headerParametersKey", "headerParameters"))
 *                         .pathParameterValues(List.of("pathParameterValues"))
 *                         .queryStringParameters(Map.of(
 *                                 "queryStringParametersKey", "queryStringParameters"))
 *                         .build())
 *                 .inputTemplate("inputTemplate")
 *                 .kinesisStreamParameters(PipeTargetKinesisStreamParametersProperty.builder()
 *                         .partitionKey("partitionKey")
 *                         .build())
 *                 .lambdaFunctionParameters(PipeTargetLambdaFunctionParametersProperty.builder()
 *                         .invocationType("invocationType")
 *                         .build())
 *                 .redshiftDataParameters(PipeTargetRedshiftDataParametersProperty.builder()
 *                         .database("database")
 *                         .sqls(List.of("sqls"))
 *                         // the properties below are optional
 *                         .dbUser("dbUser")
 *                         .secretManagerArn("secretManagerArn")
 *                         .statementName("statementName")
 *                         .withEvent(false)
 *                         .build())
 *                 .sageMakerPipelineParameters(PipeTargetSageMakerPipelineParametersProperty.builder()
 *                         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sqsQueueParameters(PipeTargetSqsQueueParametersProperty.builder()
 *                         .messageDeduplicationId("messageDeduplicationId")
 *                         .messageGroupId("messageGroupId")
 *                         .build())
 *                 .stepFunctionStateMachineParameters(PipeTargetStateMachineParametersProperty.builder()
 *                         .invocationType("invocationType")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:07.460Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe")
public class CfnPipe extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnPipe(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipe(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pipes.CfnPipe.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Pipes::Pipe`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPipe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pipes.CfnPipeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the pipe was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state the pipe is in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCurrentState() {
        return software.amazon.jsii.Kernel.get(this, "attrCurrentState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When the pipe was last updated, in [ISO-8601 format](https://docs.aws.amazon.com/https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The reason the pipe is in its current state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStateReason() {
        return software.amazon.jsii.Kernel.get(this, "attrStateReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The list of key-value pairs to associate with the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ARN of the role that allows the pipe to send data to the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the role that allows the pipe to send data to the target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The ARN of the source resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the source resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSource(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "source", java.util.Objects.requireNonNull(value, "source is required"));
    }

    /**
     * The ARN of the target resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the target resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTarget(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "target", java.util.Objects.requireNonNull(value, "target is required"));
    }

    /**
     * A description of the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The state the pipe should be in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDesiredState() {
        return software.amazon.jsii.Kernel.get(this, "desiredState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state the pipe should be in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesiredState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "desiredState", value);
    }

    /**
     * The ARN of the enrichment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnrichment() {
        return software.amazon.jsii.Kernel.get(this, "enrichment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the enrichment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnrichment(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "enrichment", value);
    }

    /**
     * The parameters required to set up enrichment on your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnrichmentParameters() {
        return software.amazon.jsii.Kernel.get(this, "enrichmentParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters required to set up enrichment on your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnrichmentParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pipes.CfnPipe.PipeEnrichmentParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "enrichmentParameters", value);
    }

    /**
     * The parameters required to set up enrichment on your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnrichmentParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enrichmentParameters", value);
    }

    /**
     * The name of the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The parameters required to set up a source for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceParameters() {
        return software.amazon.jsii.Kernel.get(this, "sourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters required to set up a source for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceParameters", value);
    }

    /**
     * The parameters required to set up a source for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceParameters", value);
    }

    /**
     * The parameters required to set up a target for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetParameters() {
        return software.amazon.jsii.Kernel.get(this, "targetParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters required to set up a target for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetParameters", value);
    }

    /**
     * The parameters required to set up a target for your pipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetParameters", value);
    }
    /**
     * This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used.
     * <p>
     * This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * AwsVpcConfigurationProperty awsVpcConfigurationProperty = AwsVpcConfigurationProperty.builder()
     *         .subnets(List.of("subnets"))
     *         // the properties below are optional
     *         .assignPublicIp("assignPublicIp")
     *         .securityGroups(List.of("securityGroups"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the subnets associated with the task.
         * <p>
         * These subnets must all be in the same VPC. You can specify as many as 16 subnets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * Specifies whether the task's elastic network interface receives a public IP address.
         * <p>
         * You can specify <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to <code>FARGATE</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * Specifies the security groups associated with the task.
         * <p>
         * These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            java.util.List<java.lang.String> subnets;
            java.lang.String assignPublicIp;
            java.util.List<java.lang.String> securityGroups;

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSubnets}
             * @param subnets Specifies the subnets associated with the task. This parameter is required.
             *                These subnets must all be in the same VPC. You can specify as many as 16 subnets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address.
             *                       You can specify <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to <code>FARGATE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSecurityGroups}
             * @param securityGroups Specifies the security groups associated with the task.
             *                       These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsVpcConfigurationProperty {
            private final java.util.List<java.lang.String> subnets;
            private final java.lang.String assignPublicIp;
            private final java.util.List<java.lang.String> securityGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
                this.assignPublicIp = builder.assignPublicIp;
                this.securityGroups = builder.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnets", om.valueToTree(this.getSubnets()));
                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.AwsVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsVpcConfigurationProperty.Jsii$Proxy that = (AwsVpcConfigurationProperty.Jsii$Proxy) o;

                if (!subnets.equals(that.subnets)) return false;
                if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
                return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnets.hashCode();
                result = 31 * result + (this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The array properties for the submitted job, such as the size of the array.
     * <p>
     * The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * BatchArrayPropertiesProperty batchArrayPropertiesProperty = BatchArrayPropertiesProperty.builder()
     *         .size(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.BatchArrayPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchArrayPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchArrayPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size of the array, if this is an array batch job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchArrayPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchArrayPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchArrayPropertiesProperty> {
            java.lang.Number size;

            /**
             * Sets the value of {@link BatchArrayPropertiesProperty#getSize}
             * @param size The size of the array, if this is an array batch job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchArrayPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchArrayPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchArrayPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchArrayPropertiesProperty {
            private final java.lang.Number size;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.size = builder.size;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSize() != null) {
                    data.set("size", om.valueToTree(this.getSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.BatchArrayPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchArrayPropertiesProperty.Jsii$Proxy that = (BatchArrayPropertiesProperty.Jsii$Proxy) o;

                return this.size != null ? this.size.equals(that.size) : that.size == null;
            }

            @Override
            public final int hashCode() {
                int result = this.size != null ? this.size.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The overrides that are sent to a container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * BatchContainerOverridesProperty batchContainerOverridesProperty = BatchContainerOverridesProperty.builder()
     *         .command(List.of("command"))
     *         .environment(List.of(BatchEnvironmentVariableProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .instanceType("instanceType")
     *         .resourceRequirements(List.of(BatchResourceRequirementProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.BatchContainerOverridesProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchContainerOverridesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchContainerOverridesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The command to send to the container that overrides the default command from the Docker image or the task definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The environment variables to send to the container.
         * <p>
         * You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.
         * <p>
         * <blockquote>
         * <p>
         * Environment variables cannot start with " <code>AWS Batch</code> ". This naming convention is reserved for variables that AWS Batch sets.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The instance type to use for a multi-node parallel job.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The type and amount of resources to assign to a container.
         * <p>
         * This overrides the settings in the job definition. The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRequirements() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchContainerOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchContainerOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchContainerOverridesProperty> {
            java.util.List<java.lang.String> command;
            java.lang.Object environment;
            java.lang.String instanceType;
            java.lang.Object resourceRequirements;

            /**
             * Sets the value of {@link BatchContainerOverridesProperty#getCommand}
             * @param command The command to send to the container that overrides the default command from the Docker image or the task definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link BatchContainerOverridesProperty#getEnvironment}
             * @param environment The environment variables to send to the container.
             *                    You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    Environment variables cannot start with " <code>AWS Batch</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link BatchContainerOverridesProperty#getEnvironment}
             * @param environment The environment variables to send to the container.
             *                    You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    Environment variables cannot start with " <code>AWS Batch</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link BatchContainerOverridesProperty#getInstanceType}
             * @param instanceType The instance type to use for a multi-node parallel job.
             *                     <blockquote>
             *                     <p>
             *                     This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link BatchContainerOverridesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of resources to assign to a container.
             *                             This overrides the settings in the job definition. The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(software.amazon.awscdk.core.IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link BatchContainerOverridesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of resources to assign to a container.
             *                             This overrides the settings in the job definition. The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(java.util.List<? extends java.lang.Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchContainerOverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchContainerOverridesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchContainerOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchContainerOverridesProperty {
            private final java.util.List<java.lang.String> command;
            private final java.lang.Object environment;
            private final java.lang.String instanceType;
            private final java.lang.Object resourceRequirements;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceRequirements = software.amazon.jsii.Kernel.get(this, "resourceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = builder.command;
                this.environment = builder.environment;
                this.instanceType = builder.instanceType;
                this.resourceRequirements = builder.resourceRequirements;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Object getResourceRequirements() {
                return this.resourceRequirements;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getResourceRequirements() != null) {
                    data.set("resourceRequirements", om.valueToTree(this.getResourceRequirements()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.BatchContainerOverridesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchContainerOverridesProperty.Jsii$Proxy that = (BatchContainerOverridesProperty.Jsii$Proxy) o;

                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                return this.resourceRequirements != null ? this.resourceRequirements.equals(that.resourceRequirements) : that.resourceRequirements == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command != null ? this.command.hashCode() : 0;
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.resourceRequirements != null ? this.resourceRequirements.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The environment variables to send to the container.
     * <p>
     * You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.
     * <p>
     * <blockquote>
     * <p>
     * Environment variables cannot start with " <code>AWS Batch</code> ". This naming convention is reserved for variables that AWS Batch sets.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * BatchEnvironmentVariableProperty batchEnvironmentVariableProperty = BatchEnvironmentVariableProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.BatchEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchEnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchEnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the key-value pair.
         * <p>
         * For environment variables, this is the name of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the key-value pair.
         * <p>
         * For environment variables, this is the value of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchEnvironmentVariableProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link BatchEnvironmentVariableProperty#getName}
             * @param name The name of the key-value pair.
             *             For environment variables, this is the name of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BatchEnvironmentVariableProperty#getValue}
             * @param value The value of the key-value pair.
             *              For environment variables, this is the value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchEnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchEnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchEnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.BatchEnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchEnvironmentVariableProperty.Jsii$Proxy that = (BatchEnvironmentVariableProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents an AWS Batch job dependency.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * BatchJobDependencyProperty batchJobDependencyProperty = BatchJobDependencyProperty.builder()
     *         .jobId("jobId")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.BatchJobDependencyProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchJobDependencyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchJobDependencyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The job ID of the AWS Batch job that's associated with this dependency.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJobId() {
            return null;
        }

        /**
         * The type of the job dependency.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchJobDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchJobDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchJobDependencyProperty> {
            java.lang.String jobId;
            java.lang.String type;

            /**
             * Sets the value of {@link BatchJobDependencyProperty#getJobId}
             * @param jobId The job ID of the AWS Batch job that's associated with this dependency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobId(java.lang.String jobId) {
                this.jobId = jobId;
                return this;
            }

            /**
             * Sets the value of {@link BatchJobDependencyProperty#getType}
             * @param type The type of the job dependency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchJobDependencyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchJobDependencyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchJobDependencyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchJobDependencyProperty {
            private final java.lang.String jobId;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jobId = software.amazon.jsii.Kernel.get(this, "jobId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jobId = builder.jobId;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getJobId() {
                return this.jobId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJobId() != null) {
                    data.set("jobId", om.valueToTree(this.getJobId()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.BatchJobDependencyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchJobDependencyProperty.Jsii$Proxy that = (BatchJobDependencyProperty.Jsii$Proxy) o;

                if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jobId != null ? this.jobId.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The type and amount of a resource to assign to a container.
     * <p>
     * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * BatchResourceRequirementProperty batchResourceRequirementProperty = BatchResourceRequirementProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.BatchResourceRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchResourceRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchResourceRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to assign to a container.
         * <p>
         * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.
         * <p>
         * <ul>
         * <li><strong>type="GPU"</strong> - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * GPUs aren't available for jobs that are running on Fargate resources.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>type="MEMORY"</strong> - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.
         * <p>
         * <ul>
         * <li><strong>value = 512</strong> - <code>VCPU</code> = 0.25</li>
         * <li><strong>value = 1024</strong> - <code>VCPU</code> = 0.25 or 0.5</li>
         * <li><strong>value = 2048</strong> - <code>VCPU</code> = 0.25, 0.5, or 1</li>
         * <li><strong>value = 3072</strong> - <code>VCPU</code> = 0.5, or 1</li>
         * <li><strong>value = 4096</strong> - <code>VCPU</code> = 0.5, 1, or 2</li>
         * <li><strong>value = 5120, 6144, or 7168</strong> - <code>VCPU</code> = 1 or 2</li>
         * <li><strong>value = 8192</strong> - <code>VCPU</code> = 1, 2, 4, or 8</li>
         * <li><strong>value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360</strong> - <code>VCPU</code> = 2 or 4</li>
         * <li><strong>value = 16384</strong> - <code>VCPU</code> = 2, 4, or 8</li>
         * <li><strong>value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720</strong> - <code>VCPU</code> = 4</li>
         * <li><strong>value = 20480, 24576, or 28672</strong> - <code>VCPU</code> = 4 or 8</li>
         * <li><strong>value = 36864, 45056, 53248, or 61440</strong> - <code>VCPU</code> = 8</li>
         * <li><strong>value = 32768, 40960, 49152, or 57344</strong> - <code>VCPU</code> = 8 or 16</li>
         * <li><strong>value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</strong> - <code>VCPU</code> = 16</li>
         * <li><strong>type="VCPU"</strong> - The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</li>
         * </ul>
         * <p>
         * The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate">AWS Fargate quotas</a> in the <em>AWS General Reference</em> .
         * <p>
         * For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
         * <p>
         * <ul>
         * <li><strong>value = 0.25</strong> - <code>MEMORY</code> = 512, 1024, or 2048</li>
         * <li><strong>value = 0.5</strong> - <code>MEMORY</code> = 1024, 2048, 3072, or 4096</li>
         * <li><strong>value = 1</strong> - <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</li>
         * <li><strong>value = 2</strong> - <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</li>
         * <li><strong>value = 4</strong> - <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</li>
         * <li><strong>value = 8</strong> - <code>MEMORY</code> = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440</li>
         * <li><strong>value = 16</strong> - <code>MEMORY</code> = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link BatchResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchResourceRequirementProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link BatchResourceRequirementProperty#getType}
             * @param type The type of resource to assign to a container. This parameter is required.
             *             The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link BatchResourceRequirementProperty#getValue}
             * @param value The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified. This parameter is required.
             *              <ul>
             *              <li><strong>type="GPU"</strong> - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              GPUs aren't available for jobs that are running on Fargate resources.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><strong>type="MEMORY"</strong> - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
             *              <p>
             *              </blockquote>
             *              <p>
             *              For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.
             *              <p>
             *              <ul>
             *              <li><strong>value = 512</strong> - <code>VCPU</code> = 0.25</li>
             *              <li><strong>value = 1024</strong> - <code>VCPU</code> = 0.25 or 0.5</li>
             *              <li><strong>value = 2048</strong> - <code>VCPU</code> = 0.25, 0.5, or 1</li>
             *              <li><strong>value = 3072</strong> - <code>VCPU</code> = 0.5, or 1</li>
             *              <li><strong>value = 4096</strong> - <code>VCPU</code> = 0.5, 1, or 2</li>
             *              <li><strong>value = 5120, 6144, or 7168</strong> - <code>VCPU</code> = 1 or 2</li>
             *              <li><strong>value = 8192</strong> - <code>VCPU</code> = 1, 2, 4, or 8</li>
             *              <li><strong>value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360</strong> - <code>VCPU</code> = 2 or 4</li>
             *              <li><strong>value = 16384</strong> - <code>VCPU</code> = 2, 4, or 8</li>
             *              <li><strong>value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720</strong> - <code>VCPU</code> = 4</li>
             *              <li><strong>value = 20480, 24576, or 28672</strong> - <code>VCPU</code> = 4 or 8</li>
             *              <li><strong>value = 36864, 45056, 53248, or 61440</strong> - <code>VCPU</code> = 8</li>
             *              <li><strong>value = 32768, 40960, 49152, or 57344</strong> - <code>VCPU</code> = 8 or 16</li>
             *              <li><strong>value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</strong> - <code>VCPU</code> = 16</li>
             *              <li><strong>type="VCPU"</strong> - The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</li>
             *              </ul>
             *              <p>
             *              The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate">AWS Fargate quotas</a> in the <em>AWS General Reference</em> .
             *              <p>
             *              For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
             *              <p>
             *              <ul>
             *              <li><strong>value = 0.25</strong> - <code>MEMORY</code> = 512, 1024, or 2048</li>
             *              <li><strong>value = 0.5</strong> - <code>MEMORY</code> = 1024, 2048, 3072, or 4096</li>
             *              <li><strong>value = 1</strong> - <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</li>
             *              <li><strong>value = 2</strong> - <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</li>
             *              <li><strong>value = 4</strong> - <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</li>
             *              <li><strong>value = 8</strong> - <code>MEMORY</code> = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440</li>
             *              <li><strong>value = 16</strong> - <code>MEMORY</code> = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchResourceRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchResourceRequirementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchResourceRequirementProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.BatchResourceRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchResourceRequirementProperty.Jsii$Proxy that = (BatchResourceRequirementProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The retry strategy that's associated with a job.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html">Automated job retries</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * BatchRetryStrategyProperty batchRetryStrategyProperty = BatchRetryStrategyProperty.builder()
     *         .attempts(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.BatchRetryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchRetryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchRetryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of times to move a job to the `RUNNABLE` status.
         * <p>
         * If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttempts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchRetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchRetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchRetryStrategyProperty> {
            java.lang.Number attempts;

            /**
             * Sets the value of {@link BatchRetryStrategyProperty#getAttempts}
             * @param attempts The number of times to move a job to the `RUNNABLE` status.
             *                 If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attempts(java.lang.Number attempts) {
                this.attempts = attempts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchRetryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchRetryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchRetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchRetryStrategyProperty {
            private final java.lang.Number attempts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attempts = software.amazon.jsii.Kernel.get(this, "attempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attempts = builder.attempts;
            }

            @Override
            public final java.lang.Number getAttempts() {
                return this.attempts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttempts() != null) {
                    data.set("attempts", om.valueToTree(this.getAttempts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.BatchRetryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchRetryStrategyProperty.Jsii$Proxy that = (BatchRetryStrategyProperty.Jsii$Proxy) o;

                return this.attempts != null ? this.attempts.equals(that.attempts) : that.attempts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attempts != null ? this.attempts.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of a capacity provider strategy.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html">CapacityProviderStrategyItem</a> in the Amazon ECS API Reference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * CapacityProviderStrategyItemProperty capacityProviderStrategyItemProperty = CapacityProviderStrategyItemProperty.builder()
     *         .capacityProvider("capacityProvider")
     *         // the properties below are optional
     *         .base(123)
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderStrategyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderStrategyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The short name of the capacity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCapacityProvider();

        /**
         * The base value designates how many tasks, at a minimum, to run on the specified capacity provider.
         * <p>
         * Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
         * <p>
         * The weight value is taken into consideration after the base value, if defined, is satisfied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            java.lang.String capacityProvider;
            java.lang.Number base;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getCapacityProvider}
             * @param capacityProvider The short name of the capacity provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProvider(java.lang.String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getBase}
             * @param base The base value designates how many tasks, at a minimum, to run on the specified capacity provider.
             *             Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getWeight}
             * @param weight The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
             *               The weight value is taken into consideration after the base value, if defined, is satisfied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderStrategyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderStrategyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderStrategyItemProperty {
            private final java.lang.String capacityProvider;
            private final java.lang.Number base;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityProvider = software.amazon.jsii.Kernel.get(this, "capacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityProvider = java.util.Objects.requireNonNull(builder.capacityProvider, "capacityProvider is required");
                this.base = builder.base;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getCapacityProvider() {
                return this.capacityProvider;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("capacityProvider", om.valueToTree(this.getCapacityProvider()));
                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.CapacityProviderStrategyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderStrategyItemProperty.Jsii$Proxy that = (CapacityProviderStrategyItemProperty.Jsii$Proxy) o;

                if (!capacityProvider.equals(that.capacityProvider)) return false;
                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityProvider.hashCode();
                result = 31 * result + (this.base != null ? this.base.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A `DeadLetterConfig` object that contains information about a dead-letter queue configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * DeadLetterConfigProperty deadLetterConfigProperty = DeadLetterConfigProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.DeadLetterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DeadLetterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeadLetterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon SQS queue specified as the target for the dead-letter queue.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeadLetterConfigProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link DeadLetterConfigProperty#getArn}
             * @param arn The ARN of the Amazon SQS queue specified as the target for the dead-letter queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeadLetterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeadLetterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeadLetterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeadLetterConfigProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.DeadLetterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeadLetterConfigProperty.Jsii$Proxy that = (DeadLetterConfigProperty.Jsii$Proxy) o;

                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The overrides that are sent to a container.
     * <p>
     * An empty container override can be passed in. An example of an empty container override is <code>{"containerOverrides": [ ] }</code> . If a non-empty container override is specified, the <code>name</code> parameter must be included.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * EcsContainerOverrideProperty ecsContainerOverrideProperty = EcsContainerOverrideProperty.builder()
     *         .command(List.of("command"))
     *         .cpu(123)
     *         .environment(List.of(EcsEnvironmentVariableProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .environmentFiles(List.of(EcsEnvironmentFileProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .memory(123)
     *         .memoryReservation(123)
     *         .name("name")
     *         .resourceRequirements(List.of(EcsResourceRequirementProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.EcsContainerOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsContainerOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsContainerOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The command to send to the container that overrides the default command from the Docker image or the task definition.
         * <p>
         * You must also specify a container name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The number of `cpu` units reserved for the container, instead of the default value from the task definition.
         * <p>
         * You must also specify a container name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
            return null;
        }

        /**
         * The environment variables to send to the container.
         * <p>
         * You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * A list of files containing the environment variables to pass to a container, instead of the value from the container definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentFiles() {
            return null;
        }

        /**
         * The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition.
         * <p>
         * If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
            return null;
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition.
         * <p>
         * You must also specify a container name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryReservation() {
            return null;
        }

        /**
         * The name of the container that receives the override.
         * <p>
         * This parameter is required if any override is specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The type and amount of a resource to assign to a container, instead of the default value from the task definition.
         * <p>
         * The only supported resource is a GPU.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRequirements() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsContainerOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsContainerOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsContainerOverrideProperty> {
            java.util.List<java.lang.String> command;
            java.lang.Number cpu;
            java.lang.Object environment;
            java.lang.Object environmentFiles;
            java.lang.Number memory;
            java.lang.Number memoryReservation;
            java.lang.String name;
            java.lang.Object resourceRequirements;

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getCommand}
             * @param command The command to send to the container that overrides the default command from the Docker image or the task definition.
             *                You must also specify a container name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getCpu}
             * @param cpu The number of `cpu` units reserved for the container, instead of the default value from the task definition.
             *            You must also specify a container name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.Number cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getEnvironment}
             * @param environment The environment variables to send to the container.
             *                    You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getEnvironment}
             * @param environment The environment variables to send to the container.
             *                    You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getEnvironmentFiles}
             * @param environmentFiles A list of files containing the environment variables to pass to a container, instead of the value from the container definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentFiles(software.amazon.awscdk.core.IResolvable environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getEnvironmentFiles}
             * @param environmentFiles A list of files containing the environment variables to pass to a container, instead of the value from the container definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentFiles(java.util.List<? extends java.lang.Object> environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getMemory}
             * @param memory The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition.
             *               If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.Number memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getMemoryReservation}
             * @param memoryReservation The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition.
             *                          You must also specify a container name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryReservation(java.lang.Number memoryReservation) {
                this.memoryReservation = memoryReservation;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getName}
             * @param name The name of the container that receives the override.
             *             This parameter is required if any override is specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition.
             *                             The only supported resource is a GPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(software.amazon.awscdk.core.IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link EcsContainerOverrideProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of a resource to assign to a container, instead of the default value from the task definition.
             *                             The only supported resource is a GPU.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(java.util.List<? extends java.lang.Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsContainerOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsContainerOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsContainerOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsContainerOverrideProperty {
            private final java.util.List<java.lang.String> command;
            private final java.lang.Number cpu;
            private final java.lang.Object environment;
            private final java.lang.Object environmentFiles;
            private final java.lang.Number memory;
            private final java.lang.Number memoryReservation;
            private final java.lang.String name;
            private final java.lang.Object resourceRequirements;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentFiles = software.amazon.jsii.Kernel.get(this, "environmentFiles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memoryReservation = software.amazon.jsii.Kernel.get(this, "memoryReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceRequirements = software.amazon.jsii.Kernel.get(this, "resourceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.command = builder.command;
                this.cpu = builder.cpu;
                this.environment = builder.environment;
                this.environmentFiles = builder.environmentFiles;
                this.memory = builder.memory;
                this.memoryReservation = builder.memoryReservation;
                this.name = builder.name;
                this.resourceRequirements = builder.resourceRequirements;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Number getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getEnvironmentFiles() {
                return this.environmentFiles;
            }

            @Override
            public final java.lang.Number getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.Number getMemoryReservation() {
                return this.memoryReservation;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getResourceRequirements() {
                return this.resourceRequirements;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getCpu() != null) {
                    data.set("cpu", om.valueToTree(this.getCpu()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getEnvironmentFiles() != null) {
                    data.set("environmentFiles", om.valueToTree(this.getEnvironmentFiles()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getMemoryReservation() != null) {
                    data.set("memoryReservation", om.valueToTree(this.getMemoryReservation()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getResourceRequirements() != null) {
                    data.set("resourceRequirements", om.valueToTree(this.getResourceRequirements()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.EcsContainerOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsContainerOverrideProperty.Jsii$Proxy that = (EcsContainerOverrideProperty.Jsii$Proxy) o;

                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.environmentFiles != null ? !this.environmentFiles.equals(that.environmentFiles) : that.environmentFiles != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                if (this.memoryReservation != null ? !this.memoryReservation.equals(that.memoryReservation) : that.memoryReservation != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.resourceRequirements != null ? this.resourceRequirements.equals(that.resourceRequirements) : that.resourceRequirements == null;
            }

            @Override
            public final int hashCode() {
                int result = this.command != null ? this.command.hashCode() : 0;
                result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.environmentFiles != null ? this.environmentFiles.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.memoryReservation != null ? this.memoryReservation.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.resourceRequirements != null ? this.resourceRequirements.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of files containing the environment variables to pass to a container.
     * <p>
     * You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated as comments and are ignored. For more information about the environment variable file syntax, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/compose/env-file/">Declare default environment variables in file</a> .
     * <p>
     * If there are environment variables specified using the <code>environment</code> parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying environment variables</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * This parameter is only supported for tasks hosted on Fargate using the following platform versions:
     * <p>
     * <ul>
     * <li>Linux platform version <code>1.4.0</code> or later.</li>
     * <li>Windows platform version <code>1.0.0</code> or later.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * EcsEnvironmentFileProperty ecsEnvironmentFileProperty = EcsEnvironmentFileProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.EcsEnvironmentFileProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsEnvironmentFileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsEnvironmentFileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file type to use.
         * <p>
         * The only supported value is <code>s3</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link EcsEnvironmentFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsEnvironmentFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsEnvironmentFileProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link EcsEnvironmentFileProperty#getType}
             * @param type The file type to use. This parameter is required.
             *             The only supported value is <code>s3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EcsEnvironmentFileProperty#getValue}
             * @param value The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsEnvironmentFileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsEnvironmentFileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsEnvironmentFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsEnvironmentFileProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.EcsEnvironmentFileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsEnvironmentFileProperty.Jsii$Proxy that = (EcsEnvironmentFileProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The environment variables to send to the container.
     * <p>
     * You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * EcsEnvironmentVariableProperty ecsEnvironmentVariableProperty = EcsEnvironmentVariableProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.EcsEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsEnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsEnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the key-value pair.
         * <p>
         * For environment variables, this is the name of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the key-value pair.
         * <p>
         * For environment variables, this is the value of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsEnvironmentVariableProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EcsEnvironmentVariableProperty#getName}
             * @param name The name of the key-value pair.
             *             For environment variables, this is the name of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EcsEnvironmentVariableProperty#getValue}
             * @param value The value of the key-value pair.
             *              For environment variables, this is the value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsEnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsEnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsEnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.EcsEnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsEnvironmentVariableProperty.Jsii$Proxy that = (EcsEnvironmentVariableProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The amount of ephemeral storage to allocate for the task.
     * <p>
     * This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task storage</a> in the <em>Amazon ECS User Guide for Fargate</em> .
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only supported for tasks hosted on Fargate using Linux platform version <code>1.4.0</code> or later. This parameter is not supported for Windows containers on Fargate .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * EcsEphemeralStorageProperty ecsEphemeralStorageProperty = EcsEphemeralStorageProperty.builder()
     *         .sizeInGiB(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.EcsEphemeralStorageProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsEphemeralStorageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsEphemeralStorageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total amount, in GiB, of ephemeral storage to set for the task.
         * <p>
         * The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSizeInGiB();

        /**
         * @return a {@link Builder} of {@link EcsEphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsEphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsEphemeralStorageProperty> {
            java.lang.Number sizeInGiB;

            /**
             * Sets the value of {@link EcsEphemeralStorageProperty#getSizeInGiB}
             * @param sizeInGiB The total amount, in GiB, of ephemeral storage to set for the task. This parameter is required.
             *                  The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGiB(java.lang.Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsEphemeralStorageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsEphemeralStorageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsEphemeralStorageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsEphemeralStorageProperty {
            private final java.lang.Number sizeInGiB;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeInGiB = software.amazon.jsii.Kernel.get(this, "sizeInGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeInGiB = java.util.Objects.requireNonNull(builder.sizeInGiB, "sizeInGiB is required");
            }

            @Override
            public final java.lang.Number getSizeInGiB() {
                return this.sizeInGiB;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sizeInGiB", om.valueToTree(this.getSizeInGiB()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.EcsEphemeralStorageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsEphemeralStorageProperty.Jsii$Proxy that = (EcsEphemeralStorageProperty.Jsii$Proxy) o;

                return this.sizeInGiB.equals(that.sizeInGiB);
            }

            @Override
            public final int hashCode() {
                int result = this.sizeInGiB.hashCode();
                return result;
            }
        }
    }
    /**
     * Details on an Elastic Inference accelerator task override.
     * <p>
     * This parameter is used to override the Elastic Inference accelerator specified in the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * EcsInferenceAcceleratorOverrideProperty ecsInferenceAcceleratorOverrideProperty = EcsInferenceAcceleratorOverrideProperty.builder()
     *         .deviceName("deviceName")
     *         .deviceType("deviceType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.EcsInferenceAcceleratorOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsInferenceAcceleratorOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsInferenceAcceleratorOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Elastic Inference accelerator device name to override for the task.
         * <p>
         * This parameter must match a <code>deviceName</code> specified in the task definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceName() {
            return null;
        }

        /**
         * The Elastic Inference accelerator type to use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsInferenceAcceleratorOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsInferenceAcceleratorOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsInferenceAcceleratorOverrideProperty> {
            java.lang.String deviceName;
            java.lang.String deviceType;

            /**
             * Sets the value of {@link EcsInferenceAcceleratorOverrideProperty#getDeviceName}
             * @param deviceName The Elastic Inference accelerator device name to override for the task.
             *                   This parameter must match a <code>deviceName</code> specified in the task definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link EcsInferenceAcceleratorOverrideProperty#getDeviceType}
             * @param deviceType The Elastic Inference accelerator type to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceType(java.lang.String deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsInferenceAcceleratorOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsInferenceAcceleratorOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsInferenceAcceleratorOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsInferenceAcceleratorOverrideProperty {
            private final java.lang.String deviceName;
            private final java.lang.String deviceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceType = software.amazon.jsii.Kernel.get(this, "deviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = builder.deviceName;
                this.deviceType = builder.deviceType;
            }

            @Override
            public final java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public final java.lang.String getDeviceType() {
                return this.deviceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeviceName() != null) {
                    data.set("deviceName", om.valueToTree(this.getDeviceName()));
                }
                if (this.getDeviceType() != null) {
                    data.set("deviceType", om.valueToTree(this.getDeviceType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.EcsInferenceAcceleratorOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsInferenceAcceleratorOverrideProperty.Jsii$Proxy that = (EcsInferenceAcceleratorOverrideProperty.Jsii$Proxy) o;

                if (this.deviceName != null ? !this.deviceName.equals(that.deviceName) : that.deviceName != null) return false;
                return this.deviceType != null ? this.deviceType.equals(that.deviceType) : that.deviceType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceName != null ? this.deviceName.hashCode() : 0;
                result = 31 * result + (this.deviceType != null ? this.deviceType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The type and amount of a resource to assign to a container.
     * <p>
     * The supported resource types are GPUs and Elastic Inference accelerators. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html">Working with GPUs on Amazon ECS</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * EcsResourceRequirementProperty ecsResourceRequirementProperty = EcsResourceRequirementProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.EcsResourceRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsResourceRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsResourceRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to assign to a container.
         * <p>
         * The supported values are <code>GPU</code> or <code>InferenceAccelerator</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The value for the specified resource type.
         * <p>
         * If the <code>GPU</code> type is used, the value is the number of physical <code>GPUs</code> the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
         * <p>
         * If the <code>InferenceAccelerator</code> type is used, the <code>value</code> matches the <code>deviceName</code> for an InferenceAccelerator specified in a task definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link EcsResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsResourceRequirementProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link EcsResourceRequirementProperty#getType}
             * @param type The type of resource to assign to a container. This parameter is required.
             *             The supported values are <code>GPU</code> or <code>InferenceAccelerator</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EcsResourceRequirementProperty#getValue}
             * @param value The value for the specified resource type. This parameter is required.
             *              If the <code>GPU</code> type is used, the value is the number of physical <code>GPUs</code> the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
             *              <p>
             *              If the <code>InferenceAccelerator</code> type is used, the <code>value</code> matches the <code>deviceName</code> for an InferenceAccelerator specified in a task definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsResourceRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsResourceRequirementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsResourceRequirementProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.EcsResourceRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsResourceRequirementProperty.Jsii$Proxy that = (EcsResourceRequirementProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The overrides that are associated with a task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * EcsTaskOverrideProperty ecsTaskOverrideProperty = EcsTaskOverrideProperty.builder()
     *         .containerOverrides(List.of(EcsContainerOverrideProperty.builder()
     *                 .command(List.of("command"))
     *                 .cpu(123)
     *                 .environment(List.of(EcsEnvironmentVariableProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .environmentFiles(List.of(EcsEnvironmentFileProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .memory(123)
     *                 .memoryReservation(123)
     *                 .name("name")
     *                 .resourceRequirements(List.of(EcsResourceRequirementProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .cpu("cpu")
     *         .ephemeralStorage(EcsEphemeralStorageProperty.builder()
     *                 .sizeInGiB(123)
     *                 .build())
     *         .executionRoleArn("executionRoleArn")
     *         .inferenceAcceleratorOverrides(List.of(EcsInferenceAcceleratorOverrideProperty.builder()
     *                 .deviceName("deviceName")
     *                 .deviceType("deviceType")
     *                 .build()))
     *         .memory("memory")
     *         .taskRoleArn("taskRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.EcsTaskOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsTaskOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsTaskOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more container overrides that are sent to a task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerOverrides() {
            return null;
        }

        /**
         * The cpu override for the task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
            return null;
        }

        /**
         * The ephemeral storage setting override for the task.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
         * <p>
         * <ul>
         * <li>Linux platform version <code>1.4.0</code> or later.</li>
         * <li>Windows platform version <code>1.0.0</code> or later.</li>
         * </ul>
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
            return null;
        }

        /**
         * The Elastic Inference accelerator override for the task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceAcceleratorOverrides() {
            return null;
        }

        /**
         * The memory override for the task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume.
         * <p>
         * All containers in this task are granted the permissions that are specified in this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsTaskOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsTaskOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsTaskOverrideProperty> {
            java.lang.Object containerOverrides;
            java.lang.String cpu;
            java.lang.Object ephemeralStorage;
            java.lang.String executionRoleArn;
            java.lang.Object inferenceAcceleratorOverrides;
            java.lang.String memory;
            java.lang.String taskRoleArn;

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getContainerOverrides}
             * @param containerOverrides One or more container overrides that are sent to a task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerOverrides(software.amazon.awscdk.core.IResolvable containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getContainerOverrides}
             * @param containerOverrides One or more container overrides that are sent to a task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerOverrides(java.util.List<? extends java.lang.Object> containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getCpu}
             * @param cpu The cpu override for the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getEphemeralStorage}
             * @param ephemeralStorage The ephemeral storage setting override for the task.
             *                         <blockquote>
             *                         <p>
             *                         This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
             *                         <p>
             *                         <ul>
             *                         <li>Linux platform version <code>1.4.0</code> or later.</li>
             *                         <li>Windows platform version <code>1.0.0</code> or later.</li>
             *                         </ul>
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ephemeralStorage(software.amazon.awscdk.services.pipes.CfnPipe.EcsEphemeralStorageProperty ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getEphemeralStorage}
             * @param ephemeralStorage The ephemeral storage setting override for the task.
             *                         <blockquote>
             *                         <p>
             *                         This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
             *                         <p>
             *                         <ul>
             *                         <li>Linux platform version <code>1.4.0</code> or later.</li>
             *                         <li>Windows platform version <code>1.0.0</code> or later.</li>
             *                         </ul>
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ephemeralStorage(software.amazon.awscdk.core.IResolvable ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getExecutionRoleArn}
             * @param executionRoleArn The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
             *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getInferenceAcceleratorOverrides}
             * @param inferenceAcceleratorOverrides The Elastic Inference accelerator override for the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceAcceleratorOverrides(software.amazon.awscdk.core.IResolvable inferenceAcceleratorOverrides) {
                this.inferenceAcceleratorOverrides = inferenceAcceleratorOverrides;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getInferenceAcceleratorOverrides}
             * @param inferenceAcceleratorOverrides The Elastic Inference accelerator override for the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceAcceleratorOverrides(java.util.List<? extends java.lang.Object> inferenceAcceleratorOverrides) {
                this.inferenceAcceleratorOverrides = inferenceAcceleratorOverrides;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getMemory}
             * @param memory The memory override for the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link EcsTaskOverrideProperty#getTaskRoleArn}
             * @param taskRoleArn The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume.
             *                    All containers in this task are granted the permissions that are specified in this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskRoleArn(java.lang.String taskRoleArn) {
                this.taskRoleArn = taskRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsTaskOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsTaskOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsTaskOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsTaskOverrideProperty {
            private final java.lang.Object containerOverrides;
            private final java.lang.String cpu;
            private final java.lang.Object ephemeralStorage;
            private final java.lang.String executionRoleArn;
            private final java.lang.Object inferenceAcceleratorOverrides;
            private final java.lang.String memory;
            private final java.lang.String taskRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerOverrides = software.amazon.jsii.Kernel.get(this, "containerOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceAcceleratorOverrides = software.amazon.jsii.Kernel.get(this, "inferenceAcceleratorOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskRoleArn = software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerOverrides = builder.containerOverrides;
                this.cpu = builder.cpu;
                this.ephemeralStorage = builder.ephemeralStorage;
                this.executionRoleArn = builder.executionRoleArn;
                this.inferenceAcceleratorOverrides = builder.inferenceAcceleratorOverrides;
                this.memory = builder.memory;
                this.taskRoleArn = builder.taskRoleArn;
            }

            @Override
            public final java.lang.Object getContainerOverrides() {
                return this.containerOverrides;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.Object getEphemeralStorage() {
                return this.ephemeralStorage;
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.Object getInferenceAcceleratorOverrides() {
                return this.inferenceAcceleratorOverrides;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.String getTaskRoleArn() {
                return this.taskRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerOverrides() != null) {
                    data.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
                }
                if (this.getCpu() != null) {
                    data.set("cpu", om.valueToTree(this.getCpu()));
                }
                if (this.getEphemeralStorage() != null) {
                    data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
                }
                if (this.getExecutionRoleArn() != null) {
                    data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                }
                if (this.getInferenceAcceleratorOverrides() != null) {
                    data.set("inferenceAcceleratorOverrides", om.valueToTree(this.getInferenceAcceleratorOverrides()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getTaskRoleArn() != null) {
                    data.set("taskRoleArn", om.valueToTree(this.getTaskRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.EcsTaskOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsTaskOverrideProperty.Jsii$Proxy that = (EcsTaskOverrideProperty.Jsii$Proxy) o;

                if (this.containerOverrides != null ? !this.containerOverrides.equals(that.containerOverrides) : that.containerOverrides != null) return false;
                if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
                if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
                if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
                if (this.inferenceAcceleratorOverrides != null ? !this.inferenceAcceleratorOverrides.equals(that.inferenceAcceleratorOverrides) : that.inferenceAcceleratorOverrides != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                return this.taskRoleArn != null ? this.taskRoleArn.equals(that.taskRoleArn) : that.taskRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerOverrides != null ? this.containerOverrides.hashCode() : 0;
                result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
                result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
                result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
                result = 31 * result + (this.inferenceAcceleratorOverrides != null ? this.inferenceAcceleratorOverrides.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.taskRoleArn != null ? this.taskRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The collection of event patterns used to filter events.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * FilterCriteriaProperty filterCriteriaProperty = FilterCriteriaProperty.builder()
     *         .filters(List.of(FilterProperty.builder()
     *                 .pattern("pattern")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.FilterCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The event patterns.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterCriteriaProperty> {
            java.lang.Object filters;

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFilters}
             * @param filters The event patterns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.core.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link FilterCriteriaProperty#getFilters}
             * @param filters The event patterns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(java.util.List<? extends java.lang.Object> filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterCriteriaProperty {
            private final java.lang.Object filters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filters = builder.filters;
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilters() != null) {
                    data.set("filters", om.valueToTree(this.getFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.FilterCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterCriteriaProperty.Jsii$Proxy that = (FilterCriteriaProperty.Jsii$Proxy) o;

                return this.filters != null ? this.filters.equals(that.filters) : that.filters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filters != null ? this.filters.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Filter events using an event pattern.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * FilterProperty filterProperty = FilterProperty.builder()
     *         .pattern("pattern")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.FilterProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The event pattern.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPattern() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterProperty> {
            java.lang.String pattern;

            /**
             * Sets the value of {@link FilterProperty#getPattern}
             * @param pattern The event pattern.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterProperty {
            private final java.lang.String pattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = builder.pattern;
            }

            @Override
            public final java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPattern() != null) {
                    data.set("pattern", om.valueToTree(this.getPattern()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.FilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterProperty.Jsii$Proxy that = (FilterProperty.Jsii$Proxy) o;

                return this.pattern != null ? this.pattern.equals(that.pattern) : that.pattern == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pattern != null ? this.pattern.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The AWS Secrets Manager secret that stores your broker credentials.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * MQBrokerAccessCredentialsProperty mQBrokerAccessCredentialsProperty = MQBrokerAccessCredentialsProperty.builder()
     *         .basicAuth("basicAuth")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.MQBrokerAccessCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(MQBrokerAccessCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MQBrokerAccessCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Secrets Manager secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBasicAuth();

        /**
         * @return a {@link Builder} of {@link MQBrokerAccessCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MQBrokerAccessCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MQBrokerAccessCredentialsProperty> {
            java.lang.String basicAuth;

            /**
             * Sets the value of {@link MQBrokerAccessCredentialsProperty#getBasicAuth}
             * @param basicAuth The ARN of the Secrets Manager secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuth(java.lang.String basicAuth) {
                this.basicAuth = basicAuth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MQBrokerAccessCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MQBrokerAccessCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MQBrokerAccessCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MQBrokerAccessCredentialsProperty {
            private final java.lang.String basicAuth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basicAuth = software.amazon.jsii.Kernel.get(this, "basicAuth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basicAuth = java.util.Objects.requireNonNull(builder.basicAuth, "basicAuth is required");
            }

            @Override
            public final java.lang.String getBasicAuth() {
                return this.basicAuth;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("basicAuth", om.valueToTree(this.getBasicAuth()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.MQBrokerAccessCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MQBrokerAccessCredentialsProperty.Jsii$Proxy that = (MQBrokerAccessCredentialsProperty.Jsii$Proxy) o;

                return this.basicAuth.equals(that.basicAuth);
            }

            @Override
            public final int hashCode() {
                int result = this.basicAuth.hashCode();
                return result;
            }
        }
    }
    /**
     * The AWS Secrets Manager secret that stores your stream credentials.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * MSKAccessCredentialsProperty mSKAccessCredentialsProperty = MSKAccessCredentialsProperty.builder()
     *         .clientCertificateTlsAuth("clientCertificateTlsAuth")
     *         .saslScram512Auth("saslScram512Auth")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.MSKAccessCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(MSKAccessCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MSKAccessCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Secrets Manager secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateTlsAuth() {
            return null;
        }

        /**
         * The ARN of the Secrets Manager secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslScram512Auth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MSKAccessCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MSKAccessCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MSKAccessCredentialsProperty> {
            java.lang.String clientCertificateTlsAuth;
            java.lang.String saslScram512Auth;

            /**
             * Sets the value of {@link MSKAccessCredentialsProperty#getClientCertificateTlsAuth}
             * @param clientCertificateTlsAuth The ARN of the Secrets Manager secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCertificateTlsAuth(java.lang.String clientCertificateTlsAuth) {
                this.clientCertificateTlsAuth = clientCertificateTlsAuth;
                return this;
            }

            /**
             * Sets the value of {@link MSKAccessCredentialsProperty#getSaslScram512Auth}
             * @param saslScram512Auth The ARN of the Secrets Manager secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslScram512Auth(java.lang.String saslScram512Auth) {
                this.saslScram512Auth = saslScram512Auth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MSKAccessCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MSKAccessCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MSKAccessCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MSKAccessCredentialsProperty {
            private final java.lang.String clientCertificateTlsAuth;
            private final java.lang.String saslScram512Auth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientCertificateTlsAuth = software.amazon.jsii.Kernel.get(this, "clientCertificateTlsAuth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.saslScram512Auth = software.amazon.jsii.Kernel.get(this, "saslScram512Auth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientCertificateTlsAuth = builder.clientCertificateTlsAuth;
                this.saslScram512Auth = builder.saslScram512Auth;
            }

            @Override
            public final java.lang.String getClientCertificateTlsAuth() {
                return this.clientCertificateTlsAuth;
            }

            @Override
            public final java.lang.String getSaslScram512Auth() {
                return this.saslScram512Auth;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientCertificateTlsAuth() != null) {
                    data.set("clientCertificateTlsAuth", om.valueToTree(this.getClientCertificateTlsAuth()));
                }
                if (this.getSaslScram512Auth() != null) {
                    data.set("saslScram512Auth", om.valueToTree(this.getSaslScram512Auth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.MSKAccessCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MSKAccessCredentialsProperty.Jsii$Proxy that = (MSKAccessCredentialsProperty.Jsii$Proxy) o;

                if (this.clientCertificateTlsAuth != null ? !this.clientCertificateTlsAuth.equals(that.clientCertificateTlsAuth) : that.clientCertificateTlsAuth != null) return false;
                return this.saslScram512Auth != null ? this.saslScram512Auth.equals(that.saslScram512Auth) : that.saslScram512Auth == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientCertificateTlsAuth != null ? this.clientCertificateTlsAuth.hashCode() : 0;
                result = 31 * result + (this.saslScram512Auth != null ? this.saslScram512Auth.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure specifies the network configuration for an Amazon ECS task.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                 .subnets(List.of("subnets"))
     *                 // the properties below are optional
     *                 .assignPublicIp("assignPublicIp")
     *                 .securityGroups(List.of("securityGroups"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used.
         * <p>
         * This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsvpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.Object awsvpcConfiguration;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used.
             *                            This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.services.pipes.CfnPipe.AwsVpcConfigurationProperty awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used.
             *                            This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.core.IResolvable awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.Object awsvpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsvpcConfiguration = software.amazon.jsii.Kernel.get(this, "awsvpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsvpcConfiguration = builder.awsvpcConfiguration;
            }

            @Override
            public final java.lang.Object getAwsvpcConfiguration() {
                return this.awsvpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsvpcConfiguration() != null) {
                    data.set("awsvpcConfiguration", om.valueToTree(this.getAwsvpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.awsvpcConfiguration != null ? this.awsvpcConfiguration.equals(that.awsvpcConfiguration) : that.awsvpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsvpcConfiguration != null ? this.awsvpcConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
     * <p>
     * In the latter case, these are merged with any InvocationParameters specified on the Connection, with any values from the Connection taking precedence.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeEnrichmentHttpParametersProperty pipeEnrichmentHttpParametersProperty = PipeEnrichmentHttpParametersProperty.builder()
     *         .headerParameters(Map.of(
     *                 "headerParametersKey", "headerParameters"))
     *         .pathParameterValues(List.of("pathParameterValues"))
     *         .queryStringParameters(Map.of(
     *                 "queryStringParametersKey", "queryStringParameters"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeEnrichmentHttpParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeEnrichmentHttpParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeEnrichmentHttpParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderParameters() {
            return null;
        }

        /**
         * The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathParameterValues() {
            return null;
        }

        /**
         * The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryStringParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeEnrichmentHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeEnrichmentHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeEnrichmentHttpParametersProperty> {
            java.lang.Object headerParameters;
            java.util.List<java.lang.String> pathParameterValues;
            java.lang.Object queryStringParameters;

            /**
             * Sets the value of {@link PipeEnrichmentHttpParametersProperty#getHeaderParameters}
             * @param headerParameters The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(software.amazon.awscdk.core.IResolvable headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeEnrichmentHttpParametersProperty#getHeaderParameters}
             * @param headerParameters The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(java.util.Map<java.lang.String, java.lang.String> headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeEnrichmentHttpParametersProperty#getPathParameterValues}
             * @param pathParameterValues The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathParameterValues(java.util.List<java.lang.String> pathParameterValues) {
                this.pathParameterValues = pathParameterValues;
                return this;
            }

            /**
             * Sets the value of {@link PipeEnrichmentHttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(software.amazon.awscdk.core.IResolvable queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeEnrichmentHttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeEnrichmentHttpParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeEnrichmentHttpParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeEnrichmentHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeEnrichmentHttpParametersProperty {
            private final java.lang.Object headerParameters;
            private final java.util.List<java.lang.String> pathParameterValues;
            private final java.lang.Object queryStringParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pathParameterValues = software.amazon.jsii.Kernel.get(this, "pathParameterValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerParameters = builder.headerParameters;
                this.pathParameterValues = builder.pathParameterValues;
                this.queryStringParameters = builder.queryStringParameters;
            }

            @Override
            public final java.lang.Object getHeaderParameters() {
                return this.headerParameters;
            }

            @Override
            public final java.util.List<java.lang.String> getPathParameterValues() {
                return this.pathParameterValues;
            }

            @Override
            public final java.lang.Object getQueryStringParameters() {
                return this.queryStringParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeaderParameters() != null) {
                    data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
                }
                if (this.getPathParameterValues() != null) {
                    data.set("pathParameterValues", om.valueToTree(this.getPathParameterValues()));
                }
                if (this.getQueryStringParameters() != null) {
                    data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeEnrichmentHttpParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeEnrichmentHttpParametersProperty.Jsii$Proxy that = (PipeEnrichmentHttpParametersProperty.Jsii$Proxy) o;

                if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
                if (this.pathParameterValues != null ? !this.pathParameterValues.equals(that.pathParameterValues) : that.pathParameterValues != null) return false;
                return this.queryStringParameters != null ? this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headerParameters != null ? this.headerParameters.hashCode() : 0;
                result = 31 * result + (this.pathParameterValues != null ? this.pathParameterValues.hashCode() : 0);
                result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters required to set up enrichment on your pipe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeEnrichmentParametersProperty pipeEnrichmentParametersProperty = PipeEnrichmentParametersProperty.builder()
     *         .httpParameters(PipeEnrichmentHttpParametersProperty.builder()
     *                 .headerParameters(Map.of(
     *                         "headerParametersKey", "headerParameters"))
     *                 .pathParameterValues(List.of("pathParameterValues"))
     *                 .queryStringParameters(Map.of(
     *                         "queryStringParametersKey", "queryStringParameters"))
     *                 .build())
     *         .inputTemplate("inputTemplate")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeEnrichmentParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeEnrichmentParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeEnrichmentParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.
         * <p>
         * If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpParameters() {
            return null;
        }

        /**
         * Valid JSON text passed to the enrichment.
         * <p>
         * In this case, nothing from the event itself is passed to the enrichment. For more information, see <a href="https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeEnrichmentParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeEnrichmentParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeEnrichmentParametersProperty> {
            java.lang.Object httpParameters;
            java.lang.String inputTemplate;

            /**
             * Sets the value of {@link PipeEnrichmentParametersProperty#getHttpParameters}
             * @param httpParameters Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.
             *                       If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeEnrichmentHttpParametersProperty httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeEnrichmentParametersProperty#getHttpParameters}
             * @param httpParameters Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.
             *                       If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpParameters(software.amazon.awscdk.core.IResolvable httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeEnrichmentParametersProperty#getInputTemplate}
             * @param inputTemplate Valid JSON text passed to the enrichment.
             *                      In this case, nothing from the event itself is passed to the enrichment. For more information, see <a href="https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputTemplate(java.lang.String inputTemplate) {
                this.inputTemplate = inputTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeEnrichmentParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeEnrichmentParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeEnrichmentParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeEnrichmentParametersProperty {
            private final java.lang.Object httpParameters;
            private final java.lang.String inputTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpParameters = software.amazon.jsii.Kernel.get(this, "httpParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputTemplate = software.amazon.jsii.Kernel.get(this, "inputTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpParameters = builder.httpParameters;
                this.inputTemplate = builder.inputTemplate;
            }

            @Override
            public final java.lang.Object getHttpParameters() {
                return this.httpParameters;
            }

            @Override
            public final java.lang.String getInputTemplate() {
                return this.inputTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpParameters() != null) {
                    data.set("httpParameters", om.valueToTree(this.getHttpParameters()));
                }
                if (this.getInputTemplate() != null) {
                    data.set("inputTemplate", om.valueToTree(this.getInputTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeEnrichmentParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeEnrichmentParametersProperty.Jsii$Proxy that = (PipeEnrichmentParametersProperty.Jsii$Proxy) o;

                if (this.httpParameters != null ? !this.httpParameters.equals(that.httpParameters) : that.httpParameters != null) return false;
                return this.inputTemplate != null ? this.inputTemplate.equals(that.inputTemplate) : that.inputTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.httpParameters != null ? this.httpParameters.hashCode() : 0;
                result = 31 * result + (this.inputTemplate != null ? this.inputTemplate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using an Active MQ broker as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceActiveMQBrokerParametersProperty pipeSourceActiveMQBrokerParametersProperty = PipeSourceActiveMQBrokerParametersProperty.builder()
     *         .credentials(MQBrokerAccessCredentialsProperty.builder()
     *                 .basicAuth("basicAuth")
     *                 .build())
     *         .queueName("queueName")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .maximumBatchingWindowInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceActiveMQBrokerParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceActiveMQBrokerParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceActiveMQBrokerParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credentials needed to access the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCredentials();

        /**
         * The name of the destination queue to consume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueName();

        /**
         * The maximum number of records to include in each batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * The maximum length of a time to wait for events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceActiveMQBrokerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceActiveMQBrokerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceActiveMQBrokerParametersProperty> {
            java.lang.Object credentials;
            java.lang.String queueName;
            java.lang.Number batchSize;
            java.lang.Number maximumBatchingWindowInSeconds;

            /**
             * Sets the value of {@link PipeSourceActiveMQBrokerParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.services.pipes.CfnPipe.MQBrokerAccessCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceActiveMQBrokerParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.core.IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceActiveMQBrokerParametersProperty#getQueueName}
             * @param queueName The name of the destination queue to consume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueName(java.lang.String queueName) {
                this.queueName = queueName;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceActiveMQBrokerParametersProperty#getBatchSize}
             * @param batchSize The maximum number of records to include in each batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceActiveMQBrokerParametersProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds The maximum length of a time to wait for events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceActiveMQBrokerParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceActiveMQBrokerParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceActiveMQBrokerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceActiveMQBrokerParametersProperty {
            private final java.lang.Object credentials;
            private final java.lang.String queueName;
            private final java.lang.Number batchSize;
            private final java.lang.Number maximumBatchingWindowInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queueName = software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentials = java.util.Objects.requireNonNull(builder.credentials, "credentials is required");
                this.queueName = java.util.Objects.requireNonNull(builder.queueName, "queueName is required");
                this.batchSize = builder.batchSize;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.Object getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.String getQueueName() {
                return this.queueName;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentials", om.valueToTree(this.getCredentials()));
                data.set("queueName", om.valueToTree(this.getQueueName()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceActiveMQBrokerParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceActiveMQBrokerParametersProperty.Jsii$Proxy that = (PipeSourceActiveMQBrokerParametersProperty.Jsii$Proxy) o;

                if (!credentials.equals(that.credentials)) return false;
                if (!queueName.equals(that.queueName)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.credentials.hashCode();
                result = 31 * result + (this.queueName.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a DynamoDB stream as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceDynamoDBStreamParametersProperty pipeSourceDynamoDBStreamParametersProperty = PipeSourceDynamoDBStreamParametersProperty.builder()
     *         .startingPosition("startingPosition")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .deadLetterConfig(DeadLetterConfigProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .maximumBatchingWindowInSeconds(123)
     *         .maximumRecordAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .onPartialBatchItemFailure("onPartialBatchItemFailure")
     *         .parallelizationFactor(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceDynamoDBStreamParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceDynamoDBStreamParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceDynamoDBStreamParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (Streams only) The position in a stream from which to start reading.
         * <p>
         * <em>Valid values</em> : <code>TRIM_HORIZON | LATEST</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartingPosition();

        /**
         * The maximum number of records to include in each batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * Define the target queue to send dead-letter queue events to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeadLetterConfig() {
            return null;
        }

        /**
         * The maximum length of a time to wait for events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * (Streams only) Discard records older than the specified age.
         * <p>
         * The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        /**
         * (Streams only) Discard records after the specified number of retries.
         * <p>
         * The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * (Streams only) Define how to handle item process failures.
         * <p>
         * <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnPartialBatchItemFailure() {
            return null;
        }

        /**
         * (Streams only) The number of batches to process concurrently from each shard.
         * <p>
         * The default value is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceDynamoDBStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceDynamoDBStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceDynamoDBStreamParametersProperty> {
            java.lang.String startingPosition;
            java.lang.Number batchSize;
            java.lang.Object deadLetterConfig;
            java.lang.Number maximumBatchingWindowInSeconds;
            java.lang.Number maximumRecordAgeInSeconds;
            java.lang.Number maximumRetryAttempts;
            java.lang.String onPartialBatchItemFailure;
            java.lang.Number parallelizationFactor;

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getStartingPosition}
             * @param startingPosition (Streams only) The position in a stream from which to start reading. This parameter is required.
             *                         <em>Valid values</em> : <code>TRIM_HORIZON | LATEST</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getBatchSize}
             * @param batchSize The maximum number of records to include in each batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getDeadLetterConfig}
             * @param deadLetterConfig Define the target queue to send dead-letter queue events to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.services.pipes.CfnPipe.DeadLetterConfigProperty deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getDeadLetterConfig}
             * @param deadLetterConfig Define the target queue to send dead-letter queue events to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.core.IResolvable deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds The maximum length of a time to wait for events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getMaximumRecordAgeInSeconds}
             * @param maximumRecordAgeInSeconds (Streams only) Discard records older than the specified age.
             *                                  The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRecordAgeInSeconds(java.lang.Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts (Streams only) Discard records after the specified number of retries.
             *                             The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getOnPartialBatchItemFailure}
             * @param onPartialBatchItemFailure (Streams only) Define how to handle item process failures.
             *                                  <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPartialBatchItemFailure(java.lang.String onPartialBatchItemFailure) {
                this.onPartialBatchItemFailure = onPartialBatchItemFailure;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceDynamoDBStreamParametersProperty#getParallelizationFactor}
             * @param parallelizationFactor (Streams only) The number of batches to process concurrently from each shard.
             *                              The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceDynamoDBStreamParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceDynamoDBStreamParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceDynamoDBStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceDynamoDBStreamParametersProperty {
            private final java.lang.String startingPosition;
            private final java.lang.Number batchSize;
            private final java.lang.Object deadLetterConfig;
            private final java.lang.Number maximumBatchingWindowInSeconds;
            private final java.lang.Number maximumRecordAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;
            private final java.lang.String onPartialBatchItemFailure;
            private final java.lang.Number parallelizationFactor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.deadLetterConfig = software.amazon.jsii.Kernel.get(this, "deadLetterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRecordAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumRecordAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.onPartialBatchItemFailure = software.amazon.jsii.Kernel.get(this, "onPartialBatchItemFailure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
                this.batchSize = builder.batchSize;
                this.deadLetterConfig = builder.deadLetterConfig;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
                this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
                this.onPartialBatchItemFailure = builder.onPartialBatchItemFailure;
                this.parallelizationFactor = builder.parallelizationFactor;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getDeadLetterConfig() {
                return this.deadLetterConfig;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRecordAgeInSeconds() {
                return this.maximumRecordAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            public final java.lang.String getOnPartialBatchItemFailure() {
                return this.onPartialBatchItemFailure;
            }

            @Override
            public final java.lang.Number getParallelizationFactor() {
                return this.parallelizationFactor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getDeadLetterConfig() != null) {
                    data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }
                if (this.getMaximumRecordAgeInSeconds() != null) {
                    data.set("maximumRecordAgeInSeconds", om.valueToTree(this.getMaximumRecordAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }
                if (this.getOnPartialBatchItemFailure() != null) {
                    data.set("onPartialBatchItemFailure", om.valueToTree(this.getOnPartialBatchItemFailure()));
                }
                if (this.getParallelizationFactor() != null) {
                    data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceDynamoDBStreamParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceDynamoDBStreamParametersProperty.Jsii$Proxy that = (PipeSourceDynamoDBStreamParametersProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
                if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
                if (this.maximumRecordAgeInSeconds != null ? !this.maximumRecordAgeInSeconds.equals(that.maximumRecordAgeInSeconds) : that.maximumRecordAgeInSeconds != null) return false;
                if (this.maximumRetryAttempts != null ? !this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts != null) return false;
                if (this.onPartialBatchItemFailure != null ? !this.onPartialBatchItemFailure.equals(that.onPartialBatchItemFailure) : that.onPartialBatchItemFailure != null) return false;
                return this.parallelizationFactor != null ? this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRecordAgeInSeconds != null ? this.maximumRecordAgeInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                result = 31 * result + (this.onPartialBatchItemFailure != null ? this.onPartialBatchItemFailure.hashCode() : 0);
                result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a Kinesis stream as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceKinesisStreamParametersProperty pipeSourceKinesisStreamParametersProperty = PipeSourceKinesisStreamParametersProperty.builder()
     *         .startingPosition("startingPosition")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .deadLetterConfig(DeadLetterConfigProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .maximumBatchingWindowInSeconds(123)
     *         .maximumRecordAgeInSeconds(123)
     *         .maximumRetryAttempts(123)
     *         .onPartialBatchItemFailure("onPartialBatchItemFailure")
     *         .parallelizationFactor(123)
     *         .startingPositionTimestamp("startingPositionTimestamp")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceKinesisStreamParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceKinesisStreamParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceKinesisStreamParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * (Streams only) The position in a stream from which to start reading.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartingPosition();

        /**
         * The maximum number of records to include in each batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * Define the target queue to send dead-letter queue events to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeadLetterConfig() {
            return null;
        }

        /**
         * The maximum length of a time to wait for events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * (Streams only) Discard records older than the specified age.
         * <p>
         * The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        /**
         * (Streams only) Discard records after the specified number of retries.
         * <p>
         * The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
            return null;
        }

        /**
         * (Streams only) Define how to handle item process failures.
         * <p>
         * <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnPartialBatchItemFailure() {
            return null;
        }

        /**
         * (Streams only) The number of batches to process concurrently from each shard.
         * <p>
         * The default value is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
            return null;
        }

        /**
         * With `StartingPosition` set to `AT_TIMESTAMP` , the time from which to start reading, in Unix time seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartingPositionTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceKinesisStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceKinesisStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceKinesisStreamParametersProperty> {
            java.lang.String startingPosition;
            java.lang.Number batchSize;
            java.lang.Object deadLetterConfig;
            java.lang.Number maximumBatchingWindowInSeconds;
            java.lang.Number maximumRecordAgeInSeconds;
            java.lang.Number maximumRetryAttempts;
            java.lang.String onPartialBatchItemFailure;
            java.lang.Number parallelizationFactor;
            java.lang.String startingPositionTimestamp;

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getStartingPosition}
             * @param startingPosition (Streams only) The position in a stream from which to start reading. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getBatchSize}
             * @param batchSize The maximum number of records to include in each batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getDeadLetterConfig}
             * @param deadLetterConfig Define the target queue to send dead-letter queue events to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.services.pipes.CfnPipe.DeadLetterConfigProperty deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getDeadLetterConfig}
             * @param deadLetterConfig Define the target queue to send dead-letter queue events to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deadLetterConfig(software.amazon.awscdk.core.IResolvable deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds The maximum length of a time to wait for events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getMaximumRecordAgeInSeconds}
             * @param maximumRecordAgeInSeconds (Streams only) Discard records older than the specified age.
             *                                  The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRecordAgeInSeconds(java.lang.Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getMaximumRetryAttempts}
             * @param maximumRetryAttempts (Streams only) Discard records after the specified number of retries.
             *                             The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getOnPartialBatchItemFailure}
             * @param onPartialBatchItemFailure (Streams only) Define how to handle item process failures.
             *                                  <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onPartialBatchItemFailure(java.lang.String onPartialBatchItemFailure) {
                this.onPartialBatchItemFailure = onPartialBatchItemFailure;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getParallelizationFactor}
             * @param parallelizationFactor (Streams only) The number of batches to process concurrently from each shard.
             *                              The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceKinesisStreamParametersProperty#getStartingPositionTimestamp}
             * @param startingPositionTimestamp With `StartingPosition` set to `AT_TIMESTAMP` , the time from which to start reading, in Unix time seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPositionTimestamp(java.lang.String startingPositionTimestamp) {
                this.startingPositionTimestamp = startingPositionTimestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceKinesisStreamParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceKinesisStreamParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceKinesisStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceKinesisStreamParametersProperty {
            private final java.lang.String startingPosition;
            private final java.lang.Number batchSize;
            private final java.lang.Object deadLetterConfig;
            private final java.lang.Number maximumBatchingWindowInSeconds;
            private final java.lang.Number maximumRecordAgeInSeconds;
            private final java.lang.Number maximumRetryAttempts;
            private final java.lang.String onPartialBatchItemFailure;
            private final java.lang.Number parallelizationFactor;
            private final java.lang.String startingPositionTimestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.deadLetterConfig = software.amazon.jsii.Kernel.get(this, "deadLetterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRecordAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumRecordAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.onPartialBatchItemFailure = software.amazon.jsii.Kernel.get(this, "onPartialBatchItemFailure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startingPositionTimestamp = software.amazon.jsii.Kernel.get(this, "startingPositionTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
                this.batchSize = builder.batchSize;
                this.deadLetterConfig = builder.deadLetterConfig;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
                this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
                this.maximumRetryAttempts = builder.maximumRetryAttempts;
                this.onPartialBatchItemFailure = builder.onPartialBatchItemFailure;
                this.parallelizationFactor = builder.parallelizationFactor;
                this.startingPositionTimestamp = builder.startingPositionTimestamp;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Object getDeadLetterConfig() {
                return this.deadLetterConfig;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRecordAgeInSeconds() {
                return this.maximumRecordAgeInSeconds;
            }

            @Override
            public final java.lang.Number getMaximumRetryAttempts() {
                return this.maximumRetryAttempts;
            }

            @Override
            public final java.lang.String getOnPartialBatchItemFailure() {
                return this.onPartialBatchItemFailure;
            }

            @Override
            public final java.lang.Number getParallelizationFactor() {
                return this.parallelizationFactor;
            }

            @Override
            public final java.lang.String getStartingPositionTimestamp() {
                return this.startingPositionTimestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getDeadLetterConfig() != null) {
                    data.set("deadLetterConfig", om.valueToTree(this.getDeadLetterConfig()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }
                if (this.getMaximumRecordAgeInSeconds() != null) {
                    data.set("maximumRecordAgeInSeconds", om.valueToTree(this.getMaximumRecordAgeInSeconds()));
                }
                if (this.getMaximumRetryAttempts() != null) {
                    data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
                }
                if (this.getOnPartialBatchItemFailure() != null) {
                    data.set("onPartialBatchItemFailure", om.valueToTree(this.getOnPartialBatchItemFailure()));
                }
                if (this.getParallelizationFactor() != null) {
                    data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
                }
                if (this.getStartingPositionTimestamp() != null) {
                    data.set("startingPositionTimestamp", om.valueToTree(this.getStartingPositionTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceKinesisStreamParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceKinesisStreamParametersProperty.Jsii$Proxy that = (PipeSourceKinesisStreamParametersProperty.Jsii$Proxy) o;

                if (!startingPosition.equals(that.startingPosition)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.deadLetterConfig != null ? !this.deadLetterConfig.equals(that.deadLetterConfig) : that.deadLetterConfig != null) return false;
                if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
                if (this.maximumRecordAgeInSeconds != null ? !this.maximumRecordAgeInSeconds.equals(that.maximumRecordAgeInSeconds) : that.maximumRecordAgeInSeconds != null) return false;
                if (this.maximumRetryAttempts != null ? !this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts != null) return false;
                if (this.onPartialBatchItemFailure != null ? !this.onPartialBatchItemFailure.equals(that.onPartialBatchItemFailure) : that.onPartialBatchItemFailure != null) return false;
                if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
                return this.startingPositionTimestamp != null ? this.startingPositionTimestamp.equals(that.startingPositionTimestamp) : that.startingPositionTimestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.startingPosition.hashCode();
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.deadLetterConfig != null ? this.deadLetterConfig.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRecordAgeInSeconds != null ? this.maximumRecordAgeInSeconds.hashCode() : 0);
                result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
                result = 31 * result + (this.onPartialBatchItemFailure != null ? this.onPartialBatchItemFailure.hashCode() : 0);
                result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
                result = 31 * result + (this.startingPositionTimestamp != null ? this.startingPositionTimestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using an MSK stream as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceManagedStreamingKafkaParametersProperty pipeSourceManagedStreamingKafkaParametersProperty = PipeSourceManagedStreamingKafkaParametersProperty.builder()
     *         .topicName("topicName")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .consumerGroupId("consumerGroupId")
     *         .credentials(MSKAccessCredentialsProperty.builder()
     *                 .clientCertificateTlsAuth("clientCertificateTlsAuth")
     *                 .saslScram512Auth("saslScram512Auth")
     *                 .build())
     *         .maximumBatchingWindowInSeconds(123)
     *         .startingPosition("startingPosition")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceManagedStreamingKafkaParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceManagedStreamingKafkaParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceManagedStreamingKafkaParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the topic that the pipe will read from.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicName();

        /**
         * The maximum number of records to include in each batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * The name of the destination queue to consume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConsumerGroupId() {
            return null;
        }

        /**
         * The credentials needed to access the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCredentials() {
            return null;
        }

        /**
         * The maximum length of a time to wait for events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * (Streams only) The position in a stream from which to start reading.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartingPosition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceManagedStreamingKafkaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceManagedStreamingKafkaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceManagedStreamingKafkaParametersProperty> {
            java.lang.String topicName;
            java.lang.Number batchSize;
            java.lang.String consumerGroupId;
            java.lang.Object credentials;
            java.lang.Number maximumBatchingWindowInSeconds;
            java.lang.String startingPosition;

            /**
             * Sets the value of {@link PipeSourceManagedStreamingKafkaParametersProperty#getTopicName}
             * @param topicName The name of the topic that the pipe will read from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicName(java.lang.String topicName) {
                this.topicName = topicName;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceManagedStreamingKafkaParametersProperty#getBatchSize}
             * @param batchSize The maximum number of records to include in each batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceManagedStreamingKafkaParametersProperty#getConsumerGroupId}
             * @param consumerGroupId The name of the destination queue to consume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumerGroupId(java.lang.String consumerGroupId) {
                this.consumerGroupId = consumerGroupId;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceManagedStreamingKafkaParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.services.pipes.CfnPipe.MSKAccessCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceManagedStreamingKafkaParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.core.IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceManagedStreamingKafkaParametersProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds The maximum length of a time to wait for events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceManagedStreamingKafkaParametersProperty#getStartingPosition}
             * @param startingPosition (Streams only) The position in a stream from which to start reading.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceManagedStreamingKafkaParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceManagedStreamingKafkaParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceManagedStreamingKafkaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceManagedStreamingKafkaParametersProperty {
            private final java.lang.String topicName;
            private final java.lang.Number batchSize;
            private final java.lang.String consumerGroupId;
            private final java.lang.Object credentials;
            private final java.lang.Number maximumBatchingWindowInSeconds;
            private final java.lang.String startingPosition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.consumerGroupId = software.amazon.jsii.Kernel.get(this, "consumerGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicName = java.util.Objects.requireNonNull(builder.topicName, "topicName is required");
                this.batchSize = builder.batchSize;
                this.consumerGroupId = builder.consumerGroupId;
                this.credentials = builder.credentials;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
                this.startingPosition = builder.startingPosition;
            }

            @Override
            public final java.lang.String getTopicName() {
                return this.topicName;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.String getConsumerGroupId() {
                return this.consumerGroupId;
            }

            @Override
            public final java.lang.Object getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicName", om.valueToTree(this.getTopicName()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getConsumerGroupId() != null) {
                    data.set("consumerGroupId", om.valueToTree(this.getConsumerGroupId()));
                }
                if (this.getCredentials() != null) {
                    data.set("credentials", om.valueToTree(this.getCredentials()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }
                if (this.getStartingPosition() != null) {
                    data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceManagedStreamingKafkaParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceManagedStreamingKafkaParametersProperty.Jsii$Proxy that = (PipeSourceManagedStreamingKafkaParametersProperty.Jsii$Proxy) o;

                if (!topicName.equals(that.topicName)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.consumerGroupId != null ? !this.consumerGroupId.equals(that.consumerGroupId) : that.consumerGroupId != null) return false;
                if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
                if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
                return this.startingPosition != null ? this.startingPosition.equals(that.startingPosition) : that.startingPosition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.topicName.hashCode();
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.consumerGroupId != null ? this.consumerGroupId.hashCode() : 0);
                result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters required to set up a source for your pipe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceParametersProperty pipeSourceParametersProperty = PipeSourceParametersProperty.builder()
     *         .activeMqBrokerParameters(PipeSourceActiveMQBrokerParametersProperty.builder()
     *                 .credentials(MQBrokerAccessCredentialsProperty.builder()
     *                         .basicAuth("basicAuth")
     *                         .build())
     *                 .queueName("queueName")
     *                 // the properties below are optional
     *                 .batchSize(123)
     *                 .maximumBatchingWindowInSeconds(123)
     *                 .build())
     *         .dynamoDbStreamParameters(PipeSourceDynamoDBStreamParametersProperty.builder()
     *                 .startingPosition("startingPosition")
     *                 // the properties below are optional
     *                 .batchSize(123)
     *                 .deadLetterConfig(DeadLetterConfigProperty.builder()
     *                         .arn("arn")
     *                         .build())
     *                 .maximumBatchingWindowInSeconds(123)
     *                 .maximumRecordAgeInSeconds(123)
     *                 .maximumRetryAttempts(123)
     *                 .onPartialBatchItemFailure("onPartialBatchItemFailure")
     *                 .parallelizationFactor(123)
     *                 .build())
     *         .filterCriteria(FilterCriteriaProperty.builder()
     *                 .filters(List.of(FilterProperty.builder()
     *                         .pattern("pattern")
     *                         .build()))
     *                 .build())
     *         .kinesisStreamParameters(PipeSourceKinesisStreamParametersProperty.builder()
     *                 .startingPosition("startingPosition")
     *                 // the properties below are optional
     *                 .batchSize(123)
     *                 .deadLetterConfig(DeadLetterConfigProperty.builder()
     *                         .arn("arn")
     *                         .build())
     *                 .maximumBatchingWindowInSeconds(123)
     *                 .maximumRecordAgeInSeconds(123)
     *                 .maximumRetryAttempts(123)
     *                 .onPartialBatchItemFailure("onPartialBatchItemFailure")
     *                 .parallelizationFactor(123)
     *                 .startingPositionTimestamp("startingPositionTimestamp")
     *                 .build())
     *         .managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParametersProperty.builder()
     *                 .topicName("topicName")
     *                 // the properties below are optional
     *                 .batchSize(123)
     *                 .consumerGroupId("consumerGroupId")
     *                 .credentials(MSKAccessCredentialsProperty.builder()
     *                         .clientCertificateTlsAuth("clientCertificateTlsAuth")
     *                         .saslScram512Auth("saslScram512Auth")
     *                         .build())
     *                 .maximumBatchingWindowInSeconds(123)
     *                 .startingPosition("startingPosition")
     *                 .build())
     *         .rabbitMqBrokerParameters(PipeSourceRabbitMQBrokerParametersProperty.builder()
     *                 .credentials(MQBrokerAccessCredentialsProperty.builder()
     *                         .basicAuth("basicAuth")
     *                         .build())
     *                 .queueName("queueName")
     *                 // the properties below are optional
     *                 .batchSize(123)
     *                 .maximumBatchingWindowInSeconds(123)
     *                 .virtualHost("virtualHost")
     *                 .build())
     *         .selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParametersProperty.builder()
     *                 .topicName("topicName")
     *                 // the properties below are optional
     *                 .additionalBootstrapServers(List.of("additionalBootstrapServers"))
     *                 .batchSize(123)
     *                 .consumerGroupId("consumerGroupId")
     *                 .credentials(SelfManagedKafkaAccessConfigurationCredentialsProperty.builder()
     *                         .basicAuth("basicAuth")
     *                         .clientCertificateTlsAuth("clientCertificateTlsAuth")
     *                         .saslScram256Auth("saslScram256Auth")
     *                         .saslScram512Auth("saslScram512Auth")
     *                         .build())
     *                 .maximumBatchingWindowInSeconds(123)
     *                 .serverRootCaCertificate("serverRootCaCertificate")
     *                 .startingPosition("startingPosition")
     *                 .vpc(SelfManagedKafkaAccessConfigurationVpcProperty.builder()
     *                         .securityGroup(List.of("securityGroup"))
     *                         .subnets(List.of("subnets"))
     *                         .build())
     *                 .build())
     *         .sqsQueueParameters(PipeSourceSqsQueueParametersProperty.builder()
     *                 .batchSize(123)
     *                 .maximumBatchingWindowInSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for using an Active MQ broker as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActiveMqBrokerParameters() {
            return null;
        }

        /**
         * The parameters for using a DynamoDB stream as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbStreamParameters() {
            return null;
        }

        /**
         * The collection of event patterns used to filter events.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterCriteria() {
            return null;
        }

        /**
         * The parameters for using a Kinesis stream as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamParameters() {
            return null;
        }

        /**
         * The parameters for using an MSK stream as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedStreamingKafkaParameters() {
            return null;
        }

        /**
         * The parameters for using a Rabbit MQ broker as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRabbitMqBrokerParameters() {
            return null;
        }

        /**
         * The parameters for using a self-managed Apache Kafka stream as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedKafkaParameters() {
            return null;
        }

        /**
         * The parameters for using a Amazon SQS stream as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsQueueParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceParametersProperty> {
            java.lang.Object activeMqBrokerParameters;
            java.lang.Object dynamoDbStreamParameters;
            java.lang.Object filterCriteria;
            java.lang.Object kinesisStreamParameters;
            java.lang.Object managedStreamingKafkaParameters;
            java.lang.Object rabbitMqBrokerParameters;
            java.lang.Object selfManagedKafkaParameters;
            java.lang.Object sqsQueueParameters;

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getActiveMqBrokerParameters}
             * @param activeMqBrokerParameters The parameters for using an Active MQ broker as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeMqBrokerParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceActiveMQBrokerParametersProperty activeMqBrokerParameters) {
                this.activeMqBrokerParameters = activeMqBrokerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getActiveMqBrokerParameters}
             * @param activeMqBrokerParameters The parameters for using an Active MQ broker as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeMqBrokerParameters(software.amazon.awscdk.core.IResolvable activeMqBrokerParameters) {
                this.activeMqBrokerParameters = activeMqBrokerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getDynamoDbStreamParameters}
             * @param dynamoDbStreamParameters The parameters for using a DynamoDB stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbStreamParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceDynamoDBStreamParametersProperty dynamoDbStreamParameters) {
                this.dynamoDbStreamParameters = dynamoDbStreamParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getDynamoDbStreamParameters}
             * @param dynamoDbStreamParameters The parameters for using a DynamoDB stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDbStreamParameters(software.amazon.awscdk.core.IResolvable dynamoDbStreamParameters) {
                this.dynamoDbStreamParameters = dynamoDbStreamParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getFilterCriteria}
             * @param filterCriteria The collection of event patterns used to filter events.
             *                       For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterCriteria(software.amazon.awscdk.services.pipes.CfnPipe.FilterCriteriaProperty filterCriteria) {
                this.filterCriteria = filterCriteria;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getFilterCriteria}
             * @param filterCriteria The collection of event patterns used to filter events.
             *                       For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterCriteria(software.amazon.awscdk.core.IResolvable filterCriteria) {
                this.filterCriteria = filterCriteria;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getKinesisStreamParameters}
             * @param kinesisStreamParameters The parameters for using a Kinesis stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceKinesisStreamParametersProperty kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getKinesisStreamParameters}
             * @param kinesisStreamParameters The parameters for using a Kinesis stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamParameters(software.amazon.awscdk.core.IResolvable kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getManagedStreamingKafkaParameters}
             * @param managedStreamingKafkaParameters The parameters for using an MSK stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedStreamingKafkaParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceManagedStreamingKafkaParametersProperty managedStreamingKafkaParameters) {
                this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getManagedStreamingKafkaParameters}
             * @param managedStreamingKafkaParameters The parameters for using an MSK stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedStreamingKafkaParameters(software.amazon.awscdk.core.IResolvable managedStreamingKafkaParameters) {
                this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getRabbitMqBrokerParameters}
             * @param rabbitMqBrokerParameters The parameters for using a Rabbit MQ broker as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rabbitMqBrokerParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceRabbitMQBrokerParametersProperty rabbitMqBrokerParameters) {
                this.rabbitMqBrokerParameters = rabbitMqBrokerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getRabbitMqBrokerParameters}
             * @param rabbitMqBrokerParameters The parameters for using a Rabbit MQ broker as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rabbitMqBrokerParameters(software.amazon.awscdk.core.IResolvable rabbitMqBrokerParameters) {
                this.rabbitMqBrokerParameters = rabbitMqBrokerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getSelfManagedKafkaParameters}
             * @param selfManagedKafkaParameters The parameters for using a self-managed Apache Kafka stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedKafkaParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceSelfManagedKafkaParametersProperty selfManagedKafkaParameters) {
                this.selfManagedKafkaParameters = selfManagedKafkaParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getSelfManagedKafkaParameters}
             * @param selfManagedKafkaParameters The parameters for using a self-managed Apache Kafka stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedKafkaParameters(software.amazon.awscdk.core.IResolvable selfManagedKafkaParameters) {
                this.selfManagedKafkaParameters = selfManagedKafkaParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getSqsQueueParameters}
             * @param sqsQueueParameters The parameters for using a Amazon SQS stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsQueueParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceSqsQueueParametersProperty sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceParametersProperty#getSqsQueueParameters}
             * @param sqsQueueParameters The parameters for using a Amazon SQS stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsQueueParameters(software.amazon.awscdk.core.IResolvable sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceParametersProperty {
            private final java.lang.Object activeMqBrokerParameters;
            private final java.lang.Object dynamoDbStreamParameters;
            private final java.lang.Object filterCriteria;
            private final java.lang.Object kinesisStreamParameters;
            private final java.lang.Object managedStreamingKafkaParameters;
            private final java.lang.Object rabbitMqBrokerParameters;
            private final java.lang.Object selfManagedKafkaParameters;
            private final java.lang.Object sqsQueueParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activeMqBrokerParameters = software.amazon.jsii.Kernel.get(this, "activeMqBrokerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDbStreamParameters = software.amazon.jsii.Kernel.get(this, "dynamoDbStreamParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterCriteria = software.amazon.jsii.Kernel.get(this, "filterCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisStreamParameters = software.amazon.jsii.Kernel.get(this, "kinesisStreamParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedStreamingKafkaParameters = software.amazon.jsii.Kernel.get(this, "managedStreamingKafkaParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rabbitMqBrokerParameters = software.amazon.jsii.Kernel.get(this, "rabbitMqBrokerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selfManagedKafkaParameters = software.amazon.jsii.Kernel.get(this, "selfManagedKafkaParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsQueueParameters = software.amazon.jsii.Kernel.get(this, "sqsQueueParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activeMqBrokerParameters = builder.activeMqBrokerParameters;
                this.dynamoDbStreamParameters = builder.dynamoDbStreamParameters;
                this.filterCriteria = builder.filterCriteria;
                this.kinesisStreamParameters = builder.kinesisStreamParameters;
                this.managedStreamingKafkaParameters = builder.managedStreamingKafkaParameters;
                this.rabbitMqBrokerParameters = builder.rabbitMqBrokerParameters;
                this.selfManagedKafkaParameters = builder.selfManagedKafkaParameters;
                this.sqsQueueParameters = builder.sqsQueueParameters;
            }

            @Override
            public final java.lang.Object getActiveMqBrokerParameters() {
                return this.activeMqBrokerParameters;
            }

            @Override
            public final java.lang.Object getDynamoDbStreamParameters() {
                return this.dynamoDbStreamParameters;
            }

            @Override
            public final java.lang.Object getFilterCriteria() {
                return this.filterCriteria;
            }

            @Override
            public final java.lang.Object getKinesisStreamParameters() {
                return this.kinesisStreamParameters;
            }

            @Override
            public final java.lang.Object getManagedStreamingKafkaParameters() {
                return this.managedStreamingKafkaParameters;
            }

            @Override
            public final java.lang.Object getRabbitMqBrokerParameters() {
                return this.rabbitMqBrokerParameters;
            }

            @Override
            public final java.lang.Object getSelfManagedKafkaParameters() {
                return this.selfManagedKafkaParameters;
            }

            @Override
            public final java.lang.Object getSqsQueueParameters() {
                return this.sqsQueueParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActiveMqBrokerParameters() != null) {
                    data.set("activeMqBrokerParameters", om.valueToTree(this.getActiveMqBrokerParameters()));
                }
                if (this.getDynamoDbStreamParameters() != null) {
                    data.set("dynamoDbStreamParameters", om.valueToTree(this.getDynamoDbStreamParameters()));
                }
                if (this.getFilterCriteria() != null) {
                    data.set("filterCriteria", om.valueToTree(this.getFilterCriteria()));
                }
                if (this.getKinesisStreamParameters() != null) {
                    data.set("kinesisStreamParameters", om.valueToTree(this.getKinesisStreamParameters()));
                }
                if (this.getManagedStreamingKafkaParameters() != null) {
                    data.set("managedStreamingKafkaParameters", om.valueToTree(this.getManagedStreamingKafkaParameters()));
                }
                if (this.getRabbitMqBrokerParameters() != null) {
                    data.set("rabbitMqBrokerParameters", om.valueToTree(this.getRabbitMqBrokerParameters()));
                }
                if (this.getSelfManagedKafkaParameters() != null) {
                    data.set("selfManagedKafkaParameters", om.valueToTree(this.getSelfManagedKafkaParameters()));
                }
                if (this.getSqsQueueParameters() != null) {
                    data.set("sqsQueueParameters", om.valueToTree(this.getSqsQueueParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceParametersProperty.Jsii$Proxy that = (PipeSourceParametersProperty.Jsii$Proxy) o;

                if (this.activeMqBrokerParameters != null ? !this.activeMqBrokerParameters.equals(that.activeMqBrokerParameters) : that.activeMqBrokerParameters != null) return false;
                if (this.dynamoDbStreamParameters != null ? !this.dynamoDbStreamParameters.equals(that.dynamoDbStreamParameters) : that.dynamoDbStreamParameters != null) return false;
                if (this.filterCriteria != null ? !this.filterCriteria.equals(that.filterCriteria) : that.filterCriteria != null) return false;
                if (this.kinesisStreamParameters != null ? !this.kinesisStreamParameters.equals(that.kinesisStreamParameters) : that.kinesisStreamParameters != null) return false;
                if (this.managedStreamingKafkaParameters != null ? !this.managedStreamingKafkaParameters.equals(that.managedStreamingKafkaParameters) : that.managedStreamingKafkaParameters != null) return false;
                if (this.rabbitMqBrokerParameters != null ? !this.rabbitMqBrokerParameters.equals(that.rabbitMqBrokerParameters) : that.rabbitMqBrokerParameters != null) return false;
                if (this.selfManagedKafkaParameters != null ? !this.selfManagedKafkaParameters.equals(that.selfManagedKafkaParameters) : that.selfManagedKafkaParameters != null) return false;
                return this.sqsQueueParameters != null ? this.sqsQueueParameters.equals(that.sqsQueueParameters) : that.sqsQueueParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.activeMqBrokerParameters != null ? this.activeMqBrokerParameters.hashCode() : 0;
                result = 31 * result + (this.dynamoDbStreamParameters != null ? this.dynamoDbStreamParameters.hashCode() : 0);
                result = 31 * result + (this.filterCriteria != null ? this.filterCriteria.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamParameters != null ? this.kinesisStreamParameters.hashCode() : 0);
                result = 31 * result + (this.managedStreamingKafkaParameters != null ? this.managedStreamingKafkaParameters.hashCode() : 0);
                result = 31 * result + (this.rabbitMqBrokerParameters != null ? this.rabbitMqBrokerParameters.hashCode() : 0);
                result = 31 * result + (this.selfManagedKafkaParameters != null ? this.selfManagedKafkaParameters.hashCode() : 0);
                result = 31 * result + (this.sqsQueueParameters != null ? this.sqsQueueParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a Rabbit MQ broker as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceRabbitMQBrokerParametersProperty pipeSourceRabbitMQBrokerParametersProperty = PipeSourceRabbitMQBrokerParametersProperty.builder()
     *         .credentials(MQBrokerAccessCredentialsProperty.builder()
     *                 .basicAuth("basicAuth")
     *                 .build())
     *         .queueName("queueName")
     *         // the properties below are optional
     *         .batchSize(123)
     *         .maximumBatchingWindowInSeconds(123)
     *         .virtualHost("virtualHost")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceRabbitMQBrokerParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceRabbitMQBrokerParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceRabbitMQBrokerParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credentials needed to access the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCredentials();

        /**
         * The name of the destination queue to consume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueName();

        /**
         * The maximum number of records to include in each batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * The maximum length of a time to wait for events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * The name of the virtual host associated with the source broker.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualHost() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceRabbitMQBrokerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceRabbitMQBrokerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceRabbitMQBrokerParametersProperty> {
            java.lang.Object credentials;
            java.lang.String queueName;
            java.lang.Number batchSize;
            java.lang.Number maximumBatchingWindowInSeconds;
            java.lang.String virtualHost;

            /**
             * Sets the value of {@link PipeSourceRabbitMQBrokerParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.services.pipes.CfnPipe.MQBrokerAccessCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceRabbitMQBrokerParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.core.IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceRabbitMQBrokerParametersProperty#getQueueName}
             * @param queueName The name of the destination queue to consume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueName(java.lang.String queueName) {
                this.queueName = queueName;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceRabbitMQBrokerParametersProperty#getBatchSize}
             * @param batchSize The maximum number of records to include in each batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceRabbitMQBrokerParametersProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds The maximum length of a time to wait for events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceRabbitMQBrokerParametersProperty#getVirtualHost}
             * @param virtualHost The name of the virtual host associated with the source broker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualHost(java.lang.String virtualHost) {
                this.virtualHost = virtualHost;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceRabbitMQBrokerParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceRabbitMQBrokerParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceRabbitMQBrokerParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceRabbitMQBrokerParametersProperty {
            private final java.lang.Object credentials;
            private final java.lang.String queueName;
            private final java.lang.Number batchSize;
            private final java.lang.Number maximumBatchingWindowInSeconds;
            private final java.lang.String virtualHost;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queueName = software.amazon.jsii.Kernel.get(this, "queueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.virtualHost = software.amazon.jsii.Kernel.get(this, "virtualHost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentials = java.util.Objects.requireNonNull(builder.credentials, "credentials is required");
                this.queueName = java.util.Objects.requireNonNull(builder.queueName, "queueName is required");
                this.batchSize = builder.batchSize;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
                this.virtualHost = builder.virtualHost;
            }

            @Override
            public final java.lang.Object getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.String getQueueName() {
                return this.queueName;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.String getVirtualHost() {
                return this.virtualHost;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentials", om.valueToTree(this.getCredentials()));
                data.set("queueName", om.valueToTree(this.getQueueName()));
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }
                if (this.getVirtualHost() != null) {
                    data.set("virtualHost", om.valueToTree(this.getVirtualHost()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceRabbitMQBrokerParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceRabbitMQBrokerParametersProperty.Jsii$Proxy that = (PipeSourceRabbitMQBrokerParametersProperty.Jsii$Proxy) o;

                if (!credentials.equals(that.credentials)) return false;
                if (!queueName.equals(that.queueName)) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
                return this.virtualHost != null ? this.virtualHost.equals(that.virtualHost) : that.virtualHost == null;
            }

            @Override
            public final int hashCode() {
                int result = this.credentials.hashCode();
                result = 31 * result + (this.queueName.hashCode());
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                result = 31 * result + (this.virtualHost != null ? this.virtualHost.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a self-managed Apache Kafka stream as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceSelfManagedKafkaParametersProperty pipeSourceSelfManagedKafkaParametersProperty = PipeSourceSelfManagedKafkaParametersProperty.builder()
     *         .topicName("topicName")
     *         // the properties below are optional
     *         .additionalBootstrapServers(List.of("additionalBootstrapServers"))
     *         .batchSize(123)
     *         .consumerGroupId("consumerGroupId")
     *         .credentials(SelfManagedKafkaAccessConfigurationCredentialsProperty.builder()
     *                 .basicAuth("basicAuth")
     *                 .clientCertificateTlsAuth("clientCertificateTlsAuth")
     *                 .saslScram256Auth("saslScram256Auth")
     *                 .saslScram512Auth("saslScram512Auth")
     *                 .build())
     *         .maximumBatchingWindowInSeconds(123)
     *         .serverRootCaCertificate("serverRootCaCertificate")
     *         .startingPosition("startingPosition")
     *         .vpc(SelfManagedKafkaAccessConfigurationVpcProperty.builder()
     *                 .securityGroup(List.of("securityGroup"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceSelfManagedKafkaParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceSelfManagedKafkaParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceSelfManagedKafkaParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the topic that the pipe will read from.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicName();

        /**
         * An array of server URLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalBootstrapServers() {
            return null;
        }

        /**
         * The maximum number of records to include in each batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * The name of the destination queue to consume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConsumerGroupId() {
            return null;
        }

        /**
         * The credentials needed to access the resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCredentials() {
            return null;
        }

        /**
         * The maximum length of a time to wait for events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * The ARN of the Secrets Manager secret used for certification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerRootCaCertificate() {
            return null;
        }

        /**
         * (Streams only) The position in a stream from which to start reading.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartingPosition() {
            return null;
        }

        /**
         * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceSelfManagedKafkaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceSelfManagedKafkaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceSelfManagedKafkaParametersProperty> {
            java.lang.String topicName;
            java.util.List<java.lang.String> additionalBootstrapServers;
            java.lang.Number batchSize;
            java.lang.String consumerGroupId;
            java.lang.Object credentials;
            java.lang.Number maximumBatchingWindowInSeconds;
            java.lang.String serverRootCaCertificate;
            java.lang.String startingPosition;
            java.lang.Object vpc;

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getTopicName}
             * @param topicName The name of the topic that the pipe will read from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicName(java.lang.String topicName) {
                this.topicName = topicName;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getAdditionalBootstrapServers}
             * @param additionalBootstrapServers An array of server URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalBootstrapServers(java.util.List<java.lang.String> additionalBootstrapServers) {
                this.additionalBootstrapServers = additionalBootstrapServers;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getBatchSize}
             * @param batchSize The maximum number of records to include in each batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getConsumerGroupId}
             * @param consumerGroupId The name of the destination queue to consume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consumerGroupId(java.lang.String consumerGroupId) {
                this.consumerGroupId = consumerGroupId;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.services.pipes.CfnPipe.SelfManagedKafkaAccessConfigurationCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getCredentials}
             * @param credentials The credentials needed to access the resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(software.amazon.awscdk.core.IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds The maximum length of a time to wait for events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getServerRootCaCertificate}
             * @param serverRootCaCertificate The ARN of the Secrets Manager secret used for certification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverRootCaCertificate(java.lang.String serverRootCaCertificate) {
                this.serverRootCaCertificate = serverRootCaCertificate;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getStartingPosition}
             * @param startingPosition (Streams only) The position in a stream from which to start reading.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startingPosition(java.lang.String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getVpc}
             * @param vpc This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.services.pipes.CfnPipe.SelfManagedKafkaAccessConfigurationVpcProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSelfManagedKafkaParametersProperty#getVpc}
             * @param vpc This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpc(software.amazon.awscdk.core.IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceSelfManagedKafkaParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceSelfManagedKafkaParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceSelfManagedKafkaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceSelfManagedKafkaParametersProperty {
            private final java.lang.String topicName;
            private final java.util.List<java.lang.String> additionalBootstrapServers;
            private final java.lang.Number batchSize;
            private final java.lang.String consumerGroupId;
            private final java.lang.Object credentials;
            private final java.lang.Number maximumBatchingWindowInSeconds;
            private final java.lang.String serverRootCaCertificate;
            private final java.lang.String startingPosition;
            private final java.lang.Object vpc;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.additionalBootstrapServers = software.amazon.jsii.Kernel.get(this, "additionalBootstrapServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.consumerGroupId = software.amazon.jsii.Kernel.get(this, "consumerGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverRootCaCertificate = software.amazon.jsii.Kernel.get(this, "serverRootCaCertificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicName = java.util.Objects.requireNonNull(builder.topicName, "topicName is required");
                this.additionalBootstrapServers = builder.additionalBootstrapServers;
                this.batchSize = builder.batchSize;
                this.consumerGroupId = builder.consumerGroupId;
                this.credentials = builder.credentials;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
                this.serverRootCaCertificate = builder.serverRootCaCertificate;
                this.startingPosition = builder.startingPosition;
                this.vpc = builder.vpc;
            }

            @Override
            public final java.lang.String getTopicName() {
                return this.topicName;
            }

            @Override
            public final java.util.List<java.lang.String> getAdditionalBootstrapServers() {
                return this.additionalBootstrapServers;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.String getConsumerGroupId() {
                return this.consumerGroupId;
            }

            @Override
            public final java.lang.Object getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.String getServerRootCaCertificate() {
                return this.serverRootCaCertificate;
            }

            @Override
            public final java.lang.String getStartingPosition() {
                return this.startingPosition;
            }

            @Override
            public final java.lang.Object getVpc() {
                return this.vpc;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicName", om.valueToTree(this.getTopicName()));
                if (this.getAdditionalBootstrapServers() != null) {
                    data.set("additionalBootstrapServers", om.valueToTree(this.getAdditionalBootstrapServers()));
                }
                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getConsumerGroupId() != null) {
                    data.set("consumerGroupId", om.valueToTree(this.getConsumerGroupId()));
                }
                if (this.getCredentials() != null) {
                    data.set("credentials", om.valueToTree(this.getCredentials()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }
                if (this.getServerRootCaCertificate() != null) {
                    data.set("serverRootCaCertificate", om.valueToTree(this.getServerRootCaCertificate()));
                }
                if (this.getStartingPosition() != null) {
                    data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
                }
                if (this.getVpc() != null) {
                    data.set("vpc", om.valueToTree(this.getVpc()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceSelfManagedKafkaParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceSelfManagedKafkaParametersProperty.Jsii$Proxy that = (PipeSourceSelfManagedKafkaParametersProperty.Jsii$Proxy) o;

                if (!topicName.equals(that.topicName)) return false;
                if (this.additionalBootstrapServers != null ? !this.additionalBootstrapServers.equals(that.additionalBootstrapServers) : that.additionalBootstrapServers != null) return false;
                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                if (this.consumerGroupId != null ? !this.consumerGroupId.equals(that.consumerGroupId) : that.consumerGroupId != null) return false;
                if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
                if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
                if (this.serverRootCaCertificate != null ? !this.serverRootCaCertificate.equals(that.serverRootCaCertificate) : that.serverRootCaCertificate != null) return false;
                if (this.startingPosition != null ? !this.startingPosition.equals(that.startingPosition) : that.startingPosition != null) return false;
                return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
            }

            @Override
            public final int hashCode() {
                int result = this.topicName.hashCode();
                result = 31 * result + (this.additionalBootstrapServers != null ? this.additionalBootstrapServers.hashCode() : 0);
                result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
                result = 31 * result + (this.consumerGroupId != null ? this.consumerGroupId.hashCode() : 0);
                result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                result = 31 * result + (this.serverRootCaCertificate != null ? this.serverRootCaCertificate.hashCode() : 0);
                result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
                result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a Amazon SQS stream as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeSourceSqsQueueParametersProperty pipeSourceSqsQueueParametersProperty = PipeSourceSqsQueueParametersProperty.builder()
     *         .batchSize(123)
     *         .maximumBatchingWindowInSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeSourceSqsQueueParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeSourceSqsQueueParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeSourceSqsQueueParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of records to include in each batch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
            return null;
        }

        /**
         * The maximum length of a time to wait for events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeSourceSqsQueueParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeSourceSqsQueueParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeSourceSqsQueueParametersProperty> {
            java.lang.Number batchSize;
            java.lang.Number maximumBatchingWindowInSeconds;

            /**
             * Sets the value of {@link PipeSourceSqsQueueParametersProperty#getBatchSize}
             * @param batchSize The maximum number of records to include in each batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchSize(java.lang.Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            /**
             * Sets the value of {@link PipeSourceSqsQueueParametersProperty#getMaximumBatchingWindowInSeconds}
             * @param maximumBatchingWindowInSeconds The maximum length of a time to wait for events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeSourceSqsQueueParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeSourceSqsQueueParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeSourceSqsQueueParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeSourceSqsQueueParametersProperty {
            private final java.lang.Number batchSize;
            private final java.lang.Number maximumBatchingWindowInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.batchSize = builder.batchSize;
                this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
            }

            @Override
            public final java.lang.Number getBatchSize() {
                return this.batchSize;
            }

            @Override
            public final java.lang.Number getMaximumBatchingWindowInSeconds() {
                return this.maximumBatchingWindowInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBatchSize() != null) {
                    data.set("batchSize", om.valueToTree(this.getBatchSize()));
                }
                if (this.getMaximumBatchingWindowInSeconds() != null) {
                    data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeSourceSqsQueueParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeSourceSqsQueueParametersProperty.Jsii$Proxy that = (PipeSourceSqsQueueParametersProperty.Jsii$Proxy) o;

                if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
                return this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.batchSize != null ? this.batchSize.hashCode() : 0;
                result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using an AWS Batch job as a target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetBatchJobParametersProperty pipeTargetBatchJobParametersProperty = PipeTargetBatchJobParametersProperty.builder()
     *         .jobDefinition("jobDefinition")
     *         .jobName("jobName")
     *         // the properties below are optional
     *         .arrayProperties(BatchArrayPropertiesProperty.builder()
     *                 .size(123)
     *                 .build())
     *         .containerOverrides(BatchContainerOverridesProperty.builder()
     *                 .command(List.of("command"))
     *                 .environment(List.of(BatchEnvironmentVariableProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .instanceType("instanceType")
     *                 .resourceRequirements(List.of(BatchResourceRequirementProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .dependsOn(List.of(BatchJobDependencyProperty.builder()
     *                 .jobId("jobId")
     *                 .type("type")
     *                 .build()))
     *         .parameters(Map.of(
     *                 "parametersKey", "parameters"))
     *         .retryStrategy(BatchRetryStrategyProperty.builder()
     *                 .attempts(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetBatchJobParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetBatchJobParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetBatchJobParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The job definition used by this job.
         * <p>
         * This value can be one of <code>name</code> , <code>name:revision</code> , or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJobDefinition();

        /**
         * The name of the job.
         * <p>
         * It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJobName();

        /**
         * The array properties for the submitted job, such as the size of the array.
         * <p>
         * The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArrayProperties() {
            return null;
        }

        /**
         * The overrides that are sent to a container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerOverrides() {
            return null;
        }

        /**
         * A list of dependencies for the job.
         * <p>
         * A job can depend upon a maximum of 20 jobs. You can specify a <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDependsOn() {
            return null;
        }

        /**
         * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition.
         * <p>
         * Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The retry strategy to use for failed jobs.
         * <p>
         * When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetBatchJobParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetBatchJobParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetBatchJobParametersProperty> {
            java.lang.String jobDefinition;
            java.lang.String jobName;
            java.lang.Object arrayProperties;
            java.lang.Object containerOverrides;
            java.lang.Object dependsOn;
            java.lang.Object parameters;
            java.lang.Object retryStrategy;

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getJobDefinition}
             * @param jobDefinition The job definition used by this job. This parameter is required.
             *                      This value can be one of <code>name</code> , <code>name:revision</code> , or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobDefinition(java.lang.String jobDefinition) {
                this.jobDefinition = jobDefinition;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getJobName}
             * @param jobName The name of the job. This parameter is required.
             *                It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobName(java.lang.String jobName) {
                this.jobName = jobName;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getArrayProperties}
             * @param arrayProperties The array properties for the submitted job, such as the size of the array.
             *                        The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arrayProperties(software.amazon.awscdk.services.pipes.CfnPipe.BatchArrayPropertiesProperty arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getArrayProperties}
             * @param arrayProperties The array properties for the submitted job, such as the size of the array.
             *                        The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arrayProperties(software.amazon.awscdk.core.IResolvable arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getContainerOverrides}
             * @param containerOverrides The overrides that are sent to a container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerOverrides(software.amazon.awscdk.services.pipes.CfnPipe.BatchContainerOverridesProperty containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getContainerOverrides}
             * @param containerOverrides The overrides that are sent to a container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerOverrides(software.amazon.awscdk.core.IResolvable containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getDependsOn}
             * @param dependsOn A list of dependencies for the job.
             *                  A job can depend upon a maximum of 20 jobs. You can specify a <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(software.amazon.awscdk.core.IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getDependsOn}
             * @param dependsOn A list of dependencies for the job.
             *                  A job can depend upon a maximum of 20 jobs. You can specify a <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dependsOn(java.util.List<? extends java.lang.Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getParameters}
             * @param parameters Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition.
             *                   Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.core.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getParameters}
             * @param parameters Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition.
             *                   Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getRetryStrategy}
             * @param retryStrategy The retry strategy to use for failed jobs.
             *                      When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryStrategy(software.amazon.awscdk.services.pipes.CfnPipe.BatchRetryStrategyProperty retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetBatchJobParametersProperty#getRetryStrategy}
             * @param retryStrategy The retry strategy to use for failed jobs.
             *                      When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryStrategy(software.amazon.awscdk.core.IResolvable retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetBatchJobParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetBatchJobParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetBatchJobParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetBatchJobParametersProperty {
            private final java.lang.String jobDefinition;
            private final java.lang.String jobName;
            private final java.lang.Object arrayProperties;
            private final java.lang.Object containerOverrides;
            private final java.lang.Object dependsOn;
            private final java.lang.Object parameters;
            private final java.lang.Object retryStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jobDefinition = software.amazon.jsii.Kernel.get(this, "jobDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jobName = software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.arrayProperties = software.amazon.jsii.Kernel.get(this, "arrayProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.containerOverrides = software.amazon.jsii.Kernel.get(this, "containerOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dependsOn = software.amazon.jsii.Kernel.get(this, "dependsOn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryStrategy = software.amazon.jsii.Kernel.get(this, "retryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jobDefinition = java.util.Objects.requireNonNull(builder.jobDefinition, "jobDefinition is required");
                this.jobName = java.util.Objects.requireNonNull(builder.jobName, "jobName is required");
                this.arrayProperties = builder.arrayProperties;
                this.containerOverrides = builder.containerOverrides;
                this.dependsOn = builder.dependsOn;
                this.parameters = builder.parameters;
                this.retryStrategy = builder.retryStrategy;
            }

            @Override
            public final java.lang.String getJobDefinition() {
                return this.jobDefinition;
            }

            @Override
            public final java.lang.String getJobName() {
                return this.jobName;
            }

            @Override
            public final java.lang.Object getArrayProperties() {
                return this.arrayProperties;
            }

            @Override
            public final java.lang.Object getContainerOverrides() {
                return this.containerOverrides;
            }

            @Override
            public final java.lang.Object getDependsOn() {
                return this.dependsOn;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.Object getRetryStrategy() {
                return this.retryStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("jobDefinition", om.valueToTree(this.getJobDefinition()));
                data.set("jobName", om.valueToTree(this.getJobName()));
                if (this.getArrayProperties() != null) {
                    data.set("arrayProperties", om.valueToTree(this.getArrayProperties()));
                }
                if (this.getContainerOverrides() != null) {
                    data.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
                }
                if (this.getDependsOn() != null) {
                    data.set("dependsOn", om.valueToTree(this.getDependsOn()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getRetryStrategy() != null) {
                    data.set("retryStrategy", om.valueToTree(this.getRetryStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetBatchJobParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetBatchJobParametersProperty.Jsii$Proxy that = (PipeTargetBatchJobParametersProperty.Jsii$Proxy) o;

                if (!jobDefinition.equals(that.jobDefinition)) return false;
                if (!jobName.equals(that.jobName)) return false;
                if (this.arrayProperties != null ? !this.arrayProperties.equals(that.arrayProperties) : that.arrayProperties != null) return false;
                if (this.containerOverrides != null ? !this.containerOverrides.equals(that.containerOverrides) : that.containerOverrides != null) return false;
                if (this.dependsOn != null ? !this.dependsOn.equals(that.dependsOn) : that.dependsOn != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                return this.retryStrategy != null ? this.retryStrategy.equals(that.retryStrategy) : that.retryStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jobDefinition.hashCode();
                result = 31 * result + (this.jobName.hashCode());
                result = 31 * result + (this.arrayProperties != null ? this.arrayProperties.hashCode() : 0);
                result = 31 * result + (this.containerOverrides != null ? this.containerOverrides.hashCode() : 0);
                result = 31 * result + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.retryStrategy != null ? this.retryStrategy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using an CloudWatch Logs log stream as a target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetCloudWatchLogsParametersProperty pipeTargetCloudWatchLogsParametersProperty = PipeTargetCloudWatchLogsParametersProperty.builder()
     *         .logStreamName("logStreamName")
     *         .timestamp("timestamp")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetCloudWatchLogsParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetCloudWatchLogsParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetCloudWatchLogsParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the log stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamName() {
            return null;
        }

        /**
         * The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetCloudWatchLogsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetCloudWatchLogsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetCloudWatchLogsParametersProperty> {
            java.lang.String logStreamName;
            java.lang.String timestamp;

            /**
             * Sets the value of {@link PipeTargetCloudWatchLogsParametersProperty#getLogStreamName}
             * @param logStreamName The name of the log stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logStreamName(java.lang.String logStreamName) {
                this.logStreamName = logStreamName;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetCloudWatchLogsParametersProperty#getTimestamp}
             * @param timestamp The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(java.lang.String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetCloudWatchLogsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetCloudWatchLogsParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetCloudWatchLogsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetCloudWatchLogsParametersProperty {
            private final java.lang.String logStreamName;
            private final java.lang.String timestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logStreamName = software.amazon.jsii.Kernel.get(this, "logStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestamp = software.amazon.jsii.Kernel.get(this, "timestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logStreamName = builder.logStreamName;
                this.timestamp = builder.timestamp;
            }

            @Override
            public final java.lang.String getLogStreamName() {
                return this.logStreamName;
            }

            @Override
            public final java.lang.String getTimestamp() {
                return this.timestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogStreamName() != null) {
                    data.set("logStreamName", om.valueToTree(this.getLogStreamName()));
                }
                if (this.getTimestamp() != null) {
                    data.set("timestamp", om.valueToTree(this.getTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetCloudWatchLogsParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetCloudWatchLogsParametersProperty.Jsii$Proxy that = (PipeTargetCloudWatchLogsParametersProperty.Jsii$Proxy) o;

                if (this.logStreamName != null ? !this.logStreamName.equals(that.logStreamName) : that.logStreamName != null) return false;
                return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logStreamName != null ? this.logStreamName.hashCode() : 0;
                result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using an Amazon ECS task as a target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetEcsTaskParametersProperty pipeTargetEcsTaskParametersProperty = PipeTargetEcsTaskParametersProperty.builder()
     *         .taskDefinitionArn("taskDefinitionArn")
     *         // the properties below are optional
     *         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
     *                 .capacityProvider("capacityProvider")
     *                 // the properties below are optional
     *                 .base(123)
     *                 .weight(123)
     *                 .build()))
     *         .enableEcsManagedTags(false)
     *         .enableExecuteCommand(false)
     *         .group("group")
     *         .launchType("launchType")
     *         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                         .subnets(List.of("subnets"))
     *                         // the properties below are optional
     *                         .assignPublicIp("assignPublicIp")
     *                         .securityGroups(List.of("securityGroups"))
     *                         .build())
     *                 .build())
     *         .overrides(EcsTaskOverrideProperty.builder()
     *                 .containerOverrides(List.of(EcsContainerOverrideProperty.builder()
     *                         .command(List.of("command"))
     *                         .cpu(123)
     *                         .environment(List.of(EcsEnvironmentVariableProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .environmentFiles(List.of(EcsEnvironmentFileProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                         .memory(123)
     *                         .memoryReservation(123)
     *                         .name("name")
     *                         .resourceRequirements(List.of(EcsResourceRequirementProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                         .build()))
     *                 .cpu("cpu")
     *                 .ephemeralStorage(EcsEphemeralStorageProperty.builder()
     *                         .sizeInGiB(123)
     *                         .build())
     *                 .executionRoleArn("executionRoleArn")
     *                 .inferenceAcceleratorOverrides(List.of(EcsInferenceAcceleratorOverrideProperty.builder()
     *                         .deviceName("deviceName")
     *                         .deviceType("deviceType")
     *                         .build()))
     *                 .memory("memory")
     *                 .taskRoleArn("taskRoleArn")
     *                 .build())
     *         .placementConstraints(List.of(PlacementConstraintProperty.builder()
     *                 .expression("expression")
     *                 .type("type")
     *                 .build()))
     *         .placementStrategy(List.of(PlacementStrategyProperty.builder()
     *                 .field("field")
     *                 .type("type")
     *                 .build()))
     *         .platformVersion("platformVersion")
     *         .propagateTags("propagateTags")
     *         .referenceId("referenceId")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .taskCount(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetEcsTaskParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetEcsTaskParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetEcsTaskParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the task definition to use if the event target is an Amazon ECS task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTaskDefinitionArn();

        /**
         * The capacity provider strategy to use for the task.
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityProviderStrategy() {
            return null;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the task.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableEcsManagedTags() {
            return null;
        }

        /**
         * Whether or not to enable the execute command functionality for the containers in this task.
         * <p>
         * If true, this enables execute command functionality on all containers in the task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableExecuteCommand() {
            return null;
        }

        /**
         * Specifies an Amazon ECS task group for the task.
         * <p>
         * The maximum length is 255 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroup() {
            return null;
        }

        /**
         * Specifies the launch type on which your task is running.
         * <p>
         * The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The <code>FARGATE</code> value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">AWS Fargate on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLaunchType() {
            return null;
        }

        /**
         * Use this structure if the Amazon ECS task uses the `awsvpc` network mode.
         * <p>
         * This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.
         * <p>
         * If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
            return null;
        }

        /**
         * The overrides that are associated with a task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * An array of placement constraint objects to use for the task.
         * <p>
         * You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
            return null;
        }

        /**
         * The placement strategy objects to use for the task.
         * <p>
         * You can specify a maximum of five strategy rules per task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementStrategy() {
            return null;
        }

        /**
         * Specifies the platform version for the task.
         * <p>
         * Specify only the numeric portion of the platform version, such as <code>1.1.0</code> .
         * <p>
         * This structure is used only if <code>LaunchType</code> is <code>FARGATE</code> . For more information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
            return null;
        }

        /**
         * Specifies whether to propagate the tags from the task definition to the task.
         * <p>
         * If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropagateTags() {
            return null;
        }

        /**
         * The reference ID to use for the task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReferenceId() {
            return null;
        }

        /**
         * The metadata that you apply to the task to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return null;
        }

        /**
         * The number of tasks to create based on `TaskDefinition` .
         * <p>
         * The default is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTaskCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetEcsTaskParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetEcsTaskParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetEcsTaskParametersProperty> {
            java.lang.String taskDefinitionArn;
            java.lang.Object capacityProviderStrategy;
            java.lang.Object enableEcsManagedTags;
            java.lang.Object enableExecuteCommand;
            java.lang.String group;
            java.lang.String launchType;
            java.lang.Object networkConfiguration;
            java.lang.Object overrides;
            java.lang.Object placementConstraints;
            java.lang.Object placementStrategy;
            java.lang.String platformVersion;
            java.lang.String propagateTags;
            java.lang.String referenceId;
            java.util.List<software.amazon.awscdk.core.CfnTag> tags;
            java.lang.Number taskCount;

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getTaskDefinitionArn}
             * @param taskDefinitionArn The ARN of the task definition to use if the event target is an Amazon ECS task. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskDefinitionArn(java.lang.String taskDefinitionArn) {
                this.taskDefinitionArn = taskDefinitionArn;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getCapacityProviderStrategy}
             * @param capacityProviderStrategy The capacity provider strategy to use for the task.
             *                                 If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProviderStrategy(software.amazon.awscdk.core.IResolvable capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getCapacityProviderStrategy}
             * @param capacityProviderStrategy The capacity provider strategy to use for the task.
             *                                 If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProviderStrategy(java.util.List<? extends java.lang.Object> capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getEnableEcsManagedTags}
             * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getEnableEcsManagedTags}
             * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableEcsManagedTags(software.amazon.awscdk.core.IResolvable enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getEnableExecuteCommand}
             * @param enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task.
             *                             If true, this enables execute command functionality on all containers in the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getEnableExecuteCommand}
             * @param enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task.
             *                             If true, this enables execute command functionality on all containers in the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableExecuteCommand(software.amazon.awscdk.core.IResolvable enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getGroup}
             * @param group Specifies an Amazon ECS task group for the task.
             *              The maximum length is 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder group(java.lang.String group) {
                this.group = group;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getLaunchType}
             * @param launchType Specifies the launch type on which your task is running.
             *                   The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The <code>FARGATE</code> value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">AWS Fargate on Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder launchType(java.lang.String launchType) {
                this.launchType = launchType;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getNetworkConfiguration}
             * @param networkConfiguration Use this structure if the Amazon ECS task uses the `awsvpc` network mode.
             *                             This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.
             *                             <p>
             *                             If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.pipes.CfnPipe.NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getNetworkConfiguration}
             * @param networkConfiguration Use this structure if the Amazon ECS task uses the `awsvpc` network mode.
             *                             This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.
             *                             <p>
             *                             If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.core.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getOverrides}
             * @param overrides The overrides that are associated with a task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.services.pipes.CfnPipe.EcsTaskOverrideProperty overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getOverrides}
             * @param overrides The overrides that are associated with a task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.core.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getPlacementConstraints}
             * @param placementConstraints An array of placement constraint objects to use for the task.
             *                             You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementConstraints(software.amazon.awscdk.core.IResolvable placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getPlacementConstraints}
             * @param placementConstraints An array of placement constraint objects to use for the task.
             *                             You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementConstraints(java.util.List<? extends java.lang.Object> placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getPlacementStrategy}
             * @param placementStrategy The placement strategy objects to use for the task.
             *                          You can specify a maximum of five strategy rules per task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementStrategy(software.amazon.awscdk.core.IResolvable placementStrategy) {
                this.placementStrategy = placementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getPlacementStrategy}
             * @param placementStrategy The placement strategy objects to use for the task.
             *                          You can specify a maximum of five strategy rules per task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder placementStrategy(java.util.List<? extends java.lang.Object> placementStrategy) {
                this.placementStrategy = placementStrategy;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getPlatformVersion}
             * @param platformVersion Specifies the platform version for the task.
             *                        Specify only the numeric portion of the platform version, such as <code>1.1.0</code> .
             *                        <p>
             *                        This structure is used only if <code>LaunchType</code> is <code>FARGATE</code> . For more information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platformVersion(java.lang.String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getPropagateTags}
             * @param propagateTags Specifies whether to propagate the tags from the task definition to the task.
             *                      If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propagateTags(java.lang.String propagateTags) {
                this.propagateTags = propagateTags;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getReferenceId}
             * @param referenceId The reference ID to use for the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder referenceId(java.lang.String referenceId) {
                this.referenceId = referenceId;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getTags}
             * @param tags The metadata that you apply to the task to help you categorize and organize them.
             *             Each tag consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEcsTaskParametersProperty#getTaskCount}
             * @param taskCount The number of tasks to create based on `TaskDefinition` .
             *                  The default is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskCount(java.lang.Number taskCount) {
                this.taskCount = taskCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetEcsTaskParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetEcsTaskParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetEcsTaskParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetEcsTaskParametersProperty {
            private final java.lang.String taskDefinitionArn;
            private final java.lang.Object capacityProviderStrategy;
            private final java.lang.Object enableEcsManagedTags;
            private final java.lang.Object enableExecuteCommand;
            private final java.lang.String group;
            private final java.lang.String launchType;
            private final java.lang.Object networkConfiguration;
            private final java.lang.Object overrides;
            private final java.lang.Object placementConstraints;
            private final java.lang.Object placementStrategy;
            private final java.lang.String platformVersion;
            private final java.lang.String propagateTags;
            private final java.lang.String referenceId;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
            private final java.lang.Number taskCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.taskDefinitionArn = software.amazon.jsii.Kernel.get(this, "taskDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityProviderStrategy = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableEcsManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.group = software.amazon.jsii.Kernel.get(this, "group", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.launchType = software.amazon.jsii.Kernel.get(this, "launchType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.placementStrategy = software.amazon.jsii.Kernel.get(this, "placementStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.referenceId = software.amazon.jsii.Kernel.get(this, "referenceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
                this.taskCount = software.amazon.jsii.Kernel.get(this, "taskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.taskDefinitionArn = java.util.Objects.requireNonNull(builder.taskDefinitionArn, "taskDefinitionArn is required");
                this.capacityProviderStrategy = builder.capacityProviderStrategy;
                this.enableEcsManagedTags = builder.enableEcsManagedTags;
                this.enableExecuteCommand = builder.enableExecuteCommand;
                this.group = builder.group;
                this.launchType = builder.launchType;
                this.networkConfiguration = builder.networkConfiguration;
                this.overrides = builder.overrides;
                this.placementConstraints = builder.placementConstraints;
                this.placementStrategy = builder.placementStrategy;
                this.platformVersion = builder.platformVersion;
                this.propagateTags = builder.propagateTags;
                this.referenceId = builder.referenceId;
                this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
                this.taskCount = builder.taskCount;
            }

            @Override
            public final java.lang.String getTaskDefinitionArn() {
                return this.taskDefinitionArn;
            }

            @Override
            public final java.lang.Object getCapacityProviderStrategy() {
                return this.capacityProviderStrategy;
            }

            @Override
            public final java.lang.Object getEnableEcsManagedTags() {
                return this.enableEcsManagedTags;
            }

            @Override
            public final java.lang.Object getEnableExecuteCommand() {
                return this.enableExecuteCommand;
            }

            @Override
            public final java.lang.String getGroup() {
                return this.group;
            }

            @Override
            public final java.lang.String getLaunchType() {
                return this.launchType;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            public final java.lang.Object getPlacementConstraints() {
                return this.placementConstraints;
            }

            @Override
            public final java.lang.Object getPlacementStrategy() {
                return this.placementStrategy;
            }

            @Override
            public final java.lang.String getPlatformVersion() {
                return this.platformVersion;
            }

            @Override
            public final java.lang.String getPropagateTags() {
                return this.propagateTags;
            }

            @Override
            public final java.lang.String getReferenceId() {
                return this.referenceId;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public final java.lang.Number getTaskCount() {
                return this.taskCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("taskDefinitionArn", om.valueToTree(this.getTaskDefinitionArn()));
                if (this.getCapacityProviderStrategy() != null) {
                    data.set("capacityProviderStrategy", om.valueToTree(this.getCapacityProviderStrategy()));
                }
                if (this.getEnableEcsManagedTags() != null) {
                    data.set("enableEcsManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
                }
                if (this.getEnableExecuteCommand() != null) {
                    data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
                }
                if (this.getGroup() != null) {
                    data.set("group", om.valueToTree(this.getGroup()));
                }
                if (this.getLaunchType() != null) {
                    data.set("launchType", om.valueToTree(this.getLaunchType()));
                }
                if (this.getNetworkConfiguration() != null) {
                    data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }
                if (this.getPlacementConstraints() != null) {
                    data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
                }
                if (this.getPlacementStrategy() != null) {
                    data.set("placementStrategy", om.valueToTree(this.getPlacementStrategy()));
                }
                if (this.getPlatformVersion() != null) {
                    data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
                }
                if (this.getPropagateTags() != null) {
                    data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
                }
                if (this.getReferenceId() != null) {
                    data.set("referenceId", om.valueToTree(this.getReferenceId()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }
                if (this.getTaskCount() != null) {
                    data.set("taskCount", om.valueToTree(this.getTaskCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetEcsTaskParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetEcsTaskParametersProperty.Jsii$Proxy that = (PipeTargetEcsTaskParametersProperty.Jsii$Proxy) o;

                if (!taskDefinitionArn.equals(that.taskDefinitionArn)) return false;
                if (this.capacityProviderStrategy != null ? !this.capacityProviderStrategy.equals(that.capacityProviderStrategy) : that.capacityProviderStrategy != null) return false;
                if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
                if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
                if (this.group != null ? !this.group.equals(that.group) : that.group != null) return false;
                if (this.launchType != null ? !this.launchType.equals(that.launchType) : that.launchType != null) return false;
                if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
                if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) return false;
                if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
                if (this.placementStrategy != null ? !this.placementStrategy.equals(that.placementStrategy) : that.placementStrategy != null) return false;
                if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
                if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
                if (this.referenceId != null ? !this.referenceId.equals(that.referenceId) : that.referenceId != null) return false;
                if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
                return this.taskCount != null ? this.taskCount.equals(that.taskCount) : that.taskCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.taskDefinitionArn.hashCode();
                result = 31 * result + (this.capacityProviderStrategy != null ? this.capacityProviderStrategy.hashCode() : 0);
                result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
                result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
                result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
                result = 31 * result + (this.launchType != null ? this.launchType.hashCode() : 0);
                result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
                result = 31 * result + (this.placementStrategy != null ? this.placementStrategy.hashCode() : 0);
                result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
                result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
                result = 31 * result + (this.referenceId != null ? this.referenceId.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                result = 31 * result + (this.taskCount != null ? this.taskCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using an EventBridge event bus as a target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetEventBridgeEventBusParametersProperty pipeTargetEventBridgeEventBusParametersProperty = PipeTargetEventBridgeEventBusParametersProperty.builder()
     *         .detailType("detailType")
     *         .endpointId("endpointId")
     *         .resources(List.of("resources"))
     *         .source("source")
     *         .time("time")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetEventBridgeEventBusParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetEventBridgeEventBusParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetEventBridgeEventBusParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDetailType() {
            return null;
        }

        /**
         * The URL subdomain of the endpoint.
         * <p>
         * For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is <code>abcde.veo</code> .
         * <p>
         * <blockquote>
         * <p>
         * When using Java, you must include <code>auth-crt</code> on the class path.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointId() {
            return null;
        }

        /**
         * AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns.
         * <p>
         * Any number, including zero, may be present.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
            return null;
        }

        /**
         * The source of the event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * The time stamp of the event, per [RFC3339](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc3339.txt) . If no time stamp is provided, the time stamp of the [PutEvents](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) call is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetEventBridgeEventBusParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetEventBridgeEventBusParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetEventBridgeEventBusParametersProperty> {
            java.lang.String detailType;
            java.lang.String endpointId;
            java.util.List<java.lang.String> resources;
            java.lang.String source;
            java.lang.String time;

            /**
             * Sets the value of {@link PipeTargetEventBridgeEventBusParametersProperty#getDetailType}
             * @param detailType A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder detailType(java.lang.String detailType) {
                this.detailType = detailType;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEventBridgeEventBusParametersProperty#getEndpointId}
             * @param endpointId The URL subdomain of the endpoint.
             *                   For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is <code>abcde.veo</code> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   When using Java, you must include <code>auth-crt</code> on the class path.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointId(java.lang.String endpointId) {
                this.endpointId = endpointId;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEventBridgeEventBusParametersProperty#getResources}
             * @param resources AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns.
             *                  Any number, including zero, may be present.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resources(java.util.List<java.lang.String> resources) {
                this.resources = resources;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEventBridgeEventBusParametersProperty#getSource}
             * @param source The source of the event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetEventBridgeEventBusParametersProperty#getTime}
             * @param time The time stamp of the event, per [RFC3339](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc3339.txt) . If no time stamp is provided, the time stamp of the [PutEvents](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) call is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(java.lang.String time) {
                this.time = time;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetEventBridgeEventBusParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetEventBridgeEventBusParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetEventBridgeEventBusParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetEventBridgeEventBusParametersProperty {
            private final java.lang.String detailType;
            private final java.lang.String endpointId;
            private final java.util.List<java.lang.String> resources;
            private final java.lang.String source;
            private final java.lang.String time;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpointId = software.amazon.jsii.Kernel.get(this, "endpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.time = software.amazon.jsii.Kernel.get(this, "time", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.detailType = builder.detailType;
                this.endpointId = builder.endpointId;
                this.resources = builder.resources;
                this.source = builder.source;
                this.time = builder.time;
            }

            @Override
            public final java.lang.String getDetailType() {
                return this.detailType;
            }

            @Override
            public final java.lang.String getEndpointId() {
                return this.endpointId;
            }

            @Override
            public final java.util.List<java.lang.String> getResources() {
                return this.resources;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTime() {
                return this.time;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDetailType() != null) {
                    data.set("detailType", om.valueToTree(this.getDetailType()));
                }
                if (this.getEndpointId() != null) {
                    data.set("endpointId", om.valueToTree(this.getEndpointId()));
                }
                if (this.getResources() != null) {
                    data.set("resources", om.valueToTree(this.getResources()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }
                if (this.getTime() != null) {
                    data.set("time", om.valueToTree(this.getTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetEventBridgeEventBusParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetEventBridgeEventBusParametersProperty.Jsii$Proxy that = (PipeTargetEventBridgeEventBusParametersProperty.Jsii$Proxy) o;

                if (this.detailType != null ? !this.detailType.equals(that.detailType) : that.detailType != null) return false;
                if (this.endpointId != null ? !this.endpointId.equals(that.endpointId) : that.endpointId != null) return false;
                if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
                if (this.source != null ? !this.source.equals(that.source) : that.source != null) return false;
                return this.time != null ? this.time.equals(that.time) : that.time == null;
            }

            @Override
            public final int hashCode() {
                int result = this.detailType != null ? this.detailType.hashCode() : 0;
                result = 31 * result + (this.endpointId != null ? this.endpointId.hashCode() : 0);
                result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetHttpParametersProperty pipeTargetHttpParametersProperty = PipeTargetHttpParametersProperty.builder()
     *         .headerParameters(Map.of(
     *                 "headerParametersKey", "headerParameters"))
     *         .pathParameterValues(List.of("pathParameterValues"))
     *         .queryStringParameters(Map.of(
     *                 "queryStringParametersKey", "queryStringParameters"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetHttpParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetHttpParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetHttpParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderParameters() {
            return null;
        }

        /**
         * The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathParameterValues() {
            return null;
        }

        /**
         * The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryStringParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetHttpParametersProperty> {
            java.lang.Object headerParameters;
            java.util.List<java.lang.String> pathParameterValues;
            java.lang.Object queryStringParameters;

            /**
             * Sets the value of {@link PipeTargetHttpParametersProperty#getHeaderParameters}
             * @param headerParameters The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(software.amazon.awscdk.core.IResolvable headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetHttpParametersProperty#getHeaderParameters}
             * @param headerParameters The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerParameters(java.util.Map<java.lang.String, java.lang.String> headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetHttpParametersProperty#getPathParameterValues}
             * @param pathParameterValues The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathParameterValues(java.util.List<java.lang.String> pathParameterValues) {
                this.pathParameterValues = pathParameterValues;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetHttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(software.amazon.awscdk.core.IResolvable queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetHttpParametersProperty#getQueryStringParameters}
             * @param queryStringParameters The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringParameters(java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetHttpParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetHttpParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetHttpParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetHttpParametersProperty {
            private final java.lang.Object headerParameters;
            private final java.util.List<java.lang.String> pathParameterValues;
            private final java.lang.Object queryStringParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pathParameterValues = software.amazon.jsii.Kernel.get(this, "pathParameterValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerParameters = builder.headerParameters;
                this.pathParameterValues = builder.pathParameterValues;
                this.queryStringParameters = builder.queryStringParameters;
            }

            @Override
            public final java.lang.Object getHeaderParameters() {
                return this.headerParameters;
            }

            @Override
            public final java.util.List<java.lang.String> getPathParameterValues() {
                return this.pathParameterValues;
            }

            @Override
            public final java.lang.Object getQueryStringParameters() {
                return this.queryStringParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeaderParameters() != null) {
                    data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
                }
                if (this.getPathParameterValues() != null) {
                    data.set("pathParameterValues", om.valueToTree(this.getPathParameterValues()));
                }
                if (this.getQueryStringParameters() != null) {
                    data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetHttpParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetHttpParametersProperty.Jsii$Proxy that = (PipeTargetHttpParametersProperty.Jsii$Proxy) o;

                if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
                if (this.pathParameterValues != null ? !this.pathParameterValues.equals(that.pathParameterValues) : that.pathParameterValues != null) return false;
                return this.queryStringParameters != null ? this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headerParameters != null ? this.headerParameters.hashCode() : 0;
                result = 31 * result + (this.pathParameterValues != null ? this.pathParameterValues.hashCode() : 0);
                result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a Kinesis stream as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetKinesisStreamParametersProperty pipeTargetKinesisStreamParametersProperty = PipeTargetKinesisStreamParametersProperty.builder()
     *         .partitionKey("partitionKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetKinesisStreamParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetKinesisStreamParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetKinesisStreamParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines which shard in the stream the data record is assigned to.
         * <p>
         * Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPartitionKey();

        /**
         * @return a {@link Builder} of {@link PipeTargetKinesisStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetKinesisStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetKinesisStreamParametersProperty> {
            java.lang.String partitionKey;

            /**
             * Sets the value of {@link PipeTargetKinesisStreamParametersProperty#getPartitionKey}
             * @param partitionKey Determines which shard in the stream the data record is assigned to. This parameter is required.
             *                     Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionKey(java.lang.String partitionKey) {
                this.partitionKey = partitionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetKinesisStreamParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetKinesisStreamParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetKinesisStreamParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetKinesisStreamParametersProperty {
            private final java.lang.String partitionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.partitionKey = java.util.Objects.requireNonNull(builder.partitionKey, "partitionKey is required");
            }

            @Override
            public final java.lang.String getPartitionKey() {
                return this.partitionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("partitionKey", om.valueToTree(this.getPartitionKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetKinesisStreamParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetKinesisStreamParametersProperty.Jsii$Proxy that = (PipeTargetKinesisStreamParametersProperty.Jsii$Proxy) o;

                return this.partitionKey.equals(that.partitionKey);
            }

            @Override
            public final int hashCode() {
                int result = this.partitionKey.hashCode();
                return result;
            }
        }
    }
    /**
     * The parameters for using a Lambda function as a target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetLambdaFunctionParametersProperty pipeTargetLambdaFunctionParametersProperty = PipeTargetLambdaFunctionParametersProperty.builder()
     *         .invocationType("invocationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetLambdaFunctionParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetLambdaFunctionParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetLambdaFunctionParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify whether to invoke the function synchronously or asynchronously.
         * <p>
         * <ul>
         * <li><code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.</li>
         * <li><code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option in the <code>InvocationType</code> parameter for the Lambda <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation types</a> in the <em>Amazon EventBridge User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvocationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetLambdaFunctionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetLambdaFunctionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetLambdaFunctionParametersProperty> {
            java.lang.String invocationType;

            /**
             * Sets the value of {@link PipeTargetLambdaFunctionParametersProperty#getInvocationType}
             * @param invocationType Specify whether to invoke the function synchronously or asynchronously.
             *                       <ul>
             *                       <li><code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.</li>
             *                       <li><code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option in the <code>InvocationType</code> parameter for the Lambda <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.</li>
             *                       </ul>
             *                       <p>
             *                       For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation types</a> in the <em>Amazon EventBridge User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationType(java.lang.String invocationType) {
                this.invocationType = invocationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetLambdaFunctionParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetLambdaFunctionParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetLambdaFunctionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetLambdaFunctionParametersProperty {
            private final java.lang.String invocationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.invocationType = software.amazon.jsii.Kernel.get(this, "invocationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.invocationType = builder.invocationType;
            }

            @Override
            public final java.lang.String getInvocationType() {
                return this.invocationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInvocationType() != null) {
                    data.set("invocationType", om.valueToTree(this.getInvocationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetLambdaFunctionParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetLambdaFunctionParametersProperty.Jsii$Proxy that = (PipeTargetLambdaFunctionParametersProperty.Jsii$Proxy) o;

                return this.invocationType != null ? this.invocationType.equals(that.invocationType) : that.invocationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.invocationType != null ? this.invocationType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The parameters required to set up a target for your pipe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetParametersProperty pipeTargetParametersProperty = PipeTargetParametersProperty.builder()
     *         .batchJobParameters(PipeTargetBatchJobParametersProperty.builder()
     *                 .jobDefinition("jobDefinition")
     *                 .jobName("jobName")
     *                 // the properties below are optional
     *                 .arrayProperties(BatchArrayPropertiesProperty.builder()
     *                         .size(123)
     *                         .build())
     *                 .containerOverrides(BatchContainerOverridesProperty.builder()
     *                         .command(List.of("command"))
     *                         .environment(List.of(BatchEnvironmentVariableProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .instanceType("instanceType")
     *                         .resourceRequirements(List.of(BatchResourceRequirementProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .dependsOn(List.of(BatchJobDependencyProperty.builder()
     *                         .jobId("jobId")
     *                         .type("type")
     *                         .build()))
     *                 .parameters(Map.of(
     *                         "parametersKey", "parameters"))
     *                 .retryStrategy(BatchRetryStrategyProperty.builder()
     *                         .attempts(123)
     *                         .build())
     *                 .build())
     *         .cloudWatchLogsParameters(PipeTargetCloudWatchLogsParametersProperty.builder()
     *                 .logStreamName("logStreamName")
     *                 .timestamp("timestamp")
     *                 .build())
     *         .ecsTaskParameters(PipeTargetEcsTaskParametersProperty.builder()
     *                 .taskDefinitionArn("taskDefinitionArn")
     *                 // the properties below are optional
     *                 .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
     *                         .capacityProvider("capacityProvider")
     *                         // the properties below are optional
     *                         .base(123)
     *                         .weight(123)
     *                         .build()))
     *                 .enableEcsManagedTags(false)
     *                 .enableExecuteCommand(false)
     *                 .group("group")
     *                 .launchType("launchType")
     *                 .networkConfiguration(NetworkConfigurationProperty.builder()
     *                         .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                                 .subnets(List.of("subnets"))
     *                                 // the properties below are optional
     *                                 .assignPublicIp("assignPublicIp")
     *                                 .securityGroups(List.of("securityGroups"))
     *                                 .build())
     *                         .build())
     *                 .overrides(EcsTaskOverrideProperty.builder()
     *                         .containerOverrides(List.of(EcsContainerOverrideProperty.builder()
     *                                 .command(List.of("command"))
     *                                 .cpu(123)
     *                                 .environment(List.of(EcsEnvironmentVariableProperty.builder()
     *                                         .name("name")
     *                                         .value("value")
     *                                         .build()))
     *                                 .environmentFiles(List.of(EcsEnvironmentFileProperty.builder()
     *                                         .type("type")
     *                                         .value("value")
     *                                         .build()))
     *                                 .memory(123)
     *                                 .memoryReservation(123)
     *                                 .name("name")
     *                                 .resourceRequirements(List.of(EcsResourceRequirementProperty.builder()
     *                                         .type("type")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build()))
     *                         .cpu("cpu")
     *                         .ephemeralStorage(EcsEphemeralStorageProperty.builder()
     *                                 .sizeInGiB(123)
     *                                 .build())
     *                         .executionRoleArn("executionRoleArn")
     *                         .inferenceAcceleratorOverrides(List.of(EcsInferenceAcceleratorOverrideProperty.builder()
     *                                 .deviceName("deviceName")
     *                                 .deviceType("deviceType")
     *                                 .build()))
     *                         .memory("memory")
     *                         .taskRoleArn("taskRoleArn")
     *                         .build())
     *                 .placementConstraints(List.of(PlacementConstraintProperty.builder()
     *                         .expression("expression")
     *                         .type("type")
     *                         .build()))
     *                 .placementStrategy(List.of(PlacementStrategyProperty.builder()
     *                         .field("field")
     *                         .type("type")
     *                         .build()))
     *                 .platformVersion("platformVersion")
     *                 .propagateTags("propagateTags")
     *                 .referenceId("referenceId")
     *                 .tags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .taskCount(123)
     *                 .build())
     *         .eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParametersProperty.builder()
     *                 .detailType("detailType")
     *                 .endpointId("endpointId")
     *                 .resources(List.of("resources"))
     *                 .source("source")
     *                 .time("time")
     *                 .build())
     *         .httpParameters(PipeTargetHttpParametersProperty.builder()
     *                 .headerParameters(Map.of(
     *                         "headerParametersKey", "headerParameters"))
     *                 .pathParameterValues(List.of("pathParameterValues"))
     *                 .queryStringParameters(Map.of(
     *                         "queryStringParametersKey", "queryStringParameters"))
     *                 .build())
     *         .inputTemplate("inputTemplate")
     *         .kinesisStreamParameters(PipeTargetKinesisStreamParametersProperty.builder()
     *                 .partitionKey("partitionKey")
     *                 .build())
     *         .lambdaFunctionParameters(PipeTargetLambdaFunctionParametersProperty.builder()
     *                 .invocationType("invocationType")
     *                 .build())
     *         .redshiftDataParameters(PipeTargetRedshiftDataParametersProperty.builder()
     *                 .database("database")
     *                 .sqls(List.of("sqls"))
     *                 // the properties below are optional
     *                 .dbUser("dbUser")
     *                 .secretManagerArn("secretManagerArn")
     *                 .statementName("statementName")
     *                 .withEvent(false)
     *                 .build())
     *         .sageMakerPipelineParameters(PipeTargetSageMakerPipelineParametersProperty.builder()
     *                 .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .sqsQueueParameters(PipeTargetSqsQueueParametersProperty.builder()
     *                 .messageDeduplicationId("messageDeduplicationId")
     *                 .messageGroupId("messageGroupId")
     *                 .build())
     *         .stepFunctionStateMachineParameters(PipeTargetStateMachineParametersProperty.builder()
     *                 .invocationType("invocationType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for using an AWS Batch job as a target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchJobParameters() {
            return null;
        }

        /**
         * The parameters for using an CloudWatch Logs log stream as a target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogsParameters() {
            return null;
        }

        /**
         * The parameters for using an Amazon ECS task as a target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcsTaskParameters() {
            return null;
        }

        /**
         * The parameters for using an EventBridge event bus as a target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeEventBusParameters() {
            return null;
        }

        /**
         * These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpParameters() {
            return null;
        }

        /**
         * Valid JSON text passed to the target.
         * <p>
         * In this case, nothing from the event itself is passed to the target. For more information, see <a href="https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputTemplate() {
            return null;
        }

        /**
         * The parameters for using a Kinesis stream as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamParameters() {
            return null;
        }

        /**
         * The parameters for using a Lambda function as a target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunctionParameters() {
            return null;
        }

        /**
         * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftDataParameters() {
            return null;
        }

        /**
         * The parameters for using a SageMaker pipeline as a target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSageMakerPipelineParameters() {
            return null;
        }

        /**
         * The parameters for using a Amazon SQS stream as a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsQueueParameters() {
            return null;
        }

        /**
         * The parameters for using a Step Functions state machine as a target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepFunctionStateMachineParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetParametersProperty> {
            java.lang.Object batchJobParameters;
            java.lang.Object cloudWatchLogsParameters;
            java.lang.Object ecsTaskParameters;
            java.lang.Object eventBridgeEventBusParameters;
            java.lang.Object httpParameters;
            java.lang.String inputTemplate;
            java.lang.Object kinesisStreamParameters;
            java.lang.Object lambdaFunctionParameters;
            java.lang.Object redshiftDataParameters;
            java.lang.Object sageMakerPipelineParameters;
            java.lang.Object sqsQueueParameters;
            java.lang.Object stepFunctionStateMachineParameters;

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getBatchJobParameters}
             * @param batchJobParameters The parameters for using an AWS Batch job as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchJobParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetBatchJobParametersProperty batchJobParameters) {
                this.batchJobParameters = batchJobParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getBatchJobParameters}
             * @param batchJobParameters The parameters for using an AWS Batch job as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchJobParameters(software.amazon.awscdk.core.IResolvable batchJobParameters) {
                this.batchJobParameters = batchJobParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getCloudWatchLogsParameters}
             * @param cloudWatchLogsParameters The parameters for using an CloudWatch Logs log stream as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetCloudWatchLogsParametersProperty cloudWatchLogsParameters) {
                this.cloudWatchLogsParameters = cloudWatchLogsParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getCloudWatchLogsParameters}
             * @param cloudWatchLogsParameters The parameters for using an CloudWatch Logs log stream as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsParameters(software.amazon.awscdk.core.IResolvable cloudWatchLogsParameters) {
                this.cloudWatchLogsParameters = cloudWatchLogsParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getEcsTaskParameters}
             * @param ecsTaskParameters The parameters for using an Amazon ECS task as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsTaskParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetEcsTaskParametersProperty ecsTaskParameters) {
                this.ecsTaskParameters = ecsTaskParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getEcsTaskParameters}
             * @param ecsTaskParameters The parameters for using an Amazon ECS task as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsTaskParameters(software.amazon.awscdk.core.IResolvable ecsTaskParameters) {
                this.ecsTaskParameters = ecsTaskParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getEventBridgeEventBusParameters}
             * @param eventBridgeEventBusParameters The parameters for using an EventBridge event bus as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeEventBusParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetEventBridgeEventBusParametersProperty eventBridgeEventBusParameters) {
                this.eventBridgeEventBusParameters = eventBridgeEventBusParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getEventBridgeEventBusParameters}
             * @param eventBridgeEventBusParameters The parameters for using an EventBridge event bus as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeEventBusParameters(software.amazon.awscdk.core.IResolvable eventBridgeEventBusParameters) {
                this.eventBridgeEventBusParameters = eventBridgeEventBusParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getHttpParameters}
             * @param httpParameters These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetHttpParametersProperty httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getHttpParameters}
             * @param httpParameters These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpParameters(software.amazon.awscdk.core.IResolvable httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getInputTemplate}
             * @param inputTemplate Valid JSON text passed to the target.
             *                      In this case, nothing from the event itself is passed to the target. For more information, see <a href="https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputTemplate(java.lang.String inputTemplate) {
                this.inputTemplate = inputTemplate;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getKinesisStreamParameters}
             * @param kinesisStreamParameters The parameters for using a Kinesis stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetKinesisStreamParametersProperty kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getKinesisStreamParameters}
             * @param kinesisStreamParameters The parameters for using a Kinesis stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamParameters(software.amazon.awscdk.core.IResolvable kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getLambdaFunctionParameters}
             * @param lambdaFunctionParameters The parameters for using a Lambda function as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetLambdaFunctionParametersProperty lambdaFunctionParameters) {
                this.lambdaFunctionParameters = lambdaFunctionParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getLambdaFunctionParameters}
             * @param lambdaFunctionParameters The parameters for using a Lambda function as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionParameters(software.amazon.awscdk.core.IResolvable lambdaFunctionParameters) {
                this.lambdaFunctionParameters = lambdaFunctionParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getRedshiftDataParameters}
             * @param redshiftDataParameters These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftDataParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetRedshiftDataParametersProperty redshiftDataParameters) {
                this.redshiftDataParameters = redshiftDataParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getRedshiftDataParameters}
             * @param redshiftDataParameters These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftDataParameters(software.amazon.awscdk.core.IResolvable redshiftDataParameters) {
                this.redshiftDataParameters = redshiftDataParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getSageMakerPipelineParameters}
             * @param sageMakerPipelineParameters The parameters for using a SageMaker pipeline as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerPipelineParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetSageMakerPipelineParametersProperty sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getSageMakerPipelineParameters}
             * @param sageMakerPipelineParameters The parameters for using a SageMaker pipeline as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerPipelineParameters(software.amazon.awscdk.core.IResolvable sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getSqsQueueParameters}
             * @param sqsQueueParameters The parameters for using a Amazon SQS stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsQueueParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetSqsQueueParametersProperty sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getSqsQueueParameters}
             * @param sqsQueueParameters The parameters for using a Amazon SQS stream as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsQueueParameters(software.amazon.awscdk.core.IResolvable sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getStepFunctionStateMachineParameters}
             * @param stepFunctionStateMachineParameters The parameters for using a Step Functions state machine as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionStateMachineParameters(software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetStateMachineParametersProperty stepFunctionStateMachineParameters) {
                this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetParametersProperty#getStepFunctionStateMachineParameters}
             * @param stepFunctionStateMachineParameters The parameters for using a Step Functions state machine as a target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctionStateMachineParameters(software.amazon.awscdk.core.IResolvable stepFunctionStateMachineParameters) {
                this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetParametersProperty {
            private final java.lang.Object batchJobParameters;
            private final java.lang.Object cloudWatchLogsParameters;
            private final java.lang.Object ecsTaskParameters;
            private final java.lang.Object eventBridgeEventBusParameters;
            private final java.lang.Object httpParameters;
            private final java.lang.String inputTemplate;
            private final java.lang.Object kinesisStreamParameters;
            private final java.lang.Object lambdaFunctionParameters;
            private final java.lang.Object redshiftDataParameters;
            private final java.lang.Object sageMakerPipelineParameters;
            private final java.lang.Object sqsQueueParameters;
            private final java.lang.Object stepFunctionStateMachineParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.batchJobParameters = software.amazon.jsii.Kernel.get(this, "batchJobParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLogsParameters = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecsTaskParameters = software.amazon.jsii.Kernel.get(this, "ecsTaskParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBridgeEventBusParameters = software.amazon.jsii.Kernel.get(this, "eventBridgeEventBusParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpParameters = software.amazon.jsii.Kernel.get(this, "httpParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputTemplate = software.amazon.jsii.Kernel.get(this, "inputTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kinesisStreamParameters = software.amazon.jsii.Kernel.get(this, "kinesisStreamParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionParameters = software.amazon.jsii.Kernel.get(this, "lambdaFunctionParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftDataParameters = software.amazon.jsii.Kernel.get(this, "redshiftDataParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sageMakerPipelineParameters = software.amazon.jsii.Kernel.get(this, "sageMakerPipelineParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsQueueParameters = software.amazon.jsii.Kernel.get(this, "sqsQueueParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stepFunctionStateMachineParameters = software.amazon.jsii.Kernel.get(this, "stepFunctionStateMachineParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.batchJobParameters = builder.batchJobParameters;
                this.cloudWatchLogsParameters = builder.cloudWatchLogsParameters;
                this.ecsTaskParameters = builder.ecsTaskParameters;
                this.eventBridgeEventBusParameters = builder.eventBridgeEventBusParameters;
                this.httpParameters = builder.httpParameters;
                this.inputTemplate = builder.inputTemplate;
                this.kinesisStreamParameters = builder.kinesisStreamParameters;
                this.lambdaFunctionParameters = builder.lambdaFunctionParameters;
                this.redshiftDataParameters = builder.redshiftDataParameters;
                this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
                this.sqsQueueParameters = builder.sqsQueueParameters;
                this.stepFunctionStateMachineParameters = builder.stepFunctionStateMachineParameters;
            }

            @Override
            public final java.lang.Object getBatchJobParameters() {
                return this.batchJobParameters;
            }

            @Override
            public final java.lang.Object getCloudWatchLogsParameters() {
                return this.cloudWatchLogsParameters;
            }

            @Override
            public final java.lang.Object getEcsTaskParameters() {
                return this.ecsTaskParameters;
            }

            @Override
            public final java.lang.Object getEventBridgeEventBusParameters() {
                return this.eventBridgeEventBusParameters;
            }

            @Override
            public final java.lang.Object getHttpParameters() {
                return this.httpParameters;
            }

            @Override
            public final java.lang.String getInputTemplate() {
                return this.inputTemplate;
            }

            @Override
            public final java.lang.Object getKinesisStreamParameters() {
                return this.kinesisStreamParameters;
            }

            @Override
            public final java.lang.Object getLambdaFunctionParameters() {
                return this.lambdaFunctionParameters;
            }

            @Override
            public final java.lang.Object getRedshiftDataParameters() {
                return this.redshiftDataParameters;
            }

            @Override
            public final java.lang.Object getSageMakerPipelineParameters() {
                return this.sageMakerPipelineParameters;
            }

            @Override
            public final java.lang.Object getSqsQueueParameters() {
                return this.sqsQueueParameters;
            }

            @Override
            public final java.lang.Object getStepFunctionStateMachineParameters() {
                return this.stepFunctionStateMachineParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBatchJobParameters() != null) {
                    data.set("batchJobParameters", om.valueToTree(this.getBatchJobParameters()));
                }
                if (this.getCloudWatchLogsParameters() != null) {
                    data.set("cloudWatchLogsParameters", om.valueToTree(this.getCloudWatchLogsParameters()));
                }
                if (this.getEcsTaskParameters() != null) {
                    data.set("ecsTaskParameters", om.valueToTree(this.getEcsTaskParameters()));
                }
                if (this.getEventBridgeEventBusParameters() != null) {
                    data.set("eventBridgeEventBusParameters", om.valueToTree(this.getEventBridgeEventBusParameters()));
                }
                if (this.getHttpParameters() != null) {
                    data.set("httpParameters", om.valueToTree(this.getHttpParameters()));
                }
                if (this.getInputTemplate() != null) {
                    data.set("inputTemplate", om.valueToTree(this.getInputTemplate()));
                }
                if (this.getKinesisStreamParameters() != null) {
                    data.set("kinesisStreamParameters", om.valueToTree(this.getKinesisStreamParameters()));
                }
                if (this.getLambdaFunctionParameters() != null) {
                    data.set("lambdaFunctionParameters", om.valueToTree(this.getLambdaFunctionParameters()));
                }
                if (this.getRedshiftDataParameters() != null) {
                    data.set("redshiftDataParameters", om.valueToTree(this.getRedshiftDataParameters()));
                }
                if (this.getSageMakerPipelineParameters() != null) {
                    data.set("sageMakerPipelineParameters", om.valueToTree(this.getSageMakerPipelineParameters()));
                }
                if (this.getSqsQueueParameters() != null) {
                    data.set("sqsQueueParameters", om.valueToTree(this.getSqsQueueParameters()));
                }
                if (this.getStepFunctionStateMachineParameters() != null) {
                    data.set("stepFunctionStateMachineParameters", om.valueToTree(this.getStepFunctionStateMachineParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetParametersProperty.Jsii$Proxy that = (PipeTargetParametersProperty.Jsii$Proxy) o;

                if (this.batchJobParameters != null ? !this.batchJobParameters.equals(that.batchJobParameters) : that.batchJobParameters != null) return false;
                if (this.cloudWatchLogsParameters != null ? !this.cloudWatchLogsParameters.equals(that.cloudWatchLogsParameters) : that.cloudWatchLogsParameters != null) return false;
                if (this.ecsTaskParameters != null ? !this.ecsTaskParameters.equals(that.ecsTaskParameters) : that.ecsTaskParameters != null) return false;
                if (this.eventBridgeEventBusParameters != null ? !this.eventBridgeEventBusParameters.equals(that.eventBridgeEventBusParameters) : that.eventBridgeEventBusParameters != null) return false;
                if (this.httpParameters != null ? !this.httpParameters.equals(that.httpParameters) : that.httpParameters != null) return false;
                if (this.inputTemplate != null ? !this.inputTemplate.equals(that.inputTemplate) : that.inputTemplate != null) return false;
                if (this.kinesisStreamParameters != null ? !this.kinesisStreamParameters.equals(that.kinesisStreamParameters) : that.kinesisStreamParameters != null) return false;
                if (this.lambdaFunctionParameters != null ? !this.lambdaFunctionParameters.equals(that.lambdaFunctionParameters) : that.lambdaFunctionParameters != null) return false;
                if (this.redshiftDataParameters != null ? !this.redshiftDataParameters.equals(that.redshiftDataParameters) : that.redshiftDataParameters != null) return false;
                if (this.sageMakerPipelineParameters != null ? !this.sageMakerPipelineParameters.equals(that.sageMakerPipelineParameters) : that.sageMakerPipelineParameters != null) return false;
                if (this.sqsQueueParameters != null ? !this.sqsQueueParameters.equals(that.sqsQueueParameters) : that.sqsQueueParameters != null) return false;
                return this.stepFunctionStateMachineParameters != null ? this.stepFunctionStateMachineParameters.equals(that.stepFunctionStateMachineParameters) : that.stepFunctionStateMachineParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.batchJobParameters != null ? this.batchJobParameters.hashCode() : 0;
                result = 31 * result + (this.cloudWatchLogsParameters != null ? this.cloudWatchLogsParameters.hashCode() : 0);
                result = 31 * result + (this.ecsTaskParameters != null ? this.ecsTaskParameters.hashCode() : 0);
                result = 31 * result + (this.eventBridgeEventBusParameters != null ? this.eventBridgeEventBusParameters.hashCode() : 0);
                result = 31 * result + (this.httpParameters != null ? this.httpParameters.hashCode() : 0);
                result = 31 * result + (this.inputTemplate != null ? this.inputTemplate.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamParameters != null ? this.kinesisStreamParameters.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionParameters != null ? this.lambdaFunctionParameters.hashCode() : 0);
                result = 31 * result + (this.redshiftDataParameters != null ? this.redshiftDataParameters.hashCode() : 0);
                result = 31 * result + (this.sageMakerPipelineParameters != null ? this.sageMakerPipelineParameters.hashCode() : 0);
                result = 31 * result + (this.sqsQueueParameters != null ? this.sqsQueueParameters.hashCode() : 0);
                result = 31 * result + (this.stepFunctionStateMachineParameters != null ? this.stepFunctionStateMachineParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetRedshiftDataParametersProperty pipeTargetRedshiftDataParametersProperty = PipeTargetRedshiftDataParametersProperty.builder()
     *         .database("database")
     *         .sqls(List.of("sqls"))
     *         // the properties below are optional
     *         .dbUser("dbUser")
     *         .secretManagerArn("secretManagerArn")
     *         .statementName("statementName")
     *         .withEvent(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetRedshiftDataParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetRedshiftDataParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetRedshiftDataParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the database.
         * <p>
         * Required when authenticating using temporary credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * The SQL statement text to run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSqls();

        /**
         * The database user name.
         * <p>
         * Required when authenticating using temporary credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDbUser() {
            return null;
        }

        /**
         * The name or ARN of the secret that enables access to the database.
         * <p>
         * Required when authenticating using Secrets Manager .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretManagerArn() {
            return null;
        }

        /**
         * The name of the SQL statement.
         * <p>
         * You can name the SQL statement when you create it to identify the query.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatementName() {
            return null;
        }

        /**
         * Indicates whether to send an event back to EventBridge after the SQL statement runs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWithEvent() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetRedshiftDataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetRedshiftDataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetRedshiftDataParametersProperty> {
            java.lang.String database;
            java.util.List<java.lang.String> sqls;
            java.lang.String dbUser;
            java.lang.String secretManagerArn;
            java.lang.String statementName;
            java.lang.Object withEvent;

            /**
             * Sets the value of {@link PipeTargetRedshiftDataParametersProperty#getDatabase}
             * @param database The name of the database. This parameter is required.
             *                 Required when authenticating using temporary credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetRedshiftDataParametersProperty#getSqls}
             * @param sqls The SQL statement text to run. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqls(java.util.List<java.lang.String> sqls) {
                this.sqls = sqls;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetRedshiftDataParametersProperty#getDbUser}
             * @param dbUser The database user name.
             *               Required when authenticating using temporary credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbUser(java.lang.String dbUser) {
                this.dbUser = dbUser;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetRedshiftDataParametersProperty#getSecretManagerArn}
             * @param secretManagerArn The name or ARN of the secret that enables access to the database.
             *                         Required when authenticating using Secrets Manager .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretManagerArn(java.lang.String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetRedshiftDataParametersProperty#getStatementName}
             * @param statementName The name of the SQL statement.
             *                      You can name the SQL statement when you create it to identify the query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statementName(java.lang.String statementName) {
                this.statementName = statementName;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetRedshiftDataParametersProperty#getWithEvent}
             * @param withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEvent(java.lang.Boolean withEvent) {
                this.withEvent = withEvent;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetRedshiftDataParametersProperty#getWithEvent}
             * @param withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEvent(software.amazon.awscdk.core.IResolvable withEvent) {
                this.withEvent = withEvent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetRedshiftDataParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetRedshiftDataParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetRedshiftDataParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetRedshiftDataParametersProperty {
            private final java.lang.String database;
            private final java.util.List<java.lang.String> sqls;
            private final java.lang.String dbUser;
            private final java.lang.String secretManagerArn;
            private final java.lang.String statementName;
            private final java.lang.Object withEvent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqls = software.amazon.jsii.Kernel.get(this, "sqls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.dbUser = software.amazon.jsii.Kernel.get(this, "dbUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretManagerArn = software.amazon.jsii.Kernel.get(this, "secretManagerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statementName = software.amazon.jsii.Kernel.get(this, "statementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.withEvent = software.amazon.jsii.Kernel.get(this, "withEvent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.sqls = java.util.Objects.requireNonNull(builder.sqls, "sqls is required");
                this.dbUser = builder.dbUser;
                this.secretManagerArn = builder.secretManagerArn;
                this.statementName = builder.statementName;
                this.withEvent = builder.withEvent;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.util.List<java.lang.String> getSqls() {
                return this.sqls;
            }

            @Override
            public final java.lang.String getDbUser() {
                return this.dbUser;
            }

            @Override
            public final java.lang.String getSecretManagerArn() {
                return this.secretManagerArn;
            }

            @Override
            public final java.lang.String getStatementName() {
                return this.statementName;
            }

            @Override
            public final java.lang.Object getWithEvent() {
                return this.withEvent;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("sqls", om.valueToTree(this.getSqls()));
                if (this.getDbUser() != null) {
                    data.set("dbUser", om.valueToTree(this.getDbUser()));
                }
                if (this.getSecretManagerArn() != null) {
                    data.set("secretManagerArn", om.valueToTree(this.getSecretManagerArn()));
                }
                if (this.getStatementName() != null) {
                    data.set("statementName", om.valueToTree(this.getStatementName()));
                }
                if (this.getWithEvent() != null) {
                    data.set("withEvent", om.valueToTree(this.getWithEvent()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetRedshiftDataParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetRedshiftDataParametersProperty.Jsii$Proxy that = (PipeTargetRedshiftDataParametersProperty.Jsii$Proxy) o;

                if (!database.equals(that.database)) return false;
                if (!sqls.equals(that.sqls)) return false;
                if (this.dbUser != null ? !this.dbUser.equals(that.dbUser) : that.dbUser != null) return false;
                if (this.secretManagerArn != null ? !this.secretManagerArn.equals(that.secretManagerArn) : that.secretManagerArn != null) return false;
                if (this.statementName != null ? !this.statementName.equals(that.statementName) : that.statementName != null) return false;
                return this.withEvent != null ? this.withEvent.equals(that.withEvent) : that.withEvent == null;
            }

            @Override
            public final int hashCode() {
                int result = this.database.hashCode();
                result = 31 * result + (this.sqls.hashCode());
                result = 31 * result + (this.dbUser != null ? this.dbUser.hashCode() : 0);
                result = 31 * result + (this.secretManagerArn != null ? this.secretManagerArn.hashCode() : 0);
                result = 31 * result + (this.statementName != null ? this.statementName.hashCode() : 0);
                result = 31 * result + (this.withEvent != null ? this.withEvent.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a SageMaker pipeline as a target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetSageMakerPipelineParametersProperty pipeTargetSageMakerPipelineParametersProperty = PipeTargetSageMakerPipelineParametersProperty.builder()
     *         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetSageMakerPipelineParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetSageMakerPipelineParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetSageMakerPipelineParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of Parameter names and values for SageMaker Model Building Pipeline execution.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPipelineParameterList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetSageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetSageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetSageMakerPipelineParametersProperty> {
            java.lang.Object pipelineParameterList;

            /**
             * Sets the value of {@link PipeTargetSageMakerPipelineParametersProperty#getPipelineParameterList}
             * @param pipelineParameterList List of Parameter names and values for SageMaker Model Building Pipeline execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineParameterList(software.amazon.awscdk.core.IResolvable pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetSageMakerPipelineParametersProperty#getPipelineParameterList}
             * @param pipelineParameterList List of Parameter names and values for SageMaker Model Building Pipeline execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineParameterList(java.util.List<? extends java.lang.Object> pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetSageMakerPipelineParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetSageMakerPipelineParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetSageMakerPipelineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetSageMakerPipelineParametersProperty {
            private final java.lang.Object pipelineParameterList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pipelineParameterList = software.amazon.jsii.Kernel.get(this, "pipelineParameterList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pipelineParameterList = builder.pipelineParameterList;
            }

            @Override
            public final java.lang.Object getPipelineParameterList() {
                return this.pipelineParameterList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPipelineParameterList() != null) {
                    data.set("pipelineParameterList", om.valueToTree(this.getPipelineParameterList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetSageMakerPipelineParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetSageMakerPipelineParametersProperty.Jsii$Proxy that = (PipeTargetSageMakerPipelineParametersProperty.Jsii$Proxy) o;

                return this.pipelineParameterList != null ? this.pipelineParameterList.equals(that.pipelineParameterList) : that.pipelineParameterList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pipelineParameterList != null ? this.pipelineParameterList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The parameters for using a Amazon SQS stream as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetSqsQueueParametersProperty pipeTargetSqsQueueParametersProperty = PipeTargetSqsQueueParametersProperty.builder()
     *         .messageDeduplicationId("messageDeduplicationId")
     *         .messageGroupId("messageGroupId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetSqsQueueParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetSqsQueueParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetSqsQueueParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This parameter applies only to FIFO (first-in-first-out) queues.
         * <p>
         * The token used for deduplication of sent messages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageDeduplicationId() {
            return null;
        }

        /**
         * The FIFO message group ID to use as the target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageGroupId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetSqsQueueParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetSqsQueueParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetSqsQueueParametersProperty> {
            java.lang.String messageDeduplicationId;
            java.lang.String messageGroupId;

            /**
             * Sets the value of {@link PipeTargetSqsQueueParametersProperty#getMessageDeduplicationId}
             * @param messageDeduplicationId This parameter applies only to FIFO (first-in-first-out) queues.
             *                               The token used for deduplication of sent messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageDeduplicationId(java.lang.String messageDeduplicationId) {
                this.messageDeduplicationId = messageDeduplicationId;
                return this;
            }

            /**
             * Sets the value of {@link PipeTargetSqsQueueParametersProperty#getMessageGroupId}
             * @param messageGroupId The FIFO message group ID to use as the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupId(java.lang.String messageGroupId) {
                this.messageGroupId = messageGroupId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetSqsQueueParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetSqsQueueParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetSqsQueueParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetSqsQueueParametersProperty {
            private final java.lang.String messageDeduplicationId;
            private final java.lang.String messageGroupId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.messageDeduplicationId = software.amazon.jsii.Kernel.get(this, "messageDeduplicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageGroupId = software.amazon.jsii.Kernel.get(this, "messageGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.messageDeduplicationId = builder.messageDeduplicationId;
                this.messageGroupId = builder.messageGroupId;
            }

            @Override
            public final java.lang.String getMessageDeduplicationId() {
                return this.messageDeduplicationId;
            }

            @Override
            public final java.lang.String getMessageGroupId() {
                return this.messageGroupId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMessageDeduplicationId() != null) {
                    data.set("messageDeduplicationId", om.valueToTree(this.getMessageDeduplicationId()));
                }
                if (this.getMessageGroupId() != null) {
                    data.set("messageGroupId", om.valueToTree(this.getMessageGroupId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetSqsQueueParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetSqsQueueParametersProperty.Jsii$Proxy that = (PipeTargetSqsQueueParametersProperty.Jsii$Proxy) o;

                if (this.messageDeduplicationId != null ? !this.messageDeduplicationId.equals(that.messageDeduplicationId) : that.messageDeduplicationId != null) return false;
                return this.messageGroupId != null ? this.messageGroupId.equals(that.messageGroupId) : that.messageGroupId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.messageDeduplicationId != null ? this.messageDeduplicationId.hashCode() : 0;
                result = 31 * result + (this.messageGroupId != null ? this.messageGroupId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters for using a Step Functions state machine as a target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PipeTargetStateMachineParametersProperty pipeTargetStateMachineParametersProperty = PipeTargetStateMachineParametersProperty.builder()
     *         .invocationType("invocationType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PipeTargetStateMachineParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(PipeTargetStateMachineParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipeTargetStateMachineParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify whether to invoke the Step Functions state machine synchronously or asynchronously.
         * <p>
         * <ul>
         * <li><code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartSyncExecution.html">StartSyncExecution</a> in the <em>AWS Step Functions API Reference</em> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * <code>REQUEST_RESPONSE</code> is not supported for <code>STANDARD</code> state machine workflows.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><code>FIRE_AND_FORGET</code> - Invoke asynchronously. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> in the <em>AWS Step Functions API Reference</em> .</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation types</a> in the <em>Amazon EventBridge User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvocationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipeTargetStateMachineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipeTargetStateMachineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipeTargetStateMachineParametersProperty> {
            java.lang.String invocationType;

            /**
             * Sets the value of {@link PipeTargetStateMachineParametersProperty#getInvocationType}
             * @param invocationType Specify whether to invoke the Step Functions state machine synchronously or asynchronously.
             *                       <ul>
             *                       <li><code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartSyncExecution.html">StartSyncExecution</a> in the <em>AWS Step Functions API Reference</em> .</li>
             *                       </ul>
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       <code>REQUEST_RESPONSE</code> is not supported for <code>STANDARD</code> state machine workflows.
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       <ul>
             *                       <li><code>FIRE_AND_FORGET</code> - Invoke asynchronously. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> in the <em>AWS Step Functions API Reference</em> .</li>
             *                       </ul>
             *                       <p>
             *                       For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation types</a> in the <em>Amazon EventBridge User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationType(java.lang.String invocationType) {
                this.invocationType = invocationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipeTargetStateMachineParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipeTargetStateMachineParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipeTargetStateMachineParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipeTargetStateMachineParametersProperty {
            private final java.lang.String invocationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.invocationType = software.amazon.jsii.Kernel.get(this, "invocationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.invocationType = builder.invocationType;
            }

            @Override
            public final java.lang.String getInvocationType() {
                return this.invocationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInvocationType() != null) {
                    data.set("invocationType", om.valueToTree(this.getInvocationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PipeTargetStateMachineParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipeTargetStateMachineParametersProperty.Jsii$Proxy that = (PipeTargetStateMachineParametersProperty.Jsii$Proxy) o;

                return this.invocationType != null ? this.invocationType.equals(that.invocationType) : that.invocationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.invocationType != null ? this.invocationType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object representing a constraint on task placement.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints</a> in the Amazon Elastic Container Service Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PlacementConstraintProperty placementConstraintProperty = PlacementConstraintProperty.builder()
     *         .expression("expression")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementConstraintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementConstraintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A cluster query language expression to apply to the constraint.
         * <p>
         * You cannot specify an expression if the constraint type is <code>distinctInstance</code> . To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * The type of constraint.
         * <p>
         * Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            java.lang.String expression;
            java.lang.String type;

            /**
             * Sets the value of {@link PlacementConstraintProperty#getExpression}
             * @param expression A cluster query language expression to apply to the constraint.
             *                   You cannot specify an expression if the constraint type is <code>distinctInstance</code> . To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link PlacementConstraintProperty#getType}
             * @param type The type of constraint.
             *             Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementConstraintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementConstraintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementConstraintProperty {
            private final java.lang.String expression;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = builder.expression;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PlacementConstraintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementConstraintProperty.Jsii$Proxy that = (PlacementConstraintProperty.Jsii$Proxy) o;

                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression != null ? this.expression.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The task placement strategy for a task or service.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the Amazon Elastic Container Service Service Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * PlacementStrategyProperty placementStrategyProperty = PlacementStrategyProperty.builder()
     *         .field("field")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The field to apply the placement strategy against.
         * <p>
         * For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * The type of placement strategy.
         * <p>
         * The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            java.lang.String field;
            java.lang.String type;

            /**
             * Sets the value of {@link PlacementStrategyProperty#getField}
             * @param field The field to apply the placement strategy against.
             *              For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link PlacementStrategyProperty#getType}
             * @param type The type of placement strategy.
             *             The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementStrategyProperty {
            private final java.lang.String field;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = builder.field;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.PlacementStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementStrategyProperty.Jsii$Proxy that = (PlacementStrategyProperty.Jsii$Proxy) o;

                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field != null ? this.field.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * SageMakerPipelineParameterProperty sageMakerPipelineParameterProperty = SageMakerPipelineParameterProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.SageMakerPipelineParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(SageMakerPipelineParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SageMakerPipelineParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of parameter to start execution of a SageMaker Model Building Pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Value of parameter to start execution of a SageMaker Model Building Pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SageMakerPipelineParameterProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link SageMakerPipelineParameterProperty#getName}
             * @param name Name of parameter to start execution of a SageMaker Model Building Pipeline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerPipelineParameterProperty#getValue}
             * @param value Value of parameter to start execution of a SageMaker Model Building Pipeline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SageMakerPipelineParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SageMakerPipelineParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SageMakerPipelineParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerPipelineParameterProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.SageMakerPipelineParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SageMakerPipelineParameterProperty.Jsii$Proxy that = (SageMakerPipelineParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The AWS Secrets Manager secret that stores your stream credentials.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * SelfManagedKafkaAccessConfigurationCredentialsProperty selfManagedKafkaAccessConfigurationCredentialsProperty = SelfManagedKafkaAccessConfigurationCredentialsProperty.builder()
     *         .basicAuth("basicAuth")
     *         .clientCertificateTlsAuth("clientCertificateTlsAuth")
     *         .saslScram256Auth("saslScram256Auth")
     *         .saslScram512Auth("saslScram512Auth")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.SelfManagedKafkaAccessConfigurationCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SelfManagedKafkaAccessConfigurationCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelfManagedKafkaAccessConfigurationCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Secrets Manager secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBasicAuth() {
            return null;
        }

        /**
         * The ARN of the Secrets Manager secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateTlsAuth() {
            return null;
        }

        /**
         * The ARN of the Secrets Manager secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslScram256Auth() {
            return null;
        }

        /**
         * The ARN of the Secrets Manager secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslScram512Auth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelfManagedKafkaAccessConfigurationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelfManagedKafkaAccessConfigurationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelfManagedKafkaAccessConfigurationCredentialsProperty> {
            java.lang.String basicAuth;
            java.lang.String clientCertificateTlsAuth;
            java.lang.String saslScram256Auth;
            java.lang.String saslScram512Auth;

            /**
             * Sets the value of {@link SelfManagedKafkaAccessConfigurationCredentialsProperty#getBasicAuth}
             * @param basicAuth The ARN of the Secrets Manager secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuth(java.lang.String basicAuth) {
                this.basicAuth = basicAuth;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedKafkaAccessConfigurationCredentialsProperty#getClientCertificateTlsAuth}
             * @param clientCertificateTlsAuth The ARN of the Secrets Manager secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCertificateTlsAuth(java.lang.String clientCertificateTlsAuth) {
                this.clientCertificateTlsAuth = clientCertificateTlsAuth;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedKafkaAccessConfigurationCredentialsProperty#getSaslScram256Auth}
             * @param saslScram256Auth The ARN of the Secrets Manager secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslScram256Auth(java.lang.String saslScram256Auth) {
                this.saslScram256Auth = saslScram256Auth;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedKafkaAccessConfigurationCredentialsProperty#getSaslScram512Auth}
             * @param saslScram512Auth The ARN of the Secrets Manager secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslScram512Auth(java.lang.String saslScram512Auth) {
                this.saslScram512Auth = saslScram512Auth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelfManagedKafkaAccessConfigurationCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelfManagedKafkaAccessConfigurationCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelfManagedKafkaAccessConfigurationCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfManagedKafkaAccessConfigurationCredentialsProperty {
            private final java.lang.String basicAuth;
            private final java.lang.String clientCertificateTlsAuth;
            private final java.lang.String saslScram256Auth;
            private final java.lang.String saslScram512Auth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basicAuth = software.amazon.jsii.Kernel.get(this, "basicAuth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientCertificateTlsAuth = software.amazon.jsii.Kernel.get(this, "clientCertificateTlsAuth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.saslScram256Auth = software.amazon.jsii.Kernel.get(this, "saslScram256Auth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.saslScram512Auth = software.amazon.jsii.Kernel.get(this, "saslScram512Auth", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basicAuth = builder.basicAuth;
                this.clientCertificateTlsAuth = builder.clientCertificateTlsAuth;
                this.saslScram256Auth = builder.saslScram256Auth;
                this.saslScram512Auth = builder.saslScram512Auth;
            }

            @Override
            public final java.lang.String getBasicAuth() {
                return this.basicAuth;
            }

            @Override
            public final java.lang.String getClientCertificateTlsAuth() {
                return this.clientCertificateTlsAuth;
            }

            @Override
            public final java.lang.String getSaslScram256Auth() {
                return this.saslScram256Auth;
            }

            @Override
            public final java.lang.String getSaslScram512Auth() {
                return this.saslScram512Auth;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBasicAuth() != null) {
                    data.set("basicAuth", om.valueToTree(this.getBasicAuth()));
                }
                if (this.getClientCertificateTlsAuth() != null) {
                    data.set("clientCertificateTlsAuth", om.valueToTree(this.getClientCertificateTlsAuth()));
                }
                if (this.getSaslScram256Auth() != null) {
                    data.set("saslScram256Auth", om.valueToTree(this.getSaslScram256Auth()));
                }
                if (this.getSaslScram512Auth() != null) {
                    data.set("saslScram512Auth", om.valueToTree(this.getSaslScram512Auth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.SelfManagedKafkaAccessConfigurationCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelfManagedKafkaAccessConfigurationCredentialsProperty.Jsii$Proxy that = (SelfManagedKafkaAccessConfigurationCredentialsProperty.Jsii$Proxy) o;

                if (this.basicAuth != null ? !this.basicAuth.equals(that.basicAuth) : that.basicAuth != null) return false;
                if (this.clientCertificateTlsAuth != null ? !this.clientCertificateTlsAuth.equals(that.clientCertificateTlsAuth) : that.clientCertificateTlsAuth != null) return false;
                if (this.saslScram256Auth != null ? !this.saslScram256Auth.equals(that.saslScram256Auth) : that.saslScram256Auth != null) return false;
                return this.saslScram512Auth != null ? this.saslScram512Auth.equals(that.saslScram512Auth) : that.saslScram512Auth == null;
            }

            @Override
            public final int hashCode() {
                int result = this.basicAuth != null ? this.basicAuth.hashCode() : 0;
                result = 31 * result + (this.clientCertificateTlsAuth != null ? this.clientCertificateTlsAuth.hashCode() : 0);
                result = 31 * result + (this.saslScram256Auth != null ? this.saslScram256Auth.hashCode() : 0);
                result = 31 * result + (this.saslScram512Auth != null ? this.saslScram512Auth.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pipes.*;
     * SelfManagedKafkaAccessConfigurationVpcProperty selfManagedKafkaAccessConfigurationVpcProperty = SelfManagedKafkaAccessConfigurationVpcProperty.builder()
     *         .securityGroup(List.of("securityGroup"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_pipes.CfnPipe.SelfManagedKafkaAccessConfigurationVpcProperty")
    @software.amazon.jsii.Jsii.Proxy(SelfManagedKafkaAccessConfigurationVpcProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelfManagedKafkaAccessConfigurationVpcProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the security groups associated with the stream.
         * <p>
         * These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroup() {
            return null;
        }

        /**
         * Specifies the subnets associated with the stream.
         * <p>
         * These subnets must all be in the same VPC. You can specify as many as 16 subnets.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelfManagedKafkaAccessConfigurationVpcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelfManagedKafkaAccessConfigurationVpcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelfManagedKafkaAccessConfigurationVpcProperty> {
            java.util.List<java.lang.String> securityGroup;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link SelfManagedKafkaAccessConfigurationVpcProperty#getSecurityGroup}
             * @param securityGroup Specifies the security groups associated with the stream.
             *                      These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroup(java.util.List<java.lang.String> securityGroup) {
                this.securityGroup = securityGroup;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedKafkaAccessConfigurationVpcProperty#getSubnets}
             * @param subnets Specifies the subnets associated with the stream.
             *                These subnets must all be in the same VPC. You can specify as many as 16 subnets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelfManagedKafkaAccessConfigurationVpcProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelfManagedKafkaAccessConfigurationVpcProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelfManagedKafkaAccessConfigurationVpcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfManagedKafkaAccessConfigurationVpcProperty {
            private final java.util.List<java.lang.String> securityGroup;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroup = builder.securityGroup;
                this.subnets = builder.subnets;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroup() {
                return this.securityGroup;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroup() != null) {
                    data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
                }
                if (this.getSubnets() != null) {
                    data.set("subnets", om.valueToTree(this.getSubnets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_pipes.CfnPipe.SelfManagedKafkaAccessConfigurationVpcProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelfManagedKafkaAccessConfigurationVpcProperty.Jsii$Proxy that = (SelfManagedKafkaAccessConfigurationVpcProperty.Jsii$Proxy) o;

                if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
                return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroup != null ? this.securityGroup.hashCode() : 0;
                result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pipes.CfnPipe}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pipes.CfnPipe> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pipes.CfnPipeProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pipes.CfnPipeProps.Builder();
        }

        /**
         * The ARN of the role that allows the pipe to send data to the target.
         * <p>
         * @return {@code this}
         * @param roleArn The ARN of the role that allows the pipe to send data to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The ARN of the source resource.
         * <p>
         * @return {@code this}
         * @param source The ARN of the source resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final java.lang.String source) {
            this.props.source(source);
            return this;
        }

        /**
         * The ARN of the target resource.
         * <p>
         * @return {@code this}
         * @param target The ARN of the target resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final java.lang.String target) {
            this.props.target(target);
            return this;
        }

        /**
         * A description of the pipe.
         * <p>
         * @return {@code this}
         * @param description A description of the pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The state the pipe should be in.
         * <p>
         * @return {@code this}
         * @param desiredState The state the pipe should be in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredState(final java.lang.String desiredState) {
            this.props.desiredState(desiredState);
            return this;
        }

        /**
         * The ARN of the enrichment resource.
         * <p>
         * @return {@code this}
         * @param enrichment The ARN of the enrichment resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enrichment(final java.lang.String enrichment) {
            this.props.enrichment(enrichment);
            return this;
        }

        /**
         * The parameters required to set up enrichment on your pipe.
         * <p>
         * @return {@code this}
         * @param enrichmentParameters The parameters required to set up enrichment on your pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enrichmentParameters(final software.amazon.awscdk.services.pipes.CfnPipe.PipeEnrichmentParametersProperty enrichmentParameters) {
            this.props.enrichmentParameters(enrichmentParameters);
            return this;
        }
        /**
         * The parameters required to set up enrichment on your pipe.
         * <p>
         * @return {@code this}
         * @param enrichmentParameters The parameters required to set up enrichment on your pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enrichmentParameters(final software.amazon.awscdk.core.IResolvable enrichmentParameters) {
            this.props.enrichmentParameters(enrichmentParameters);
            return this;
        }

        /**
         * The name of the pipe.
         * <p>
         * @return {@code this}
         * @param name The name of the pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The parameters required to set up a source for your pipe.
         * <p>
         * @return {@code this}
         * @param sourceParameters The parameters required to set up a source for your pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceParameters(final software.amazon.awscdk.services.pipes.CfnPipe.PipeSourceParametersProperty sourceParameters) {
            this.props.sourceParameters(sourceParameters);
            return this;
        }
        /**
         * The parameters required to set up a source for your pipe.
         * <p>
         * @return {@code this}
         * @param sourceParameters The parameters required to set up a source for your pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceParameters(final software.amazon.awscdk.core.IResolvable sourceParameters) {
            this.props.sourceParameters(sourceParameters);
            return this;
        }

        /**
         * The list of key-value pairs to associate with the pipe.
         * <p>
         * @return {@code this}
         * @param tags The list of key-value pairs to associate with the pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The parameters required to set up a target for your pipe.
         * <p>
         * @return {@code this}
         * @param targetParameters The parameters required to set up a target for your pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetParameters(final software.amazon.awscdk.services.pipes.CfnPipe.PipeTargetParametersProperty targetParameters) {
            this.props.targetParameters(targetParameters);
            return this;
        }
        /**
         * The parameters required to set up a target for your pipe.
         * <p>
         * @return {@code this}
         * @param targetParameters The parameters required to set up a target for your pipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetParameters(final software.amazon.awscdk.core.IResolvable targetParameters) {
            this.props.targetParameters(targetParameters);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.pipes.CfnPipe}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pipes.CfnPipe build() {
            return new software.amazon.awscdk.services.pipes.CfnPipe(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
