package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 * <p>
 * The <code>AWS::RDS::DBCluster</code> resource creates an Amazon Aurora DB cluster or Multi-AZ DB cluster.
 * <p>
 * For more information about creating an Aurora DB cluster, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html">Creating an Amazon Aurora DB cluster</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * For more information about creating a Multi-AZ DB cluster, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html">Creating a Multi-AZ DB cluster</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * You can only create this resource in AWS Regions where Amazon Aurora or Multi-AZ DB clusters are supported.
 * <p>
 * </blockquote>
 * <p>
 * <em>Updating DB clusters</em>
 * <p>
 * When properties labeled " <em>Update requires:</em> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">Replacement</a> " are updated, AWS CloudFormation first creates a replacement DB cluster, then changes references from other dependent resources to point to the replacement DB cluster, and finally deletes the old DB cluster.
 * <p>
 * <blockquote>
 * <p>
 * We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB cluster. To preserve your data, perform the following procedure:
 * <p>
 * <ul>
 * <li>Deactivate any applications that are using the DB cluster so that there's no activity on the DB instance.</li>
 * <li>Create a snapshot of the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CreateSnapshotCluster.html">Creating a DB Cluster Snapshot</a> .</li>
 * <li>If you want to restore your DB cluster using a DB cluster snapshot, modify the updated template with your DB cluster changes and add the <code>SnapshotIdentifier</code> property with the ID of the DB cluster snapshot that you want to use.</li>
 * </ul>
 * <p>
 * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the DB cluster snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
 * <p>
 * <ul>
 * <li>Update the stack.</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Currently, when you are updating the stack for an Aurora Serverless DB cluster, you can't include changes to any other properties when you specify one of the following properties: <code>PreferredBackupWindow</code> , <code>PreferredMaintenanceWindow</code> , and <code>Port</code> . This limitation doesn't apply to provisioned DB clusters.
 * <p>
 * For more information about updating other properties of this resource, see <code>[ModifyDBCluster](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBCluster.html)</code> . For more information about updating stacks, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">AWS CloudFormation Stacks Updates</a> .
 * <p>
 * <em>Deleting DB clusters</em>
 * <p>
 * The default <code>DeletionPolicy</code> for <code>AWS::RDS::DBCluster</code> resources is <code>Snapshot</code> . For more information about how AWS CloudFormation deletes resources, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy Attribute</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBCluster cfnDBCluster = CfnDBCluster.Builder.create(this, "MyCfnDBCluster")
 *         .allocatedStorage(123)
 *         .associatedRoles(List.of(DBClusterRoleProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .featureName("featureName")
 *                 .build()))
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZones(List.of("availabilityZones"))
 *         .backtrackWindow(123)
 *         .backupRetentionPeriod(123)
 *         .copyTagsToSnapshot(false)
 *         .databaseName("databaseName")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterInstanceClass("dbClusterInstanceClass")
 *         .dbClusterParameterGroupName("dbClusterParameterGroupName")
 *         .dbInstanceParameterGroupName("dbInstanceParameterGroupName")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .dbSystemId("dbSystemId")
 *         .deletionProtection(false)
 *         .domain("domain")
 *         .domainIamRoleName("domainIamRoleName")
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .enableHttpEndpoint(false)
 *         .enableIamDatabaseAuthentication(false)
 *         .engine("engine")
 *         .engineMode("engineMode")
 *         .engineVersion("engineVersion")
 *         .globalClusterIdentifier("globalClusterIdentifier")
 *         .iops(123)
 *         .kmsKeyId("kmsKeyId")
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .monitoringInterval(123)
 *         .monitoringRoleArn("monitoringRoleArn")
 *         .networkType("networkType")
 *         .performanceInsightsEnabled(false)
 *         .performanceInsightsKmsKeyId("performanceInsightsKmsKeyId")
 *         .performanceInsightsRetentionPeriod(123)
 *         .port(123)
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .publiclyAccessible(false)
 *         .replicationSourceIdentifier("replicationSourceIdentifier")
 *         .restoreType("restoreType")
 *         .scalingConfiguration(ScalingConfigurationProperty.builder()
 *                 .autoPause(false)
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .secondsBeforeTimeout(123)
 *                 .secondsUntilAutoPause(123)
 *                 .timeoutAction("timeoutAction")
 *                 .build())
 *         .serverlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationProperty.builder()
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .build())
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .sourceRegion("sourceRegion")
 *         .storageEncrypted(false)
 *         .storageType("storageType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useLatestRestorableTime(false)
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:07.826Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.CfnDBCluster")
public class CfnDBCluster extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDBCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::RDS::DBCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDbClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region -unique, immutable identifier for the DB cluster.
     * <p>
     * This identifier is found in AWS CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbClusterResourceId() {
        return software.amazon.jsii.Kernel.get(this, "attrDbClusterResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The connection endpoint for the DB cluster.
     * <p>
     * For example: <code>mystack-mydbcluster-123456789012.us-east-2.rds.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number that will accept connections on this DB cluster.
     * <p>
     * For example: <code>3306</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The reader endpoint for the DB cluster.
     * <p>
     * For example: <code>mystack-mydbcluster-ro-123456789012.us-east-2.rds.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReadEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrReadEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An optional array of key-value pairs to apply to this DB cluster.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAllocatedStorage() {
        return software.amazon.jsii.Kernel.get(this, "allocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocatedStorage(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "allocatedStorage", value);
    }

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBCluster.DBClusterRoleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.rds.CfnDBCluster.DBClusterRoleProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZones(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZones", value);
    }

    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * <p>
     * <blockquote>
     * <p>
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     * <p>
     * </blockquote>
     * <p>
     * Default: 0
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
     * </ul>
     * <p>
     * Valid for: Aurora MySQL DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBacktrackWindow() {
        return software.amazon.jsii.Kernel.get(this, "backtrackWindow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * <p>
     * <blockquote>
     * <p>
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     * <p>
     * </blockquote>
     * <p>
     * Default: 0
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
     * </ul>
     * <p>
     * Valid for: Aurora MySQL DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBacktrackWindow(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backtrackWindow", value);
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backupRetentionPeriod", value);
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * The name of your database.
     * <p>
     * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of your database.
     * <p>
     * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifier", value);
    }

    /**
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all AWS Regions , or for all database engines.
     * <p>
     * For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterInstanceClass() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterInstanceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all AWS Regions , or for all database engines.
     * <p>
     * For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterInstanceClass(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterInstanceClass", value);
    }

    /**
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     * <p>
     * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available DB cluster parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     * <p>
     * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available DB cluster parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterParameterGroupName", value);
    }

    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
     * <p>
     * </blockquote>
     * <p>
     * Default: The existing name setting
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>The DB parameter group must be in the same DB parameter group family as this DB cluster.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
     * <p>
     * </blockquote>
     * <p>
     * Default: The existing name setting
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>The DB parameter group must be in the same DB parameter group family as this DB cluster.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbInstanceParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbInstanceParameterGroupName", value);
    }

    /**
     * A DB subnet group that you want to associate with this DB cluster.
     * <p>
     * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A DB subnet group that you want to associate with this DB cluster.
     * <p>
     * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSubnetGroupName", value);
    }

    /**
     * Reserved for future use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSystemId() {
        return software.amazon.jsii.Kernel.get(this, "dbSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Reserved for future use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSystemId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSystemId", value);
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * Indicates the directory ID of the Active Directory to create the DB cluster.
     * <p>
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the directory ID of the Active Directory to create the DB cluster.
     * <p>
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * Specifies the name of the IAM role to use when making API calls to the Directory Service.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainIamRoleName() {
        return software.amazon.jsii.Kernel.get(this, "domainIamRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the IAM role to use when making API calls to the Directory Service.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainIamRoleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainIamRoleName", value);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>Aurora MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Aurora PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>Aurora MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Aurora PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableCloudwatchLogsExports(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "enableCloudwatchLogsExports", value);
    }

    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
     * <p>
     * By default, the HTTP endpoint is disabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableHttpEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "enableHttpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
     * <p>
     * By default, the HTTP endpoint is disabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableHttpEndpoint(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableHttpEndpoint", value);
    }

    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
     * <p>
     * By default, the HTTP endpoint is disabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableHttpEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableHttpEndpoint", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>aurora</code> (for MySQL 5.6-compatible Aurora)</li>
     * <li><code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</li>
     * <li><code>aurora-postgresql</code></li>
     * <li><code>mysql</code></li>
     * <li><code>postgres</code></li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>aurora</code> (for MySQL 5.6-compatible Aurora)</li>
     * <li><code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</li>
     * <li><code>aurora-postgresql</code></li>
     * <li><code>mysql</code></li>
     * <li><code>postgres</code></li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
     * <p>
     * The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
     * <p>
     * The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
     * <p>
     * The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
     * <p>
     * For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
     * <p>
     * Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineMode() {
        return software.amazon.jsii.Kernel.get(this, "engineMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
     * <p>
     * The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
     * <p>
     * The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
     * <p>
     * The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
     * <p>
     * For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
     * <p>
     * Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineMode", value);
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
     * <p>
     * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
     * <p>
     * If you aren't configuring a global database cluster, don't specify this property.
     * <p>
     * <blockquote>
     * <p>
     * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
     * <p>
     * </blockquote>
     * <p>
     * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlobalClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
     * <p>
     * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
     * <p>
     * If you aren't configuring a global database cluster, don't specify this property.
     * <p>
     * <blockquote>
     * <p>
     * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
     * <p>
     * </blockquote>
     * <p>
     * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "globalClusterIdentifier", value);
    }

    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     * <p>
     * For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     * <p>
     * For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIops(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "iops", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The name of the master user for the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the master user for the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", value);
    }

    /**
     * The master password for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The master password for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", value);
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
     * <p>
     * To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMonitoringInterval() {
        return software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
     * <p>
     * To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringInterval(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "monitoringInterval", value);
    }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     * <p>
     * An example is <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMonitoringRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "monitoringRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     * <p>
     * An example is <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringRoleArn", value);
    }

    /**
     * The network type of the DB cluster.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>IPV4</code></li>
     * <li><code>DUAL</code></li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkType() {
        return software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The network type of the DB cluster.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>IPV4</code></li>
     * <li><code>DUAL</code></li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkType", value);
    }

    /**
     * A value that indicates whether to turn on Performance Insights for the DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPerformanceInsightsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to turn on Performance Insights for the DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsEnabled", value);
    }

    /**
     * A value that indicates whether to turn on Performance Insights for the DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsEnabled", value);
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     * <p>
     * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * <p>
     * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account . Your AWS account has a different default KMS key for each AWS Region .
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPerformanceInsightsKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     * <p>
     * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * <p>
     * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account . Your AWS account has a different default KMS key for each AWS Region .
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsKmsKeyId", value);
    }

    /**
     * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:.
     * <p>
     * <ul>
     * <li>7</li>
     * <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23</li>
     * <li>731</li>
     * </ul>
     * <p>
     * For example, the following values are valid:
     * <p>
     * <ul>
     * <li>93 (3 months * 31)</li>
     * <li>341 (11 months * 31)</li>
     * <li>589 (19 months * 31)</li>
     * <li>731</li>
     * </ul>
     * <p>
     * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPerformanceInsightsRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:.
     * <p>
     * <ul>
     * <li>7</li>
     * <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23</li>
     * <li>731</li>
     * </ul>
     * <p>
     * For example, the following values are valid:
     * <p>
     * <ul>
     * <li>93 (3 months * 31)</li>
     * <li>341 (11 months * 31)</li>
     * <li>589 (19 months * 31)</li>
     * <li>731</li>
     * </ul>
     * <p>
     * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsRetentionPeriod", value);
    }

    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
     * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
     * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
     * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
     * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
     * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
     * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The daily time range during which automated backups are created.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range during which automated backups are created.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * <p>
     * Constraints: Minimum 30-minute window.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * <p>
     * Constraints: Minimum 30-minute window.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * A value that indicates whether the DB cluster is publicly accessible.
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     * <p>
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the DB cluster is publicly accessible.
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     * <p>
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * A value that indicates whether the DB cluster is publicly accessible.
     * <p>
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     * <p>
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReplicationSourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "replicationSourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationSourceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicationSourceIdentifier", value);
    }

    /**
     * The type of restore to be performed. You can specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
     * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
     * </ul>
     * <p>
     * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRestoreType() {
        return software.amazon.jsii.Kernel.get(this, "restoreType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of restore to be performed. You can specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
     * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
     * </ul>
     * <p>
     * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restoreType", value);
    }

    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, use <code>ServerlessV2ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, use <code>ServerlessV2ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, use <code>ServerlessV2ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use <code>ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServerlessV2ScalingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "serverlessV2ScalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use <code>ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerlessV2ScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBCluster.ServerlessV2ScalingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "serverlessV2ScalingConfiguration", value);
    }

    /**
     * The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use <code>ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerlessV2ScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serverlessV2ScalingConfiguration", value);
    }

    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     * <p>
     * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>GlobalClusterIdentifier</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>ReplicationSourceIdentifier</code></li>
     * <li><code>RestoreType</code></li>
     * <li><code>SourceDBClusterIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>UseLatestRestorableTime</code></li>
     * </ul>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing Snapshot.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     * <p>
     * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>GlobalClusterIdentifier</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>ReplicationSourceIdentifier</code></li>
     * <li><code>RestoreType</code></li>
     * <li><code>SourceDBClusterIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>UseLatestRestorableTime</code></li>
     * </ul>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing Snapshot.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotIdentifier", value);
    }

    /**
     * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing DBCluster.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing DBCluster.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbClusterIdentifier", value);
    }

    /**
     * The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, `us-east-1` .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, `us-east-1` .
     * <p>
     * Valid for: Aurora DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceRegion", value);
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * Specifies the storage type to be associated with the DB cluster.
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid values: <code>io1</code>
     * <p>
     * When specified, a value for the <code>Iops</code> parameter is required.
     * <p>
     * Default: <code>io1</code>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the storage type to be associated with the DB cluster.
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid values: <code>io1</code>
     * <p>
     * When specified, a value for the <code>Iops</code> parameter is required.
     * <p>
     * Default: <code>io1</code>
     * <p>
     * Valid for: Multi-AZ DB clusters only
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroupIds", value);
    }
    /**
     * Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * DBClusterRoleProperty dBClusterRoleProperty = DBClusterRoleProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .featureName("featureName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.CfnDBCluster.DBClusterRoleProperty")
    @software.amazon.jsii.Jsii.Proxy(DBClusterRoleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DBClusterRoleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the feature associated with the AWS Identity and Access Management (IAM) role.
         * <p>
         * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFeatureName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DBClusterRoleProperty> {
            java.lang.String roleArn;
            java.lang.String featureName;

            /**
             * Sets the value of {@link DBClusterRoleProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DBClusterRoleProperty#getFeatureName}
             * @param featureName The name of the feature associated with the AWS Identity and Access Management (IAM) role.
             *                    IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureName(java.lang.String featureName) {
                this.featureName = featureName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DBClusterRoleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DBClusterRoleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBClusterRoleProperty {
            private final java.lang.String roleArn;
            private final java.lang.String featureName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureName = software.amazon.jsii.Kernel.get(this, "featureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.featureName = builder.featureName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getFeatureName() {
                return this.featureName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getFeatureName() != null) {
                    data.set("featureName", om.valueToTree(this.getFeatureName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_rds.CfnDBCluster.DBClusterRoleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DBClusterRoleProperty.Jsii$Proxy that = (DBClusterRoleProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.featureName != null ? this.featureName.equals(that.featureName) : that.featureName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.featureName != null ? this.featureName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the connection endpoint for the primary instance of the DB cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * EndpointProperty endpointProperty = EndpointProperty.builder()
     *         .address("address")
     *         .port("port")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.CfnDBCluster.EndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the connection endpoint for the primary instance of the DB cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * Specifies the port that the database engine is listening on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointProperty> {
            java.lang.String address;
            java.lang.String port;

            /**
             * Sets the value of {@link EndpointProperty#getAddress}
             * @param address Specifies the connection endpoint for the primary instance of the DB cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getPort}
             * @param port Specifies the port that the database engine is listening on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointProperty {
            private final java.lang.String address;
            private final java.lang.String port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_rds.CfnDBCluster.EndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointProperty.Jsii$Proxy that = (EndpointProperty.Jsii$Proxy) o;

                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ReadEndpoint` return value specifies the reader endpoint for the DB cluster.
     * <p>
     * The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.
     * <p>
     * If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.
     * <p>
     * For more information about Aurora endpoints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.Endpoints.html">Amazon Aurora connection management</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ReadEndpointProperty readEndpointProperty = ReadEndpointProperty.builder()
     *         .address("address")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.CfnDBCluster.ReadEndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(ReadEndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReadEndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host address of the reader endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReadEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReadEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReadEndpointProperty> {
            java.lang.String address;

            /**
             * Sets the value of {@link ReadEndpointProperty#getAddress}
             * @param address The host address of the reader endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReadEndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReadEndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ReadEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReadEndpointProperty {
            private final java.lang.String address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_rds.CfnDBCluster.ReadEndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReadEndpointProperty.Jsii$Proxy that = (ReadEndpointProperty.Jsii$Proxy) o;

                return this.address != null ? this.address.equals(that.address) : that.address == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, use <code>ServerlessV2ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ScalingConfigurationProperty scalingConfigurationProperty = ScalingConfigurationProperty.builder()
     *         .autoPause(false)
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .secondsBeforeTimeout(123)
     *         .secondsUntilAutoPause(123)
     *         .timeoutAction("timeoutAction")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.CfnDBCluster.ScalingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode.
         * <p>
         * A DB cluster can be paused only when it's idle (it has no connections).
         * <p>
         * <blockquote>
         * <p>
         * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoPause() {
            return null;
        }

        /**
         * The maximum capacity for an Aurora DB cluster in `serverless` DB engine mode.
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
         * <p>
         * The maximum capacity must be greater than or equal to the minimum capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * The minimum capacity for an Aurora DB cluster in `serverless` DB engine mode.
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
         * <p>
         * The minimum capacity must be less than or equal to the maximum capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
            return null;
        }

        /**
         * The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action.
         * <p>
         * The default is 300.
         * <p>
         * Specify a value between 60 and 600 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondsBeforeTimeout() {
            return null;
        }

        /**
         * The time, in seconds, before an Aurora DB cluster in `serverless` mode is paused.
         * <p>
         * Specify a value between 300 and 86,400 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondsUntilAutoPause() {
            return null;
        }

        /**
         * The action to take when the timeout is reached, either `ForceApplyCapacityChange` or `RollbackCapacityChange` .
         * <p>
         * <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
         * <p>
         * <code>RollbackCapacityChange</code> , the default, ignores the capacity change if a scaling point isn't found in the timeout period.
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>ForceApplyCapacityChange</code> , connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling">Autoscaling for Aurora Serverless v1</a> in the <em>Amazon Aurora User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeoutAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConfigurationProperty> {
            java.lang.Object autoPause;
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;
            java.lang.Number secondsBeforeTimeout;
            java.lang.Number secondsUntilAutoPause;
            java.lang.String timeoutAction;

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getAutoPause}
             * @param autoPause A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode.
             *                  A DB cluster can be paused only when it's idle (it has no connections).
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoPause(java.lang.Boolean autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getAutoPause}
             * @param autoPause A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode.
             *                  A DB cluster can be paused only when it's idle (it has no connections).
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoPause(software.amazon.awscdk.core.IResolvable autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getMaxCapacity}
             * @param maxCapacity The maximum capacity for an Aurora DB cluster in `serverless` DB engine mode.
             *                    For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
             *                    <p>
             *                    For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
             *                    <p>
             *                    The maximum capacity must be greater than or equal to the minimum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getMinCapacity}
             * @param minCapacity The minimum capacity for an Aurora DB cluster in `serverless` DB engine mode.
             *                    For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
             *                    <p>
             *                    For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
             *                    <p>
             *                    The minimum capacity must be less than or equal to the maximum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getSecondsBeforeTimeout}
             * @param secondsBeforeTimeout The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action.
             *                             The default is 300.
             *                             <p>
             *                             Specify a value between 60 and 600 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondsBeforeTimeout(java.lang.Number secondsBeforeTimeout) {
                this.secondsBeforeTimeout = secondsBeforeTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getSecondsUntilAutoPause}
             * @param secondsUntilAutoPause The time, in seconds, before an Aurora DB cluster in `serverless` mode is paused.
             *                              Specify a value between 300 and 86,400 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondsUntilAutoPause(java.lang.Number secondsUntilAutoPause) {
                this.secondsUntilAutoPause = secondsUntilAutoPause;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getTimeoutAction}
             * @param timeoutAction The action to take when the timeout is reached, either `ForceApplyCapacityChange` or `RollbackCapacityChange` .
             *                      <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
             *                      <p>
             *                      <code>RollbackCapacityChange</code> , the default, ignores the capacity change if a scaling point isn't found in the timeout period.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      If you specify <code>ForceApplyCapacityChange</code> , connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
             *                      <p>
             *                      </blockquote>
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling">Autoscaling for Aurora Serverless v1</a> in the <em>Amazon Aurora User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutAction(java.lang.String timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConfigurationProperty {
            private final java.lang.Object autoPause;
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;
            private final java.lang.Number secondsBeforeTimeout;
            private final java.lang.Number secondsUntilAutoPause;
            private final java.lang.String timeoutAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoPause = software.amazon.jsii.Kernel.get(this, "autoPause", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secondsBeforeTimeout = software.amazon.jsii.Kernel.get(this, "secondsBeforeTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secondsUntilAutoPause = software.amazon.jsii.Kernel.get(this, "secondsUntilAutoPause", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutAction = software.amazon.jsii.Kernel.get(this, "timeoutAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoPause = builder.autoPause;
                this.maxCapacity = builder.maxCapacity;
                this.minCapacity = builder.minCapacity;
                this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
                this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
                this.timeoutAction = builder.timeoutAction;
            }

            @Override
            public final java.lang.Object getAutoPause() {
                return this.autoPause;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public final java.lang.Number getSecondsBeforeTimeout() {
                return this.secondsBeforeTimeout;
            }

            @Override
            public final java.lang.Number getSecondsUntilAutoPause() {
                return this.secondsUntilAutoPause;
            }

            @Override
            public final java.lang.String getTimeoutAction() {
                return this.timeoutAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoPause() != null) {
                    data.set("autoPause", om.valueToTree(this.getAutoPause()));
                }
                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getMinCapacity() != null) {
                    data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                }
                if (this.getSecondsBeforeTimeout() != null) {
                    data.set("secondsBeforeTimeout", om.valueToTree(this.getSecondsBeforeTimeout()));
                }
                if (this.getSecondsUntilAutoPause() != null) {
                    data.set("secondsUntilAutoPause", om.valueToTree(this.getSecondsUntilAutoPause()));
                }
                if (this.getTimeoutAction() != null) {
                    data.set("timeoutAction", om.valueToTree(this.getTimeoutAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_rds.CfnDBCluster.ScalingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConfigurationProperty.Jsii$Proxy that = (ScalingConfigurationProperty.Jsii$Proxy) o;

                if (this.autoPause != null ? !this.autoPause.equals(that.autoPause) : that.autoPause != null) return false;
                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
                if (this.secondsBeforeTimeout != null ? !this.secondsBeforeTimeout.equals(that.secondsBeforeTimeout) : that.secondsBeforeTimeout != null) return false;
                if (this.secondsUntilAutoPause != null ? !this.secondsUntilAutoPause.equals(that.secondsUntilAutoPause) : that.secondsUntilAutoPause != null) return false;
                return this.timeoutAction != null ? this.timeoutAction.equals(that.timeoutAction) : that.timeoutAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoPause != null ? this.autoPause.hashCode() : 0;
                result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
                result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
                result = 31 * result + (this.secondsBeforeTimeout != null ? this.secondsBeforeTimeout.hashCode() : 0);
                result = 31 * result + (this.secondsUntilAutoPause != null ? this.secondsUntilAutoPause.hashCode() : 0);
                result = 31 * result + (this.timeoutAction != null ? this.timeoutAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * If you have an Aurora cluster, you must set the <code>ScalingConfigurationInfo</code> attribute before you add a DB instance that uses the <code>db.serverless</code> DB instance class. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html#aurora-serverless-v2.requirements.capacity-range">Clusters that use Aurora Serverless v2 must have a capacity range specified</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use <code>ScalingConfiguration</code> property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ServerlessV2ScalingConfigurationProperty serverlessV2ScalingConfigurationProperty = ServerlessV2ScalingConfigurationProperty.builder()
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.CfnDBCluster.ServerlessV2ScalingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerlessV2ScalingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerlessV2ScalingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
         * <p>
         * You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
         * <p>
         * The maximum capacity must be higher than 0.5 ACUs. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations">Choosing the maximum Aurora Serverless v2 capacity setting for a cluster</a> in the <em>Amazon Aurora User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
         * <p>
         * You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is 0.5.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerlessV2ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerlessV2ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerlessV2ScalingConfigurationProperty> {
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;

            /**
             * Sets the value of {@link ServerlessV2ScalingConfigurationProperty#getMaxCapacity}
             * @param maxCapacity The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
             *                    You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
             *                    <p>
             *                    The maximum capacity must be higher than 0.5 ACUs. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations">Choosing the maximum Aurora Serverless v2 capacity setting for a cluster</a> in the <em>Amazon Aurora User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ServerlessV2ScalingConfigurationProperty#getMinCapacity}
             * @param minCapacity The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster.
             *                    You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is 0.5.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerlessV2ScalingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerlessV2ScalingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerlessV2ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessV2ScalingConfigurationProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = builder.maxCapacity;
                this.minCapacity = builder.minCapacity;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getMinCapacity() != null) {
                    data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_rds.CfnDBCluster.ServerlessV2ScalingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerlessV2ScalingConfigurationProperty.Jsii$Proxy that = (ServerlessV2ScalingConfigurationProperty.Jsii$Proxy) o;

                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                return this.minCapacity != null ? this.minCapacity.equals(that.minCapacity) : that.minCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity != null ? this.maxCapacity.hashCode() : 0;
                result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.rds.CfnDBClusterProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param allocatedStorage The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedStorage(final java.lang.Number allocatedStorage) {
            this.props().allocatedStorage(allocatedStorage);
            return this;
        }

        /**
         * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         * <p>
         * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final software.amazon.awscdk.core.IResolvable associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }
        /**
         * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         * <p>
         * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final java.util.List<? extends java.lang.Object> associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }

        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
         * <p>
         * By default, minor engine upgrades are applied automatically.
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }
        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
         * <p>
         * By default, minor engine upgrades are applied automatically.
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final software.amazon.awscdk.core.IResolvable autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         * <p>
         * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param availabilityZones A list of Availability Zones (AZs) where instances in the DB cluster can be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(final java.util.List<java.lang.String> availabilityZones) {
            this.props().availabilityZones(availabilityZones);
            return this;
        }

        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         * <p>
         * <blockquote>
         * <p>
         * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         * <p>
         * </blockquote>
         * <p>
         * Default: 0
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
         * </ul>
         * <p>
         * Valid for: Aurora MySQL DB clusters only
         * <p>
         * @return {@code this}
         * @param backtrackWindow The target backtrack window, in seconds. To disable backtracking, set this value to 0. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(final java.lang.Number backtrackWindow) {
            this.props().backtrackWindow(backtrackWindow);
            return this;
        }

        /**
         * The number of days for which automated backups are retained.
         * <p>
         * Default: 1
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be a value from 1 to 35</li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param backupRetentionPeriod The number of days for which automated backups are retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(final java.lang.Number backupRetentionPeriod) {
            this.props().backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        /**
         * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         * <p>
         * The default is not to copy them.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }
        /**
         * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         * <p>
         * The default is not to copy them.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final software.amazon.awscdk.core.IResolvable copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * The name of your database.
         * <p>
         * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param databaseName The name of your database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props().databaseName(databaseName);
            return this;
        }

        /**
         * The DB cluster identifier. This parameter is stored as a lowercase string.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
         * </ul>
         * <p>
         * Example: <code>my-cluster1</code>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param dbClusterIdentifier The DB cluster identifier. This parameter is stored as a lowercase string. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(final java.lang.String dbClusterIdentifier) {
            this.props().dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        /**
         * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all AWS Regions , or for all database engines.
         * <p>
         * For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param dbClusterInstanceClass The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all AWS Regions , or for all database engines. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterInstanceClass(final java.lang.String dbClusterInstanceClass) {
            this.props().dbClusterInstanceClass(dbClusterInstanceClass);
            return this;
        }

        /**
         * The name of the DB cluster parameter group to associate with this DB cluster.
         * <p>
         * <blockquote>
         * <p>
         * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
         * <p>
         * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
         * <p>
         * </blockquote>
         * <p>
         * To list all of the available DB cluster parameter group names, use the following command:
         * <p>
         * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param dbClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterParameterGroupName(final java.lang.String dbClusterParameterGroupName) {
            this.props().dbClusterParameterGroupName(dbClusterParameterGroupName);
            return this;
        }

        /**
         * The name of the DB parameter group to apply to all instances of the DB cluster.
         * <p>
         * <blockquote>
         * <p>
         * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
         * <p>
         * </blockquote>
         * <p>
         * Default: The existing name setting
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>The DB parameter group must be in the same DB parameter group family as this DB cluster.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param dbInstanceParameterGroupName The name of the DB parameter group to apply to all instances of the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceParameterGroupName(final java.lang.String dbInstanceParameterGroupName) {
            this.props().dbInstanceParameterGroupName(dbInstanceParameterGroupName);
            return this;
        }

        /**
         * A DB subnet group that you want to associate with this DB cluster.
         * <p>
         * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param dbSubnetGroupName A DB subnet group that you want to associate with this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(final java.lang.String dbSubnetGroupName) {
            this.props().dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        /**
         * Reserved for future use.
         * <p>
         * @return {@code this}
         * @param dbSystemId Reserved for future use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSystemId(final java.lang.String dbSystemId) {
            this.props().dbSystemId(dbSystemId);
            return this;
        }

        /**
         * A value that indicates whether the DB cluster has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.core.IResolvable deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Indicates the directory ID of the Active Directory to create the DB cluster.
         * <p>
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param domain Indicates the directory ID of the Active Directory to create the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props().domain(domain);
            return this;
        }

        /**
         * Specifies the name of the IAM role to use when making API calls to the Directory Service.
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param domainIamRoleName Specifies the name of the IAM role to use when making API calls to the Directory Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIamRoleName(final java.lang.String domainIamRoleName) {
            this.props().domainIamRoleName(domainIamRoleName);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * <p>
         * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * <em>Aurora MySQL</em>
         * <p>
         * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         * <p>
         * <em>Aurora PostgreSQL</em>
         * <p>
         * Valid values: <code>postgresql</code>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(final java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.props().enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        /**
         * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
         * <p>
         * By default, the HTTP endpoint is disabled.
         * <p>
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param enableHttpEndpoint A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(final java.lang.Boolean enableHttpEndpoint) {
            this.props().enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }
        /**
         * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
         * <p>
         * By default, the HTTP endpoint is disabled.
         * <p>
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param enableHttpEndpoint A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(final software.amazon.awscdk.core.IResolvable enableHttpEndpoint) {
            this.props().enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }

        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final java.lang.Boolean enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }
        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final software.amazon.awscdk.core.IResolvable enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        /**
         * The name of the database engine to be used for this DB cluster.
         * <p>
         * Valid Values:
         * <p>
         * <ul>
         * <li><code>aurora</code> (for MySQL 5.6-compatible Aurora)</li>
         * <li><code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</li>
         * <li><code>aurora-postgresql</code></li>
         * <li><code>mysql</code></li>
         * <li><code>postgres</code></li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param engine The name of the database engine to be used for this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props().engine(engine);
            return this;
        }

        /**
         * The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
         * <p>
         * The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
         * <p>
         * The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
         * <p>
         * The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
         * <p>
         * For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
         * <p>
         * Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param engineMode The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineMode(final java.lang.String engineMode) {
            this.props().engineMode(engineMode);
            return this;
        }

        /**
         * The version number of the database engine to use.
         * <p>
         * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
         * <p>
         * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         * <p>
         * To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param engineVersion The version number of the database engine to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        /**
         * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
         * <p>
         * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
         * <p>
         * If you aren't configuring a global database cluster, don't specify this property.
         * <p>
         * <blockquote>
         * <p>
         * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
         * <p>
         * </blockquote>
         * <p>
         * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param globalClusterIdentifier If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalClusterIdentifier(final java.lang.String globalClusterIdentifier) {
            this.props().globalClusterIdentifier(globalClusterIdentifier);
            return this;
        }

        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         * <p>
         * For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * <p>
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param iops The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(final java.lang.Number iops) {
            this.props().iops(iops);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
         * <p>
         * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param kmsKeyId The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The name of the master user for the DB cluster.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         * <p>
         * </blockquote>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param masterUsername The name of the master user for the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props().masterUsername(masterUsername);
            return this;
        }

        /**
         * The master password for the DB instance.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         * <p>
         * </blockquote>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param masterUserPassword The master password for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props().masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
         * <p>
         * To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.
         * <p>
         * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param monitoringInterval The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(final java.lang.Number monitoringInterval) {
            this.props().monitoringInterval(monitoringInterval);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         * <p>
         * An example is <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param monitoringRoleArn The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRoleArn(final java.lang.String monitoringRoleArn) {
            this.props().monitoringRoleArn(monitoringRoleArn);
            return this;
        }

        /**
         * The network type of the DB cluster.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>IPV4</code></li>
         * <li><code>DUAL</code></li>
         * </ul>
         * <p>
         * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param networkType The network type of the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(final java.lang.String networkType) {
            this.props().networkType(networkType);
            return this;
        }

        /**
         * A value that indicates whether to turn on Performance Insights for the DB cluster.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param performanceInsightsEnabled A value that indicates whether to turn on Performance Insights for the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsEnabled(final java.lang.Boolean performanceInsightsEnabled) {
            this.props().performanceInsightsEnabled(performanceInsightsEnabled);
            return this;
        }
        /**
         * A value that indicates whether to turn on Performance Insights for the DB cluster.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param performanceInsightsEnabled A value that indicates whether to turn on Performance Insights for the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsEnabled(final software.amazon.awscdk.core.IResolvable performanceInsightsEnabled) {
            this.props().performanceInsightsEnabled(performanceInsightsEnabled);
            return this;
        }

        /**
         * The AWS KMS key identifier for encryption of Performance Insights data.
         * <p>
         * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * <p>
         * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account . Your AWS account has a different default KMS key for each AWS Region .
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param performanceInsightsKmsKeyId The AWS KMS key identifier for encryption of Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsKmsKeyId(final java.lang.String performanceInsightsKmsKeyId) {
            this.props().performanceInsightsKmsKeyId(performanceInsightsKmsKeyId);
            return this;
        }

        /**
         * The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:.
         * <p>
         * <ul>
         * <li>7</li>
         * <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23</li>
         * <li>731</li>
         * </ul>
         * <p>
         * For example, the following values are valid:
         * <p>
         * <ul>
         * <li>93 (3 months * 31)</li>
         * <li>341 (11 months * 31)</li>
         * <li>589 (19 months * 31)</li>
         * <li>731</li>
         * </ul>
         * <p>
         * If you specify a retention period such as 94, which isn't a valid value, RDS issues an error.
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param performanceInsightsRetentionPeriod The number of days to retain Performance Insights data. The default is 7 days. The following values are valid:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsRetentionPeriod(final java.lang.Number performanceInsightsRetentionPeriod) {
            this.props().performanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
            return this;
        }

        /**
         * The port number on which the DB instances in the DB cluster accept connections.
         * <p>
         * Default:
         * <p>
         * <ul>
         * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
         * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
         * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
         * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
         * <p>
         * </blockquote>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param port The port number on which the DB instances in the DB cluster accept connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props().port(port);
            return this;
        }

        /**
         * The daily time range during which automated backups are created.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         * <li>Must be in Universal Coordinated Time (UTC).</li>
         * <li>Must not conflict with the preferred maintenance window.</li>
         * <li>Must be at least 30 minutes.</li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow The daily time range during which automated backups are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props().preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * <p>
         * Constraints: Minimum 30-minute window.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props().preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * A value that indicates whether the DB cluster is publicly accessible.
         * <p>
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         * <p>
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
         * </ul>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param publiclyAccessible A value that indicates whether the DB cluster is publicly accessible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * A value that indicates whether the DB cluster is publicly accessible.
         * <p>
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         * <p>
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         * <p>
         * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         * <p>
         * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
         * </ul>
         * <p>
         * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         * <p>
         * <ul>
         * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
         * </ul>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param publiclyAccessible A value that indicates whether the DB cluster is publicly accessible. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.core.IResolvable publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param replicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSourceIdentifier(final java.lang.String replicationSourceIdentifier) {
            this.props().replicationSourceIdentifier(replicationSourceIdentifier);
            return this;
        }

        /**
         * The type of restore to be performed. You can specify one of the following values:.
         * <p>
         * <ul>
         * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
         * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
         * </ul>
         * <p>
         * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
         * <p>
         * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param restoreType The type of restore to be performed. You can specify one of the following values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreType(final java.lang.String restoreType) {
            this.props().restoreType(restoreType);
            return this;
        }

        /**
         * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
         * <p>
         * This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, use <code>ServerlessV2ScalingConfiguration</code> property.
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param scalingConfiguration The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }
        /**
         * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
         * <p>
         * This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, use <code>ServerlessV2ScalingConfiguration</code> property.
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param scalingConfiguration The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.core.IResolvable scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }

        /**
         * The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster.
         * <p>
         * This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use <code>ScalingConfiguration</code> property.
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param serverlessV2ScalingConfiguration The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2ScalingConfiguration(final software.amazon.awscdk.services.rds.CfnDBCluster.ServerlessV2ScalingConfigurationProperty serverlessV2ScalingConfiguration) {
            this.props().serverlessV2ScalingConfiguration(serverlessV2ScalingConfiguration);
            return this;
        }
        /**
         * The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster.
         * <p>
         * This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use <code>ScalingConfiguration</code> property.
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param serverlessV2ScalingConfiguration The `ServerlessV2ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2ScalingConfiguration(final software.amazon.awscdk.core.IResolvable serverlessV2ScalingConfiguration) {
            this.props().serverlessV2ScalingConfiguration(serverlessV2ScalingConfiguration);
            return this;
        }

        /**
         * The identifier for the DB snapshot or DB cluster snapshot to restore from.
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         * <p>
         * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
         * <p>
         * <ul>
         * <li><code>GlobalClusterIdentifier</code></li>
         * <li><code>MasterUsername</code></li>
         * <li><code>MasterUserPassword</code></li>
         * <li><code>ReplicationSourceIdentifier</code></li>
         * <li><code>RestoreType</code></li>
         * <li><code>SourceDBClusterIdentifier</code></li>
         * <li><code>SourceRegion</code></li>
         * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
         * <li><code>UseLatestRestorableTime</code></li>
         * </ul>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must match the identifier of an existing Snapshot.</li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param snapshotIdentifier The identifier for the DB snapshot or DB cluster snapshot to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(final java.lang.String snapshotIdentifier) {
            this.props().snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        /**
         * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must match the identifier of an existing DBCluster.</li>
         * </ul>
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param sourceDbClusterIdentifier When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(final java.lang.String sourceDbClusterIdentifier) {
            this.props().sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        /**
         * The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, `us-east-1` .
         * <p>
         * Valid for: Aurora DB clusters only
         * <p>
         * @return {@code this}
         * @param sourceRegion The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, `us-east-1` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(final java.lang.String sourceRegion) {
            this.props().sourceRegion(sourceRegion);
            return this;
        }

        /**
         * Indicates whether the DB cluster is encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }
        /**
         * Indicates whether the DB cluster is encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final software.amazon.awscdk.core.IResolvable storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * Specifies the storage type to be associated with the DB cluster.
         * <p>
         * This setting is required to create a Multi-AZ DB cluster.
         * <p>
         * Valid values: <code>io1</code>
         * <p>
         * When specified, a value for the <code>Iops</code> parameter is required.
         * <p>
         * Default: <code>io1</code>
         * <p>
         * Valid for: Multi-AZ DB clusters only
         * <p>
         * @return {@code this}
         * @param storageType Specifies the storage type to be associated with the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props().storageType(storageType);
            return this;
        }

        /**
         * An optional array of key-value pairs to apply to this DB cluster.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param tags An optional array of key-value pairs to apply to this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         * <p>
         * By default, the DB cluster is not restored to the latest restorable backup time.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final java.lang.Boolean useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }
        /**
         * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         * <p>
         * By default, the DB cluster is not restored to the latest restorable backup time.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final software.amazon.awscdk.core.IResolvable useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        /**
         * A list of EC2 VPC security groups to associate with this DB cluster.
         * <p>
         * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         * <p>
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(final java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.props().vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBCluster build() {
            return new software.amazon.awscdk.services.rds.CfnDBCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.rds.CfnDBClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.rds.CfnDBClusterProps.Builder();
            }
            return this.props;
        }
    }
}
