package software.amazon.awscdk.services.rds;

/**
 * (experimental) The extra options passed to the {@link IClusterEngine.bindToCluster} method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.rds.*;
 * ParameterGroup parameterGroup;
 * Role role;
 * ClusterEngineBindOptions clusterEngineBindOptions = ClusterEngineBindOptions.builder()
 *         .parameterGroup(parameterGroup)
 *         .s3ExportRole(role)
 *         .s3ImportRole(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:07.973Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.ClusterEngineBindOptions")
@software.amazon.jsii.Jsii.Proxy(ClusterEngineBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClusterEngineBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The customer-provided ParameterGroup.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * (experimental) The role used for S3 exporting.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
        return null;
    }

    /**
     * (experimental) The role used for S3 importing.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterEngineBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterEngineBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterEngineBindOptions> {
        software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        software.amazon.awscdk.services.iam.IRole s3ExportRole;
        software.amazon.awscdk.services.iam.IRole s3ImportRole;

        /**
         * Sets the value of {@link ClusterEngineBindOptions#getParameterGroup}
         * @param parameterGroup The customer-provided ParameterGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameterGroup(software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link ClusterEngineBindOptions#getS3ExportRole}
         * @param s3ExportRole The role used for S3 exporting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3ExportRole(software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        /**
         * Sets the value of {@link ClusterEngineBindOptions#getS3ImportRole}
         * @param s3ImportRole The role used for S3 importing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3ImportRole(software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterEngineBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClusterEngineBindOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterEngineBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterEngineBindOptions {
        private final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        private final software.amazon.awscdk.services.iam.IRole s3ExportRole;
        private final software.amazon.awscdk.services.iam.IRole s3ImportRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IParameterGroup.class));
            this.s3ExportRole = software.amazon.jsii.Kernel.get(this, "s3ExportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.s3ImportRole = software.amazon.jsii.Kernel.get(this, "s3ImportRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parameterGroup = builder.parameterGroup;
            this.s3ExportRole = builder.s3ExportRole;
            this.s3ImportRole = builder.s3ImportRole;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ExportRole() {
            return this.s3ExportRole;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getS3ImportRole() {
            return this.s3ImportRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getS3ExportRole() != null) {
                data.set("s3ExportRole", om.valueToTree(this.getS3ExportRole()));
            }
            if (this.getS3ImportRole() != null) {
                data.set("s3ImportRole", om.valueToTree(this.getS3ImportRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_rds.ClusterEngineBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterEngineBindOptions.Jsii$Proxy that = (ClusterEngineBindOptions.Jsii$Proxy) o;

            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            if (this.s3ExportRole != null ? !this.s3ExportRole.equals(that.s3ExportRole) : that.s3ExportRole != null) return false;
            return this.s3ImportRole != null ? this.s3ImportRole.equals(that.s3ImportRole) : that.s3ImportRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parameterGroup != null ? this.parameterGroup.hashCode() : 0;
            result = 31 * result + (this.s3ExportRole != null ? this.s3ExportRole.hashCode() : 0);
            result = 31 * result + (this.s3ImportRole != null ? this.s3ImportRole.hashCode() : 0);
            return result;
        }
    }
}
