package software.amazon.awscdk.services.rds;

/**
 * (experimental) A database cluster engine.
 * <p>
 * Provides mapping to the serverless application
 * used for secret rotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AnotherCluster")
 *         .engine(DatabaseClusterEngine.AURORA_POSTGRESQL)
 *         .parameterGroup(ParameterGroup.fromParameterGroupName(this, "ParameterGroup", "default.aurora-postgresql10"))
 *         .vpc(vpc)
 *         .scaling(ServerlessScalingOptions.builder()
 *                 .autoPause(Duration.minutes(10)) // default is to pause after 5 minutes of idle time
 *                 .minCapacity(AuroraCapacityUnit.ACU_8) // default is 2 Aurora capacity units (ACUs)
 *                 .maxCapacity(AuroraCapacityUnit.ACU_32)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:08.001Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.DatabaseClusterEngine")
public class DatabaseClusterEngine extends software.amazon.jsii.JsiiObject {

    protected DatabaseClusterEngine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseClusterEngine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AURORA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "AURORA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
        AURORA_MYSQL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "AURORA_MYSQL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
        AURORA_POSTGRESQL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "AURORA_POSTGRESQL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DatabaseClusterEngine() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Creates a new plain Aurora database cluster engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine aurora(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraClusterEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "aurora", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Creates a new Aurora MySQL database cluster engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine auroraMysql(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraMysqlClusterEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "auroraMysql", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Creates a new Aurora PostgreSQL database cluster engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterEngine auroraPostgres(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraPostgresClusterEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseClusterEngine.class, "auroraPostgres", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The unversioned 'aurora' cluster engine.
     * <p>
     * <strong>Note</strong>: we do not recommend using unversioned engines for non-serverless Clusters,
     * as that can pose an availability risk.
     * We recommend using versioned engines created using the {&#64;link aurora()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.IClusterEngine AURORA;

    /**
     * (experimental) The unversioned 'aurora-msql' cluster engine.
     * <p>
     * <strong>Note</strong>: we do not recommend using unversioned engines for non-serverless Clusters,
     * as that can pose an availability risk.
     * We recommend using versioned engines created using the {&#64;link auroraMysql()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.IClusterEngine AURORA_MYSQL;

    /**
     * (experimental) The unversioned 'aurora-postgresql' cluster engine.
     * <p>
     * <strong>Note</strong>: we do not recommend using unversioned engines for non-serverless Clusters,
     * as that can pose an availability risk.
     * We recommend using versioned engines created using the {&#64;link auroraPostgres()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.rds.IClusterEngine AURORA_POSTGRESQL;
}
