package software.amazon.awscdk.services.rds;

/**
 * (experimental) A database secret.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Build a data source for AppSync to access the database.
 * GraphqlApi api;
 * // Create username and password secret for DB Cluster
 * DatabaseSecret secret = DatabaseSecret.Builder.create(this, "AuroraSecret")
 *         .username("clusteradmin")
 *         .build();
 * // The VPC to place the cluster in
 * Vpc vpc = new Vpc(this, "AuroraVpc");
 * // Create the serverless cluster, provide all values needed to customise the database.
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AuroraCluster")
 *         .engine(DatabaseClusterEngine.AURORA_MYSQL)
 *         .vpc(vpc)
 *         .credentials(Map.of("username", "clusteradmin"))
 *         .clusterIdentifier("db-endpoint-test")
 *         .defaultDatabaseName("demos")
 *         .build();
 * RdsDataSource rdsDS = api.addRdsDataSource("rds", cluster, secret, "demos");
 * // Set up a resolver for an RDS query.
 * rdsDS.createResolver(BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemosRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"SELECT * FROM demos\"\n    ]\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[0])\n  "))
 *         .build());
 * // Set up a resolver for an RDS mutation.
 * rdsDS.createResolver(BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemoRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"INSERT INTO demos VALUES (:id, :version)\",\n      \"SELECT * WHERE id = :id\"\n    ],\n    \"variableMap\": {\n      \":id\": $util.toJson($util.autoId()),\n      \":version\": $util.toJson($ctx.args.version)\n    }\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[1][0])\n  "))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:08.059Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_rds.DatabaseSecret")
public class DatabaseSecret extends software.amazon.awscdk.services.secretsmanager.Secret {

    protected DatabaseSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DatabaseSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseSecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.rds.DatabaseSecret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.DatabaseSecret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.DatabaseSecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.DatabaseSecretProps.Builder();
        }

        /**
         * (experimental) The username.
         * <p>
         * @return {@code this}
         * @param username The username. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * (experimental) The KMS key to use to encrypt the secret.
         * <p>
         * Default: default master key
         * <p>
         * @return {@code this}
         * @param encryptionKey The KMS key to use to encrypt the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * (experimental) Characters to not include in the generated password.
         * <p>
         * Default: " %+~`#$&*()|[]{}:;<>?!'/
         * <p>
         * @return {@code this}
         * @param excludeCharacters Characters to not include in the generated password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder excludeCharacters(final java.lang.String excludeCharacters) {
            this.props.excludeCharacters(excludeCharacters);
            return this;
        }

        /**
         * (experimental) The master secret which will be used to rotate this secret.
         * <p>
         * Default: - no master secret information will be included
         * <p>
         * @return {@code this}
         * @param masterSecret The master secret which will be used to rotate this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder masterSecret(final software.amazon.awscdk.services.secretsmanager.ISecret masterSecret) {
            this.props.masterSecret(masterSecret);
            return this;
        }

        /**
         * (experimental) Whether to replace this secret when the criteria for the password change.
         * <p>
         * This is achieved by overriding the logical id of the AWS::SecretsManager::Secret
         * with a hash of the options that influence the password generation. This
         * way a new secret will be created when the password is regenerated and the
         * cluster or instance consuming this secret will have its credentials updated.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param replaceOnPasswordCriteriaChanges Whether to replace this secret when the criteria for the password change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replaceOnPasswordCriteriaChanges(final java.lang.Boolean replaceOnPasswordCriteriaChanges) {
            this.props.replaceOnPasswordCriteriaChanges(replaceOnPasswordCriteriaChanges);
            return this;
        }

        /**
         * (experimental) A list of regions where to replicate this secret.
         * <p>
         * Default: - Secret is not replicated
         * <p>
         * @return {@code this}
         * @param replicaRegions A list of regions where to replicate this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder replicaRegions(final java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions) {
            this.props.replicaRegions(replicaRegions);
            return this;
        }

        /**
         * (experimental) A name for the secret.
         * <p>
         * Default: - A name is generated by CloudFormation.
         * <p>
         * @return {@code this}
         * @param secretName A name for the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretName(final java.lang.String secretName) {
            this.props.secretName(secretName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.DatabaseSecret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.rds.DatabaseSecret build() {
            return new software.amazon.awscdk.services.rds.DatabaseSecret(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
