package software.amazon.awscdk.services.redshift;

/**
 * Properties for defining a `CfnEndpointAuthorization`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * CfnEndpointAuthorizationProps cfnEndpointAuthorizationProps = CfnEndpointAuthorizationProps.builder()
 *         .account("account")
 *         .clusterIdentifier("clusterIdentifier")
 *         // the properties below are optional
 *         .force(false)
 *         .vpcIds(List.of("vpcIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:08.213Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_redshift.CfnEndpointAuthorizationProps")
@software.amazon.jsii.Jsii.Proxy(CfnEndpointAuthorizationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEndpointAuthorizationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The A AWS account ID of either the cluster owner (grantor) or grantee.
     * <p>
     * If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccount();

    /**
     * The cluster identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

    /**
     * Indicates whether to force the revoke action.
     * <p>
     * If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForce() {
        return null;
    }

    /**
     * The virtual private cloud (VPC) identifiers to grant access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEndpointAuthorizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEndpointAuthorizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEndpointAuthorizationProps> {
        java.lang.String account;
        java.lang.String clusterIdentifier;
        java.lang.Object force;
        java.util.List<java.lang.String> vpcIds;

        /**
         * Sets the value of {@link CfnEndpointAuthorizationProps#getAccount}
         * @param account The A AWS account ID of either the cluster owner (grantor) or grantee. This parameter is required.
         *                If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAuthorizationProps#getClusterIdentifier}
         * @param clusterIdentifier The cluster identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAuthorizationProps#getForce}
         * @param force Indicates whether to force the revoke action.
         *              If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(java.lang.Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAuthorizationProps#getForce}
         * @param force Indicates whether to force the revoke action.
         *              If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(software.amazon.awscdk.core.IResolvable force) {
            this.force = force;
            return this;
        }

        /**
         * Sets the value of {@link CfnEndpointAuthorizationProps#getVpcIds}
         * @param vpcIds The virtual private cloud (VPC) identifiers to grant access to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcIds(java.util.List<java.lang.String> vpcIds) {
            this.vpcIds = vpcIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEndpointAuthorizationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEndpointAuthorizationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEndpointAuthorizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEndpointAuthorizationProps {
        private final java.lang.String account;
        private final java.lang.String clusterIdentifier;
        private final java.lang.Object force;
        private final java.util.List<java.lang.String> vpcIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.force = software.amazon.jsii.Kernel.get(this, "force", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcIds = software.amazon.jsii.Kernel.get(this, "vpcIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.account = java.util.Objects.requireNonNull(builder.account, "account is required");
            this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
            this.force = builder.force;
            this.vpcIds = builder.vpcIds;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.Object getForce() {
            return this.force;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcIds() {
            return this.vpcIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("account", om.valueToTree(this.getAccount()));
            data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            if (this.getForce() != null) {
                data.set("force", om.valueToTree(this.getForce()));
            }
            if (this.getVpcIds() != null) {
                data.set("vpcIds", om.valueToTree(this.getVpcIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_redshift.CfnEndpointAuthorizationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEndpointAuthorizationProps.Jsii$Proxy that = (CfnEndpointAuthorizationProps.Jsii$Proxy) o;

            if (!account.equals(that.account)) return false;
            if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
            if (this.force != null ? !this.force.equals(that.force) : that.force != null) return false;
            return this.vpcIds != null ? this.vpcIds.equals(that.vpcIds) : that.vpcIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.account.hashCode();
            result = 31 * result + (this.clusterIdentifier.hashCode());
            result = 31 * result + (this.force != null ? this.force.hashCode() : 0);
            result = 31 * result + (this.vpcIds != null ? this.vpcIds.hashCode() : 0);
            return result;
        }
    }
}
