package software.amazon.awscdk.services.route53;

/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 * <p>
 * Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
 * <p>
 * <blockquote>
 * <p>
 * You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.
 * <p>
 * </blockquote>
 * <p>
 * For more information about charges for hosted zones, see <a href="https://docs.aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a> .
 * <p>
 * Note the following:
 * <p>
 * <ul>
 * <li>You can't create a hosted zone for a top-level domain (TLD) such as .com.</li>
 * <li>If your domain is registered with a registrar other than Route 53, you must update the name servers with your registrar to make Route 53 the DNS service for the domain. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html">Migrating DNS Service for an Existing Domain to Amazon Route 53</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
 * </ul>
 * <p>
 * When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is <code>PENDING</code> . For public hosted zones, this means that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to <code>INSYNC</code> .
 * <p>
 * The <code>CreateHostedZone</code> request requires the caller to have an <code>ec2:DescribeVpcs</code> permission.
 * <p>
 * <blockquote>
 * <p>
 * When creating private hosted zones, the Amazon VPC must belong to the same partition where the hosted zone is created. A partition is a group of AWS Regions . Each AWS account is scoped to one partition.
 * <p>
 * The following are the supported partitions:
 * <p>
 * <ul>
 * <li><code>aws</code> - AWS Regions</li>
 * <li><code>aws-cn</code> - China Regions</li>
 * <li><code>aws-us-gov</code> - AWS GovCloud (US) Region</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Access Management</a> in the <em>AWS General Reference</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CfnHostedZone cfnHostedZone = CfnHostedZone.Builder.create(this, "MyCfnHostedZone")
 *         .hostedZoneConfig(HostedZoneConfigProperty.builder()
 *                 .comment("comment")
 *                 .build())
 *         .hostedZoneTags(List.of(HostedZoneTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .name("name")
 *         .queryLoggingConfig(QueryLoggingConfigProperty.builder()
 *                 .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *                 .build())
 *         .vpcs(List.of(VPCProperty.builder()
 *                 .vpcId("vpcId")
 *                 .vpcRegion("vpcRegion")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:08.485Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53.CfnHostedZone")
public class CfnHostedZone extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnHostedZone(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnHostedZone(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.CfnHostedZone.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Route53::HostedZone`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnHostedZone(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnHostedZoneProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Route53::HostedZone`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnHostedZone(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the set of name servers for the specific hosted zone. For example: `ns1.example.com` .
     * <p>
     * This attribute is not supported for private hosted zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrNameServers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrNameServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Adds, edits, or deletes tags for a health check or a hosted zone.
     * <p>
     * For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * A complex type that contains an optional comment.
     * <p>
     * If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHostedZoneConfig() {
        return software.amazon.jsii.Kernel.get(this, "hostedZoneConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A complex type that contains an optional comment.
     * <p>
     * If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "hostedZoneConfig", value);
    }

    /**
     * A complex type that contains an optional comment.
     * <p>
     * If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hostedZoneConfig", value);
    }

    /**
     * The name of the domain.
     * <p>
     * Specify a fully qualified domain name, for example, <em>www.example.com</em> . The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <em>www.example.com</em> (without a trailing dot) and <em>www.example.com.</em> (with a trailing dot) as identical.
     * <p>
     * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that are returned by the <code>Fn::GetAtt</code> intrinsic function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the domain.
     * <p>
     * Specify a fully qualified domain name, for example, <em>www.example.com</em> . The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <em>www.example.com</em> (without a trailing dot) and <em>www.example.com.</em> (with a trailing dot) as identical.
     * <p>
     * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that are returned by the <code>Fn::GetAtt</code> intrinsic function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Creates a configuration for DNS query logging.
     * <p>
     * After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
     * <p>
     * <ul>
     * <li>Route 53 edge location that responded to the DNS query</li>
     * <li>Domain or subdomain that was requested</li>
     * <li>DNS record type, such as A or AAAA</li>
     * <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
     * <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
     * <li>You must create the log group in the us-east-1 region.</li>
     * <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
     * <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
     * </ul>
     * <p>
     * <code>/aws/route53/ *hosted zone name*</code>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
     * </ul>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * <p>
     * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
     * <p>
     * <ul>
     * <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
     * <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
     * <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
     * <li>Begins to send query logs to the applicable log stream.</li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * <p>
     * <code>*hosted zone ID* / *edge location code*</code>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
     * <p>
     * <ul>
     * <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
     * <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getQueryLoggingConfig() {
        return software.amazon.jsii.Kernel.get(this, "queryLoggingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates a configuration for DNS query logging.
     * <p>
     * After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
     * <p>
     * <ul>
     * <li>Route 53 edge location that responded to the DNS query</li>
     * <li>Domain or subdomain that was requested</li>
     * <li>DNS record type, such as A or AAAA</li>
     * <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
     * <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
     * <li>You must create the log group in the us-east-1 region.</li>
     * <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
     * <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
     * </ul>
     * <p>
     * <code>/aws/route53/ *hosted zone name*</code>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
     * </ul>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * <p>
     * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
     * <p>
     * <ul>
     * <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
     * <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
     * <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
     * <li>Begins to send query logs to the applicable log stream.</li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * <p>
     * <code>*hosted zone ID* / *edge location code*</code>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
     * <p>
     * <ul>
     * <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
     * <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryLoggingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnHostedZone.QueryLoggingConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "queryLoggingConfig", value);
    }

    /**
     * Creates a configuration for DNS query logging.
     * <p>
     * After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
     * <p>
     * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
     * <p>
     * <ul>
     * <li>Route 53 edge location that responded to the DNS query</li>
     * <li>Domain or subdomain that was requested</li>
     * <li>DNS record type, such as A or AAAA</li>
     * <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
     * <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
     * <li>You must create the log group in the us-east-1 region.</li>
     * <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
     * <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
     * </ul>
     * <p>
     * <code>/aws/route53/ *hosted zone name*</code>
     * <p>
     * In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
     * <p>
     * <ul>
     * <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
     * </ul>
     * <p>
     * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
     * <p>
     * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
     * <p>
     * <ul>
     * <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
     * <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
     * <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
     * <li>Begins to send query logs to the applicable log stream.</li>
     * </ul>
     * <p>
     * The name of each log stream is in the following format:
     * <p>
     * <code>*hosted zone ID* / *edge location code*</code>
     * <p>
     * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
     * <p>
     * <ul>
     * <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
     * <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryLoggingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "queryLoggingConfig", value);
    }

    /**
     * *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone.
     * <p>
     * <blockquote>
     * <p>
     * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcs() {
        return software.amazon.jsii.Kernel.get(this, "vpcs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone.
     * <p>
     * <blockquote>
     * <p>
     * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcs", value);
    }

    /**
     * *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone.
     * <p>
     * <blockquote>
     * <p>
     * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.route53.CfnHostedZone.VPCProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.route53.CfnHostedZone.VPCProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "vpcs", value);
    }
    /**
     * A complex type that contains an optional comment about your hosted zone.
     * <p>
     * If you don't want to specify a comment, omit both the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * HostedZoneConfigProperty hostedZoneConfigProperty = HostedZoneConfigProperty.builder()
     *         .comment("comment")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53.CfnHostedZone.HostedZoneConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HostedZoneConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostedZoneConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Any comments that you want to include about the hosted zone.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostedZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostedZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostedZoneConfigProperty> {
            java.lang.String comment;

            /**
             * Sets the value of {@link HostedZoneConfigProperty#getComment}
             * @param comment Any comments that you want to include about the hosted zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostedZoneConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostedZoneConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostedZoneConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedZoneConfigProperty {
            private final java.lang.String comment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comment = builder.comment;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_route53.CfnHostedZone.HostedZoneConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostedZoneConfigProperty.Jsii$Proxy that = (HostedZoneConfigProperty.Jsii$Proxy) o;

                return this.comment != null ? this.comment.equals(that.comment) : that.comment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comment != null ? this.comment.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about a tag that you want to add or edit for the specified health check or hosted zone.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * HostedZoneTagProperty hostedZoneTagProperty = HostedZoneTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53.CfnHostedZone.HostedZoneTagProperty")
    @software.amazon.jsii.Jsii.Proxy(HostedZoneTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostedZoneTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of `Key` depends on the operation that you want to perform:.
         * <p>
         * <ul>
         * <li><em>Add a tag to a health check or hosted zone</em> : <code>Key</code> is the name that you want to give the new tag.</li>
         * <li><em>Edit a tag</em> : <code>Key</code> is the name of the tag that you want to change the <code>Value</code> for.</li>
         * <li><em>Delete a key</em> : <code>Key</code> is the name of the tag you want to remove.</li>
         * <li><em>Give a name to a health check</em> : Edit the default <code>Name</code> tag. In the Amazon Route 53 console, the list of your health checks includes a <em>Name</em> column that lets you see the name that you've given to each health check.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of `Value` depends on the operation that you want to perform:.
         * <p>
         * <ul>
         * <li><em>Add a tag to a health check or hosted zone</em> : <code>Value</code> is the value that you want to give the new tag.</li>
         * <li><em>Edit a tag</em> : <code>Value</code> is the new value that you want to assign the tag.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link HostedZoneTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostedZoneTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostedZoneTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link HostedZoneTagProperty#getKey}
             * @param key The value of `Key` depends on the operation that you want to perform:. This parameter is required.
             *            <ul>
             *            <li><em>Add a tag to a health check or hosted zone</em> : <code>Key</code> is the name that you want to give the new tag.</li>
             *            <li><em>Edit a tag</em> : <code>Key</code> is the name of the tag that you want to change the <code>Value</code> for.</li>
             *            <li><em>Delete a key</em> : <code>Key</code> is the name of the tag you want to remove.</li>
             *            <li><em>Give a name to a health check</em> : Edit the default <code>Name</code> tag. In the Amazon Route 53 console, the list of your health checks includes a <em>Name</em> column that lets you see the name that you've given to each health check.</li>
             *            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link HostedZoneTagProperty#getValue}
             * @param value The value of `Value` depends on the operation that you want to perform:. This parameter is required.
             *              <ul>
             *              <li><em>Add a tag to a health check or hosted zone</em> : <code>Value</code> is the value that you want to give the new tag.</li>
             *              <li><em>Edit a tag</em> : <code>Value</code> is the new value that you want to assign the tag.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostedZoneTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostedZoneTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostedZoneTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedZoneTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_route53.CfnHostedZone.HostedZoneTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostedZoneTagProperty.Jsii$Proxy that = (HostedZoneTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about a configuration for DNS query logging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * QueryLoggingConfigProperty queryLoggingConfigProperty = QueryLoggingConfigProperty.builder()
     *         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53.CfnHostedZone.QueryLoggingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryLoggingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryLoggingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCloudWatchLogsLogGroupArn();

        /**
         * @return a {@link Builder} of {@link QueryLoggingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryLoggingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryLoggingConfigProperty> {
            java.lang.String cloudWatchLogsLogGroupArn;

            /**
             * Sets the value of {@link QueryLoggingConfigProperty#getCloudWatchLogsLogGroupArn}
             * @param cloudWatchLogsLogGroupArn The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroupArn(java.lang.String cloudWatchLogsLogGroupArn) {
                this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryLoggingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryLoggingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryLoggingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryLoggingConfigProperty {
            private final java.lang.String cloudWatchLogsLogGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsLogGroupArn = java.util.Objects.requireNonNull(builder.cloudWatchLogsLogGroupArn, "cloudWatchLogsLogGroupArn is required");
            }

            @Override
            public final java.lang.String getCloudWatchLogsLogGroupArn() {
                return this.cloudWatchLogsLogGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchLogsLogGroupArn", om.valueToTree(this.getCloudWatchLogsLogGroupArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_route53.CfnHostedZone.QueryLoggingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryLoggingConfigProperty.Jsii$Proxy that = (QueryLoggingConfigProperty.Jsii$Proxy) o;

                return this.cloudWatchLogsLogGroupArn.equals(that.cloudWatchLogsLogGroupArn);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsLogGroupArn.hashCode();
                return result;
            }
        }
    }
    /**
     * *Private hosted zones only:* A complex type that contains information about an Amazon VPC.
     * <p>
     * Route 53 Resolver uses the records in the private hosted zone to route traffic in that VPC.
     * <p>
     * <blockquote>
     * <p>
     * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * VPCProperty vPCProperty = VPCProperty.builder()
     *         .vpcId("vpcId")
     *         .vpcRegion("vpcRegion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53.CfnHostedZone.VPCProperty")
    @software.amazon.jsii.Jsii.Proxy(VPCProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VPCProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * *Private hosted zones only:* The ID of an Amazon VPC.
         * <p>
         * <blockquote>
         * <p>
         * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

        /**
         * *Private hosted zones only:* The region that an Amazon VPC was created in.
         * <p>
         * <blockquote>
         * <p>
         * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVpcRegion();

        /**
         * @return a {@link Builder} of {@link VPCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VPCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VPCProperty> {
            java.lang.String vpcId;
            java.lang.String vpcRegion;

            /**
             * Sets the value of {@link VPCProperty#getVpcId}
             * @param vpcId *Private hosted zones only:* The ID of an Amazon VPC. This parameter is required.
             *              <blockquote>
             *              <p>
             *              For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Sets the value of {@link VPCProperty#getVpcRegion}
             * @param vpcRegion *Private hosted zones only:* The region that an Amazon VPC was created in. This parameter is required.
             *                  <blockquote>
             *                  <p>
             *                  For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcRegion(java.lang.String vpcRegion) {
                this.vpcRegion = vpcRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VPCProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VPCProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VPCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPCProperty {
            private final java.lang.String vpcId;
            private final java.lang.String vpcRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcRegion = software.amazon.jsii.Kernel.get(this, "vpcRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
                this.vpcRegion = java.util.Objects.requireNonNull(builder.vpcRegion, "vpcRegion is required");
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            public final java.lang.String getVpcRegion() {
                return this.vpcRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("vpcId", om.valueToTree(this.getVpcId()));
                data.set("vpcRegion", om.valueToTree(this.getVpcRegion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_route53.CfnHostedZone.VPCProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VPCProperty.Jsii$Proxy that = (VPCProperty.Jsii$Proxy) o;

                if (!vpcId.equals(that.vpcId)) return false;
                return this.vpcRegion.equals(that.vpcRegion);
            }

            @Override
            public final int hashCode() {
                int result = this.vpcId.hashCode();
                result = 31 * result + (this.vpcRegion.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.CfnHostedZone}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CfnHostedZone> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.route53.CfnHostedZoneProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A complex type that contains an optional comment.
         * <p>
         * If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
         * <p>
         * @return {@code this}
         * @param hostedZoneConfig A complex type that contains an optional comment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneConfig(final software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneConfigProperty hostedZoneConfig) {
            this.props().hostedZoneConfig(hostedZoneConfig);
            return this;
        }
        /**
         * A complex type that contains an optional comment.
         * <p>
         * If you don't want to specify a comment, omit the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
         * <p>
         * @return {@code this}
         * @param hostedZoneConfig A complex type that contains an optional comment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneConfig(final software.amazon.awscdk.core.IResolvable hostedZoneConfig) {
            this.props().hostedZoneConfig(hostedZoneConfig);
            return this;
        }

        /**
         * Adds, edits, or deletes tags for a health check or a hosted zone.
         * <p>
         * For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
         * <p>
         * @return {@code this}
         * @param hostedZoneTags Adds, edits, or deletes tags for a health check or a hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneTags(final java.util.List<? extends software.amazon.awscdk.services.route53.CfnHostedZone.HostedZoneTagProperty> hostedZoneTags) {
            this.props().hostedZoneTags(hostedZoneTags);
            return this;
        }

        /**
         * The name of the domain.
         * <p>
         * Specify a fully qualified domain name, for example, <em>www.example.com</em> . The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <em>www.example.com</em> (without a trailing dot) and <em>www.example.com.</em> (with a trailing dot) as identical.
         * <p>
         * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that are returned by the <code>Fn::GetAtt</code> intrinsic function.
         * <p>
         * @return {@code this}
         * @param name The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * Creates a configuration for DNS query logging.
         * <p>
         * After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
         * <p>
         * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
         * <p>
         * <ul>
         * <li>Route 53 edge location that responded to the DNS query</li>
         * <li>Domain or subdomain that was requested</li>
         * <li>DNS record type, such as A or AAAA</li>
         * <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
         * <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
         * <li>You must create the log group in the us-east-1 region.</li>
         * <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
         * <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
         * </ul>
         * <p>
         * <code>/aws/route53/ *hosted zone name*</code>
         * <p>
         * In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
         * <p>
         * <ul>
         * <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
         * </ul>
         * <p>
         * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
         * <p>
         * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
         * <p>
         * <ul>
         * <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
         * <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
         * <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
         * <li>Begins to send query logs to the applicable log stream.</li>
         * </ul>
         * <p>
         * The name of each log stream is in the following format:
         * <p>
         * <code>*hosted zone ID* / *edge location code*</code>
         * <p>
         * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
         * <p>
         * <ul>
         * <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         * <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         * <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
         * <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param queryLoggingConfig Creates a configuration for DNS query logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfig(final software.amazon.awscdk.services.route53.CfnHostedZone.QueryLoggingConfigProperty queryLoggingConfig) {
            this.props().queryLoggingConfig(queryLoggingConfig);
            return this;
        }
        /**
         * Creates a configuration for DNS query logging.
         * <p>
         * After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
         * <p>
         * DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:
         * <p>
         * <ul>
         * <li>Route 53 edge location that responded to the DNS query</li>
         * <li>Domain or subdomain that was requested</li>
         * <li>DNS record type, such as A or AAAA</li>
         * <li>DNS response code, such as <code>NoError</code> or <code>ServFail</code></li>
         * <li><strong>Log Group and Resource Policy</strong> - Before you create a query logging configuration, perform the following operations.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</li>
         * <li>You must create the log group in the us-east-1 region.</li>
         * <li>You must use the same AWS account to create the log group and the hosted zone that you want to configure query logging for.</li>
         * <li>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</li>
         * </ul>
         * <p>
         * <code>/aws/route53/ *hosted zone name*</code>
         * <p>
         * In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated AWS resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.
         * <p>
         * <ul>
         * <li>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of <code>Resource</code> , specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code> , for example:</li>
         * </ul>
         * <p>
         * <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code>
         * <p>
         * To avoid the confused deputy problem, a security issue where an entity without a permission for an action can coerce a more-privileged entity to perform it, you can optionally limit the permissions that a service has to a resource in a resource-based policy by supplying the following values:
         * <p>
         * <ul>
         * <li>For <code>aws:SourceArn</code> , supply the hosted zone ARN used in creating the query logging configuration. For example, <code>aws:SourceArn: arn:aws:route53:::hostedzone/hosted zone ID</code> .</li>
         * <li>For <code>aws:SourceAccount</code> , supply the account ID for the account that creates the query logging configuration. For example, <code>aws:SourceAccount:111111111111</code> .</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html">The confused deputy problem</a> in the <em>AWS IAM User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the AWS SDKs, or the AWS CLI .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>Log Streams and Edge Locations</strong> - When Route 53 finishes creating the configuration for DNS query logging, it does the following:</li>
         * <li>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</li>
         * <li>Begins to send query logs to the applicable log stream.</li>
         * </ul>
         * <p>
         * The name of each log stream is in the following format:
         * <p>
         * <code>*hosted zone ID* / *edge location code*</code>
         * <p>
         * The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="https://docs.aws.amazon.com/route53/details/">Route 53 Product Details</a> page.
         * <p>
         * <ul>
         * <li><strong>Queries That Are Logged</strong> - Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         * <li><strong>Log File Format</strong> - For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         * <li><strong>Pricing</strong> - For information about charges for query logs, see <a href="https://docs.aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a> .</li>
         * <li><strong>How to Stop Logging</strong> - If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param queryLoggingConfig Creates a configuration for DNS query logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLoggingConfig(final software.amazon.awscdk.core.IResolvable queryLoggingConfig) {
            this.props().queryLoggingConfig(queryLoggingConfig);
            return this;
        }

        /**
         * *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * <p>
         * <blockquote>
         * <p>
         * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param vpcs *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcs(final software.amazon.awscdk.core.IResolvable vpcs) {
            this.props().vpcs(vpcs);
            return this;
        }
        /**
         * *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * <p>
         * <blockquote>
         * <p>
         * For public hosted zones, omit <code>VPCs</code> , <code>VPCId</code> , and <code>VPCRegion</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param vpcs *Private hosted zones:* A complex type that contains information about the VPCs that are associated with the specified hosted zone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcs(final java.util.List<? extends java.lang.Object> vpcs) {
            this.props().vpcs(vpcs);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.CfnHostedZone}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.CfnHostedZone build() {
            return new software.amazon.awscdk.services.route53.CfnHostedZone(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.route53.CfnHostedZoneProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.route53.CfnHostedZoneProps.Builder();
            }
            return this.props;
        }
    }
}
