package software.amazon.awscdk.services.route53;

/**
 * (experimental) A Private DNS configuration for a VPC endpoint service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.route53.HostedZone;
 * import software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName;
 * HostedZone zone;
 * VpcEndpointService vpces;
 * VpcEndpointServiceDomainName.Builder.create(this, "EndpointDomain")
 *         .endpointService(vpces)
 *         .domainName("my-stuff.aws-cdk.dev")
 *         .publicHostedZone(zone)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:08.601Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53.VpcEndpointServiceDomainName")
public class VpcEndpointServiceDomainName extends software.amazon.awscdk.core.Construct {

    protected VpcEndpointServiceDomainName(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcEndpointServiceDomainName(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public VpcEndpointServiceDomainName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.VpcEndpointServiceDomainNameProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The domain name associated with the private DNS configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The domain name associated with the private DNS configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.VpcEndpointServiceDomainNameProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.VpcEndpointServiceDomainNameProps.Builder();
        }

        /**
         * (experimental) The domain name to use.
         * <p>
         * This domain name must be owned by this account (registered through Route53),
         * or delegated to this account. Domain ownership will be verified by AWS before
         * private DNS can be used.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html</a>
         * @param domainName The domain name to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * (experimental) The VPC Endpoint Service to configure Private DNS for.
         * <p>
         * @return {@code this}
         * @param endpointService The VPC Endpoint Service to configure Private DNS for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endpointService(final software.amazon.awscdk.services.ec2.IVpcEndpointService endpointService) {
            this.props.endpointService(endpointService);
            return this;
        }

        /**
         * (experimental) The public hosted zone to use for the domain.
         * <p>
         * @return {@code this}
         * @param publicHostedZone The public hosted zone to use for the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publicHostedZone(final software.amazon.awscdk.services.route53.IPublicHostedZone publicHostedZone) {
            this.props.publicHostedZone(publicHostedZone);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName build() {
            return new software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
