package software.amazon.awscdk.services.route53.targets;

/**
 * (experimental) Defines an API Gateway REST API as the alias target. Requires that the domain name will be defined through `RestApiProps.domainName`.
 * <p>
 * You can direct the alias to any <code>apigateway.DomainName</code> resource through the
 * <code>ApiGatewayDomain</code> class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * RestApi api;
 * Object hostedZoneForExampleCom;
 * ARecord.Builder.create(this, "CustomDomainAliasRecord")
 *         .zone(hostedZoneForExampleCom)
 *         .target(RecordTarget.fromAlias(new ApiGateway(api)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:08.622Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53_targets.ApiGateway")
public class ApiGateway extends software.amazon.awscdk.services.route53.targets.ApiGatewayDomain {

    protected ApiGateway(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiGateway(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param api This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ApiGateway(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApiBase api) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(api, "api is required") });
    }
}
