package software.amazon.awscdk.services.route53resolver;

/**
 * A CloudFormation `AWS::Route53Resolver::ResolverConfig`.
 * <p>
 * A complex type that contains information about a Resolver configuration for a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * CfnResolverConfig cfnResolverConfig = CfnResolverConfig.Builder.create(this, "MyCfnResolverConfig")
 *         .autodefinedReverseFlag("autodefinedReverseFlag")
 *         .resourceId("resourceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:08.703Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_route53resolver.CfnResolverConfig")
public class CfnResolverConfig extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnResolverConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResolverConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53resolver.CfnResolverConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Route53Resolver::ResolverConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResolverConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53resolver.CfnResolverConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The status of whether or not the Route 53 Resolver will create autodefined rules for reverse DNS lookups.
     * <p>
     * This is enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAutodefinedReverse() {
        return software.amazon.jsii.Kernel.get(this, "attrAutodefinedReverse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ID for the Route 53 Resolver configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The owner account ID of the Amazon Virtual Private Cloud VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOwnerId() {
        return software.amazon.jsii.Kernel.get(this, "attrOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Represents the desired status of `AutodefinedReverse` .
     * <p>
     * The only supported value on creation is <code>DISABLE</code> . Deletion of this resource will return <code>AutodefinedReverse</code> to its default value of <code>ENABLED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutodefinedReverseFlag() {
        return software.amazon.jsii.Kernel.get(this, "autodefinedReverseFlag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Represents the desired status of `AutodefinedReverse` .
     * <p>
     * The only supported value on creation is <code>DISABLE</code> . Deletion of this resource will return <code>AutodefinedReverse</code> to its default value of <code>ENABLED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutodefinedReverseFlag(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autodefinedReverseFlag", java.util.Objects.requireNonNull(value, "autodefinedReverseFlag is required"));
    }

    /**
     * The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53resolver.CfnResolverConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53resolver.CfnResolverConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53resolver.CfnResolverConfigProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53resolver.CfnResolverConfigProps.Builder();
        }

        /**
         * Represents the desired status of `AutodefinedReverse` .
         * <p>
         * The only supported value on creation is <code>DISABLE</code> . Deletion of this resource will return <code>AutodefinedReverse</code> to its default value of <code>ENABLED</code> .
         * <p>
         * @return {@code this}
         * @param autodefinedReverseFlag Represents the desired status of `AutodefinedReverse` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autodefinedReverseFlag(final java.lang.String autodefinedReverseFlag) {
            this.props.autodefinedReverseFlag(autodefinedReverseFlag);
            return this;
        }

        /**
         * The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for.
         * <p>
         * @return {@code this}
         * @param resourceId The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53resolver.CfnResolverConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53resolver.CfnResolverConfig build() {
            return new software.amazon.awscdk.services.route53resolver.CfnResolverConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
