package software.amazon.awscdk.services.s3;

/**
 * (experimental) All supported inventory frequencies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket inventoryBucket = new Bucket(this, "InventoryBucket");
 * Bucket dataBucket = Bucket.Builder.create(this, "DataBucket")
 *         .inventories(List.of(Inventory.builder()
 *                 .frequency(InventoryFrequency.DAILY)
 *                 .includeObjectVersions(InventoryObjectVersion.CURRENT)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .build())
 *                 .build(), Inventory.builder()
 *                 .frequency(InventoryFrequency.WEEKLY)
 *                 .includeObjectVersions(InventoryObjectVersion.ALL)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .prefix("with-all-versions")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:09.001Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3.InventoryFrequency")
public enum InventoryFrequency {
    /**
     * (experimental) A report is generated every day.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DAILY,
    /**
     * (experimental) A report is generated every Sunday (UTC timezone) after the initial report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    WEEKLY,
}
