package software.amazon.awscdk.services.s3;

/**
 * (experimental) The ObjectOwnership of the bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket.Builder.create(this, "MyBucket")
 *         .objectOwnership(ObjectOwnership.OBJECT_WRITER)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:09.008Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3.ObjectOwnership")
public enum ObjectOwnership {
    /**
     * (experimental) ACLs are disabled, and the bucket owner automatically owns and has full control over every object in the bucket.
     * <p>
     * ACLs no longer affect permissions to data in the S3 bucket.
     * The bucket uses policies to define access control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BUCKET_OWNER_ENFORCED,
    /**
     * (experimental) Objects uploaded to the bucket change ownership to the bucket owner .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BUCKET_OWNER_PREFERRED,
    /**
     * (experimental) The uploading account will own the object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OBJECT_WRITER,
}
