package software.amazon.awscdk.services.s3outposts;

/**
 * A CloudFormation `AWS::S3Outposts::Bucket`.
 * <p>
 * The AWS::S3Outposts::Bucket resource specifies a new Amazon S3 on Outposts bucket. To create an S3 on Outposts bucket, you must have S3 on Outposts capacity provisioned on your Outpost. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> .
 * <p>
 * S3 on Outposts buckets support the following:
 * <p>
 * <ul>
 * <li>Tags</li>
 * <li>Lifecycle configuration rules for deleting expired objects</li>
 * </ul>
 * <p>
 * For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html">Amazon S3 on Outposts Restrictions and Limitations</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3outposts.*;
 * Object filter;
 * CfnBucket cfnBucket = CfnBucket.Builder.create(this, "MyCfnBucket")
 *         .bucketName("bucketName")
 *         .outpostId("outpostId")
 *         // the properties below are optional
 *         .lifecycleConfiguration(LifecycleConfigurationProperty.builder()
 *                 .rules(List.of(RuleProperty.builder()
 *                         .status("status")
 *                         // the properties below are optional
 *                         .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
 *                                 .daysAfterInitiation(123)
 *                                 .build())
 *                         .expirationDate("expirationDate")
 *                         .expirationInDays(123)
 *                         .filter(filter)
 *                         .id("id")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:09.101Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3outposts.CfnBucket")
public class CfnBucket extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnBucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3outposts.CfnBucket.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::S3Outposts::Bucket`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3outposts.CfnBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the ARN of the specified bucket.
     * <p>
     * Example: <code>arn:aws:s3Outposts:::DOC-EXAMPLE-BUCKET</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Sets the tags for an S3 on Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) .
     * <p>
     * Use tags to organize your AWS bill to reflect your own cost structure. To do this, sign up to get your AWS account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost allocation and tags</a> .
     * <p>
     * <blockquote>
     * <p>
     * Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html">Using cost allocation and bucket tags</a> .
     * <p>
     * </blockquote>
     * <p>
     * To use this resource, you must have permissions to perform the <code>s3-outposts:PutBucketTagging</code> . The S3 on Outposts bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions to your Amazon S3 resources</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * A name for the S3 on Outposts bucket.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Bucket naming rules</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the S3 on Outposts bucket.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Bucket naming rules</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketName", java.util.Objects.requireNonNull(value, "bucketName is required"));
    }

    /**
     * The ID of the Outpost of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOutpostId() {
        return software.amazon.jsii.Kernel.get(this, "outpostId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Outpost of the specified bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutpostId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "outpostId", java.util.Objects.requireNonNull(value, "outpostId is required"));
    }

    /**
     * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration.
     * <p>
     * Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lifecycleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration.
     * <p>
     * Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3outposts.CfnBucket.LifecycleConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleConfiguration", value);
    }

    /**
     * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration.
     * <p>
     * Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleConfiguration", value);
    }
    /**
     * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 on Outposts waits before permanently removing all parts of the upload.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3outposts.*;
     * AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUploadProperty = AbortIncompleteMultipartUploadProperty.builder()
     *         .daysAfterInitiation(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3outposts.CfnBucket.AbortIncompleteMultipartUploadProperty")
    @software.amazon.jsii.Jsii.Proxy(AbortIncompleteMultipartUploadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days after initiation that Amazon S3 on Outposts aborts an incomplete multipart upload.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDaysAfterInitiation();

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AbortIncompleteMultipartUploadProperty> {
            java.lang.Number daysAfterInitiation;

            /**
             * Sets the value of {@link AbortIncompleteMultipartUploadProperty#getDaysAfterInitiation}
             * @param daysAfterInitiation Specifies the number of days after initiation that Amazon S3 on Outposts aborts an incomplete multipart upload. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysAfterInitiation(java.lang.Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AbortIncompleteMultipartUploadProperty {
            private final java.lang.Number daysAfterInitiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daysAfterInitiation = software.amazon.jsii.Kernel.get(this, "daysAfterInitiation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daysAfterInitiation = java.util.Objects.requireNonNull(builder.daysAfterInitiation, "daysAfterInitiation is required");
            }

            @Override
            public final java.lang.Number getDaysAfterInitiation() {
                return this.daysAfterInitiation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_s3outposts.CfnBucket.AbortIncompleteMultipartUploadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AbortIncompleteMultipartUploadProperty.Jsii$Proxy that = (AbortIncompleteMultipartUploadProperty.Jsii$Proxy) o;

                return this.daysAfterInitiation.equals(that.daysAfterInitiation);
            }

            @Override
            public final int hashCode() {
                int result = this.daysAfterInitiation.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3outposts.*;
     * FilterAndOperatorProperty filterAndOperatorProperty = FilterAndOperatorProperty.builder()
     *         .tags(List.of(FilterTagProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         // the properties below are optional
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3outposts.CfnBucket.FilterAndOperatorProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterAndOperatorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterAndOperatorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.FilterAndOperatorProperty.Tags`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty> getTags();

        /**
         * `CfnBucket.FilterAndOperatorProperty.Prefix`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterAndOperatorProperty> {
            java.util.List<software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty> tags;
            java.lang.String prefix;

            /**
             * Sets the value of {@link FilterAndOperatorProperty#getTags}
             * @param tags `CfnBucket.FilterAndOperatorProperty.Tags`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty>)tags;
                return this;
            }

            /**
             * Sets the value of {@link FilterAndOperatorProperty#getPrefix}
             * @param prefix `CfnBucket.FilterAndOperatorProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterAndOperatorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterAndOperatorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterAndOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterAndOperatorProperty {
            private final java.util.List<software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty> tags;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty.class)));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tags = (java.util.List<software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty>)java.util.Objects.requireNonNull(builder.tags, "tags is required");
                this.prefix = builder.prefix;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty> getTags() {
                return this.tags;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tags", om.valueToTree(this.getTags()));
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_s3outposts.CfnBucket.FilterAndOperatorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterAndOperatorProperty.Jsii$Proxy that = (FilterAndOperatorProperty.Jsii$Proxy) o;

                if (!tags.equals(that.tags)) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tags.hashCode();
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3outposts.*;
     * FilterProperty filterProperty = FilterProperty.builder()
     *         .andOperator(FilterAndOperatorProperty.builder()
     *                 .tags(List.of(FilterTagProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 // the properties below are optional
     *                 .prefix("prefix")
     *                 .build())
     *         .prefix("prefix")
     *         .tag(FilterTagProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3outposts.CfnBucket.FilterProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.FilterProperty.AndOperator`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAndOperator() {
            return null;
        }

        /**
         * `CfnBucket.FilterProperty.Prefix`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * `CfnBucket.FilterProperty.Tag`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTag() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterProperty> {
            java.lang.Object andOperator;
            java.lang.String prefix;
            java.lang.Object tag;

            /**
             * Sets the value of {@link FilterProperty#getAndOperator}
             * @param andOperator `CfnBucket.FilterProperty.AndOperator`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andOperator(software.amazon.awscdk.services.s3outposts.CfnBucket.FilterAndOperatorProperty andOperator) {
                this.andOperator = andOperator;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getAndOperator}
             * @param andOperator `CfnBucket.FilterProperty.AndOperator`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andOperator(software.amazon.awscdk.core.IResolvable andOperator) {
                this.andOperator = andOperator;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getPrefix}
             * @param prefix `CfnBucket.FilterProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getTag}
             * @param tag `CfnBucket.FilterProperty.Tag`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tag(software.amazon.awscdk.services.s3outposts.CfnBucket.FilterTagProperty tag) {
                this.tag = tag;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getTag}
             * @param tag `CfnBucket.FilterProperty.Tag`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tag(software.amazon.awscdk.core.IResolvable tag) {
                this.tag = tag;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterProperty {
            private final java.lang.Object andOperator;
            private final java.lang.String prefix;
            private final java.lang.Object tag;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.andOperator = software.amazon.jsii.Kernel.get(this, "andOperator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.andOperator = builder.andOperator;
                this.prefix = builder.prefix;
                this.tag = builder.tag;
            }

            @Override
            public final java.lang.Object getAndOperator() {
                return this.andOperator;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getTag() {
                return this.tag;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAndOperator() != null) {
                    data.set("andOperator", om.valueToTree(this.getAndOperator()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getTag() != null) {
                    data.set("tag", om.valueToTree(this.getTag()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_s3outposts.CfnBucket.FilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterProperty.Jsii$Proxy that = (FilterProperty.Jsii$Proxy) o;

                if (this.andOperator != null ? !this.andOperator.equals(that.andOperator) : that.andOperator != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.tag != null ? this.tag.equals(that.tag) : that.tag == null;
            }

            @Override
            public final int hashCode() {
                int result = this.andOperator != null ? this.andOperator.hashCode() : 0;
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3outposts.*;
     * FilterTagProperty filterTagProperty = FilterTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3outposts.CfnBucket.FilterTagProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnBucket.FilterTagProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * `CfnBucket.FilterTagProperty.Value`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link FilterTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link FilterTagProperty#getKey}
             * @param key `CfnBucket.FilterTagProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link FilterTagProperty#getValue}
             * @param value `CfnBucket.FilterTagProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_s3outposts.CfnBucket.FilterTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterTagProperty.Jsii$Proxy that = (FilterTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The container for the lifecycle configuration for the objects stored in an S3 on Outposts bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3outposts.*;
     * Object filter;
     * LifecycleConfigurationProperty lifecycleConfigurationProperty = LifecycleConfigurationProperty.builder()
     *         .rules(List.of(RuleProperty.builder()
     *                 .status("status")
     *                 // the properties below are optional
     *                 .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
     *                         .daysAfterInitiation(123)
     *                         .build())
     *                 .expirationDate("expirationDate")
     *                 .expirationInDays(123)
     *                 .filter(filter)
     *                 .id("id")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3outposts.CfnBucket.LifecycleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecycleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container for the lifecycle configuration rules for the objects stored in the S3 on Outposts bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecycleConfigurationProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules The container for the lifecycle configuration rules for the objects stored in the S3 on Outposts bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.core.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules The container for the lifecycle configuration rules for the objects stored in the S3 on Outposts bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecycleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleConfigurationProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_s3outposts.CfnBucket.LifecycleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecycleConfigurationProperty.Jsii$Proxy that = (LifecycleConfigurationProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * A container for an Amazon S3 on Outposts bucket lifecycle rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3outposts.*;
     * Object filter;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
     *                 .daysAfterInitiation(123)
     *                 .build())
     *         .expirationDate("expirationDate")
     *         .expirationInDays(123)
     *         .filter(filter)
     *         .id("id")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_s3outposts.CfnBucket.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If `Enabled` , the rule is currently being applied.
         * <p>
         * If <code>Disabled</code> , the rule is not currently being applied.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * The container for the abort incomplete multipart upload rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAbortIncompleteMultipartUpload() {
            return null;
        }

        /**
         * Specifies the expiration for the lifecycle of the object by specifying an expiry date.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpirationDate() {
            return null;
        }

        /**
         * Specifies the expiration for the lifecycle of the object in the form of days that the object has been in the S3 on Outposts bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExpirationInDays() {
            return null;
        }

        /**
         * The container for the filter of the lifecycle rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilter() {
            return null;
        }

        /**
         * The unique identifier for the lifecycle rule.
         * <p>
         * The value can't be longer than 255 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.String status;
            java.lang.Object abortIncompleteMultipartUpload;
            java.lang.String expirationDate;
            java.lang.Number expirationInDays;
            java.lang.Object filter;
            java.lang.String id;

            /**
             * Sets the value of {@link RuleProperty#getStatus}
             * @param status If `Enabled` , the rule is currently being applied. This parameter is required.
             *               If <code>Disabled</code> , the rule is not currently being applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload The container for the abort incomplete multipart upload rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.services.s3outposts.CfnBucket.AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload The container for the abort incomplete multipart upload rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.core.IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationDate}
             * @param expirationDate Specifies the expiration for the lifecycle of the object by specifying an expiry date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationDate(java.lang.String expirationDate) {
                this.expirationDate = expirationDate;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationInDays}
             * @param expirationInDays Specifies the expiration for the lifecycle of the object in the form of days that the object has been in the S3 on Outposts bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationInDays(java.lang.Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getFilter}
             * @param filter The container for the filter of the lifecycle rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(java.lang.Object filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getId}
             * @param id The unique identifier for the lifecycle rule.
             *           The value can't be longer than 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.String status;
            private final java.lang.Object abortIncompleteMultipartUpload;
            private final java.lang.String expirationDate;
            private final java.lang.Number expirationInDays;
            private final java.lang.Object filter;
            private final java.lang.String id;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.abortIncompleteMultipartUpload = software.amazon.jsii.Kernel.get(this, "abortIncompleteMultipartUpload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expirationDate = software.amazon.jsii.Kernel.get(this, "expirationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expirationInDays = software.amazon.jsii.Kernel.get(this, "expirationInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
                this.expirationDate = builder.expirationDate;
                this.expirationInDays = builder.expirationInDays;
                this.filter = builder.filter;
                this.id = builder.id;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.abortIncompleteMultipartUpload;
            }

            @Override
            public final java.lang.String getExpirationDate() {
                return this.expirationDate;
            }

            @Override
            public final java.lang.Number getExpirationInDays() {
                return this.expirationInDays;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getAbortIncompleteMultipartUpload() != null) {
                    data.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                }
                if (this.getExpirationDate() != null) {
                    data.set("expirationDate", om.valueToTree(this.getExpirationDate()));
                }
                if (this.getExpirationInDays() != null) {
                    data.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                }
                if (this.getFilter() != null) {
                    data.set("filter", om.valueToTree(this.getFilter()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_s3outposts.CfnBucket.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.abortIncompleteMultipartUpload != null ? !this.abortIncompleteMultipartUpload.equals(that.abortIncompleteMultipartUpload) : that.abortIncompleteMultipartUpload != null) return false;
                if (this.expirationDate != null ? !this.expirationDate.equals(that.expirationDate) : that.expirationDate != null) return false;
                if (this.expirationInDays != null ? !this.expirationInDays.equals(that.expirationInDays) : that.expirationInDays != null) return false;
                if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) return false;
                return this.id != null ? this.id.equals(that.id) : that.id == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.hashCode() : 0);
                result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
                result = 31 * result + (this.expirationInDays != null ? this.expirationInDays.hashCode() : 0);
                result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3outposts.CfnBucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3outposts.CfnBucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3outposts.CfnBucketProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3outposts.CfnBucketProps.Builder();
        }

        /**
         * A name for the S3 on Outposts bucket.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html">Amazon S3 bucket restrictions and limitations</a> . For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Bucket naming rules</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param bucketName A name for the S3 on Outposts bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props.bucketName(bucketName);
            return this;
        }

        /**
         * The ID of the Outpost of the specified bucket.
         * <p>
         * @return {@code this}
         * @param outpostId The ID of the Outpost of the specified bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostId(final java.lang.String outpostId) {
            this.props.outpostId(outpostId);
            return this;
        }

        /**
         * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration.
         * <p>
         * Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.
         * <p>
         * @return {@code this}
         * @param lifecycleConfiguration Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.services.s3outposts.CfnBucket.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.props.lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }
        /**
         * Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration.
         * <p>
         * Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.
         * <p>
         * @return {@code this}
         * @param lifecycleConfiguration Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.core.IResolvable lifecycleConfiguration) {
            this.props.lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        /**
         * Sets the tags for an S3 on Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) .
         * <p>
         * Use tags to organize your AWS bill to reflect your own cost structure. To do this, sign up to get your AWS account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost allocation and tags</a> .
         * <p>
         * <blockquote>
         * <p>
         * Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html">Using cost allocation and bucket tags</a> .
         * <p>
         * </blockquote>
         * <p>
         * To use this resource, you must have permissions to perform the <code>s3-outposts:PutBucketTagging</code> . The S3 on Outposts bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions to your Amazon S3 resources</a> .
         * <p>
         * @return {@code this}
         * @param tags Sets the tags for an S3 on Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.s3outposts.CfnBucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3outposts.CfnBucket build() {
            return new software.amazon.awscdk.services.s3outposts.CfnBucket(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
