package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a `CfnModelExplainabilityJobDefinition`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object json;
 * CfnModelExplainabilityJobDefinitionProps cfnModelExplainabilityJobDefinitionProps = CfnModelExplainabilityJobDefinitionProps.builder()
 *         .jobResources(MonitoringResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .modelExplainabilityAppSpecification(ModelExplainabilityAppSpecificationProperty.builder()
 *                 .configUri("configUri")
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .build())
 *         .modelExplainabilityJobInput(ModelExplainabilityJobInputProperty.builder()
 *                 .batchTransformInput(BatchTransformInputProperty.builder()
 *                         .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
 *                         .datasetFormat(DatasetFormatProperty.builder()
 *                                 .csv(CsvProperty.builder()
 *                                         .header(false)
 *                                         .build())
 *                                 .json(json)
 *                                 .parquet(false)
 *                                 .build())
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .featuresAttribute("featuresAttribute")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .build())
 *                 .endpointInput(EndpointInputProperty.builder()
 *                         .endpointName("endpointName")
 *                         .localPath("localPath")
 *                         // the properties below are optional
 *                         .featuresAttribute("featuresAttribute")
 *                         .inferenceAttribute("inferenceAttribute")
 *                         .probabilityAttribute("probabilityAttribute")
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .build())
 *                 .build())
 *         .modelExplainabilityJobOutputConfig(MonitoringOutputConfigProperty.builder()
 *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .localPath("localPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .endpointName("endpointName")
 *         .jobDefinitionName("jobDefinitionName")
 *         .modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfigProperty.builder()
 *                 .baseliningJobName("baseliningJobName")
 *                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:09.353Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnModelExplainabilityJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnModelExplainabilityJobDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getJobResources();

    /**
     * Configures the model explainability job to run a specified Docker container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelExplainabilityAppSpecification();

    /**
     * Inputs for the model explainability job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelExplainabilityJobInput();

    /**
     * The output configuration for monitoring jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getModelExplainabilityJobOutputConfig();

    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return null;
    }

    /**
     * The name of the model explainability job definition.
     * <p>
     * The name must be unique within an AWS Region in the AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return null;
    }

    /**
     * The baseline configuration for a model explainability job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModelExplainabilityBaselineConfig() {
        return null;
    }

    /**
     * Networking options for a model explainability job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return null;
    }

    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnModelExplainabilityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnModelExplainabilityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnModelExplainabilityJobDefinitionProps> {
        java.lang.Object jobResources;
        java.lang.Object modelExplainabilityAppSpecification;
        java.lang.Object modelExplainabilityJobInput;
        java.lang.Object modelExplainabilityJobOutputConfig;
        java.lang.String roleArn;
        java.lang.String endpointName;
        java.lang.String jobDefinitionName;
        java.lang.Object modelExplainabilityBaselineConfig;
        java.lang.Object networkConfig;
        java.lang.Object stoppingCondition;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getJobResources}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getJobResources}
         * @param jobResources Identifies the resources to deploy for a monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobResources(software.amazon.awscdk.core.IResolvable jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityAppSpecification}
         * @param modelExplainabilityAppSpecification Configures the model explainability job to run a specified Docker container image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityAppSpecification(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityAppSpecification}
         * @param modelExplainabilityAppSpecification Configures the model explainability job to run a specified Docker container image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityAppSpecification(software.amazon.awscdk.core.IResolvable modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobInput}
         * @param modelExplainabilityJobInput Inputs for the model explainability job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobInput(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobInput}
         * @param modelExplainabilityJobInput Inputs for the model explainability job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobInput(software.amazon.awscdk.core.IResolvable modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobOutputConfig}
         * @param modelExplainabilityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobOutputConfig(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityJobOutputConfig}
         * @param modelExplainabilityJobOutputConfig The output configuration for monitoring jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityJobOutputConfig(software.amazon.awscdk.core.IResolvable modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getEndpointName}
         * @param endpointName `AWS::SageMaker::ModelExplainabilityJobDefinition.EndpointName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name of the model explainability job definition.
         *                          The name must be unique within an AWS Region in the AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityBaselineConfig}
         * @param modelExplainabilityBaselineConfig The baseline configuration for a model explainability job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityBaselineConfig(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getModelExplainabilityBaselineConfig}
         * @param modelExplainabilityBaselineConfig The baseline configuration for a model explainability job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelExplainabilityBaselineConfig(software.amazon.awscdk.core.IResolvable modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig Networking options for a model explainability job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.NetworkConfigProperty networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getNetworkConfig}
         * @param networkConfig Networking options for a model explainability job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.core.IResolvable networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnModelExplainabilityJobDefinition.StoppingConditionProperty stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getStoppingCondition}
         * @param stoppingCondition A time limit for how long the monitoring job is allowed to run before stopping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.core.IResolvable stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelExplainabilityJobDefinitionProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnModelExplainabilityJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnModelExplainabilityJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnModelExplainabilityJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnModelExplainabilityJobDefinitionProps {
        private final java.lang.Object jobResources;
        private final java.lang.Object modelExplainabilityAppSpecification;
        private final java.lang.Object modelExplainabilityJobInput;
        private final java.lang.Object modelExplainabilityJobOutputConfig;
        private final java.lang.String roleArn;
        private final java.lang.String endpointName;
        private final java.lang.String jobDefinitionName;
        private final java.lang.Object modelExplainabilityBaselineConfig;
        private final java.lang.Object networkConfig;
        private final java.lang.Object stoppingCondition;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jobResources = software.amazon.jsii.Kernel.get(this, "jobResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelExplainabilityAppSpecification = software.amazon.jsii.Kernel.get(this, "modelExplainabilityAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelExplainabilityJobInput = software.amazon.jsii.Kernel.get(this, "modelExplainabilityJobInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelExplainabilityJobOutputConfig = software.amazon.jsii.Kernel.get(this, "modelExplainabilityJobOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelExplainabilityBaselineConfig = software.amazon.jsii.Kernel.get(this, "modelExplainabilityBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jobResources = java.util.Objects.requireNonNull(builder.jobResources, "jobResources is required");
            this.modelExplainabilityAppSpecification = java.util.Objects.requireNonNull(builder.modelExplainabilityAppSpecification, "modelExplainabilityAppSpecification is required");
            this.modelExplainabilityJobInput = java.util.Objects.requireNonNull(builder.modelExplainabilityJobInput, "modelExplainabilityJobInput is required");
            this.modelExplainabilityJobOutputConfig = java.util.Objects.requireNonNull(builder.modelExplainabilityJobOutputConfig, "modelExplainabilityJobOutputConfig is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.endpointName = builder.endpointName;
            this.jobDefinitionName = builder.jobDefinitionName;
            this.modelExplainabilityBaselineConfig = builder.modelExplainabilityBaselineConfig;
            this.networkConfig = builder.networkConfig;
            this.stoppingCondition = builder.stoppingCondition;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getJobResources() {
            return this.jobResources;
        }

        @Override
        public final java.lang.Object getModelExplainabilityAppSpecification() {
            return this.modelExplainabilityAppSpecification;
        }

        @Override
        public final java.lang.Object getModelExplainabilityJobInput() {
            return this.modelExplainabilityJobInput;
        }

        @Override
        public final java.lang.Object getModelExplainabilityJobOutputConfig() {
            return this.modelExplainabilityJobOutputConfig;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.lang.Object getModelExplainabilityBaselineConfig() {
            return this.modelExplainabilityBaselineConfig;
        }

        @Override
        public final java.lang.Object getNetworkConfig() {
            return this.networkConfig;
        }

        @Override
        public final java.lang.Object getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("jobResources", om.valueToTree(this.getJobResources()));
            data.set("modelExplainabilityAppSpecification", om.valueToTree(this.getModelExplainabilityAppSpecification()));
            data.set("modelExplainabilityJobInput", om.valueToTree(this.getModelExplainabilityJobInput()));
            data.set("modelExplainabilityJobOutputConfig", om.valueToTree(this.getModelExplainabilityJobOutputConfig()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getEndpointName() != null) {
                data.set("endpointName", om.valueToTree(this.getEndpointName()));
            }
            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getModelExplainabilityBaselineConfig() != null) {
                data.set("modelExplainabilityBaselineConfig", om.valueToTree(this.getModelExplainabilityBaselineConfig()));
            }
            if (this.getNetworkConfig() != null) {
                data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
            }
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_sagemaker.CfnModelExplainabilityJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnModelExplainabilityJobDefinitionProps.Jsii$Proxy that = (CfnModelExplainabilityJobDefinitionProps.Jsii$Proxy) o;

            if (!jobResources.equals(that.jobResources)) return false;
            if (!modelExplainabilityAppSpecification.equals(that.modelExplainabilityAppSpecification)) return false;
            if (!modelExplainabilityJobInput.equals(that.modelExplainabilityJobInput)) return false;
            if (!modelExplainabilityJobOutputConfig.equals(that.modelExplainabilityJobOutputConfig)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.endpointName != null ? !this.endpointName.equals(that.endpointName) : that.endpointName != null) return false;
            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.modelExplainabilityBaselineConfig != null ? !this.modelExplainabilityBaselineConfig.equals(that.modelExplainabilityBaselineConfig) : that.modelExplainabilityBaselineConfig != null) return false;
            if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jobResources.hashCode();
            result = 31 * result + (this.modelExplainabilityAppSpecification.hashCode());
            result = 31 * result + (this.modelExplainabilityJobInput.hashCode());
            result = 31 * result + (this.modelExplainabilityJobOutputConfig.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.endpointName != null ? this.endpointName.hashCode() : 0);
            result = 31 * result + (this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0);
            result = 31 * result + (this.modelExplainabilityBaselineConfig != null ? this.modelExplainabilityBaselineConfig.hashCode() : 0);
            result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
