package software.amazon.awscdk.services.secretsmanager;

/**
 * (experimental) Attributes required to import an existing secret into the Stack.
 * <p>
 * One ARN format (<code>secretArn</code>, <code>secretCompleteArn</code>, <code>secretPartialArn</code>) must be provided.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key encryptionKey;
 * ISecret secret = Secret.fromSecretAttributes(this, "ImportedSecret", SecretAttributes.builder()
 *         .secretArn("arn:aws:secretsmanager:&lt;region&gt;:&lt;account-id-number&gt;:secret:&lt;secret-name&gt;-&lt;random-6-characters&gt;")
 *         // If the secret is encrypted using a KMS-hosted CMK, either import or reference that key:
 *         .encryptionKey(encryptionKey)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:09.827Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_secretsmanager.SecretAttributes")
@software.amazon.jsii.Jsii.Proxy(SecretAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SecretAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The encryption key that is used to encrypt the secret, unless the default SecretsManager key is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (deprecated) The ARN of the secret in SecretsManager.
     * <p>
     * Cannot be used with <code>secretCompleteArn</code> or <code>secretPartialArn</code>.
     * <p>
     * @deprecated use `secretCompleteArn` or `secretPartialArn` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
        return null;
    }

    /**
     * (experimental) The complete ARN of the secret in SecretsManager.
     * <p>
     * This is the ARN including the Secrets Manager 6-character suffix.
     * Cannot be used with <code>secretArn</code> or <code>secretPartialArn</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretCompleteArn() {
        return null;
    }

    /**
     * (experimental) The partial ARN of the secret in SecretsManager.
     * <p>
     * This is the ARN without the Secrets Manager 6-character suffix.
     * Cannot be used with <code>secretArn</code> or <code>secretCompleteArn</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretPartialArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SecretAttributes> {
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String secretArn;
        java.lang.String secretCompleteArn;
        java.lang.String secretPartialArn;

        /**
         * Sets the value of {@link SecretAttributes#getEncryptionKey}
         * @param encryptionKey The encryption key that is used to encrypt the secret, unless the default SecretsManager key is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link SecretAttributes#getSecretArn}
         * @param secretArn The ARN of the secret in SecretsManager.
         *                  Cannot be used with <code>secretCompleteArn</code> or <code>secretPartialArn</code>.
         * @return {@code this}
         * @deprecated use `secretCompleteArn` or `secretPartialArn` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder secretArn(java.lang.String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        /**
         * Sets the value of {@link SecretAttributes#getSecretCompleteArn}
         * @param secretCompleteArn The complete ARN of the secret in SecretsManager.
         *                          This is the ARN including the Secrets Manager 6-character suffix.
         *                          Cannot be used with <code>secretArn</code> or <code>secretPartialArn</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretCompleteArn(java.lang.String secretCompleteArn) {
            this.secretCompleteArn = secretCompleteArn;
            return this;
        }

        /**
         * Sets the value of {@link SecretAttributes#getSecretPartialArn}
         * @param secretPartialArn The partial ARN of the secret in SecretsManager.
         *                         This is the ARN without the Secrets Manager 6-character suffix.
         *                         Cannot be used with <code>secretArn</code> or <code>secretCompleteArn</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretPartialArn(java.lang.String secretPartialArn) {
            this.secretPartialArn = secretPartialArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SecretAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecretAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretAttributes {
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String secretArn;
        private final java.lang.String secretCompleteArn;
        private final java.lang.String secretPartialArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretCompleteArn = software.amazon.jsii.Kernel.get(this, "secretCompleteArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretPartialArn = software.amazon.jsii.Kernel.get(this, "secretPartialArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionKey = builder.encryptionKey;
            this.secretArn = builder.secretArn;
            this.secretCompleteArn = builder.secretCompleteArn;
            this.secretPartialArn = builder.secretPartialArn;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final java.lang.String getSecretCompleteArn() {
            return this.secretCompleteArn;
        }

        @Override
        public final java.lang.String getSecretPartialArn() {
            return this.secretPartialArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getSecretArn() != null) {
                data.set("secretArn", om.valueToTree(this.getSecretArn()));
            }
            if (this.getSecretCompleteArn() != null) {
                data.set("secretCompleteArn", om.valueToTree(this.getSecretCompleteArn()));
            }
            if (this.getSecretPartialArn() != null) {
                data.set("secretPartialArn", om.valueToTree(this.getSecretPartialArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_secretsmanager.SecretAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretAttributes.Jsii$Proxy that = (SecretAttributes.Jsii$Proxy) o;

            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.secretArn != null ? !this.secretArn.equals(that.secretArn) : that.secretArn != null) return false;
            if (this.secretCompleteArn != null ? !this.secretCompleteArn.equals(that.secretCompleteArn) : that.secretCompleteArn != null) return false;
            return this.secretPartialArn != null ? this.secretPartialArn.equals(that.secretPartialArn) : that.secretPartialArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionKey != null ? this.encryptionKey.hashCode() : 0;
            result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
            result = 31 * result + (this.secretCompleteArn != null ? this.secretCompleteArn.hashCode() : 0);
            result = 31 * result + (this.secretPartialArn != null ? this.secretPartialArn.hashCode() : 0);
            return result;
        }
    }
}
