package software.amazon.awscdk.services.secretsmanager;

/**
 * (experimental) The properties required to create a new secret in AWS Secrets Manager.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a new IAM user, access and secret keys, and stores the secret access key in a Secret.
 * User user = new User(this, "User");
 * AccessKey accessKey = AccessKey.Builder.create(this, "AccessKey").user(user).build();
 * SecretStringValueBeta1 secretValue = SecretStringValueBeta1.fromToken(accessKey.secretAccessKey.toString());
 * Secret.Builder.create(this, "Secret")
 *         .secretStringBeta1(secretValue)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-11T14:45:09.828Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_secretsmanager.SecretProps")
@software.amazon.jsii.Jsii.Proxy(SecretProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SecretProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) An optional, human-friendly description of the secret.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) The customer-managed encryption key to use for encrypting the secret value.
     * <p>
     * Default: - A default KMS key for the account and region is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (experimental) Configuration for how to generate a secret value.
     * <p>
     * Only one of <code>secretString</code> and <code>generateSecretString</code> can be provided.
     * <p>
     * Default: - 32 characters with upper-case letters, lower-case letters, punctuation and numbers (at least one from each
     * category), per the default values of ``SecretStringGenerator``.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretStringGenerator getGenerateSecretString() {
        return null;
    }

    /**
     * (experimental) Policy to apply when the secret is removed from this stack.
     * <p>
     * Default: - Not set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * (experimental) A list of regions where to replicate this secret.
     * <p>
     * Default: - Secret is not replicated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
        return null;
    }

    /**
     * (experimental) A name for the secret.
     * <p>
     * Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
     * 30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
     * <p>
     * Default: - A name is generated by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretName() {
        return null;
    }

    /**
     * (deprecated) Initial value for the secret.
     * <p>
     * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
     * The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
     * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
     * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
     * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
     * <p>
     * Specifies text data that you want to encrypt and store in this new version of the secret.
     * May be a simple string value, or a string representation of a JSON structure.
     * <p>
     * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, and <code>generateSecretString</code> can be provided.
     * <p>
     * Default: - SecretsManager generates a new secret value.
     * <p>
     * @deprecated Use `secretStringValue` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 getSecretStringBeta1() {
        return null;
    }

    /**
     * (experimental) Initial value for the secret.
     * <p>
     * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
     * The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
     * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
     * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
     * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
     * <p>
     * Specifies text data that you want to encrypt and store in this new version of the secret.
     * May be a simple string value, or a string representation of a JSON structure.
     * <p>
     * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, and <code>generateSecretString</code> can be provided.
     * <p>
     * Default: - SecretsManager generates a new secret value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.SecretValue getSecretStringValue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SecretProps> {
        java.lang.String description;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString;
        software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions;
        java.lang.String secretName;
        software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 secretStringBeta1;
        software.amazon.awscdk.core.SecretValue secretStringValue;

        /**
         * Sets the value of {@link SecretProps#getDescription}
         * @param description An optional, human-friendly description of the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getEncryptionKey}
         * @param encryptionKey The customer-managed encryption key to use for encrypting the secret value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getGenerateSecretString}
         * @param generateSecretString Configuration for how to generate a secret value.
         *                             Only one of <code>secretString</code> and <code>generateSecretString</code> can be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generateSecretString(software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString) {
            this.generateSecretString = generateSecretString;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the secret is removed from this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getReplicaRegions}
         * @param replicaRegions A list of regions where to replicate this secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder replicaRegions(java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions) {
            this.replicaRegions = (java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)replicaRegions;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getSecretName}
         * @param secretName A name for the secret.
         *                   Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
         *                   30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretName(java.lang.String secretName) {
            this.secretName = secretName;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getSecretStringBeta1}
         * @param secretStringBeta1 Initial value for the secret.
         *                          <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         *                          The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
         *                          and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         *                          another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         *                          to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         *                          <p>
         *                          Specifies text data that you want to encrypt and store in this new version of the secret.
         *                          May be a simple string value, or a string representation of a JSON structure.
         *                          <p>
         *                          Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, and <code>generateSecretString</code> can be provided.
         * @return {@code this}
         * @deprecated Use `secretStringValue` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder secretStringBeta1(software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 secretStringBeta1) {
            this.secretStringBeta1 = secretStringBeta1;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getSecretStringValue}
         * @param secretStringValue Initial value for the secret.
         *                          <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         *                          The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
         *                          and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         *                          another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         *                          to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         *                          <p>
         *                          Specifies text data that you want to encrypt and store in this new version of the secret.
         *                          May be a simple string value, or a string representation of a JSON structure.
         *                          <p>
         *                          Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, and <code>generateSecretString</code> can be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretStringValue(software.amazon.awscdk.core.SecretValue secretStringValue) {
            this.secretStringValue = secretStringValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SecretProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProps {
        private final java.lang.String description;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString;
        private final software.amazon.awscdk.core.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions;
        private final java.lang.String secretName;
        private final software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 secretStringBeta1;
        private final software.amazon.awscdk.core.SecretValue secretStringValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.generateSecretString = software.amazon.jsii.Kernel.get(this, "generateSecretString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretStringGenerator.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.RemovalPolicy.class));
            this.replicaRegions = software.amazon.jsii.Kernel.get(this, "replicaRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ReplicaRegion.class)));
            this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretStringBeta1 = software.amazon.jsii.Kernel.get(this, "secretStringBeta1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1.class));
            this.secretStringValue = software.amazon.jsii.Kernel.get(this, "secretStringValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SecretValue.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.encryptionKey = builder.encryptionKey;
            this.generateSecretString = builder.generateSecretString;
            this.removalPolicy = builder.removalPolicy;
            this.replicaRegions = (java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)builder.replicaRegions;
            this.secretName = builder.secretName;
            this.secretStringBeta1 = builder.secretStringBeta1;
            this.secretStringValue = builder.secretStringValue;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.SecretStringGenerator getGenerateSecretString() {
            return this.generateSecretString;
        }

        @Override
        public final software.amazon.awscdk.core.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
            return this.replicaRegions;
        }

        @Override
        public final java.lang.String getSecretName() {
            return this.secretName;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 getSecretStringBeta1() {
            return this.secretStringBeta1;
        }

        @Override
        public final software.amazon.awscdk.core.SecretValue getSecretStringValue() {
            return this.secretStringValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getGenerateSecretString() != null) {
                data.set("generateSecretString", om.valueToTree(this.getGenerateSecretString()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReplicaRegions() != null) {
                data.set("replicaRegions", om.valueToTree(this.getReplicaRegions()));
            }
            if (this.getSecretName() != null) {
                data.set("secretName", om.valueToTree(this.getSecretName()));
            }
            if (this.getSecretStringBeta1() != null) {
                data.set("secretStringBeta1", om.valueToTree(this.getSecretStringBeta1()));
            }
            if (this.getSecretStringValue() != null) {
                data.set("secretStringValue", om.valueToTree(this.getSecretStringValue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_secretsmanager.SecretProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretProps.Jsii$Proxy that = (SecretProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.generateSecretString != null ? !this.generateSecretString.equals(that.generateSecretString) : that.generateSecretString != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.replicaRegions != null ? !this.replicaRegions.equals(that.replicaRegions) : that.replicaRegions != null) return false;
            if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) return false;
            if (this.secretStringBeta1 != null ? !this.secretStringBeta1.equals(that.secretStringBeta1) : that.secretStringBeta1 != null) return false;
            return this.secretStringValue != null ? this.secretStringValue.equals(that.secretStringValue) : that.secretStringValue == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.generateSecretString != null ? this.generateSecretString.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.replicaRegions != null ? this.replicaRegions.hashCode() : 0);
            result = 31 * result + (this.secretName != null ? this.secretName.hashCode() : 0);
            result = 31 * result + (this.secretStringBeta1 != null ? this.secretStringBeta1.hashCode() : 0);
            result = 31 * result + (this.secretStringValue != null ? this.secretStringValue.hashCode() : 0);
            return result;
        }
    }
}
